/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.util.LinkedList;
import sun.nio.ch.AllocatedNativeObject;
import sun.nio.ch.FileDispatcher;

class DevPollArrayWrapper {
    static final short POLLIN = 1;
    static final short POLLPRI = 2;
    static final short POLLOUT = 4;
    static final short POLLRDNORM = 64;
    static final short POLLWRNORM = 4;
    static final short POLLRDBAND = 128;
    static final short POLLWRBAND = 256;
    static final short POLLNORM = 64;
    static final short POLLERR = 8;
    static final short POLLHUP = 16;
    static final short POLLNVAL = 32;
    static final short POLLREMOVE = 2048;
    static final short POLLCONN = 4;
    static final short SIZE_POLLFD = 8;
    static final short FD_OFFSET = 0;
    static final short EVENT_OFFSET = 4;
    static final short REVENT_OFFSET = 6;
    static final int OPEN_MAX = DevPollArrayWrapper.fdLimit();
    static final int NUM_POLLFDS = Math.min(OPEN_MAX - 1, 8192);
    private long pollArrayAddress;
    private int MAX_UPDATE_SIZE = 10000;
    private LinkedList<Updator> updateList = new LinkedList();
    private AllocatedNativeObject pollArray;
    int wfd;
    int outgoingInterruptFD;
    int incomingInterruptFD;
    int interruptedIndex;
    int updated;
    boolean interrupted = false;

    DevPollArrayWrapper() {
        int allocationSize = NUM_POLLFDS * 8;
        this.pollArray = new AllocatedNativeObject(allocationSize, true);
        this.pollArrayAddress = this.pollArray.address();
        this.wfd = this.init();
        for (int i = 0; i < NUM_POLLFDS; ++i) {
            this.putDescriptor(i, 0);
            this.putEventOps(i, 0);
            this.putReventOps(i, 0);
        }
    }

    void initInterrupt(int fd0, int fd1) {
        this.outgoingInterruptFD = fd1;
        this.incomingInterruptFD = fd0;
        this.register(this.wfd, fd0, 1);
    }

    void putEventOps(int i, int event) {
        int offset = 8 * i + 4;
        this.pollArray.putShort(offset, (short)event);
    }

    void putReventOps(int i, int revent) {
        int offset = 8 * i + 6;
        this.pollArray.putShort(offset, (short)revent);
    }

    void putDescriptor(int i, int fd) {
        int offset = 8 * i + 0;
        this.pollArray.putInt(offset, fd);
    }

    int getEventOps(int i) {
        int offset = 8 * i + 4;
        return this.pollArray.getShort(offset);
    }

    int getReventOps(int i) {
        int offset = 8 * i + 6;
        return this.pollArray.getShort(offset);
    }

    int getDescriptor(int i) {
        int offset = 8 * i + 0;
        return this.pollArray.getInt(offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInterest(int fd, int mask) {
        LinkedList<Updator> linkedList = this.updateList;
        synchronized (linkedList) {
            this.updateList.add(new Updator(fd, mask));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(int fd) {
        LinkedList<Updator> linkedList = this.updateList;
        synchronized (linkedList) {
            this.updateList.add(new Updator(fd, 2048));
        }
    }

    void closeDevPollFD() throws IOException {
        FileDispatcher.closeIntFD(this.wfd);
        this.pollArray.free();
    }

    int poll(long timeout) {
        this.updateRegistrations();
        this.updated = this.poll0(this.pollArrayAddress, NUM_POLLFDS, timeout, this.wfd);
        for (int i = 0; i < this.updated; ++i) {
            if (this.getDescriptor(i) != this.incomingInterruptFD) continue;
            this.interruptedIndex = i;
            this.interrupted = true;
            break;
        }
        return this.updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRegistrations() {
        int updateSize;
        LinkedList<Updator> linkedList = this.updateList;
        synchronized (linkedList) {
            updateSize = this.updateList.size();
        }
        if (updateSize > 0) {
            int maxUpdates = Math.min(updateSize * 2, this.MAX_UPDATE_SIZE);
            int allocationSize = maxUpdates * 8;
            AllocatedNativeObject updatePollArray = new AllocatedNativeObject(allocationSize, true);
            try {
                LinkedList<Updator> linkedList2 = this.updateList;
                synchronized (linkedList2) {
                    while (this.updateList.size() > 0) {
                        int index = 0;
                        Updator u = null;
                        while ((u = this.updateList.poll()) != null) {
                            this.putPollFD(updatePollArray, index, u.fd, (short)2048);
                            ++index;
                            if (u.mask != 2048) {
                                this.putPollFD(updatePollArray, index, u.fd, (short)u.mask);
                                ++index;
                            }
                            if (index <= maxUpdates - 2) continue;
                        }
                        this.registerMultiple(this.wfd, updatePollArray.address(), index);
                    }
                }
                Object var10_11 = null;
                updatePollArray.free();
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                updatePollArray.free();
                throw throwable;
            }
        }
    }

    private void putPollFD(AllocatedNativeObject array, int index, int fd, short event) {
        int structIndex = 8 * index;
        array.putInt(structIndex + 0, fd);
        array.putShort(structIndex + 4, event);
        array.putShort(structIndex + 6, (short)0);
    }

    public void interrupt() {
        DevPollArrayWrapper.interrupt(this.outgoingInterruptFD);
    }

    public int interruptedIndex() {
        return this.interruptedIndex;
    }

    boolean interrupted() {
        return this.interrupted;
    }

    void clearInterrupted() {
        this.interrupted = false;
    }

    private native int init();

    private native void register(int var1, int var2, int var3);

    private native void registerMultiple(int var1, long var2, int var4);

    private native int poll0(long var1, int var3, long var4, int var6);

    private static native void interrupt(int var0);

    private static native int fdLimit();

    private static class Updator {
        int fd;
        int mask;

        Updator(int fd, int mask) {
            this.fd = fd;
            this.mask = mask;
        }
    }
}

