/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.ftp;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketPermission;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.StringTokenizer;
import sun.net.ProgressMonitor;
import sun.net.ProgressSource;
import sun.net.ftp.FtpClient;
import sun.net.ftp.FtpLoginException;
import sun.net.www.MessageHeader;
import sun.net.www.MeteredStream;
import sun.net.www.ParseUtil;
import sun.net.www.URLConnection;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.security.action.GetPropertyAction;

public class FtpURLConnection
extends URLConnection {
    HttpURLConnection http = null;
    private Proxy instProxy;
    Proxy proxy = null;
    InputStream is = null;
    OutputStream os = null;
    FtpClient ftp = null;
    Permission permission;
    String password;
    String user;
    String host;
    String pathname;
    String filename;
    String fullpath;
    int port;
    static final int NONE = 0;
    static final int ASCII = 1;
    static final int BIN = 2;
    static final int DIR = 3;
    int type = 0;
    private int connectTimeout = -1;
    private int readTimeout = -1;

    public FtpURLConnection(URL url) {
        this(url, null);
    }

    FtpURLConnection(URL url, Proxy p) {
        super(url);
        this.instProxy = p;
        this.host = url.getHost();
        this.port = url.getPort();
        String userInfo = url.getUserInfo();
        if (userInfo != null) {
            int delimiter = userInfo.indexOf(58);
            if (delimiter == -1) {
                this.user = ParseUtil.decode(userInfo);
                this.password = null;
            } else {
                this.user = ParseUtil.decode(userInfo.substring(0, delimiter++));
                this.password = ParseUtil.decode(userInfo.substring(delimiter));
            }
        }
    }

    private void setTimeouts() {
        if (this.ftp != null) {
            if (this.connectTimeout >= 0) {
                this.ftp.setConnectTimeout(this.connectTimeout);
            }
            if (this.readTimeout >= 0) {
                this.ftp.setReadTimeout(this.readTimeout);
            }
        }
    }

    public synchronized void connect() throws IOException {
        if (this.connected) {
            return;
        }
        Proxy p2 = null;
        if (this.instProxy == null) {
            ProxySelector sel = (ProxySelector)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return ProxySelector.getDefault();
                }
            });
            if (sel != null) {
                URI uri = ParseUtil.toURI(this.url);
                for (Proxy p2 : sel.select(uri)) {
                    if (p2 == null || p2 == Proxy.NO_PROXY || p2.type() == Proxy.Type.SOCKS) break;
                    if (p2.type() != Proxy.Type.HTTP || !(p2.address() instanceof InetSocketAddress)) {
                        sel.connectFailed(uri, p2.address(), new IOException("Wrong proxy type"));
                        continue;
                    }
                    InetSocketAddress paddr = (InetSocketAddress)p2.address();
                    try {
                        this.http = new HttpURLConnection(this.url, p2);
                        if (this.connectTimeout >= 0) {
                            this.http.setConnectTimeout(this.connectTimeout);
                        }
                        if (this.readTimeout >= 0) {
                            this.http.setReadTimeout(this.readTimeout);
                        }
                        this.http.connect();
                        this.connected = true;
                        return;
                    }
                    catch (IOException ioe) {
                        sel.connectFailed(uri, paddr, ioe);
                        this.http = null;
                    }
                }
            }
        } else {
            p2 = this.instProxy;
            if (p2.type() == Proxy.Type.HTTP) {
                this.http = new HttpURLConnection(this.url, this.instProxy);
                if (this.connectTimeout >= 0) {
                    this.http.setConnectTimeout(this.connectTimeout);
                }
                if (this.readTimeout >= 0) {
                    this.http.setReadTimeout(this.readTimeout);
                }
                this.http.connect();
                this.connected = true;
                return;
            }
        }
        if (this.user == null) {
            this.user = "anonymous";
            String vers = AccessController.doPrivileged(new GetPropertyAction("java.version"));
            this.password = AccessController.doPrivileged(new GetPropertyAction("ftp.protocol.user", "Java" + vers + "@"));
        }
        this.ftp = p2 != null ? new FtpClient(p2) : new FtpClient();
        this.setTimeouts();
        if (this.port != -1) {
            this.ftp.openServer(this.host, this.port);
        } else {
            this.ftp.openServer(this.host);
        }
        try {
            this.ftp.login(this.user, this.password);
        }
        catch (FtpLoginException e) {
            this.ftp.closeServer();
            throw e;
        }
        this.connected = true;
    }

    private void decodePath(String path) {
        int i = path.indexOf(";type=");
        if (i >= 0) {
            String s1 = path.substring(i + 6, path.length());
            if ("i".equalsIgnoreCase(s1)) {
                this.type = 2;
            }
            if ("a".equalsIgnoreCase(s1)) {
                this.type = 1;
            }
            if ("d".equalsIgnoreCase(s1)) {
                this.type = 3;
            }
            path = path.substring(0, i);
        }
        if (path != null && path.length() > 1 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        if (path == null || path.length() == 0) {
            path = "./";
        }
        if (!path.endsWith("/")) {
            i = path.lastIndexOf(47);
            if (i > 0) {
                this.filename = path.substring(i + 1, path.length());
                this.filename = ParseUtil.decode(this.filename);
                this.pathname = path.substring(0, i);
            } else {
                this.filename = ParseUtil.decode(path);
                this.pathname = null;
            }
        } else {
            this.pathname = path.substring(0, path.length() - 1);
            this.filename = null;
        }
        this.fullpath = this.pathname != null ? this.pathname + "/" + (this.filename != null ? this.filename : "") : this.filename;
    }

    private void cd(String path) throws IOException {
        if (path == null || "".equals(path)) {
            return;
        }
        if (path.indexOf(47) == -1) {
            this.ftp.cd(ParseUtil.decode(path));
            return;
        }
        StringTokenizer token = new StringTokenizer(path, "/");
        while (token.hasMoreTokens()) {
            this.ftp.cd(ParseUtil.decode(token.nextToken()));
        }
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.http != null) {
            return this.http.getInputStream();
        }
        if (this.os != null) {
            throw new IOException("Already opened for output");
        }
        if (this.is != null) {
            return this.is;
        }
        MessageHeader msgh = new MessageHeader();
        try {
            this.decodePath(this.url.getPath());
            if (this.filename == null || this.type == 3) {
                this.ftp.ascii();
                this.cd(this.pathname);
                this.is = this.filename == null ? new FtpInputStream(this.ftp, this.ftp.list()) : new FtpInputStream(this.ftp, this.ftp.nameList(this.filename));
            } else {
                if (this.type == 1) {
                    this.ftp.ascii();
                } else {
                    this.ftp.binary();
                }
                this.cd(this.pathname);
                this.is = new FtpInputStream(this.ftp, this.ftp.get(this.filename));
            }
            try {
                String response = this.ftp.getResponseString();
                int offset = response.indexOf(" bytes)");
                if (offset != -1) {
                    char c;
                    int i = offset;
                    while (--i >= 0 && (c = response.charAt(i)) >= '0' && c <= '9') {
                    }
                    i = Integer.parseInt(response.substring(i + 1, offset));
                    msgh.add("content-length", "" + i);
                    if (i > 0) {
                        boolean meteredInput = ProgressMonitor.getDefault().shouldMeterInput(this.url, "GET");
                        ProgressSource pi = null;
                        if (meteredInput) {
                            pi = new ProgressSource(this.url, "GET", i);
                            pi.beginTracking();
                        }
                        this.is = new MeteredStream(this.is, pi, i);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String type = FtpURLConnection.guessContentTypeFromName(this.fullpath);
            if (type == null && this.is.markSupported()) {
                type = FtpURLConnection.guessContentTypeFromStream(this.is);
            }
            if (type != null) {
                msgh.add("content-type", type);
            }
        }
        catch (FileNotFoundException e) {
            try {
                this.cd(this.fullpath);
                this.ftp.ascii();
                this.is = new FtpInputStream(this.ftp, this.ftp.list());
                msgh.add("content-type", "text/plain");
            }
            catch (IOException ex) {
                throw new FileNotFoundException(this.fullpath);
            }
        }
        this.setProperties(msgh);
        return this.is;
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.http != null) {
            return this.http.getOutputStream();
        }
        if (this.is != null) {
            throw new IOException("Already opened for input");
        }
        if (this.os != null) {
            return this.os;
        }
        this.decodePath(this.url.getPath());
        if (this.filename == null || this.filename.length() == 0) {
            throw new IOException("illegal filename for a PUT");
        }
        if (this.pathname != null) {
            this.cd(this.pathname);
        }
        if (this.type == 1) {
            this.ftp.ascii();
        } else {
            this.ftp.binary();
        }
        this.os = new FtpOutputStream(this.ftp, this.ftp.put(this.filename));
        return this.os;
    }

    String guessContentTypeFromFilename(String fname) {
        return FtpURLConnection.guessContentTypeFromName(fname);
    }

    public Permission getPermission() {
        if (this.permission == null) {
            int port = this.url.getPort();
            port = port < 0 ? 21 : port;
            String host = this.host + ":" + port;
            this.permission = new SocketPermission(host, "connect");
        }
        return this.permission;
    }

    public void setRequestProperty(String key, String value) {
        super.setRequestProperty(key, value);
        if ("type".equals(key)) {
            if ("i".equalsIgnoreCase(value)) {
                this.type = 2;
            } else if ("a".equalsIgnoreCase(value)) {
                this.type = 1;
            } else if ("d".equalsIgnoreCase(value)) {
                this.type = 3;
            } else {
                throw new IllegalArgumentException("Value of '" + key + "' request property was '" + value + "' when it must be either 'i', 'a' or 'd'");
            }
        }
    }

    public String getRequestProperty(String key) {
        String value = super.getRequestProperty(key);
        if (value == null && "type".equals(key)) {
            value = this.type == 1 ? "a" : (this.type == 3 ? "d" : "i");
        }
        return value;
    }

    public void setConnectTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeouts can't be negative");
        }
        this.connectTimeout = timeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout < 0 ? 0 : this.connectTimeout;
    }

    public void setReadTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeouts can't be negative");
        }
        this.readTimeout = timeout;
    }

    public int getReadTimeout() {
        return this.readTimeout < 0 ? 0 : this.readTimeout;
    }

    protected class FtpOutputStream
    extends FilterOutputStream {
        FtpClient ftp;

        FtpOutputStream(FtpClient cl, OutputStream fd) {
            super(fd);
            this.ftp = cl;
        }

        public void close() throws IOException {
            super.close();
            try {
                if (this.ftp != null) {
                    this.ftp.closeServer();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected class FtpInputStream
    extends FilterInputStream {
        FtpClient ftp;

        FtpInputStream(FtpClient cl, InputStream fd) {
            super(new BufferedInputStream(fd));
            this.ftp = cl;
        }

        public void close() throws IOException {
            super.close();
            try {
                if (this.ftp != null) {
                    this.ftp.closeServer();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

