/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www;

import java.util.Iterator;

public class HeaderParser {
    String raw;
    String[][] tab;
    int nkeys;
    int asize = 10;

    public HeaderParser(String raw) {
        this.raw = raw;
        this.tab = new String[this.asize][2];
        this.parse();
    }

    private HeaderParser() {
    }

    public HeaderParser subsequence(int start, int end) {
        if (start == 0 && end == this.nkeys) {
            return this;
        }
        if (start < 0 || start >= end || end > this.nkeys) {
            throw new IllegalArgumentException("invalid start or end");
        }
        HeaderParser n = new HeaderParser();
        n.tab = new String[this.asize][2];
        n.asize = this.asize;
        System.arraycopy(this.tab, start, n.tab, 0, end - start);
        n.nkeys = end - start;
        return n;
    }

    private void parse() {
        if (this.raw != null) {
            this.raw = this.raw.trim();
            char[] ca = this.raw.toCharArray();
            int beg = 0;
            int end = 0;
            int i = 0;
            boolean inKey = true;
            boolean inQuote = false;
            int len = ca.length;
            while (end < len) {
                char c = ca[end];
                if (c == '=' && !inQuote) {
                    this.tab[i][0] = new String(ca, beg, end - beg).toLowerCase();
                    inKey = false;
                    beg = ++end;
                } else if (c == '\"') {
                    if (inQuote) {
                        this.tab[i++][1] = new String(ca, beg, end - beg);
                        inQuote = false;
                        while (++end < len && (ca[end] == ' ' || ca[end] == ',')) {
                        }
                        inKey = true;
                        beg = end;
                    } else {
                        inQuote = true;
                        beg = ++end;
                    }
                } else if (c == ' ' || c == ',') {
                    if (inQuote) {
                        ++end;
                        continue;
                    }
                    if (inKey) {
                        this.tab[i++][0] = new String(ca, beg, end - beg).toLowerCase();
                    } else {
                        this.tab[i++][1] = new String(ca, beg, end - beg);
                    }
                    while (end < len && (ca[end] == ' ' || ca[end] == ',')) {
                        ++end;
                    }
                    inKey = true;
                    beg = end;
                } else {
                    ++end;
                }
                if (i != this.asize) continue;
                this.asize *= 2;
                String[][] ntab = new String[this.asize][2];
                System.arraycopy(this.tab, 0, ntab, 0, this.tab.length);
                this.tab = ntab;
            }
            if (--end > beg) {
                if (!inKey) {
                    this.tab[i++][1] = ca[end] == '\"' ? new String(ca, beg, end - beg) : new String(ca, beg, end - beg + 1);
                } else {
                    this.tab[i++][0] = new String(ca, beg, end - beg + 1).toLowerCase();
                }
            } else if (end == beg) {
                if (!inKey) {
                    this.tab[i++][1] = ca[end] == '\"' ? String.valueOf(ca[end - 1]) : String.valueOf(ca[end]);
                } else {
                    this.tab[i++][0] = String.valueOf(ca[end]).toLowerCase();
                }
            }
            this.nkeys = i;
        }
    }

    public String findKey(int i) {
        if (i < 0 || i > this.asize) {
            return null;
        }
        return this.tab[i][0];
    }

    public String findValue(int i) {
        if (i < 0 || i > this.asize) {
            return null;
        }
        return this.tab[i][1];
    }

    public String findValue(String key) {
        return this.findValue(key, null);
    }

    public String findValue(String k, String Default2) {
        if (k == null) {
            return Default2;
        }
        k = k.toLowerCase();
        for (int i = 0; i < this.asize; ++i) {
            if (this.tab[i][0] == null) {
                return Default2;
            }
            if (!k.equals(this.tab[i][0])) continue;
            return this.tab[i][1];
        }
        return Default2;
    }

    public Iterator keys() {
        return new ParserIterator(false);
    }

    public Iterator values() {
        return new ParserIterator(true);
    }

    public String toString() {
        Iterator k = this.keys();
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("{size=" + this.asize + " nkeys=" + this.nkeys + " ");
        int i = 0;
        while (k.hasNext()) {
            String key = (String)k.next();
            String val = this.findValue(i);
            if (val != null && "".equals(val)) {
                val = null;
            }
            sbuf.append(" {" + key + (val == null ? "" : "," + val) + "}");
            if (k.hasNext()) {
                sbuf.append(",");
            }
            ++i;
        }
        sbuf.append(" }");
        return new String(sbuf);
    }

    public int findInt(String k, int Default2) {
        try {
            return Integer.parseInt(this.findValue(k, String.valueOf(Default2)));
        }
        catch (Throwable t) {
            return Default2;
        }
    }

    class ParserIterator
    implements Iterator {
        int index;
        boolean returnsValue;

        ParserIterator(boolean returnValue) {
            this.returnsValue = returnValue;
        }

        public boolean hasNext() {
            return this.index < HeaderParser.this.nkeys;
        }

        public Object next() {
            return HeaderParser.this.tab[this.index++][this.returnsValue ? 1 : 0];
        }

        public void remove() {
            throw new UnsupportedOperationException("remove not supported");
        }
    }
}

