/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.shell;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import sun.awt.shell.DefaultShellFolder;
import sun.awt.shell.ShellFolder;
import sun.awt.shell.ShellFolderColumnInfo;

class ShellFolderManager {
    private static final String COLUMN_NAME = "FileChooser.fileNameHeaderText";
    private static final String COLUMN_SIZE = "FileChooser.fileSizeHeaderText";
    private static final String COLUMN_DATE = "FileChooser.fileDateHeaderText";
    private Comparator fileComparator = new Comparator(){

        public int compare(Object a, Object b) {
            return this.compare((File)a, (File)b);
        }

        public int compare(File f1, File f2) {
            ShellFolder sf1 = null;
            ShellFolder sf2 = null;
            if (f1 instanceof ShellFolder && (sf1 = (ShellFolder)f1).isFileSystem()) {
                sf1 = null;
            }
            if (f2 instanceof ShellFolder && (sf2 = (ShellFolder)f2).isFileSystem()) {
                sf2 = null;
            }
            if (sf1 != null && sf2 != null) {
                return sf1.compareTo(sf2);
            }
            if (sf1 != null) {
                return -1;
            }
            if (sf2 != null) {
                return 1;
            }
            String name1 = f1.getName();
            String name2 = f2.getName();
            int diff = name1.toLowerCase().compareTo(name2.toLowerCase());
            if (diff != 0) {
                return diff;
            }
            return name1.compareTo(name2);
        }
    };

    ShellFolderManager() {
    }

    public ShellFolder createShellFolder(File file) throws FileNotFoundException {
        return new DefaultShellFolder(null, file);
    }

    public Object get(String key) {
        if (key.equals("fileChooserDefaultFolder")) {
            File homeDir = new File(System.getProperty("user.home"));
            try {
                return this.createShellFolder(homeDir);
            }
            catch (FileNotFoundException e) {
                return homeDir;
            }
        }
        if (key.equals("roots")) {
            return File.listRoots();
        }
        if (key.equals("fileChooserComboBoxFolders")) {
            return this.get("roots");
        }
        if (key.equals("fileChooserShortcutPanelFolders")) {
            return new File[]{(File)this.get("fileChooserDefaultFolder")};
        }
        return null;
    }

    public boolean isComputerNode(File dir) {
        return false;
    }

    public boolean isFileSystemRoot(File dir) {
        if (dir instanceof ShellFolder && !((ShellFolder)dir).isFileSystem()) {
            return false;
        }
        return dir.getParentFile() == null;
    }

    public void sortFiles(List files) {
        Collections.sort(files, this.fileComparator);
    }

    public ShellFolderColumnInfo[] getFolderColumns(File dir) {
        ShellFolderColumnInfo[] columns = null;
        if (dir instanceof ShellFolder) {
            columns = ((ShellFolder)dir).getFolderColumns();
        }
        if (columns == null) {
            columns = new ShellFolderColumnInfo[]{new ShellFolderColumnInfo(COLUMN_NAME, 150, 10, true, null, this.fileComparator), new ShellFolderColumnInfo(COLUMN_SIZE, 75, 4, true, null, ComparableComparator.getInstance(), true), new ShellFolderColumnInfo(COLUMN_DATE, 130, 10, true, null, ComparableComparator.getInstance(), true)};
        }
        return columns;
    }

    public Object getFolderColumnValue(File file, int column) {
        Object value;
        if (file instanceof ShellFolder && (value = ((ShellFolder)file).getFolderColumnValue(column)) != null) {
            return value;
        }
        if (file == null || !file.exists()) {
            return null;
        }
        switch (column) {
            case 0: {
                return file;
            }
            case 1: {
                return file.isDirectory() ? null : new Long(file.length());
            }
            case 2: {
                if (this.isFileSystemRoot(file)) {
                    return null;
                }
                long time = file.lastModified();
                return time == 0L ? null : new Date(time);
            }
        }
        return null;
    }

    private static class ComparableComparator
    implements Comparator {
        private static Comparator instance;

        private ComparableComparator() {
        }

        public static Comparator getInstance() {
            if (instance == null) {
                instance = new ComparableComparator();
            }
            return instance;
        }

        public int compare(Object o1, Object o2) {
            int gt = o1 == null && o2 == null ? 0 : (o1 != null && o2 == null ? 1 : (o1 == null && o2 != null ? -1 : (o1 instanceof Comparable ? ((Comparable)o1).compareTo(o2) : 0)));
            return gt;
        }
    }
}

