/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import sun.awt.X11.Native;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XDecoratedPeer;
import sun.awt.X11.XEmbeddedFramePeer;
import sun.awt.X11.XQueryTree;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XTranslateCoordinates;
import sun.awt.X11.XWM;
import sun.awt.X11.XWindowAttributes;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibWrapper;
import sun.awt.X11GraphicsEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XlibUtil {
    static Boolean isShapingSupported = null;

    private XlibUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getRootWindow(int screenNumber) {
        XToolkit.awtLock();
        try {
            X11GraphicsEnvironment x11ge = (X11GraphicsEnvironment)GraphicsEnvironment.getLocalGraphicsEnvironment();
            if (x11ge.runningXinerama()) {
                long l = XlibWrapper.RootWindow(XToolkit.getDisplay(), 0L);
                return l;
            }
            long l = XlibWrapper.RootWindow(XToolkit.getDisplay(), screenNumber);
            return l;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isRoot(long rootCandidate, long screenNumber) {
        long root;
        XToolkit.awtLock();
        try {
            root = XlibWrapper.RootWindow(XToolkit.getDisplay(), screenNumber);
        }
        finally {
            XToolkit.awtUnlock();
        }
        return root == rootCandidate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Rectangle getWindowGeometry(long window) {
        XToolkit.awtLock();
        try {
            int res = XlibWrapper.XGetGeometry(XToolkit.getDisplay(), window, XlibWrapper.larg1, XlibWrapper.larg2, XlibWrapper.larg3, XlibWrapper.larg4, XlibWrapper.larg5, XlibWrapper.larg6, XlibWrapper.larg7);
            if (res == 0) {
                Rectangle rectangle = null;
                return rectangle;
            }
            int x = Native.getInt(XlibWrapper.larg2);
            int y = Native.getInt(XlibWrapper.larg3);
            long width = Native.getUInt(XlibWrapper.larg4);
            long height = Native.getUInt(XlibWrapper.larg5);
            Rectangle rectangle = new Rectangle(x, y, (int)width, (int)height);
            return rectangle;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Point translateCoordinates(long src, long dst, Point p) {
        Point translated = null;
        XToolkit.awtLock();
        try {
            XTranslateCoordinates xtc = new XTranslateCoordinates(src, dst, p.x, p.y);
            try {
                int status = xtc.execute(XToolkit.IgnoreBadWindowHandler);
                if (status != 0 && (XToolkit.saved_error == null || XToolkit.saved_error.get_error_code() == 0)) {
                    translated = new Point(xtc.get_dest_x(), xtc.get_dest_y());
                }
            }
            finally {
                xtc.dispose();
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
        return translated;
    }

    static Rectangle translateCoordinates(long src, long dst, Rectangle r) {
        Point translatedLoc = XlibUtil.translateCoordinates(src, dst, r.getLocation());
        if (translatedLoc == null) {
            return null;
        }
        return new Rectangle(translatedLoc, r.getSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long getParentWindow(long window) {
        XToolkit.awtLock();
        try {
            XQueryTree qt;
            block10: {
                XBaseWindow pbw;
                XBaseWindow bw = XToolkit.windowToXWindow(window);
                if (bw != null && (pbw = bw.getParentWindow()) != null) {
                    long l = pbw.getWindow();
                    return l;
                }
                qt = new XQueryTree(window);
                try {
                    if (qt.execute() != 0) break block10;
                    long l = 0L;
                    qt.dispose();
                    return l;
                }
                catch (Throwable throwable) {
                    qt.dispose();
                    throw throwable;
                }
            }
            long l = qt.get_parent();
            qt.dispose();
            return l;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set<Long> getChildWindows(long window) {
        XToolkit.awtLock();
        try {
            long children;
            XQueryTree xqt;
            block14: {
                block13: {
                    XBaseWindow bw = XToolkit.windowToXWindow(window);
                    if (bw != null) {
                        Set<Long> set = bw.getChildren();
                        return set;
                    }
                    xqt = new XQueryTree(window);
                    int status = xqt.execute();
                    if (status != 0) break block13;
                    Set<Long> set = Collections.emptySet();
                    xqt.dispose();
                    return set;
                }
                children = xqt.get_children();
                if (children != 0L) break block14;
                Set<Long> set = Collections.emptySet();
                xqt.dispose();
                return set;
            }
            try {
                int childrenCount = xqt.get_nchildren();
                HashSet<Long> childrenSet = new HashSet<Long>(childrenCount);
                for (int i = 0; i < childrenCount; ++i) {
                    childrenSet.add(Native.getWindow(children, i));
                }
                HashSet<Long> hashSet = childrenSet;
                xqt.dispose();
                return hashSet;
            }
            catch (Throwable throwable) {
                xqt.dispose();
                throw throwable;
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    static boolean isXAWTToplevelWindow(long window) {
        return XToolkit.windowToXWindow(window) instanceof XWindowPeer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isToplevelWindow(long window) {
        if (XToolkit.windowToXWindow(window) instanceof XDecoratedPeer) {
            return true;
        }
        XToolkit.awtLock();
        try {
            WindowPropertyGetter wpg = new WindowPropertyGetter(window, XWM.XA_WM_STATE, 0L, 1L, false, XWM.XA_WM_STATE);
            try {
                wpg.execute(XToolkit.IgnoreBadWindowHandler);
                if (wpg.getActualType() == XWM.XA_WM_STATE.getAtom()) {
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                wpg.dispose();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    static boolean isTrueToplevelWindow(long window) {
        if (XToolkit.windowToXWindow(window) instanceof XEmbeddedFramePeer) {
            return false;
        }
        return XlibUtil.isToplevelWindow(window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getWindowMapState(long window) {
        XToolkit.awtLock();
        XWindowAttributes wattr = new XWindowAttributes();
        try {
            XToolkit.WITH_XERROR_HANDLER(XToolkit.IgnoreBadWindowHandler);
            int status = XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), window, wattr.pData);
            XToolkit.RESTORE_XERROR_HANDLER();
            if (status != 0 && (XToolkit.saved_error == null || XToolkit.saved_error.get_error_code() == 0)) {
                int n = wattr.get_map_state();
                return n;
            }
        }
        finally {
            wattr.dispose();
            XToolkit.awtUnlock();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized boolean isShapingSupported() {
        if (isShapingSupported == null) {
            XToolkit.awtLock();
            try {
                isShapingSupported = XlibWrapper.XShapeQueryExtension(XToolkit.getDisplay(), XlibWrapper.larg1, XlibWrapper.larg2);
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        return isShapingSupported;
    }
}

