/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import sun.awt.X11.XAtom;
import sun.awt.X11.XToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XAtomList {
    Set<XAtom> atoms = new HashSet<XAtom>();

    public XAtomList() {
    }

    public XAtomList(long data, int count) {
        this.init(data, count);
    }

    private void init(long data, int count) {
        for (int i = 0; i < count; ++i) {
            this.add(new XAtom(XToolkit.getDisplay(), XAtom.getAtom(data + (long)(count * XAtom.getAtomSize()))));
        }
    }

    public XAtomList(XAtom[] atoms) {
        this.init(atoms);
    }

    private void init(XAtom[] atoms) {
        for (int i = 0; i < atoms.length; ++i) {
            this.add(atoms[i]);
        }
    }

    public XAtom[] getAtoms() {
        XAtom[] res = new XAtom[this.size()];
        Iterator<XAtom> iter = this.atoms.iterator();
        int i = 0;
        while (iter.hasNext()) {
            res[i++] = iter.next();
        }
        return res;
    }

    public long getAtomsData() {
        return XAtom.toData(this.getAtoms());
    }

    public boolean contains(XAtom atom) {
        return this.atoms.contains(atom);
    }

    public void add(XAtom atom) {
        this.atoms.add(atom);
    }

    public void remove(XAtom atom) {
        this.atoms.remove(atom);
    }

    public int size() {
        return this.atoms.size();
    }

    public XAtomList subset(int mask, Map<Integer, XAtom> mapping) {
        XAtomList res = new XAtomList();
        for (Integer bits : mapping.keySet()) {
            XAtom atom;
            if ((mask & bits) != bits || !this.contains(atom = mapping.get(bits))) continue;
            res.add(atom);
        }
        return res;
    }

    public Iterator<XAtom> iterator() {
        return this.atoms.iterator();
    }

    public void addAll(XAtomList atoms) {
        Iterator<XAtom> iter = atoms.iterator();
        while (iter.hasNext()) {
            this.add(iter.next());
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        Iterator<XAtom> iter = this.atoms.iterator();
        while (iter.hasNext()) {
            buf.append(((Object)iter.next()).toString());
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }
}

