/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalUtils;

public class MetalTabbedPaneUI
extends BasicTabbedPaneUI {
    protected int minTabWidth = 40;
    private Color unselectedBackground;
    protected Color tabAreaBackground;
    protected Color selectColor;
    protected Color selectHighlight;
    private boolean tabsOpaque = true;
    private boolean ocean;
    private Color oceanSelectedBorderColor;

    public static ComponentUI createUI(JComponent x) {
        return new MetalTabbedPaneUI();
    }

    protected LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            return super.createLayoutManager();
        }
        return new TabbedPaneLayout();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.tabAreaBackground = UIManager.getColor("TabbedPane.tabAreaBackground");
        this.selectColor = UIManager.getColor("TabbedPane.selected");
        this.selectHighlight = UIManager.getColor("TabbedPane.selectHighlight");
        this.tabsOpaque = UIManager.getBoolean("TabbedPane.tabsOpaque");
        this.unselectedBackground = UIManager.getColor("TabbedPane.unselectedBackground");
        this.ocean = MetalLookAndFeel.usingOcean();
        if (this.ocean) {
            this.oceanSelectedBorderColor = UIManager.getColor("TabbedPane.borderHightlightColor");
        }
    }

    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        int bottom = y + (h - 1);
        int right = x + (w - 1);
        switch (tabPlacement) {
            case 2: {
                this.paintLeftTabBorder(tabIndex, g, x, y, w, h, bottom, right, isSelected);
                break;
            }
            case 3: {
                this.paintBottomTabBorder(tabIndex, g, x, y, w, h, bottom, right, isSelected);
                break;
            }
            case 4: {
                this.paintRightTabBorder(tabIndex, g, x, y, w, h, bottom, right, isSelected);
                break;
            }
            default: {
                this.paintTopTabBorder(tabIndex, g, x, y, w, h, bottom, right, isSelected);
            }
        }
    }

    protected void paintTopTabBorder(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
        int currentRun = this.getRunForTab(this.tabPane.getTabCount(), tabIndex);
        int lastIndex = this.lastTabInRun(this.tabPane.getTabCount(), currentRun);
        int firstIndex = this.tabRuns[currentRun];
        boolean leftToRight = MetalUtils.isLeftToRight(this.tabPane);
        int selectedIndex = this.tabPane.getSelectedIndex();
        int bottom = h - 1;
        int right = w - 1;
        if (this.shouldFillGap(currentRun, tabIndex, x, y)) {
            g.translate(x, y);
            if (leftToRight) {
                g.setColor(this.getColorForGap(currentRun, x, y + 1));
                g.fillRect(1, 0, 5, 3);
                g.fillRect(1, 3, 2, 2);
            } else {
                g.setColor(this.getColorForGap(currentRun, x + w - 1, y + 1));
                g.fillRect(right - 5, 0, 5, 3);
                g.fillRect(right - 2, 3, 2, 2);
            }
            g.translate(-x, -y);
        }
        g.translate(x, y);
        if (this.ocean && isSelected) {
            g.setColor(this.oceanSelectedBorderColor);
        } else {
            g.setColor(this.darkShadow);
        }
        if (leftToRight) {
            g.drawLine(1, 5, 6, 0);
            g.drawLine(6, 0, right, 0);
            if (tabIndex == lastIndex) {
                g.drawLine(right, 1, right, bottom);
            }
            if (this.ocean && tabIndex - 1 == selectedIndex && currentRun == this.getRunForTab(this.tabPane.getTabCount(), selectedIndex)) {
                g.setColor(this.oceanSelectedBorderColor);
            }
            if (tabIndex != this.tabRuns[this.runCount - 1]) {
                if (this.ocean && isSelected) {
                    g.drawLine(0, 6, 0, bottom);
                    g.setColor(this.darkShadow);
                    g.drawLine(0, 0, 0, 5);
                } else {
                    g.drawLine(0, 0, 0, bottom);
                }
            } else {
                g.drawLine(0, 6, 0, bottom);
            }
        } else {
            g.drawLine(right - 1, 5, right - 6, 0);
            g.drawLine(right - 6, 0, 0, 0);
            if (tabIndex == lastIndex) {
                g.drawLine(0, 1, 0, bottom);
            }
            if (this.ocean && tabIndex - 1 == selectedIndex && currentRun == this.getRunForTab(this.tabPane.getTabCount(), selectedIndex)) {
                g.setColor(this.oceanSelectedBorderColor);
                g.drawLine(right, 0, right, bottom);
            } else if (this.ocean && isSelected) {
                g.drawLine(right, 6, right, bottom);
                if (tabIndex != 0) {
                    g.setColor(this.darkShadow);
                    g.drawLine(right, 0, right, 5);
                }
            } else if (tabIndex != this.tabRuns[this.runCount - 1]) {
                g.drawLine(right, 0, right, bottom);
            } else {
                g.drawLine(right, 6, right, bottom);
            }
        }
        g.setColor(isSelected ? this.selectHighlight : this.highlight);
        if (leftToRight) {
            g.drawLine(1, 6, 6, 1);
            g.drawLine(6, 1, tabIndex == lastIndex ? right - 1 : right, 1);
            g.drawLine(1, 6, 1, bottom);
            if (tabIndex == firstIndex && tabIndex != this.tabRuns[this.runCount - 1]) {
                if (this.tabPane.getSelectedIndex() == this.tabRuns[currentRun + 1]) {
                    g.setColor(this.selectHighlight);
                } else {
                    g.setColor(this.highlight);
                }
                g.drawLine(1, 0, 1, 4);
            }
        } else {
            g.drawLine(right - 1, 6, right - 6, 1);
            g.drawLine(right - 6, 1, 1, 1);
            if (tabIndex == lastIndex) {
                g.drawLine(1, 1, 1, bottom);
            } else {
                g.drawLine(0, 1, 0, bottom);
            }
        }
        g.translate(-x, -y);
    }

    protected boolean shouldFillGap(int currentRun, int tabIndex, int x, int y) {
        boolean result = false;
        if (!this.tabsOpaque) {
            return false;
        }
        if (currentRun == this.runCount - 2) {
            int currentTabRight;
            int lastTabLeft;
            int lastTabRight;
            Rectangle lastTabBounds = this.getTabBounds(this.tabPane, this.tabPane.getTabCount() - 1);
            Rectangle tabBounds = this.getTabBounds(this.tabPane, tabIndex);
            if (MetalUtils.isLeftToRight(this.tabPane) ? (lastTabRight = lastTabBounds.x + lastTabBounds.width - 1) > tabBounds.x + 2 : (lastTabLeft = lastTabBounds.x) < (currentTabRight = tabBounds.x + tabBounds.width - 1) - 2) {
                return true;
            }
        } else {
            result = currentRun != this.runCount - 1;
        }
        return result;
    }

    protected Color getColorForGap(int currentRun, int x, int y) {
        int shadowWidth = 4;
        int selectedIndex = this.tabPane.getSelectedIndex();
        int startIndex = this.tabRuns[currentRun + 1];
        int endIndex = this.lastTabInRun(this.tabPane.getTabCount(), currentRun + 1);
        int tabOverGap = -1;
        for (int i = startIndex; i <= endIndex; ++i) {
            Rectangle tabBounds = this.getTabBounds(this.tabPane, i);
            int tabLeft = tabBounds.x;
            int tabRight = tabBounds.x + tabBounds.width - 1;
            if (!(MetalUtils.isLeftToRight(this.tabPane) ? tabLeft <= x && tabRight - 4 > x : tabLeft + 4 < x && tabRight >= x)) continue;
            return selectedIndex == i ? this.selectColor : this.getUnselectedBackgroundAt(i);
        }
        return this.tabPane.getBackground();
    }

    protected void paintLeftTabBorder(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
        int tabCount = this.tabPane.getTabCount();
        int currentRun = this.getRunForTab(tabCount, tabIndex);
        int lastIndex = this.lastTabInRun(tabCount, currentRun);
        int firstIndex = this.tabRuns[currentRun];
        g.translate(x, y);
        int bottom = h - 1;
        int right = w - 1;
        if (tabIndex != firstIndex && this.tabsOpaque) {
            g.setColor(this.tabPane.getSelectedIndex() == tabIndex - 1 ? this.selectColor : this.getUnselectedBackgroundAt(tabIndex - 1));
            g.fillRect(2, 0, 4, 3);
            g.drawLine(2, 3, 2, 3);
        }
        if (this.ocean) {
            g.setColor(isSelected ? this.selectHighlight : MetalLookAndFeel.getWhite());
        } else {
            g.setColor(isSelected ? this.selectHighlight : this.highlight);
        }
        g.drawLine(1, 6, 6, 1);
        g.drawLine(1, 6, 1, bottom);
        g.drawLine(6, 1, right, 1);
        if (tabIndex != firstIndex) {
            if (this.tabPane.getSelectedIndex() == tabIndex - 1) {
                g.setColor(this.selectHighlight);
            } else {
                g.setColor(this.ocean ? MetalLookAndFeel.getWhite() : this.highlight);
            }
            g.drawLine(1, 0, 1, 4);
        }
        if (this.ocean) {
            if (isSelected) {
                g.setColor(this.oceanSelectedBorderColor);
            } else {
                g.setColor(this.darkShadow);
            }
        } else {
            g.setColor(this.darkShadow);
        }
        g.drawLine(1, 5, 6, 0);
        g.drawLine(6, 0, right, 0);
        if (tabIndex == lastIndex) {
            g.drawLine(0, bottom, right, bottom);
        }
        if (this.ocean) {
            if (this.tabPane.getSelectedIndex() == tabIndex - 1) {
                g.drawLine(0, 5, 0, bottom);
                g.setColor(this.oceanSelectedBorderColor);
                g.drawLine(0, 0, 0, 5);
            } else if (isSelected) {
                g.drawLine(0, 6, 0, bottom);
                if (tabIndex != 0) {
                    g.setColor(this.darkShadow);
                    g.drawLine(0, 0, 0, 5);
                }
            } else if (tabIndex != firstIndex) {
                g.drawLine(0, 0, 0, bottom);
            } else {
                g.drawLine(0, 6, 0, bottom);
            }
        } else if (tabIndex != firstIndex) {
            g.drawLine(0, 0, 0, bottom);
        } else {
            g.drawLine(0, 6, 0, bottom);
        }
        g.translate(-x, -y);
    }

    protected void paintBottomTabBorder(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
        int tabCount = this.tabPane.getTabCount();
        int currentRun = this.getRunForTab(tabCount, tabIndex);
        int lastIndex = this.lastTabInRun(tabCount, currentRun);
        int firstIndex = this.tabRuns[currentRun];
        boolean leftToRight = MetalUtils.isLeftToRight(this.tabPane);
        int bottom = h - 1;
        int right = w - 1;
        if (this.shouldFillGap(currentRun, tabIndex, x, y)) {
            g.translate(x, y);
            if (leftToRight) {
                g.setColor(this.getColorForGap(currentRun, x, y));
                g.fillRect(1, bottom - 4, 3, 5);
                g.fillRect(4, bottom - 1, 2, 2);
            } else {
                g.setColor(this.getColorForGap(currentRun, x + w - 1, y));
                g.fillRect(right - 3, bottom - 3, 3, 4);
                g.fillRect(right - 5, bottom - 1, 2, 2);
                g.drawLine(right - 1, bottom - 4, right - 1, bottom - 4);
            }
            g.translate(-x, -y);
        }
        g.translate(x, y);
        if (this.ocean && isSelected) {
            g.setColor(this.oceanSelectedBorderColor);
        } else {
            g.setColor(this.darkShadow);
        }
        if (leftToRight) {
            g.drawLine(1, bottom - 5, 6, bottom);
            g.drawLine(6, bottom, right, bottom);
            if (tabIndex == lastIndex) {
                g.drawLine(right, 0, right, bottom);
            }
            if (this.ocean && isSelected) {
                g.drawLine(0, 0, 0, bottom - 6);
                if (currentRun == 0 && tabIndex != 0 || currentRun > 0 && tabIndex != this.tabRuns[currentRun - 1]) {
                    g.setColor(this.darkShadow);
                    g.drawLine(0, bottom - 5, 0, bottom);
                }
            } else {
                if (this.ocean && tabIndex == this.tabPane.getSelectedIndex() + 1) {
                    g.setColor(this.oceanSelectedBorderColor);
                }
                if (tabIndex != this.tabRuns[this.runCount - 1]) {
                    g.drawLine(0, 0, 0, bottom);
                } else {
                    g.drawLine(0, 0, 0, bottom - 6);
                }
            }
        } else {
            g.drawLine(right - 1, bottom - 5, right - 6, bottom);
            g.drawLine(right - 6, bottom, 0, bottom);
            if (tabIndex == lastIndex) {
                g.drawLine(0, 0, 0, bottom);
            }
            if (this.ocean && tabIndex == this.tabPane.getSelectedIndex() + 1) {
                g.setColor(this.oceanSelectedBorderColor);
                g.drawLine(right, 0, right, bottom);
            } else if (this.ocean && isSelected) {
                g.drawLine(right, 0, right, bottom - 6);
                if (tabIndex != firstIndex) {
                    g.setColor(this.darkShadow);
                    g.drawLine(right, bottom - 5, right, bottom);
                }
            } else if (tabIndex != this.tabRuns[this.runCount - 1]) {
                g.drawLine(right, 0, right, bottom);
            } else {
                g.drawLine(right, 0, right, bottom - 6);
            }
        }
        g.setColor(isSelected ? this.selectHighlight : this.highlight);
        if (leftToRight) {
            g.drawLine(1, bottom - 6, 6, bottom - 1);
            g.drawLine(1, 0, 1, bottom - 6);
            if (tabIndex == firstIndex && tabIndex != this.tabRuns[this.runCount - 1]) {
                if (this.tabPane.getSelectedIndex() == this.tabRuns[currentRun + 1]) {
                    g.setColor(this.selectHighlight);
                } else {
                    g.setColor(this.highlight);
                }
                g.drawLine(1, bottom - 4, 1, bottom);
            }
        } else if (tabIndex == lastIndex) {
            g.drawLine(1, 0, 1, bottom - 1);
        } else {
            g.drawLine(0, 0, 0, bottom - 1);
        }
        g.translate(-x, -y);
    }

    protected void paintRightTabBorder(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
        int tabCount = this.tabPane.getTabCount();
        int currentRun = this.getRunForTab(tabCount, tabIndex);
        int lastIndex = this.lastTabInRun(tabCount, currentRun);
        int firstIndex = this.tabRuns[currentRun];
        g.translate(x, y);
        int bottom = h - 1;
        int right = w - 1;
        if (tabIndex != firstIndex && this.tabsOpaque) {
            g.setColor(this.tabPane.getSelectedIndex() == tabIndex - 1 ? this.selectColor : this.getUnselectedBackgroundAt(tabIndex - 1));
            g.fillRect(right - 5, 0, 5, 3);
            g.fillRect(right - 2, 3, 2, 2);
        }
        g.setColor(isSelected ? this.selectHighlight : this.highlight);
        g.drawLine(right - 6, 1, right - 1, 6);
        g.drawLine(0, 1, right - 6, 1);
        if (!isSelected) {
            g.drawLine(0, 1, 0, bottom);
        }
        if (this.ocean && isSelected) {
            g.setColor(this.oceanSelectedBorderColor);
        } else {
            g.setColor(this.darkShadow);
        }
        if (tabIndex == lastIndex) {
            g.drawLine(0, bottom, right, bottom);
        }
        if (this.ocean && this.tabPane.getSelectedIndex() == tabIndex - 1) {
            g.setColor(this.oceanSelectedBorderColor);
        }
        g.drawLine(right - 6, 0, right, 6);
        g.drawLine(0, 0, right - 6, 0);
        if (this.ocean && isSelected) {
            g.drawLine(right, 6, right, bottom);
            if (tabIndex != firstIndex) {
                g.setColor(this.darkShadow);
                g.drawLine(right, 0, right, 5);
            }
        } else if (this.ocean && this.tabPane.getSelectedIndex() == tabIndex - 1) {
            g.setColor(this.oceanSelectedBorderColor);
            g.drawLine(right, 0, right, 6);
            g.setColor(this.darkShadow);
            g.drawLine(right, 6, right, bottom);
        } else if (tabIndex != firstIndex) {
            g.drawLine(right, 0, right, bottom);
        } else {
            g.drawLine(right, 6, right, bottom);
        }
        g.translate(-x, -y);
    }

    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            g.setColor(this.tabAreaBackground);
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        this.paint(g, c);
    }

    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        int slantWidth = h / 2;
        if (isSelected) {
            g.setColor(this.selectColor);
        } else {
            g.setColor(this.getUnselectedBackgroundAt(tabIndex));
        }
        if (MetalUtils.isLeftToRight(this.tabPane)) {
            switch (tabPlacement) {
                case 2: {
                    g.fillRect(x + 5, y + 1, w - 5, h - 1);
                    g.fillRect(x + 2, y + 4, 3, h - 4);
                    break;
                }
                case 3: {
                    g.fillRect(x + 2, y, w - 2, h - 4);
                    g.fillRect(x + 5, y + (h - 1) - 3, w - 5, 3);
                    break;
                }
                case 4: {
                    g.fillRect(x, y + 2, w - 4, h - 2);
                    g.fillRect(x + (w - 1) - 3, y + 5, 3, h - 5);
                    break;
                }
                default: {
                    g.fillRect(x + 4, y + 2, w - 1 - 3, h - 1 - 1);
                    g.fillRect(x + 2, y + 5, 2, h - 5);
                    break;
                }
            }
        } else {
            switch (tabPlacement) {
                case 2: {
                    g.fillRect(x + 5, y + 1, w - 5, h - 1);
                    g.fillRect(x + 2, y + 4, 3, h - 4);
                    break;
                }
                case 3: {
                    g.fillRect(x, y, w - 5, h - 1);
                    g.fillRect(x + (w - 1) - 4, y, 4, h - 5);
                    g.fillRect(x + (w - 1) - 4, y + (h - 1) - 4, 2, 2);
                    break;
                }
                case 4: {
                    g.fillRect(x + 1, y + 1, w - 5, h - 1);
                    g.fillRect(x + (w - 1) - 3, y + 5, 3, h - 5);
                    break;
                }
                default: {
                    g.fillRect(x, y + 2, w - 1 - 3, h - 1 - 1);
                    g.fillRect(x + (w - 1) - 3, y + 5, 3, h - 3);
                }
            }
        }
    }

    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        return 0;
    }

    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        return 0;
    }

    protected int getBaselineOffset() {
        return 0;
    }

    public void paint(Graphics g, JComponent c) {
        int tabPlacement = this.tabPane.getTabPlacement();
        Insets insets = c.getInsets();
        Dimension size = c.getSize();
        if (this.tabPane.isOpaque()) {
            Color bg = UIManager.getColor("TabbedPane.tabAreaBackground");
            if (bg != null) {
                g.setColor(bg);
            } else {
                g.setColor(c.getBackground());
            }
            switch (tabPlacement) {
                case 2: {
                    g.fillRect(insets.left, insets.top, this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth), size.height - insets.bottom - insets.top);
                    break;
                }
                case 3: {
                    int totalTabHeight = this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                    g.fillRect(insets.left, size.height - insets.bottom - totalTabHeight, size.width - insets.left - insets.right, totalTabHeight);
                    break;
                }
                case 4: {
                    int totalTabWidth = this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                    g.fillRect(size.width - insets.right - totalTabWidth, insets.top, totalTabWidth, size.height - insets.top - insets.bottom);
                    break;
                }
                default: {
                    g.fillRect(insets.left, insets.top, size.width - insets.right - insets.left, this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight));
                    this.paintHighlightBelowTab();
                }
            }
        }
        super.paint(g, c);
    }

    protected void paintHighlightBelowTab() {
    }

    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        if (this.tabPane.hasFocus() && isSelected) {
            Rectangle tabRect = rects[tabIndex];
            boolean lastInRun = this.isLastInRun(tabIndex);
            g.setColor(this.focus);
            g.translate(tabRect.x, tabRect.y);
            int right = tabRect.width - 1;
            int bottom = tabRect.height - 1;
            boolean leftToRight = MetalUtils.isLeftToRight(this.tabPane);
            switch (tabPlacement) {
                case 4: {
                    g.drawLine(right - 6, 2, right - 2, 6);
                    g.drawLine(1, 2, right - 6, 2);
                    g.drawLine(right - 2, 6, right - 2, bottom);
                    g.drawLine(1, 2, 1, bottom);
                    g.drawLine(1, bottom, right - 2, bottom);
                    break;
                }
                case 3: {
                    if (leftToRight) {
                        g.drawLine(2, bottom - 6, 6, bottom - 2);
                        g.drawLine(6, bottom - 2, right, bottom - 2);
                        g.drawLine(2, 0, 2, bottom - 6);
                        g.drawLine(2, 0, right, 0);
                        g.drawLine(right, 0, right, bottom - 2);
                        break;
                    }
                    g.drawLine(right - 2, bottom - 6, right - 6, bottom - 2);
                    g.drawLine(right - 2, 0, right - 2, bottom - 6);
                    if (lastInRun) {
                        g.drawLine(2, bottom - 2, right - 6, bottom - 2);
                        g.drawLine(2, 0, right - 2, 0);
                        g.drawLine(2, 0, 2, bottom - 2);
                        break;
                    }
                    g.drawLine(1, bottom - 2, right - 6, bottom - 2);
                    g.drawLine(1, 0, right - 2, 0);
                    g.drawLine(1, 0, 1, bottom - 2);
                    break;
                }
                case 2: {
                    g.drawLine(2, 6, 6, 2);
                    g.drawLine(2, 6, 2, bottom - 1);
                    g.drawLine(6, 2, right, 2);
                    g.drawLine(right, 2, right, bottom - 1);
                    g.drawLine(2, bottom - 1, right, bottom - 1);
                    break;
                }
                default: {
                    if (leftToRight) {
                        g.drawLine(2, 6, 6, 2);
                        g.drawLine(2, 6, 2, bottom - 1);
                        g.drawLine(6, 2, right, 2);
                        g.drawLine(right, 2, right, bottom - 1);
                        g.drawLine(2, bottom - 1, right, bottom - 1);
                        break;
                    }
                    g.drawLine(right - 2, 6, right - 6, 2);
                    g.drawLine(right - 2, 6, right - 2, bottom - 1);
                    if (lastInRun) {
                        g.drawLine(right - 6, 2, 2, 2);
                        g.drawLine(2, 2, 2, bottom - 1);
                        g.drawLine(right - 2, bottom - 1, 2, bottom - 1);
                        break;
                    }
                    g.drawLine(right - 6, 2, 1, 2);
                    g.drawLine(1, 2, 1, bottom - 1);
                    g.drawLine(right - 2, bottom - 1, 1, bottom - 1);
                }
            }
            g.translate(-tabRect.x, -tabRect.y);
        }
    }

    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect;
        boolean leftToRight = MetalUtils.isLeftToRight(this.tabPane);
        int right = x + w - 1;
        Rectangle rectangle = selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        if (this.ocean) {
            g.setColor(this.oceanSelectedBorderColor);
        } else {
            g.setColor(this.selectHighlight);
        }
        if (tabPlacement != 1 || selectedIndex < 0 || selRect.y + selRect.height + 1 < y || selRect.x < x || selRect.x > x + w) {
            g.drawLine(x, y, x + w - 2, y);
            if (this.ocean && tabPlacement == 1) {
                g.setColor(MetalLookAndFeel.getWhite());
                g.drawLine(x, y + 1, x + w - 2, y + 1);
            }
        } else {
            boolean lastInRun = this.isLastInRun(selectedIndex);
            if (leftToRight || lastInRun) {
                g.drawLine(x, y, selRect.x + 1, y);
            } else {
                g.drawLine(x, y, selRect.x, y);
            }
            if (selRect.x + selRect.width < right - 1) {
                if (leftToRight && !lastInRun) {
                    g.drawLine(selRect.x + selRect.width, y, right - 1, y);
                } else {
                    g.drawLine(selRect.x + selRect.width - 1, y, right - 1, y);
                }
            } else {
                g.setColor(this.shadow);
                g.drawLine(x + w - 2, y, x + w - 2, y);
            }
            if (this.ocean) {
                g.setColor(MetalLookAndFeel.getWhite());
                if (leftToRight || lastInRun) {
                    g.drawLine(x, y + 1, selRect.x + 1, y + 1);
                } else {
                    g.drawLine(x, y + 1, selRect.x, y + 1);
                }
                if (selRect.x + selRect.width < right - 1) {
                    if (leftToRight && !lastInRun) {
                        g.drawLine(selRect.x + selRect.width, y + 1, right - 1, y + 1);
                    } else {
                        g.drawLine(selRect.x + selRect.width - 1, y + 1, right - 1, y + 1);
                    }
                } else {
                    g.setColor(this.shadow);
                    g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                }
            }
        }
    }

    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        boolean leftToRight = MetalUtils.isLeftToRight(this.tabPane);
        int bottom = y + h - 1;
        int right = x + w - 1;
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.darkShadow);
        if (tabPlacement != 3 || selectedIndex < 0 || selRect.y - 1 > h || selRect.x < x || selRect.x > x + w) {
            if (this.ocean && tabPlacement == 3) {
                g.setColor(this.oceanSelectedBorderColor);
            }
            g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        } else {
            boolean lastInRun = this.isLastInRun(selectedIndex);
            if (this.ocean) {
                g.setColor(this.oceanSelectedBorderColor);
            }
            if (leftToRight || lastInRun) {
                g.drawLine(x, bottom, selRect.x, bottom);
            } else {
                g.drawLine(x, bottom, selRect.x - 1, bottom);
            }
            if (selRect.x + selRect.width < x + w - 2) {
                if (leftToRight && !lastInRun) {
                    g.drawLine(selRect.x + selRect.width, bottom, right, bottom);
                } else {
                    g.drawLine(selRect.x + selRect.width - 1, bottom, right, bottom);
                }
            }
        }
    }

    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect;
        Rectangle rectangle = selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        if (this.ocean) {
            g.setColor(this.oceanSelectedBorderColor);
        } else {
            g.setColor(this.selectHighlight);
        }
        if (tabPlacement != 2 || selectedIndex < 0 || selRect.x + selRect.width + 1 < x || selRect.y < y || selRect.y > y + h) {
            g.drawLine(x, y + 1, x, y + h - 2);
            if (this.ocean && tabPlacement == 2) {
                g.setColor(MetalLookAndFeel.getWhite());
                g.drawLine(x + 1, y, x + 1, y + h - 2);
            }
        } else {
            g.drawLine(x, y, x, selRect.y + 1);
            if (selRect.y + selRect.height < y + h - 2) {
                g.drawLine(x, selRect.y + selRect.height + 1, x, y + h + 2);
            }
            if (this.ocean) {
                g.setColor(MetalLookAndFeel.getWhite());
                g.drawLine(x + 1, y + 1, x + 1, selRect.y + 1);
                if (selRect.y + selRect.height < y + h - 2) {
                    g.drawLine(x + 1, selRect.y + selRect.height + 1, x + 1, y + h + 2);
                }
            }
        }
    }

    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.darkShadow);
        if (tabPlacement != 4 || selectedIndex < 0 || selRect.x - 1 > w || selRect.y < y || selRect.y > y + h) {
            if (this.ocean && tabPlacement == 4) {
                g.setColor(this.oceanSelectedBorderColor);
            }
            g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
        } else {
            if (this.ocean) {
                g.setColor(this.oceanSelectedBorderColor);
            }
            g.drawLine(x + w - 1, y, x + w - 1, selRect.y);
            if (selRect.y + selRect.height < y + h - 2) {
                g.drawLine(x + w - 1, selRect.y + selRect.height, x + w - 1, y + h - 2);
            }
        }
    }

    protected int calculateMaxTabHeight(int tabPlacement) {
        FontMetrics metrics = this.getFontMetrics();
        int height = metrics.getHeight();
        boolean tallerIcons = false;
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            Icon icon = this.tabPane.getIconAt(i);
            if (icon == null || icon.getIconHeight() <= height) continue;
            tallerIcons = true;
            break;
        }
        return super.calculateMaxTabHeight(tabPlacement) - (tallerIcons ? this.tabInsets.top + this.tabInsets.bottom : 0);
    }

    protected int getTabRunOverlay(int tabPlacement) {
        if (tabPlacement == 2 || tabPlacement == 4) {
            int maxTabHeight = this.calculateMaxTabHeight(tabPlacement);
            return maxTabHeight / 2;
        }
        return 0;
    }

    protected boolean shouldRotateTabRuns(int tabPlacement, int selectedRun) {
        return false;
    }

    protected boolean shouldPadTabRun(int tabPlacement, int run) {
        return this.runCount > 1 && run < this.runCount - 1;
    }

    private boolean isLastInRun(int tabIndex) {
        int run = this.getRunForTab(this.tabPane.getTabCount(), tabIndex);
        int lastIndex = this.lastTabInRun(this.tabPane.getTabCount(), run);
        return tabIndex == lastIndex;
    }

    private Color getUnselectedBackgroundAt(int index) {
        Color color = this.tabPane.getBackgroundAt(index);
        if (color instanceof UIResource && this.unselectedBackground != null) {
            return this.unselectedBackground;
        }
        return color;
    }

    int getRolloverTabIndex() {
        return this.getRolloverTab();
    }

    public class TabbedPaneLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        protected void normalizeTabRuns(int tabPlacement, int tabCount, int start, int max) {
            if (tabPlacement == 1 || tabPlacement == 3) {
                super.normalizeTabRuns(tabPlacement, tabCount, start, max);
            }
        }

        protected void rotateTabRuns(int tabPlacement, int selectedRun) {
        }

        protected void padSelectedTab(int tabPlacement, int selectedIndex) {
        }
    }
}

