/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.ChangeListenerMap;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeListenerProxy;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Map;

public class VetoableChangeSupport
implements Serializable {
    private VetoableChangeListenerMap map = new VetoableChangeListenerMap();
    private Object source;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("children", Hashtable.class), new ObjectStreamField("source", Object.class), new ObjectStreamField("vetoableChangeSupportSerializedDataVersion", Integer.TYPE)};
    static final long serialVersionUID = -5090210921595982017L;

    public VetoableChangeSupport(Object sourceBean) {
        if (sourceBean == null) {
            throw new NullPointerException();
        }
        this.source = sourceBean;
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (listener instanceof VetoableChangeListenerProxy) {
            VetoableChangeListenerProxy proxy = (VetoableChangeListenerProxy)listener;
            this.addVetoableChangeListener(proxy.getPropertyName(), (VetoableChangeListener)proxy.getListener());
        } else {
            this.map.add(null, listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (listener instanceof VetoableChangeListenerProxy) {
            VetoableChangeListenerProxy proxy = (VetoableChangeListenerProxy)listener;
            this.removeVetoableChangeListener(proxy.getPropertyName(), (VetoableChangeListener)proxy.getListener());
        } else {
            this.map.remove(null, listener);
        }
    }

    public VetoableChangeListener[] getVetoableChangeListeners() {
        return (VetoableChangeListener[])this.map.getListeners();
    }

    public void addVetoableChangeListener(String propertyName, VetoableChangeListener listener) {
        if (listener == null || propertyName == null) {
            return;
        }
        if ((listener = this.map.extract(listener)) != null) {
            this.map.add(propertyName, listener);
        }
    }

    public void removeVetoableChangeListener(String propertyName, VetoableChangeListener listener) {
        if (listener == null || propertyName == null) {
            return;
        }
        if ((listener = this.map.extract(listener)) != null) {
            this.map.remove(propertyName, listener);
        }
    }

    public VetoableChangeListener[] getVetoableChangeListeners(String propertyName) {
        return (VetoableChangeListener[])this.map.getListeners(propertyName);
    }

    public void fireVetoableChange(String propertyName, Object oldValue, Object newValue) throws PropertyVetoException {
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this.source, propertyName, oldValue, newValue);
        this.fireVetoableChange(evt);
    }

    public void fireVetoableChange(String propertyName, int oldValue, int newValue) throws PropertyVetoException {
        if (oldValue == newValue) {
            return;
        }
        this.fireVetoableChange(propertyName, (Object)oldValue, (Object)newValue);
    }

    public void fireVetoableChange(String propertyName, boolean oldValue, boolean newValue) throws PropertyVetoException {
        if (oldValue == newValue) {
            return;
        }
        this.fireVetoableChange(propertyName, (Object)oldValue, (Object)newValue);
    }

    public void fireVetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        Object oldValue = evt.getOldValue();
        Object newValue = evt.getNewValue();
        String propertyName = evt.getPropertyName();
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        VetoableChangeListener[] common = (VetoableChangeListener[])this.map.get(null);
        VetoableChangeListener[] named = propertyName != null ? (VetoableChangeListener[])this.map.get(propertyName) : null;
        this.fire(common, evt);
        this.fire(named, evt);
    }

    private void fire(VetoableChangeListener[] listeners, PropertyChangeEvent event) throws PropertyVetoException {
        if (listeners != null) {
            VetoableChangeListener current = null;
            try {
                VetoableChangeListener[] arr$ = listeners;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    VetoableChangeListener listener;
                    current = listener = arr$[i$];
                    listener.vetoableChange(event);
                }
            }
            catch (PropertyVetoException veto) {
                event = new PropertyChangeEvent(this.source, event.getPropertyName(), event.getNewValue(), event.getOldValue());
                for (VetoableChangeListener listener : listeners) {
                    try {
                        listener.vetoableChange(event);
                    }
                    catch (PropertyVetoException ex) {
                        // empty catch block
                    }
                }
                throw veto;
            }
        }
    }

    public boolean hasListeners(String propertyName) {
        return this.map.hasListeners(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        Hashtable<String, VetoableChangeSupport> children = null;
        VetoableChangeListener[] listeners = null;
        VetoableChangeListenerMap vetoableChangeListenerMap = this.map;
        synchronized (vetoableChangeListenerMap) {
            for (Map.Entry<String, L[]> entry : this.map.getEntries()) {
                String property = entry.getKey();
                if (property == null) {
                    listeners = (VetoableChangeListener[])entry.getValue();
                    continue;
                }
                if (children == null) {
                    children = new Hashtable<String, VetoableChangeSupport>();
                }
                VetoableChangeSupport vcs = new VetoableChangeSupport(this.source);
                vcs.map.set(null, (EventListener[])entry.getValue());
                children.put(property, vcs);
            }
        }
        ObjectOutputStream.PutField fields = s.putFields();
        fields.put("children", children);
        fields.put("source", this.source);
        fields.put("vetoableChangeSupportSerializedDataVersion", 2);
        s.writeFields();
        if (listeners != null) {
            for (VetoableChangeListener l : listeners) {
                if (!(l instanceof Serializable)) continue;
                s.writeObject(l);
            }
        }
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        Object listenerOrNull;
        this.map = new VetoableChangeListenerMap();
        ObjectInputStream.GetField fields = s.readFields();
        Hashtable children = (Hashtable)fields.get("children", null);
        this.source = fields.get("source", null);
        fields.get("vetoableChangeSupportSerializedDataVersion", 2);
        while (null != (listenerOrNull = s.readObject())) {
            this.map.add(null, (VetoableChangeListener)listenerOrNull);
        }
        if (children != null) {
            for (Map.Entry entry : children.entrySet()) {
                for (VetoableChangeListener listener : ((VetoableChangeSupport)entry.getValue()).getVetoableChangeListeners()) {
                    this.map.add((String)entry.getKey(), listener);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class VetoableChangeListenerMap
    extends ChangeListenerMap<VetoableChangeListener> {
        private static final VetoableChangeListener[] EMPTY = new VetoableChangeListener[0];

        private VetoableChangeListenerMap() {
        }

        protected VetoableChangeListener[] newArray(int length) {
            return 0 < length ? new VetoableChangeListener[length] : EMPTY;
        }

        @Override
        protected VetoableChangeListener newProxy(String name, VetoableChangeListener listener) {
            return new VetoableChangeListenerProxy(name, listener);
        }
    }
}

