/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CropImageFilter
extends ImageFilter {
    int cropX;
    int cropY;
    int cropW;
    int cropH;

    public CropImageFilter(int x, int y, int w, int h) {
        this.cropX = x;
        this.cropY = y;
        this.cropW = w;
        this.cropH = h;
    }

    @Override
    public void setProperties(Hashtable<?, ?> props) {
        Hashtable p = (Hashtable)props.clone();
        p.put("croprect", new Rectangle(this.cropX, this.cropY, this.cropW, this.cropH));
        super.setProperties(p);
    }

    @Override
    public void setDimensions(int w, int h) {
        this.consumer.setDimensions(this.cropW, this.cropH);
    }

    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        int y2;
        int y1;
        int x2;
        int x1 = x;
        if (x1 < this.cropX) {
            x1 = this.cropX;
        }
        if ((x2 = this.addWithoutOverflow(x, w)) > this.cropX + this.cropW) {
            x2 = this.cropX + this.cropW;
        }
        if ((y1 = y) < this.cropY) {
            y1 = this.cropY;
        }
        if ((y2 = this.addWithoutOverflow(y, h)) > this.cropY + this.cropH) {
            y2 = this.cropY + this.cropH;
        }
        if (x1 >= x2 || y1 >= y2) {
            return;
        }
        this.consumer.setPixels(x1 - this.cropX, y1 - this.cropY, x2 - x1, y2 - y1, model, pixels, off + (y1 - y) * scansize + (x1 - x), scansize);
    }

    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        int y2;
        int y1;
        int x2;
        int x1 = x;
        if (x1 < this.cropX) {
            x1 = this.cropX;
        }
        if ((x2 = this.addWithoutOverflow(x, w)) > this.cropX + this.cropW) {
            x2 = this.cropX + this.cropW;
        }
        if ((y1 = y) < this.cropY) {
            y1 = this.cropY;
        }
        if ((y2 = this.addWithoutOverflow(y, h)) > this.cropY + this.cropH) {
            y2 = this.cropY + this.cropH;
        }
        if (x1 >= x2 || y1 >= y2) {
            return;
        }
        this.consumer.setPixels(x1 - this.cropX, y1 - this.cropY, x2 - x1, y2 - y1, model, pixels, off + (y1 - y) * scansize + (x1 - x), scansize);
    }

    private int addWithoutOverflow(int x, int w) {
        int x2 = x + w;
        if (x > 0 && w > 0 && x2 < 0) {
            x2 = Integer.MAX_VALUE;
        } else if (x < 0 && w < 0 && x2 > 0) {
            x2 = Integer.MIN_VALUE;
        }
        return x2;
    }
}

