/*
 * Decompiled with CFR 0.152.
 */
package java.awt.event;

import java.awt.AWTEvent;
import java.awt.Adjustable;

public class AdjustmentEvent
extends AWTEvent {
    public static final int ADJUSTMENT_FIRST = 601;
    public static final int ADJUSTMENT_LAST = 601;
    public static final int ADJUSTMENT_VALUE_CHANGED = 601;
    public static final int UNIT_INCREMENT = 1;
    public static final int UNIT_DECREMENT = 2;
    public static final int BLOCK_DECREMENT = 3;
    public static final int BLOCK_INCREMENT = 4;
    public static final int TRACK = 5;
    Adjustable adjustable;
    int value;
    int adjustmentType;
    boolean isAdjusting;
    private static final long serialVersionUID = 5700290645205279921L;

    public AdjustmentEvent(Adjustable source, int id, int type, int value) {
        this(source, id, type, value, false);
    }

    public AdjustmentEvent(Adjustable source, int id, int type, int value, boolean isAdjusting) {
        super(source, id);
        this.adjustable = source;
        this.adjustmentType = type;
        this.value = value;
        this.isAdjusting = isAdjusting;
    }

    public Adjustable getAdjustable() {
        return this.adjustable;
    }

    public int getValue() {
        return this.value;
    }

    public int getAdjustmentType() {
        return this.adjustmentType;
    }

    public boolean getValueIsAdjusting() {
        return this.isAdjusting;
    }

    public String paramString() {
        String adjTypeStr;
        String typeStr;
        switch (this.id) {
            case 601: {
                typeStr = "ADJUSTMENT_VALUE_CHANGED";
                break;
            }
            default: {
                typeStr = "unknown type";
            }
        }
        switch (this.adjustmentType) {
            case 1: {
                adjTypeStr = "UNIT_INCREMENT";
                break;
            }
            case 2: {
                adjTypeStr = "UNIT_DECREMENT";
                break;
            }
            case 4: {
                adjTypeStr = "BLOCK_INCREMENT";
                break;
            }
            case 3: {
                adjTypeStr = "BLOCK_DECREMENT";
                break;
            }
            case 5: {
                adjTypeStr = "TRACK";
                break;
            }
            default: {
                adjTypeStr = "unknown type";
            }
        }
        return typeStr + ",adjType=" + adjTypeStr + ",value=" + this.value + ",isAdjusting=" + this.isAdjusting;
    }
}

