/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.daemon;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.SnmpDefinitions;
import com.sun.jmx.snmp.SnmpEngine;
import com.sun.jmx.snmp.SnmpPdu;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpVarBind;
import com.sun.jmx.snmp.ThreadContext;
import com.sun.jmx.snmp.agent.SnmpMibAgent;
import com.sun.jmx.snmp.agent.SnmpMibRequest;
import com.sun.jmx.snmp.internal.SnmpIncomingRequest;
import java.util.Vector;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SnmpSubRequestHandler
implements SnmpDefinitions,
Runnable {
    protected SnmpIncomingRequest incRequest = null;
    protected SnmpEngine engine = null;
    protected int version = 330;
    protected int type = 0;
    protected SnmpMibAgent agent;
    protected int errorStatus = 1230;
    protected int errorIndex = -1;
    protected Vector<SnmpVarBind> varBind;
    protected int[] translation;
    protected Object data;
    private SnmpMibRequest mibRequest = null;
    private SnmpPdu reqPdu = null;

    protected SnmpSubRequestHandler(SnmpEngine engine, SnmpIncomingRequest incRequest, SnmpMibAgent agent2, SnmpPdu req) {
        this(agent2, req);
        this.init(engine, incRequest);
    }

    protected SnmpSubRequestHandler(SnmpEngine engine, SnmpIncomingRequest incRequest, SnmpMibAgent agent2, SnmpPdu req, boolean nouse) {
        this(agent2, req, nouse);
        this.init(engine, incRequest);
    }

    protected SnmpSubRequestHandler(SnmpMibAgent agent2, SnmpPdu req) {
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "constructor", "creating instance for request " + String.valueOf(req.requestId));
        }
        this.version = req.version;
        this.type = req.type;
        this.agent = agent2;
        this.reqPdu = req;
        int length = req.varBindList.length;
        this.translation = new int[length];
        this.varBind = new NonSyncVector<SnmpVarBind>(length);
    }

    protected SnmpSubRequestHandler(SnmpMibAgent agent2, SnmpPdu req, boolean nouse) {
        this(agent2, req);
        int max = this.translation.length;
        SnmpVarBind[] list = req.varBindList;
        for (int i = 0; i < max; ++i) {
            this.translation[i] = i;
            ((NonSyncVector)this.varBind).addNonSyncElement(list[i]);
        }
    }

    SnmpMibRequest createMibRequest(Vector<SnmpVarBind> vblist, int protocolVersion, Object userData) {
        if (this.type == 4 && this.mibRequest != null) {
            return this.mibRequest;
        }
        SnmpMibRequest result = null;
        result = this.incRequest != null ? SnmpMibAgent.newMibRequest(this.engine, this.reqPdu, vblist, protocolVersion, userData, this.incRequest.getPrincipal(), this.incRequest.getSecurityLevel(), this.incRequest.getSecurityModel(), this.incRequest.getContextName(), this.incRequest.getAccessContext()) : SnmpMibAgent.newMibRequest(this.reqPdu, vblist, protocolVersion, userData);
        if (this.type == 3) {
            this.mibRequest = result;
        }
        return result;
    }

    void setUserData(Object userData) {
        this.data = userData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block18: {
            try {
                ThreadContext oldContext = ThreadContext.push("SnmpUserData", this.data);
                try {
                    switch (this.type) {
                        case 1: {
                            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:get operation on " + this.agent.getMibName());
                            }
                            this.agent.get(this.createMibRequest(this.varBind, this.version, this.data));
                            break;
                        }
                        case 2: {
                            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:getNext operation on " + this.agent.getMibName());
                            }
                            this.agent.getNext(this.createMibRequest(this.varBind, this.version, this.data));
                            break;
                        }
                        case 4: {
                            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:set operation on " + this.agent.getMibName());
                            }
                            this.agent.set(this.createMibRequest(this.varBind, this.version, this.data));
                            break;
                        }
                        case 3: {
                            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:check operation on " + this.agent.getMibName());
                            }
                            this.agent.check(this.createMibRequest(this.varBind, this.version, this.data));
                            break;
                        }
                        default: {
                            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:unknown operation (" + this.type + ") on " + this.agent.getMibName());
                            }
                            this.errorStatus = 0;
                            this.errorIndex = 1;
                        }
                    }
                    Object var3_4 = null;
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    ThreadContext.restore(oldContext);
                    throw throwable;
                }
                ThreadContext.restore(oldContext);
                {
                }
            }
            catch (SnmpStatusException x) {
                this.errorStatus = x.getStatus();
                this.errorIndex = x.getErrorIndex();
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:an Snmp error occured during the operation", x);
                }
            }
            catch (Exception x) {
                this.errorStatus = 0;
                if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) break block18;
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:a generic error occured during the operation", x);
            }
        }
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:operation completed");
        }
    }

    static final int mapErrorStatusToV1(int errorStatus, int reqPduType) {
        if (errorStatus == 1230) {
            return 1230;
        }
        if (errorStatus == 0) {
            return 0;
        }
        if (errorStatus == 10) {
            return 10;
        }
        if (errorStatus == 224 || errorStatus == 225 || errorStatus == 20 || errorStatus == 60 || errorStatus == 70) {
            return 10;
        }
        if (errorStatus == 70 || errorStatus == 0) {
            if (reqPduType == 3) {
                return 30;
            }
            return 10;
        }
        if (errorStatus == 80) {
            return 10;
        }
        if (errorStatus == 90 || errorStatus == 110 || errorStatus == 0 || errorStatus == 50 || errorStatus == 110 || errorStatus == 220) {
            if (reqPduType == 4 || reqPduType == 3) {
                return 40;
            }
            return 10;
        }
        if (errorStatus == 330 || errorStatus == 440 || errorStatus == 550) {
            return 0;
        }
        if (errorStatus == 660) {
            return 660;
        }
        if (errorStatus == 40 || errorStatus == 30) {
            if (reqPduType == 4 || reqPduType == 3) {
                return errorStatus;
            }
            return 10;
        }
        return 0;
    }

    static final int mapErrorStatusToV2(int errorStatus, int reqPduType) {
        if (errorStatus == 1230) {
            return 1230;
        }
        if (errorStatus == 0) {
            return 0;
        }
        if (errorStatus == 660) {
            return 660;
        }
        if (reqPduType != 4 && reqPduType != 3) {
            if (errorStatus == 70) {
                return errorStatus;
            }
            return 0;
        }
        if (errorStatus == 10) {
            return 20;
        }
        if (errorStatus == 30) {
            return 0;
        }
        if (errorStatus == 40) {
            return 50;
        }
        if (errorStatus == 20 || errorStatus == 60 || errorStatus == 70 || errorStatus == 0 || errorStatus == 80 || errorStatus == 90 || errorStatus == 110 || errorStatus == 0 || errorStatus == 50 || errorStatus == 110 || errorStatus == 220 || errorStatus == 330 || errorStatus == 440 || errorStatus == 550) {
            return errorStatus;
        }
        return 0;
    }

    static final int mapErrorStatus(int errorStatus, int protocolVersion, int reqPduType) {
        if (errorStatus == 1230) {
            return 1230;
        }
        if (protocolVersion == 330) {
            return SnmpSubRequestHandler.mapErrorStatusToV1(errorStatus, reqPduType);
        }
        if (protocolVersion == 220 || protocolVersion == 4430) {
            return SnmpSubRequestHandler.mapErrorStatusToV2(errorStatus, reqPduType);
        }
        return 0;
    }

    protected int getErrorStatus() {
        if (this.errorStatus == 1230) {
            return 1230;
        }
        return SnmpSubRequestHandler.mapErrorStatus(this.errorStatus, this.version, this.type);
    }

    protected int getErrorIndex() {
        if (this.errorStatus == 1230) {
            return -1;
        }
        if (this.errorIndex == 0 || this.errorIndex == -1) {
            this.errorIndex = 1;
        }
        return this.translation[this.errorIndex - 1];
    }

    protected void updateRequest(SnmpVarBind var, int pos) {
        int size = this.varBind.size();
        this.translation[size] = pos;
        this.varBind.addElement(var);
    }

    protected void updateResult(SnmpVarBind[] result) {
        if (result == null) {
            return;
        }
        int max = this.varBind.size();
        int len = result.length;
        for (int i = 0; i < max; ++i) {
            int pos = this.translation[i];
            if (pos < len) {
                result[pos] = (SnmpVarBind)((NonSyncVector)this.varBind).elementAtNonSync(i);
                continue;
            }
            if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) continue;
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSubRequestHandler.class.getName(), "updateResult", "Position `" + pos + "' is out of bound...");
        }
    }

    private void init(SnmpEngine engine, SnmpIncomingRequest incRequest) {
        this.incRequest = incRequest;
        this.engine = engine;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NonSyncVector<E>
    extends Vector<E> {
        public NonSyncVector(int size) {
            super(size);
        }

        final void addNonSyncElement(E obj) {
            this.ensureCapacity(this.elementCount + 1);
            this.elementData[this.elementCount++] = obj;
        }

        final E elementAtNonSync(int index) {
            return (E)this.elementData[index];
        }
    }
}

