/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.daemon;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.SnmpEngine;
import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpPdu;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpValue;
import com.sun.jmx.snmp.SnmpVarBind;
import com.sun.jmx.snmp.ThreadContext;
import com.sun.jmx.snmp.agent.SnmpMibAgent;
import com.sun.jmx.snmp.daemon.SnmpAdaptorServer;
import com.sun.jmx.snmp.daemon.SnmpSubRequestHandler;
import com.sun.jmx.snmp.internal.SnmpIncomingRequest;
import java.util.Enumeration;
import java.util.logging.Level;

class SnmpSubBulkRequestHandler
extends SnmpSubRequestHandler {
    private SnmpAdaptorServer server = null;
    protected int nonRepeat = 0;
    protected int maxRepeat = 0;
    protected int globalR = 0;
    protected int size = 0;

    protected SnmpSubBulkRequestHandler(SnmpEngine engine, SnmpAdaptorServer server, SnmpIncomingRequest incRequest, SnmpMibAgent agent2, SnmpPdu req, int nonRepeat, int maxRepeat, int R) {
        super(engine, incRequest, agent2, req);
        this.init(server, req, nonRepeat, maxRepeat, R);
    }

    protected SnmpSubBulkRequestHandler(SnmpAdaptorServer server, SnmpMibAgent agent2, SnmpPdu req, int nonRepeat, int maxRepeat, int R) {
        super(agent2, req);
        this.init(server, req, nonRepeat, maxRepeat, R);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block8: {
            this.size = this.varBind.size();
            try {
                ThreadContext oldContext = ThreadContext.push("SnmpUserData", this.data);
                try {
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:getBulk operation on " + this.agent.getMibName());
                    }
                    this.agent.getBulk(this.createMibRequest(this.varBind, this.version, this.data), this.nonRepeat, this.maxRepeat);
                    Object var3_4 = null;
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    ThreadContext.restore(oldContext);
                    throw throwable;
                }
                ThreadContext.restore(oldContext);
                {
                }
            }
            catch (SnmpStatusException x) {
                this.errorStatus = x.getStatus();
                this.errorIndex = x.getErrorIndex();
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:an Snmp error occured during the operation", x);
                }
            }
            catch (Exception x) {
                this.errorStatus = 0;
                if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) break block8;
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:a generic error occured during the operation", x);
            }
        }
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:operation completed");
        }
    }

    private void init(SnmpAdaptorServer server, SnmpPdu req, int nonRepeat, int maxRepeat, int R) {
        this.server = server;
        this.nonRepeat = nonRepeat;
        this.maxRepeat = maxRepeat;
        this.globalR = R;
        int max = this.translation.length;
        SnmpVarBind[] list = req.varBindList;
        SnmpSubRequestHandler.NonSyncVector nonSyncVarBind = (SnmpSubRequestHandler.NonSyncVector)this.varBind;
        for (int i = 0; i < max; ++i) {
            this.translation[i] = i;
            SnmpVarBind newVarBind = new SnmpVarBind(list[i].oid, list[i].value);
            nonSyncVarBind.addNonSyncElement(newVarBind);
        }
    }

    private SnmpVarBind findVarBind(SnmpVarBind element, SnmpVarBind result) {
        if (element == null) {
            return null;
        }
        if (result.oid == null) {
            return element;
        }
        if (element.value == SnmpVarBind.endOfMibView) {
            return result;
        }
        if (result.value == SnmpVarBind.endOfMibView) {
            return element;
        }
        SnmpValue val = result.value;
        int comp = element.oid.compareTo(result.oid);
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "findVarBind", "Comparing OID element : " + element.oid + " with result : " + result.oid);
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "findVarBind", "Values element : " + element.value + " result : " + result.value);
        }
        if (comp < 0) {
            return element;
        }
        if (comp == 0) {
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "findVarBind", " oid overlapping. Oid : " + element.oid + "value :" + element.value);
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "findVarBind", "Already present varBind : " + result);
            }
            SnmpOid oid = result.oid;
            SnmpMibAgent deeperAgent = this.server.getAgentMib(oid);
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "findVarBind", "Deeper agent : " + deeperAgent);
            }
            if (deeperAgent == this.agent) {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "findVarBind", "The current agent is the deeper one. Update the value with the current one");
                }
                return element;
            }
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "findVarBind", "The current agent is not the deeper one. return the previous one.");
            }
            return result;
        }
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "findVarBind", "The right varBind is the already present one");
        }
        return result;
    }

    protected void updateResult(SnmpVarBind[] result) {
        Enumeration e = this.varBind.elements();
        int max = result.length;
        for (int i = 0; i < this.size; ++i) {
            SnmpVarBind res;
            if (!e.hasMoreElements()) {
                return;
            }
            int pos = this.translation[i];
            if (pos >= max) {
                if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) continue;
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSubRequestHandler.class.getName(), "updateResult", "Position '" + pos + "' is out of bound...");
                continue;
            }
            SnmpVarBind element = (SnmpVarBind)e.nextElement();
            if (element == null) continue;
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "updateResult", "Non repeaters Current element : " + element + " from agent : " + this.agent);
            }
            if ((res = this.findVarBind(element, result[pos])) == null) continue;
            result[pos] = res;
        }
        int localR = this.size - this.nonRepeat;
        for (int i = 2; i <= this.maxRepeat; ++i) {
            for (int r = 0; r < localR; ++r) {
                SnmpVarBind res;
                int pos = (i - 1) * this.globalR + this.translation[this.nonRepeat + r];
                if (pos >= max) {
                    return;
                }
                if (!e.hasMoreElements()) {
                    return;
                }
                SnmpVarBind element = (SnmpVarBind)e.nextElement();
                if (element == null) continue;
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "updateResult", "Repeaters Current element : " + element + " from agent : " + this.agent);
                }
                if ((res = this.findVarBind(element, result[pos])) == null) continue;
                result[pos] = res;
            }
        }
    }
}

