/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.IPAcl;

import java.io.Serializable;
import java.net.UnknownHostException;
import java.security.Principal;
import java.security.acl.AclEntry;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AclEntryImpl
implements AclEntry,
Serializable {
    private static final long serialVersionUID = -5047185131260073216L;
    private Principal princ = null;
    private boolean neg = false;
    private Vector<Permission> permList = null;
    private Vector<String> commList = null;

    private AclEntryImpl(AclEntryImpl i) throws UnknownHostException {
        this.setPrincipal(i.getPrincipal());
        this.permList = new Vector();
        this.commList = new Vector();
        Enumeration<Object> en = i.communities();
        while (en.hasMoreElements()) {
            this.addCommunity(en.nextElement());
        }
        en = i.permissions();
        while (en.hasMoreElements()) {
            this.addPermission((Permission)en.nextElement());
        }
        if (i.isNegative()) {
            this.setNegativePermissions();
        }
    }

    public AclEntryImpl() {
        this.princ = null;
        this.permList = new Vector();
        this.commList = new Vector();
    }

    public AclEntryImpl(Principal p) throws UnknownHostException {
        this.princ = p;
        this.permList = new Vector();
        this.commList = new Vector();
    }

    @Override
    public Object clone() {
        AclEntryImpl i;
        try {
            i = new AclEntryImpl(this);
        }
        catch (UnknownHostException e) {
            i = null;
        }
        return i;
    }

    @Override
    public boolean isNegative() {
        return this.neg;
    }

    @Override
    public boolean addPermission(Permission perm) {
        if (this.permList.contains(perm)) {
            return false;
        }
        this.permList.addElement(perm);
        return true;
    }

    @Override
    public boolean removePermission(Permission perm) {
        if (!this.permList.contains(perm)) {
            return false;
        }
        this.permList.removeElement(perm);
        return true;
    }

    @Override
    public boolean checkPermission(Permission perm) {
        return this.permList.contains(perm);
    }

    @Override
    public Enumeration<Permission> permissions() {
        return this.permList.elements();
    }

    @Override
    public void setNegativePermissions() {
        this.neg = true;
    }

    @Override
    public Principal getPrincipal() {
        return this.princ;
    }

    @Override
    public boolean setPrincipal(Principal p) {
        if (this.princ != null) {
            return false;
        }
        this.princ = p;
        return true;
    }

    @Override
    public String toString() {
        return "AclEntry:" + ((Object)this.princ).toString();
    }

    public Enumeration<String> communities() {
        return this.commList.elements();
    }

    public boolean addCommunity(String comm) {
        if (this.commList.contains(comm)) {
            return false;
        }
        this.commList.addElement(comm);
        return true;
    }

    public boolean removeCommunity(String comm) {
        if (!this.commList.contains(comm)) {
            return false;
        }
        this.commList.removeElement(comm);
        return true;
    }

    public boolean checkCommunity(String comm) {
        return this.commList.contains(comm);
    }
}

