/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import sun.tools.jconsole.JConsole;

public class MaximizableInternalFrame
extends JInternalFrame {
    private boolean isXP;
    private JFrame mainFrame;
    private JMenuBar mainMenuBar;
    private String mainTitle;
    private JComponent titlePane;
    private Border normalBorder;
    private PropertyChangeListener pcl;
    private static Object WP_MINBUTTON;
    private static Object WP_RESTOREBUTTON;
    private static Object WP_CLOSEBUTTON;
    private static Object WP_MDIMINBUTTON;
    private static Object WP_MDIRESTOREBUTTON;
    private static Object WP_MDICLOSEBUTTON;
    private Method setButtonIcons;
    private Method enableActions;

    public MaximizableInternalFrame(String title, boolean resizable, boolean closable, boolean maximizable, boolean iconifiable) {
        super(title, resizable, closable, maximizable, iconifiable);
        this.init();
    }

    private void init() {
        this.normalBorder = this.getBorder();
        this.isXP = this.normalBorder.getClass().getName().endsWith("XPBorder");
        if (this.isXP) {
            this.setRootPaneCheckingEnabled(false);
            this.titlePane = ((BasicInternalFrameUI)this.getUI()).getNorthPane();
            if (this.pcl == null) {
                this.pcl = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent ev) {
                        String prop = ev.getPropertyName();
                        if (prop.equals("icon") || prop.equals("maximum") || prop.equals("closed")) {
                            MaximizableInternalFrame.this.updateFrame();
                        }
                    }
                };
                this.addPropertyChangeListener(this.pcl);
            }
        } else if (this.pcl != null) {
            this.removePropertyChangeListener(this.pcl);
            this.pcl = null;
        }
    }

    private void updateFrame() {
        JFrame mainFrame;
        if (!this.isXP || (mainFrame = this.getMainFrame()) == null) {
            return;
        }
        JMenuBar menuBar = this.getMainMenuBar();
        BasicInternalFrameUI ui = (BasicInternalFrameUI)this.getUI();
        if (this.isMaximum() && !this.isIcon() && !this.isClosed()) {
            if (ui.getNorthPane() != null) {
                this.mainTitle = mainFrame.getTitle();
                mainFrame.setTitle(this.mainTitle + " - " + this.getTitle());
                if (menuBar != null) {
                    this.updateButtonStates();
                    menuBar.add(Box.createGlue());
                    for (Component c : this.titlePane.getComponents()) {
                        if (c instanceof JButton) {
                            menuBar.add(c);
                            continue;
                        }
                        if (!(c instanceof JLabel)) continue;
                        menuBar.add(Box.createHorizontalStrut(3), 0);
                        menuBar.add(c, 1);
                        menuBar.add(Box.createHorizontalStrut(3), 2);
                    }
                    ui.setNorthPane(null);
                    this.setBorder(null);
                }
            }
        } else if (ui.getNorthPane() == null) {
            mainFrame.setTitle(this.mainTitle);
            if (menuBar != null) {
                for (Component c : menuBar.getComponents()) {
                    if (c instanceof JButton || c instanceof JLabel) {
                        this.titlePane.add(c);
                        continue;
                    }
                    if (!(c instanceof Box.Filler)) continue;
                    menuBar.remove(c);
                }
                menuBar.repaint();
                this.updateButtonStates();
                ui.setNorthPane(this.titlePane);
                this.setBorder(this.normalBorder);
            }
        }
    }

    public void updateUI() {
        boolean isMax;
        boolean bl = isMax = this.isXP && this.getBorder() == null;
        if (isMax) {
            try {
                this.setMaximum(false);
            }
            catch (PropertyVetoException ex) {
                // empty catch block
            }
        }
        super.updateUI();
        this.init();
        if (isMax) {
            try {
                this.setMaximum(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private JFrame getMainFrame() {
        JDesktopPane desktop;
        if (this.mainFrame == null && (desktop = this.getDesktopPane()) != null) {
            this.mainFrame = (JFrame)SwingUtilities.getWindowAncestor(desktop);
        }
        return this.mainFrame;
    }

    private JMenuBar getMainMenuBar() {
        JFrame mainFrame;
        if (this.mainMenuBar == null && (mainFrame = this.getMainFrame()) != null) {
            this.mainMenuBar = mainFrame.getJMenuBar();
            if (this.mainMenuBar != null && !(this.mainMenuBar.getLayout() instanceof FixedMenuBarLayout)) {
                this.mainMenuBar.setLayout(new FixedMenuBarLayout(this.mainMenuBar, 0));
            }
        }
        return this.mainMenuBar;
    }

    public void setTitle(String title) {
        if (this.isXP && this.isMaximum() && this.getMainFrame() != null) {
            this.getMainFrame().setTitle(this.mainTitle + " - " + title);
        }
        super.setTitle(title);
    }

    private void updateButtonStates() {
        block3: {
            try {
                if (this.setButtonIcons == null) {
                    Class<?> cls = this.titlePane.getClass();
                    Class<?> superCls = cls.getSuperclass();
                    this.setButtonIcons = cls.getDeclaredMethod("setButtonIcons", new Class[0]);
                    this.enableActions = superCls.getDeclaredMethod("enableActions", new Class[0]);
                    this.setButtonIcons.setAccessible(true);
                    this.enableActions.setAccessible(true);
                }
                this.setButtonIcons.invoke((Object)this.titlePane, new Object[0]);
                this.enableActions.invoke((Object)this.titlePane, new Object[0]);
            }
            catch (Exception ex) {
                if (!JConsole.debug) break block3;
                ex.printStackTrace();
            }
        }
    }

    static {
        block9: {
            if (JConsole.IS_WIN) {
                try {
                    Class<?> Part = Class.forName("com.sun.java.swing.plaf.windows.TMSchema$Part");
                    if (Part != null) {
                        WP_MINBUTTON = Part.getField("WP_MINBUTTON").get(null);
                        WP_RESTOREBUTTON = Part.getField("WP_RESTOREBUTTON").get(null);
                        WP_CLOSEBUTTON = Part.getField("WP_CLOSEBUTTON").get(null);
                        WP_MDIMINBUTTON = Part.getField("WP_MDIMINBUTTON").get(null);
                        WP_MDIRESTOREBUTTON = Part.getField("WP_MDIRESTOREBUTTON").get(null);
                        WP_MDICLOSEBUTTON = Part.getField("WP_MDICLOSEBUTTON").get(null);
                    }
                    for (String str : new String[]{"maximize", "minimize", "iconify", "close"}) {
                        String key = "InternalFrame." + str + "Icon";
                        UIManager.put(key, new MDIButtonIcon(UIManager.getIcon(key)));
                    }
                }
                catch (ClassNotFoundException ex) {
                    if (JConsole.debug) {
                        ex.printStackTrace();
                    }
                }
                catch (NoSuchFieldException ex) {
                    if (JConsole.debug) {
                        ex.printStackTrace();
                    }
                }
                catch (IllegalAccessException ex) {
                    if (!JConsole.debug) break block9;
                    ex.printStackTrace();
                }
            }
        }
    }

    private static class MDIButtonIcon
    implements Icon {
        Icon windowsIcon;
        Field part;

        MDIButtonIcon(Icon icon) {
            block3: {
                this.windowsIcon = icon;
                if (WP_MINBUTTON != null) {
                    try {
                        this.part = this.windowsIcon.getClass().getDeclaredField("part");
                        this.part.setAccessible(true);
                    }
                    catch (NoSuchFieldException ex) {
                        if (!JConsole.debug) break block3;
                        ex.printStackTrace();
                    }
                }
            }
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            block15: {
                if (this.part != null) {
                    try {
                        Object v = this.part.get(this.windowsIcon);
                        if (c.getParent() instanceof JMenuBar) {
                            if (v == WP_MINBUTTON) {
                                this.part.set(this.windowsIcon, WP_MDIMINBUTTON);
                            } else if (v == WP_RESTOREBUTTON) {
                                this.part.set(this.windowsIcon, WP_MDIRESTOREBUTTON);
                            } else if (v == WP_CLOSEBUTTON) {
                                this.part.set(this.windowsIcon, WP_MDICLOSEBUTTON);
                            }
                        } else if (v == WP_MDIMINBUTTON) {
                            this.part.set(this.windowsIcon, WP_MINBUTTON);
                        } else if (v == WP_MDIRESTOREBUTTON) {
                            this.part.set(this.windowsIcon, WP_RESTOREBUTTON);
                        } else if (v == WP_MDICLOSEBUTTON) {
                            this.part.set(this.windowsIcon, WP_CLOSEBUTTON);
                        }
                    }
                    catch (IllegalAccessException ex) {
                        if (!JConsole.debug) break block15;
                        ex.printStackTrace();
                    }
                }
            }
            this.windowsIcon.paintIcon(c, g, x, y);
        }

        public int getIconWidth() {
            return this.windowsIcon.getIconWidth();
        }

        public int getIconHeight() {
            return this.windowsIcon.getIconHeight();
        }
    }

    private class FixedMenuBarLayout
    extends BoxLayout {
        public FixedMenuBarLayout(Container target, int axis) {
            super(target, axis);
        }

        public void layoutContainer(Container target) {
            super.layoutContainer(target);
            for (Component c : target.getComponents()) {
                if (!(c instanceof JButton)) continue;
                int y = (target.getHeight() - c.getHeight()) / 2;
                c.setLocation(c.getX(), Math.max(2, y));
            }
        }
    }
}

