/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jar;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.KeyManagementException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import sun.security.provider.SystemIdentity;
import sun.security.x509.X509Cert;
import sun.tools.jar.Manifest;

public class JarVerifierStream
extends ZipInputStream {
    private JarEntry current;
    private Hashtable verified = new Hashtable();
    private JarInputStream jis;
    private Manifest man = null;
    private ArrayList certCache = null;

    public JarVerifierStream(InputStream is) throws IOException {
        super(is);
        this.jis = new JarInputStream(is);
    }

    public void close() throws IOException {
        this.jis.close();
    }

    public void closeEntry() throws IOException {
        this.jis.closeEntry();
    }

    public synchronized ZipEntry getNextEntry() throws IOException {
        this.current = (JarEntry)this.jis.getNextEntry();
        return this.current;
    }

    public int read() throws IOException {
        int n = this.jis.read();
        if (n == -1) {
            this.addIds();
        }
        return n;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int n = this.jis.read(b, off, len);
        if (n == -1) {
            this.addIds();
        }
        return n;
    }

    private void addIds() {
        Vector ids;
        Certificate[] certs;
        if (this.current != null && (certs = this.current.getCertificates()) != null && (ids = this.getIds(certs)) != null) {
            this.verified.put(this.current.getName(), ids);
        }
    }

    public Hashtable getVerifiedSignatures() {
        if (this.verified.isEmpty()) {
            return null;
        }
        return this.verified;
    }

    public Enumeration getBlocks() {
        if (this.verified.isEmpty()) {
            return null;
        }
        return new Enumeration(){

            public boolean hasMoreElements() {
                return false;
            }

            public Object nextElement() {
                return null;
            }
        };
    }

    public Hashtable getNameToHash() {
        return null;
    }

    public Manifest getManifest() {
        if (this.man == null) {
            try {
                java.util.jar.Manifest jman = this.jis.getManifest();
                if (jman == null) {
                    return null;
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                jman.write(baos);
                byte[] data = baos.toByteArray();
                this.man = new Manifest(data);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.man;
    }

    protected Vector getIds(Certificate[] certs) {
        CertCache cc;
        int i;
        if (certs == null) {
            return null;
        }
        if (this.certCache == null) {
            this.certCache = new ArrayList();
        }
        for (i = 0; i < this.certCache.size(); ++i) {
            cc = (CertCache)this.certCache.get(i);
            if (!cc.equals(certs)) continue;
            return cc.ids;
        }
        cc = new CertCache();
        cc.certs = certs;
        if (certs.length > 0) {
            for (i = 0; i < certs.length; ++i) {
                try {
                    X509Certificate cert = (X509Certificate)certs[i];
                    Principal tmpName = cert.getSubjectDN();
                    final SystemIdentity id = new SystemIdentity(tmpName.getName(), null);
                    byte[] encoded = cert.getEncoded();
                    final X509Cert oldC = new X509Cert(encoded);
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws KeyManagementException {
                                id.addCertificate(oldC);
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException pae) {
                        throw (KeyManagementException)pae.getException();
                    }
                    if (cc.ids == null) {
                        cc.ids = new Vector();
                    }
                    cc.ids.addElement(id);
                    continue;
                }
                catch (KeyManagementException kme) {
                    continue;
                }
                catch (IOException ioe) {
                    continue;
                }
                catch (CertificateEncodingException cee) {
                    // empty catch block
                }
            }
        }
        this.certCache.add(cc);
        return cc.ids;
    }

    static class CertCache {
        Certificate[] certs;
        Vector ids;

        CertCache() {
        }

        boolean equals(Certificate[] certs) {
            int j;
            boolean match;
            int i;
            if (this.certs == null) {
                return certs == null;
            }
            if (certs == null) {
                return false;
            }
            for (i = 0; i < certs.length; ++i) {
                match = false;
                for (j = 0; j < this.certs.length; ++j) {
                    if (!certs[i].equals(this.certs[j])) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                return false;
            }
            for (i = 0; i < this.certs.length; ++i) {
                match = false;
                for (j = 0; j < certs.length; ++j) {
                    if (!this.certs[i].equals(certs[j])) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                return false;
            }
            return true;
        }
    }
}

