/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import sun.security.provider.PolicyParser;
import sun.security.tools.PolicyTool;
import sun.security.tools.TaggedList;
import sun.security.tools.ToolDialog;
import sun.security.tools.ToolWindow;

class NewPolicyPrinOKButtonListener
implements ActionListener {
    private PolicyTool tool;
    private ToolWindow tw;
    private ToolDialog listDialog;
    private ToolDialog infoDialog;
    private boolean edit;

    NewPolicyPrinOKButtonListener(PolicyTool tool, ToolWindow tw, ToolDialog listDialog, ToolDialog infoDialog, boolean edit) {
        this.tool = tool;
        this.tw = tw;
        this.listDialog = listDialog;
        this.infoDialog = infoDialog;
        this.edit = edit;
    }

    public void actionPerformed(ActionEvent e) {
        try {
            PolicyParser.PrincipalEntry pppe = this.infoDialog.getPrinFromDialog();
            if (pppe != null) {
                try {
                    this.tool.verifyPrincipal(pppe.getPrincipalClass(), pppe.getPrincipalName());
                }
                catch (ClassNotFoundException cnfe) {
                    MessageFormat form = new MessageFormat(PolicyTool.rb.getString("Warning: Class not found: class"));
                    Object[] source = new Object[]{pppe.getPrincipalClass()};
                    this.tool.warnings.addElement(form.format(source));
                    this.tw.displayStatusDialog(this.infoDialog, form.format(source));
                }
                TaggedList prinList = (TaggedList)this.listDialog.getComponent(6);
                String prinString = ToolDialog.PrincipalEntryToUserFriendlyString(pppe);
                if (this.edit) {
                    int index = prinList.getSelectedIndex();
                    prinList.replaceTaggedItem(prinString, pppe, index);
                } else {
                    prinList.addTaggedItem(prinString, pppe);
                }
            }
            this.infoDialog.dispose();
        }
        catch (Exception ee) {
            this.tw.displayErrorDialog((Window)this.infoDialog, ee);
        }
    }
}

