/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools;

import java.awt.List;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.PublicKey;
import java.text.MessageFormat;
import sun.security.provider.PolicyParser;
import sun.security.tools.PolicyEntry;
import sun.security.tools.PolicyTool;
import sun.security.tools.ToolDialog;
import sun.security.tools.ToolWindow;

class AddEntryDoneButtonListener
implements ActionListener {
    private PolicyTool tool;
    private ToolWindow tw;
    private ToolDialog td;
    private boolean edit;

    AddEntryDoneButtonListener(PolicyTool tool, ToolWindow tw, ToolDialog td, boolean edit) {
        this.tool = tool;
        this.tw = tw;
        this.td = td;
        this.edit = edit;
    }

    public void actionPerformed(ActionEvent e) {
        try {
            PolicyEntry newEntry = this.td.getPolicyEntryFromDialog();
            PolicyParser.GrantEntry newGe = newEntry.getGrantEntry();
            if (newGe.signedBy != null) {
                String[] signers = this.tool.parseSigners(newGe.signedBy);
                for (int i = 0; i < signers.length; ++i) {
                    PublicKey pubKey = this.tool.getPublicKeyAlias(signers[i]);
                    if (pubKey != null) continue;
                    MessageFormat form = new MessageFormat(PolicyTool.rb.getString("Warning: A public key for alias 'signers[i]' does not exist.  Make sure a KeyStore is properly configured."));
                    Object[] source = new Object[]{signers[i]};
                    this.tool.warnings.addElement(form.format(source));
                    this.tw.displayStatusDialog(this.td, form.format(source));
                }
            }
            List policyList = (List)this.tw.getComponent(3);
            if (this.edit) {
                int listIndex = policyList.getSelectedIndex();
                this.tool.addEntry(newEntry, listIndex);
                String newCodeBaseStr = newEntry.headerToString();
                if (PolicyTool.collator.compare(newCodeBaseStr, policyList.getItem(listIndex)) != 0) {
                    this.tool.modified = true;
                }
                policyList.replaceItem(newCodeBaseStr, listIndex);
            } else {
                this.tool.addEntry(newEntry, -1);
                policyList.add(newEntry.headerToString());
                this.tool.modified = true;
            }
            this.td.setVisible(false);
            this.td.dispose();
        }
        catch (Exception eee) {
            this.tw.displayErrorDialog((Window)this.td, eee);
        }
    }
}

