/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;

public class AttributeClass {
    private String myName;
    private int myType;
    private int nameLen;
    private Object myValue;
    public static final int TAG_UNSUPPORTED_VALUE = 16;
    public static final int TAG_INT = 33;
    public static final int TAG_BOOL = 34;
    public static final int TAG_ENUM = 35;
    public static final int TAG_OCTET = 48;
    public static final int TAG_DATE = 49;
    public static final int TAG_RESOLUTION = 50;
    public static final int TAG_RANGE_INTEGER = 51;
    public static final int TAG_TEXT_LANGUAGE = 53;
    public static final int TAG_NAME_LANGUAGE = 54;
    public static final int TAG_TEXT_WO_LANGUAGE = 65;
    public static final int TAG_NAME_WO_LANGUAGE = 66;
    public static final int TAG_KEYWORD = 68;
    public static final int TAG_URI = 69;
    public static final int TAG_CHARSET = 71;
    public static final int TAG_NATURALLANGUAGE = 72;
    public static final int TAG_MIME_MEDIATYPE = 73;
    public static final int TAG_MEMBER_ATTRNAME = 74;
    public static final AttributeClass ATTRIBUTES_CHARSET = new AttributeClass("attributes-charset", 71, "utf-8");
    public static final AttributeClass ATTRIBUTES_NATURAL_LANGUAGE = new AttributeClass("attributes-natural-language", 72, "en");

    protected AttributeClass(String name, int type, Object value) {
        this.myName = name;
        this.myType = type;
        this.nameLen = name.length();
        this.myValue = value;
    }

    public byte getType() {
        return (byte)this.myType;
    }

    public char[] getLenChars() {
        char[] chars = new char[]{'\u0000', (char)this.nameLen};
        return chars;
    }

    public Object getObjectValue() {
        return this.myValue;
    }

    public int getIntValue() {
        byte[] bufArray = (byte[])this.myValue;
        if (bufArray != null) {
            byte[] buf = new byte[4];
            for (int i = 0; i < 4; ++i) {
                buf[i] = bufArray[i + 1];
            }
            return this.convertToInt(buf);
        }
        return 0;
    }

    public int[] getArrayOfIntValues() {
        byte[] bufArray = (byte[])this.myValue;
        if (bufArray != null) {
            ByteArrayInputStream bufStream = new ByteArrayInputStream(bufArray);
            int available = bufStream.available();
            bufStream.mark(available);
            bufStream.skip(available - 1);
            int length = bufStream.read();
            bufStream.reset();
            int[] valueArray = new int[length];
            for (int i = 0; i < length; ++i) {
                int valLength = bufStream.read();
                if (valLength != 4) {
                    return null;
                }
                byte[] bufBytes = new byte[valLength];
                bufStream.read(bufBytes, 0, valLength);
                valueArray[i] = this.convertToInt(bufBytes);
            }
            return valueArray;
        }
        return null;
    }

    public int[] getIntRangeValue() {
        int[] range = new int[]{0, 0};
        byte[] bufArray = (byte[])this.myValue;
        if (bufArray != null) {
            int nBytes = 4;
            for (int j = 0; j < 2; ++j) {
                byte[] intBytes = new byte[nBytes];
                for (int i = 0; i < nBytes; ++i) {
                    intBytes[i] = bufArray[i + 4 * j + 1];
                }
                range[j] = this.convertToInt(intBytes);
            }
        }
        return range;
    }

    public String getStringValue() {
        String strVal = null;
        byte[] bufArray = (byte[])this.myValue;
        if (bufArray != null) {
            ByteArrayInputStream bufStream = new ByteArrayInputStream(bufArray);
            int valLength = bufStream.read();
            byte[] strBytes = new byte[valLength];
            bufStream.read(strBytes, 0, valLength);
            try {
                strVal = new String(strBytes, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                // empty catch block
            }
        }
        return strVal;
    }

    public String[] getArrayOfStringValues() {
        byte[] bufArray = (byte[])this.myValue;
        if (bufArray != null) {
            ByteArrayInputStream bufStream = new ByteArrayInputStream(bufArray);
            int available = bufStream.available();
            bufStream.mark(available);
            bufStream.skip(available - 1);
            int length = bufStream.read();
            bufStream.reset();
            String[] valueArray = new String[length];
            for (int i = 0; i < length; ++i) {
                int valLength = bufStream.read();
                byte[] bufBytes = new byte[valLength];
                bufStream.read(bufBytes, 0, valLength);
                try {
                    valueArray[i] = new String(bufBytes, "UTF-8");
                    continue;
                }
                catch (UnsupportedEncodingException uee) {
                    // empty catch block
                }
            }
            return valueArray;
        }
        return null;
    }

    public byte getByteValue() {
        byte[] bufArray = (byte[])this.myValue;
        if (bufArray != null && bufArray.length >= 2) {
            return bufArray[1];
        }
        return 0;
    }

    public String getName() {
        return this.myName;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof AttributeClass && obj.toString().equals(((AttributeClass)obj).toString());
    }

    public String toString() {
        return this.myName;
    }

    private int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    private int convertToInt(byte[] buf) {
        int intVal = 0;
        int pos = 0;
        intVal += this.unsignedByteToInt(buf[pos++]) << 24;
        intVal += this.unsignedByteToInt(buf[pos++]) << 16;
        intVal += this.unsignedByteToInt(buf[pos++]) << 8;
        return intVal += this.unsignedByteToInt(buf[pos++]) << 0;
    }
}

