/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.lang.management.MemoryUsage;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import sun.management.LazyCompositeData;
import sun.management.MappedMXBeanType;
import sun.management.Util;

public class MemoryUsageCompositeData
extends LazyCompositeData {
    private final MemoryUsage usage;
    private static final CompositeType memoryUsageCompositeType;
    private static final String INIT = "init";
    private static final String USED = "used";
    private static final String COMMITTED = "committed";
    private static final String MAX = "max";
    private static final String[] memoryUsageItemNames;

    private MemoryUsageCompositeData(MemoryUsage u) {
        this.usage = u;
    }

    public MemoryUsage getMemoryUsage() {
        return this.usage;
    }

    public static CompositeData toCompositeData(MemoryUsage u) {
        MemoryUsageCompositeData mucd = new MemoryUsageCompositeData(u);
        return mucd.getCompositeData();
    }

    protected CompositeData getCompositeData() {
        Object[] memoryUsageItemValues = new Object[]{new Long(this.usage.getInit()), new Long(this.usage.getUsed()), new Long(this.usage.getCommitted()), new Long(this.usage.getMax())};
        try {
            return new CompositeDataSupport(memoryUsageCompositeType, memoryUsageItemNames, memoryUsageItemValues);
        }
        catch (OpenDataException e) {
            throw Util.newInternalError(e);
        }
    }

    static CompositeType getMemoryUsageCompositeType() {
        return memoryUsageCompositeType;
    }

    public static long getInit(CompositeData cd) {
        return MemoryUsageCompositeData.getLong(cd, INIT);
    }

    public static long getUsed(CompositeData cd) {
        return MemoryUsageCompositeData.getLong(cd, USED);
    }

    public static long getCommitted(CompositeData cd) {
        return MemoryUsageCompositeData.getLong(cd, COMMITTED);
    }

    public static long getMax(CompositeData cd) {
        return MemoryUsageCompositeData.getLong(cd, MAX);
    }

    public static void validateCompositeData(CompositeData cd) {
        if (cd == null) {
            throw new NullPointerException("Null CompositeData");
        }
        if (!MemoryUsageCompositeData.isTypeMatched(memoryUsageCompositeType, cd.getCompositeType())) {
            throw new IllegalArgumentException("Unexpected composite type for MemoryUsage");
        }
    }

    static {
        try {
            memoryUsageCompositeType = (CompositeType)MappedMXBeanType.toOpenType(MemoryUsage.class);
        }
        catch (OpenDataException e) {
            throw Util.newInternalError(e);
        }
        memoryUsageItemNames = new String[]{INIT, USED, COMMITTED, MAX};
    }
}

