/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.awt.BasicStroke;
import java.awt.Rectangle;
import java.awt.Shape;
import sun.java2d.SunGraphics2D;
import sun.java2d.pipe.AATileGenerator;
import sun.java2d.pipe.CompositePipe;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.RenderingEngine;
import sun.java2d.pipe.ShapeDrawPipe;

public class AAShapePipe
implements ShapeDrawPipe {
    static RenderingEngine renderengine = RenderingEngine.getInstance();
    CompositePipe outpipe;
    private static byte[] theTile;

    public AAShapePipe(CompositePipe pipe) {
        this.outpipe = pipe;
    }

    public void draw(SunGraphics2D sg, Shape s) {
        BasicStroke bs;
        if (sg.stroke instanceof BasicStroke) {
            bs = (BasicStroke)sg.stroke;
        } else {
            s = sg.stroke.createStrokedShape(s);
            bs = null;
        }
        this.renderPath(sg, s, bs);
    }

    public void fill(SunGraphics2D sg, Shape s) {
        this.renderPath(sg, s, null);
    }

    public static synchronized byte[] getAlphaTile(int len) {
        byte[] t = theTile;
        if (t == null || t.length < len) {
            t = new byte[len];
        } else {
            theTile = null;
        }
        return t;
    }

    public static synchronized void dropAlphaTile(byte[] t) {
        theTile = t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void renderPath(SunGraphics2D sg, Shape s, BasicStroke bs) {
        int[] abox;
        boolean adjust = bs != null && sg.strokeHint != 2;
        boolean thin = sg.strokeState <= 1;
        Object context = null;
        byte[] alpha = null;
        Region clip = sg.getCompClip();
        AATileGenerator aatg = renderengine.getAATileGenerator(s, sg.transform, clip, bs, thin, adjust, abox = new int[4]);
        if (aatg == null) {
            return;
        }
        try {
            context = this.outpipe.startSequence(sg, s, new Rectangle(abox[0], abox[1], abox[2] - abox[0], abox[3] - abox[1]), abox);
            int tw = aatg.getTileWidth();
            int th = aatg.getTileHeight();
            alpha = AAShapePipe.getAlphaTile(tw * th);
            for (int y = abox[1]; y < abox[3]; y += th) {
                for (int x = abox[0]; x < abox[2]; x += tw) {
                    byte[] atile;
                    int w = Math.min(tw, abox[2] - x);
                    int h = Math.min(th, abox[3] - y);
                    int a = aatg.getTypicalAlpha();
                    if (a == 0 || !this.outpipe.needTile(context, x, y, w, h)) {
                        aatg.nextTile();
                        this.outpipe.skipTile(context, x, y);
                        continue;
                    }
                    if (a == 255) {
                        atile = null;
                        aatg.nextTile();
                    } else {
                        atile = alpha;
                        aatg.getAlpha(alpha, 0, tw);
                    }
                    this.outpipe.renderPathTile(context, atile, 0, tw, x, y, w, h);
                }
            }
            aatg.dispose();
            if (context != null) {
                this.outpipe.endSequence(context);
            }
            if (alpha == null) return;
        }
        catch (Throwable throwable) {
            aatg.dispose();
            if (context != null) {
                this.outpipe.endSequence(context);
            }
            if (alpha == null) throw throwable;
            AAShapePipe.dropAlphaTile(alpha);
            throw throwable;
        }
        AAShapePipe.dropAlphaTile(alpha);
    }
}

