/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XVisualInfo
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return 40;
    }

    public int getDataSize() {
        return XVisualInfo.getSize();
    }

    public long getPData() {
        return this.pData;
    }

    XVisualInfo(long addr) {
        log.finest("Creating");
        this.pData = addr;
        this.should_free_memory = false;
    }

    XVisualInfo() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XVisualInfo.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public long get_visual(int index) {
        log.finest("");
        return Native.getLong(this.pData + 0L) + (long)(index * Native.getLongSize());
    }

    public long get_visual() {
        log.finest("");
        return Native.getLong(this.pData + 0L);
    }

    public void set_visual(long v) {
        log.finest("");
        Native.putLong(this.pData + 0L, v);
    }

    public long get_visualid() {
        log.finest("");
        return Native.getLong(this.pData + 4L);
    }

    public void set_visualid(long v) {
        log.finest("");
        Native.putLong(this.pData + 4L, v);
    }

    public int get_screen() {
        log.finest("");
        return Native.getInt(this.pData + 8L);
    }

    public void set_screen(int v) {
        log.finest("");
        Native.putInt(this.pData + 8L, v);
    }

    public int get_depth() {
        log.finest("");
        return Native.getInt(this.pData + 12L);
    }

    public void set_depth(int v) {
        log.finest("");
        Native.putInt(this.pData + 12L, v);
    }

    public int get_class() {
        log.finest("");
        return Native.getInt(this.pData + 16L);
    }

    public void set_class(int v) {
        log.finest("");
        Native.putInt(this.pData + 16L, v);
    }

    public long get_red_mask() {
        log.finest("");
        return Native.getLong(this.pData + 20L);
    }

    public void set_red_mask(long v) {
        log.finest("");
        Native.putLong(this.pData + 20L, v);
    }

    public long get_green_mask() {
        log.finest("");
        return Native.getLong(this.pData + 24L);
    }

    public void set_green_mask(long v) {
        log.finest("");
        Native.putLong(this.pData + 24L, v);
    }

    public long get_blue_mask() {
        log.finest("");
        return Native.getLong(this.pData + 28L);
    }

    public void set_blue_mask(long v) {
        log.finest("");
        Native.putLong(this.pData + 28L, v);
    }

    public int get_colormap_size() {
        log.finest("");
        return Native.getInt(this.pData + 32L);
    }

    public void set_colormap_size(int v) {
        log.finest("");
        Native.putInt(this.pData + 32L, v);
    }

    public int get_bits_per_rgb() {
        log.finest("");
        return Native.getInt(this.pData + 36L);
    }

    public void set_bits_per_rgb(int v) {
        log.finest("");
        Native.putInt(this.pData + 36L, v);
    }

    String getName() {
        return "XVisualInfo";
    }

    String getFieldsAsString() {
        String ret = "";
        ret = ret + "visual = " + this.get_visual() + ", ";
        ret = ret + "visualid = " + this.get_visualid() + ", ";
        ret = ret + "screen = " + this.get_screen() + ", ";
        ret = ret + "depth = " + this.get_depth() + ", ";
        ret = ret + "class = " + this.get_class() + ", ";
        ret = ret + "red_mask = " + this.get_red_mask() + ", ";
        ret = ret + "green_mask = " + this.get_green_mask() + ", ";
        ret = ret + "blue_mask = " + this.get_blue_mask() + ", ";
        ret = ret + "colormap_size = " + this.get_colormap_size() + ", ";
        ret = ret + "bits_per_rgb = " + this.get_bits_per_rgb() + ", ";
        return ret;
    }
}

