/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.SunToolkit;
import sun.awt.X11.MotifColorUtilities;
import sun.awt.X11.XScrollRepeater;
import sun.awt.X11.XScrollbarClient;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XlibWrapper;
import sun.awt.X11GraphicsConfig;

abstract class XScrollbar {
    private static Logger log = Logger.getLogger("sun.awt.X11.XScrollbar");
    private static XScrollRepeater scroller = new XScrollRepeater(null);
    private XScrollRepeater i_scroller = new XScrollRepeater(null);
    private static final int MIN_THUMB_H = 5;
    private static final int ARROW_IND = 1;
    XScrollbarClient sb;
    private int val;
    private int min;
    private int max;
    private int vis;
    private int line;
    private int page;
    private boolean needsRepaint = true;
    private boolean pressed = false;
    private boolean dragging = false;
    Polygon firstArrow;
    Polygon secondArrow;
    int width;
    int height;
    int barWidth;
    int barLength;
    int arrowArea;
    int alignment;
    public static final int ALIGNMENT_VERTICAL = 1;
    public static final int ALIGNMENT_HORIZONTAL = 2;
    int mode;
    Point thumbOffset;
    private Rectangle prevThumb;

    public XScrollbar(int alignment, XScrollbarClient sb) {
        this.sb = sb;
        this.alignment = alignment;
    }

    public boolean needsRepaint() {
        return this.needsRepaint;
    }

    void notifyValue(int v) {
        this.notifyValue(v, false);
    }

    void notifyValue(int v, final boolean isAdjusting) {
        if (v < this.min) {
            v = this.min;
        } else if (v > this.max - this.vis) {
            v = this.max - this.vis;
        }
        final int value = v;
        final int mode = this.mode;
        if (!(this.sb == null || value == this.val && this.pressed)) {
            SunToolkit.executeOnEventHandlerThread(this.sb.getEventSource(), new Runnable(){

                public void run() {
                    XScrollbar.this.sb.notifyValue(XScrollbar.this, mode, value, isAdjusting);
                }
            });
        }
    }

    protected abstract void rebuildArrows();

    public void setSize(int width, int height) {
        if (log.isLoggable(Level.FINER)) {
            log.finer("Setting scroll bar " + this + " size to " + width + "x" + height);
        }
        this.width = width;
        this.height = height;
    }

    protected Polygon createArrowShape(boolean vertical, boolean up) {
        Polygon arrow = new Polygon();
        if (vertical) {
            int x = this.width / 2 - this.getArrowWidth() / 2;
            int y1 = up ? 1 : this.barLength - 1;
            int y2 = up ? this.getArrowWidth() : this.barLength - this.getArrowWidth() - 1;
            arrow.addPoint(x + this.getArrowWidth() / 2, y1);
            arrow.addPoint(x + this.getArrowWidth(), y2);
            arrow.addPoint(x, y2);
            arrow.addPoint(x + this.getArrowWidth() / 2, y1);
        } else {
            int y = this.height / 2 - this.getArrowWidth() / 2;
            int x1 = up ? 1 : this.barLength - 1;
            int x2 = up ? this.getArrowWidth() : this.barLength - this.getArrowWidth() - 1;
            arrow.addPoint(x1, y + this.getArrowWidth() / 2);
            arrow.addPoint(x2, y + this.getArrowWidth());
            arrow.addPoint(x2, y);
            arrow.addPoint(x1, y + this.getArrowWidth() / 2);
        }
        return arrow;
    }

    protected abstract Rectangle getThumbArea();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paint(Graphics g, Color[] colors, boolean paintAll) {
        if (log.isLoggable(Level.FINER)) {
            log.finer("Painting scrollbar " + this);
        }
        boolean useBufferedImage = false;
        Graphics2D g2 = null;
        BufferedImage buffer = null;
        if (!(g instanceof Graphics2D)) {
            X11GraphicsConfig graphicsConfig = (X11GraphicsConfig)this.sb.getEventSource().getGraphicsConfiguration();
            buffer = graphicsConfig.createCompatibleImage(this.width, this.height);
            g2 = buffer.createGraphics();
            useBufferedImage = true;
        } else {
            g2 = (Graphics2D)g;
        }
        try {
            Rectangle thumbRect;
            this.prevThumb = thumbRect = this.calculateThumbRect();
            Color back = colors[0];
            Color selectColor = new Color(MotifColorUtilities.calculateSelectFromBackground(back.getRed(), back.getGreen(), back.getBlue()));
            Color darkShadow = new Color(MotifColorUtilities.calculateBottomShadowFromBackground(back.getRed(), back.getGreen(), back.getBlue()));
            Color lightShadow = new Color(MotifColorUtilities.calculateTopShadowFromBackground(back.getRed(), back.getGreen(), back.getBlue()));
            XToolkit.awtLock();
            try {
                XlibWrapper.XFlush(XToolkit.getDisplay());
            }
            finally {
                XToolkit.awtUnlock();
            }
            if (paintAll) {
                g2.setColor(selectColor);
                if (this.alignment == 2) {
                    g2.fillRect(0, 0, thumbRect.x, this.height);
                    g2.fillRect(thumbRect.x + thumbRect.width, 0, this.width - (thumbRect.x + thumbRect.width), this.height);
                } else {
                    g2.fillRect(0, 0, this.width, thumbRect.y);
                    g2.fillRect(0, thumbRect.y + thumbRect.height, this.width, this.height - (thumbRect.y + thumbRect.height));
                }
                g2.setColor(darkShadow);
                g2.drawLine(0, 0, this.width - 1, 0);
                g2.drawLine(0, 0, 0, this.height - 1);
                g2.setColor(lightShadow);
                g2.drawLine(1, this.height - 1, this.width - 1, this.height - 1);
                g2.drawLine(this.width - 1, 1, this.width - 1, this.height - 1);
            } else {
                g2.setColor(selectColor);
                Rectangle thumbArea = this.getThumbArea();
                g2.fill(thumbArea);
            }
            if (paintAll) {
                this.paintArrows(g2, colors[0], darkShadow, lightShadow);
            }
            g2.setColor(colors[0]);
            g2.fillRect(thumbRect.x, thumbRect.y, thumbRect.width, thumbRect.height);
            g2.setColor(lightShadow);
            g2.drawLine(thumbRect.x, thumbRect.y, thumbRect.x + thumbRect.width, thumbRect.y);
            g2.drawLine(thumbRect.x, thumbRect.y, thumbRect.x, thumbRect.y + thumbRect.height);
            g2.setColor(darkShadow);
            g2.drawLine(thumbRect.x + 1, thumbRect.y + thumbRect.height, thumbRect.x + thumbRect.width, thumbRect.y + thumbRect.height);
            g2.drawLine(thumbRect.x + thumbRect.width, thumbRect.y + 1, thumbRect.x + thumbRect.width, thumbRect.y + thumbRect.height);
        }
        finally {
            if (useBufferedImage) {
                g2.dispose();
            }
        }
        if (useBufferedImage) {
            g.drawImage(buffer, 0, 0, null);
        }
        XToolkit.awtLock();
        try {
            XlibWrapper.XFlush(XToolkit.getDisplay());
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    void paintArrows(Graphics2D g, Color background, Color darkShadow, Color lightShadow) {
        g.setColor(background);
        if (this.pressed && this.mode == 2) {
            g.fill(this.firstArrow);
            g.setColor(lightShadow);
            g.drawLine(this.firstArrow.xpoints[0], this.firstArrow.ypoints[0], this.firstArrow.xpoints[1], this.firstArrow.ypoints[1]);
            g.drawLine(this.firstArrow.xpoints[1], this.firstArrow.ypoints[1], this.firstArrow.xpoints[2], this.firstArrow.ypoints[2]);
            g.setColor(darkShadow);
            g.drawLine(this.firstArrow.xpoints[2], this.firstArrow.ypoints[2], this.firstArrow.xpoints[0], this.firstArrow.ypoints[0]);
        } else {
            g.fill(this.firstArrow);
            g.setColor(darkShadow);
            g.drawLine(this.firstArrow.xpoints[0], this.firstArrow.ypoints[0], this.firstArrow.xpoints[1], this.firstArrow.ypoints[1]);
            g.drawLine(this.firstArrow.xpoints[1], this.firstArrow.ypoints[1], this.firstArrow.xpoints[2], this.firstArrow.ypoints[2]);
            g.setColor(lightShadow);
            g.drawLine(this.firstArrow.xpoints[2], this.firstArrow.ypoints[2], this.firstArrow.xpoints[0], this.firstArrow.ypoints[0]);
        }
        g.setColor(background);
        if (this.pressed && this.mode == 1) {
            g.fill(this.secondArrow);
            g.setColor(lightShadow);
            g.drawLine(this.secondArrow.xpoints[0], this.secondArrow.ypoints[0], this.secondArrow.xpoints[1], this.secondArrow.ypoints[1]);
            g.setColor(darkShadow);
            g.drawLine(this.secondArrow.xpoints[1], this.secondArrow.ypoints[1], this.secondArrow.xpoints[2], this.secondArrow.ypoints[2]);
            g.drawLine(this.secondArrow.xpoints[2], this.secondArrow.ypoints[2], this.secondArrow.xpoints[0], this.secondArrow.ypoints[0]);
        } else {
            g.fill(this.secondArrow);
            g.setColor(darkShadow);
            g.drawLine(this.secondArrow.xpoints[0], this.secondArrow.ypoints[0], this.secondArrow.xpoints[1], this.secondArrow.ypoints[1]);
            g.setColor(lightShadow);
            g.drawLine(this.secondArrow.xpoints[1], this.secondArrow.ypoints[1], this.secondArrow.xpoints[2], this.secondArrow.ypoints[2]);
            g.drawLine(this.secondArrow.xpoints[2], this.secondArrow.ypoints[2], this.secondArrow.xpoints[0], this.secondArrow.ypoints[0]);
        }
    }

    void startScrolling() {
        log.finer("Start scrolling on " + this);
        this.scroll();
        if (scroller == null) {
            scroller = new XScrollRepeater(this);
        } else {
            scroller.setScrollbar(this);
        }
        scroller.start();
    }

    void startScrollingInstance() {
        log.finer("Start scrolling on " + this);
        this.scroll();
        this.i_scroller.setScrollbar(this);
        this.i_scroller.start();
    }

    void stopScrollingInstance() {
        log.finer("Stop scrolling on " + this);
        this.i_scroller.stop();
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    void scroll() {
        switch (this.mode) {
            case 2: {
                this.notifyValue(this.val - this.line);
                return;
            }
            case 1: {
                this.notifyValue(this.val + this.line);
                return;
            }
            case 3: {
                this.notifyValue(this.val - this.page);
                return;
            }
            case 4: {
                this.notifyValue(this.val + this.page);
                return;
            }
        }
    }

    boolean isInArrow(int x, int y) {
        int arrAreaH;
        int coord = this.alignment == 2 ? x : y;
        return coord < (arrAreaH = this.getArrowAreaWidth()) || coord > this.barLength - arrAreaH + 1;
    }

    boolean isInThumb(int x, int y) {
        Rectangle thumbRect = this.calculateThumbRect();
        --thumbRect.x;
        thumbRect.width += 3;
        ++thumbRect.height;
        return thumbRect.contains(x, y);
    }

    abstract boolean beforeThumb(int var1, int var2);

    public void handleMouseEvent(int id, int modifiers, int x, int y) {
        if ((modifiers & 0x10) == 0) {
            return;
        }
        if (log.isLoggable(Level.FINER)) {
            String type;
            switch (id) {
                case 501: {
                    type = new String("press");
                    break;
                }
                case 502: {
                    type = new String("release");
                    break;
                }
                case 506: {
                    type = new String("drag");
                    break;
                }
                default: {
                    type = new String("other");
                }
            }
            log.finer("Mouse " + type + " event in scroll bar " + this + "x = " + x + ", y = " + y + ", on arrow: " + this.isInArrow(x, y) + ", on thumb: " + this.isInThumb(x, y) + ", before thumb: " + this.beforeThumb(x, y) + ", thumb rect" + this.calculateThumbRect());
        }
        switch (id) {
            case 501: {
                if (this.isInArrow(x, y)) {
                    this.pressed = true;
                    this.mode = this.beforeThumb(x, y) ? 2 : 1;
                    this.sb.repaintScrollbarRequest(this);
                    this.startScrolling();
                    break;
                }
                if (this.isInThumb(x, y)) {
                    this.mode = 5;
                } else {
                    this.mode = this.beforeThumb(x, y) ? 3 : 4;
                    this.startScrolling();
                }
                Rectangle pos = this.calculateThumbRect();
                this.thumbOffset = new Point(x - pos.x, y - pos.y);
                break;
            }
            case 502: {
                this.pressed = false;
                this.sb.repaintScrollbarRequest(this);
                scroller.stop();
                if (!this.dragging) break;
                this.handleTrackEvent(x, y, false);
                this.dragging = false;
                break;
            }
            case 506: {
                this.dragging = true;
                this.handleTrackEvent(x, y, true);
            }
        }
    }

    private void handleTrackEvent(int x, int y, boolean isAdjusting) {
        if (this.mode == 5) {
            this.notifyValue(this.calculateCursorOffset(x, y), isAdjusting);
        }
    }

    private int calculateCursorOffset(int x, int y) {
        if (this.alignment == 2) {
            if (this.dragging) {
                return Math.max(0, (int)((double)(x - (this.thumbOffset.x + this.getArrowAreaWidth())) / this.getScaleFactor())) + this.min;
            }
            return Math.max(0, (int)((double)(x - this.getArrowAreaWidth()) / this.getScaleFactor())) + this.min;
        }
        if (this.dragging) {
            return Math.max(0, (int)((double)(y - (this.thumbOffset.y + this.getArrowAreaWidth())) / this.getScaleFactor())) + this.min;
        }
        return Math.max(0, (int)((double)(y - this.getArrowAreaWidth()) / this.getScaleFactor())) + this.min;
    }

    synchronized void setValues(int value, int visible, int minimum, int maximum) {
        if (maximum <= minimum) {
            maximum = minimum + 1;
        }
        if (visible > maximum - minimum) {
            visible = maximum - minimum;
        }
        if (visible < 1) {
            visible = 1;
        }
        if (value < minimum) {
            value = minimum;
        }
        if (value > maximum - visible) {
            value = maximum - visible;
        }
        this.val = value;
        this.vis = visible;
        this.min = minimum;
        this.max = maximum;
    }

    synchronized void setValues(int value, int visible, int minimum, int maximum, int unitSize, int blockSize) {
        this.setValues(value, visible, minimum, maximum);
        this.setUnitIncrement(unitSize);
        this.setBlockIncrement(blockSize);
    }

    int getValue() {
        return this.val;
    }

    synchronized void setValue(int newValue) {
        this.setValues(newValue, this.vis, this.min, this.max);
    }

    int getMinimum() {
        return this.min;
    }

    synchronized void setMinimum(int newMinimum) {
        this.setValues(this.val, this.vis, newMinimum, this.max);
    }

    int getMaximum() {
        return this.max;
    }

    synchronized void setMaximum(int newMaximum) {
        this.setValues(this.val, this.vis, this.min, newMaximum);
    }

    int getVisibleAmount() {
        return this.vis;
    }

    synchronized void setVisibleAmount(int newAmount) {
        this.setValues(this.val, newAmount, this.min, this.max);
    }

    synchronized void setUnitIncrement(int unitSize) {
        this.line = unitSize;
    }

    int getUnitIncrement() {
        return this.line;
    }

    synchronized void setBlockIncrement(int blockSize) {
        this.page = blockSize;
    }

    int getBlockIncrement() {
        return this.page;
    }

    int getArrowWidth() {
        return this.getArrowAreaWidth() - 2;
    }

    int getArrowAreaWidth() {
        return this.arrowArea;
    }

    void calculateArrowWidth() {
        this.arrowArea = this.barLength < 2 * this.barWidth + 5 + 2 ? (this.barLength - 5 + 2) / 2 - 1 : this.barWidth - 1;
    }

    private double getScaleFactor() {
        double f = (double)(this.barLength - 2 * this.getArrowAreaWidth()) / (double)Math.max(1, this.max - this.min);
        return f;
    }

    protected Rectangle calculateThumbRect() {
        int minSliderHeight;
        int minSliderWidth;
        int hitTheWall = 0;
        int arrAreaH = this.getArrowAreaWidth();
        Rectangle retVal = new Rectangle(0, 0, 0, 0);
        float trueSize = this.barLength - 2 * arrAreaH - 1;
        if (this.alignment == 2) {
            minSliderWidth = 5;
            minSliderHeight = this.height - 3;
        } else {
            minSliderWidth = this.width - 3;
            minSliderHeight = 5;
        }
        float range = this.max - this.min;
        float factor = trueSize / range;
        float slideSize = (float)this.vis * factor;
        if (this.alignment == 2) {
            int localVal = (int)((double)slideSize + 0.5);
            int localMin = minSliderWidth;
            if (localVal > localMin) {
                retVal.width = localVal;
            } else {
                retVal.width = localMin;
                hitTheWall = localMin;
            }
            retVal.height = minSliderHeight;
        } else {
            retVal.width = minSliderWidth;
            int localVal = (int)((double)slideSize + 0.5);
            int localMin = minSliderHeight;
            if (localVal > localMin) {
                retVal.height = localVal;
            } else {
                retVal.height = localMin;
                hitTheWall = localMin;
            }
        }
        if (hitTheWall != 0) {
            factor = (trueSize -= (float)hitTheWall) / (range -= (float)this.vis);
        }
        if (this.alignment == 2) {
            retVal.x = (int)((double)(((float)this.val - (float)this.min) * factor) + 0.5) + arrAreaH;
            retVal.y = 1;
        } else {
            retVal.x = 1;
            retVal.y = (int)((double)(((float)this.val - (float)this.min) * factor) + 0.5) + arrAreaH;
        }
        return retVal;
    }

    public String toString() {
        return this.getClass() + "[" + this.width + "x" + this.height + "," + this.barWidth + "x" + this.barLength + "]";
    }
}

