/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.im.spi.InputMethodContext;
import java.awt.peer.ComponentPeer;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.awt.X11InputMethod;

public class XInputMethod
extends X11InputMethod {
    private static final Logger log = Logger.getLogger("sun.awt.X11.XInputMethod");
    private static volatile long xicFocus = 0L;

    public void setInputMethodContext(InputMethodContext context) {
        context.enableClientWindowNotification(this, true);
    }

    public void notifyClientWindowChange(Rectangle location) {
        XComponentPeer peer = (XComponentPeer)this.getPeer(this.clientComponentWindow);
        if (peer != null) {
            this.adjustStatusWindow(peer.getContentWindow());
        }
    }

    protected boolean openXIM() {
        return this.openXIMNative(XToolkit.getDisplay());
    }

    protected boolean createXIC() {
        XComponentPeer peer = (XComponentPeer)this.getPeer(this.clientComponentWindow);
        if (peer == null) {
            return false;
        }
        return this.createXICNative(peer.getContentWindow());
    }

    protected void setXICFocus(ComponentPeer peer, boolean value, boolean active) {
        if (peer == null) {
            return;
        }
        xicFocus = ((XComponentPeer)peer).getContentWindow();
        this.setXICFocusNative(((XComponentPeer)peer).getContentWindow(), value, active);
    }

    public static long getXICFocus() {
        return xicFocus;
    }

    protected Container getParent(Component client) {
        return client.getParent();
    }

    protected ComponentPeer getPeer(Component client) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Client is " + client);
        }
        XComponentPeer peer = (XComponentPeer)XToolkit.targetToPeer(client);
        while (client != null && peer == null) {
            client = this.getParent(client);
            peer = (XComponentPeer)XToolkit.targetToPeer(client);
        }
        log.log(Level.FINE, "Peer is {0}, client is {1}", new Object[]{peer, client});
        if (peer != null) {
            return peer;
        }
        return null;
    }

    protected synchronized void disposeImpl() {
        super.disposeImpl();
        this.clientComponentWindow = null;
    }

    protected void awtLock() {
        XToolkit.awtLock();
    }

    protected void awtUnlock() {
        XToolkit.awtUnlock();
    }

    long getCurrentParentWindow() {
        return ((XWindow)((Object)this.clientComponentWindow.getPeer())).getContentWindow();
    }

    private native boolean openXIMNative(long var1);

    private native boolean createXICNative(long var1);

    private native void setXICFocusNative(long var1, boolean var3, boolean var4);

    private native void adjustStatusWindow(long var1);
}

