/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.SystemTray;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.WritableRaster;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FontPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.KeyboardFocusManagerPeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.MouseInfoPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.RobotPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.SystemTrayPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.TrayIconPeer;
import java.awt.peer.WindowPeer;
import java.io.FilePermission;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketPermission;
import java.net.URL;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.AWTAutoShutdown;
import sun.awt.AppContext;
import sun.awt.ComponentFactory;
import sun.awt.DebugSettings;
import sun.awt.DefaultMouseInfoPeer;
import sun.awt.InputMethodSupport;
import sun.awt.KeyboardFocusManagerPeerImpl;
import sun.awt.ModalityEvent;
import sun.awt.ModalityListener;
import sun.awt.PeerEvent;
import sun.awt.PostEventQueue;
import sun.awt.WindowClosingListener;
import sun.awt.WindowClosingSupport;
import sun.awt.im.InputContext;
import sun.awt.im.SimpleInputMethodWindow;
import sun.awt.image.ByteArrayImageSource;
import sun.awt.image.FileImageSource;
import sun.awt.image.ImageRepresentation;
import sun.awt.image.ToolkitImage;
import sun.awt.image.URLImageSource;
import sun.font.FontDesignMetrics;
import sun.misc.SoftCache;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetPropertyAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SunToolkit
extends Toolkit
implements WindowClosingSupport,
WindowClosingListener,
ComponentFactory,
InputMethodSupport {
    private static final Logger log = Logger.getLogger("sun.awt.SunToolkit");
    public static final int GRAB_EVENT_MASK = Integer.MIN_VALUE;
    private static Field syncLWRequestsField;
    private static Method wakeupMethod;
    private static Field componentKeyField;
    private static Field menuComponentKeyField;
    private static Field trayIconKeyField;
    private static Field componentAppContextField;
    private static Field menuComponentAppContextField;
    private static Field isPostedField;
    private static final String POST_EVENT_QUEUE_KEY = "PostEventQueue";
    private static final ReentrantLock AWT_LOCK;
    private static final Condition AWT_LOCK_COND;
    private static final Map appContextMap;
    static SoftCache imgCache;
    private static Locale startupLocale;
    private static String dataTransfererClassName;
    private transient WindowClosingListener windowClosingListener = null;
    private static DefaultMouseInfoPeer mPeer;
    private static Dialog.ModalExclusionType DEFAULT_MODAL_EXCLUSION_TYPE;
    private ModalityListenerList modalityListeners = new ModalityListenerList();
    public static final int DEFAULT_WAIT_TIME = 10000;
    private static final int MAX_ITERS = 20;
    private static final int MIN_ITERS = 0;
    private static final int MINIMAL_EDELAY = 0;
    private boolean eventDispatched = false;
    private boolean queueEmpty = false;
    private final Object waitLock = "Wait Lock";
    static Method eqNoEvents;
    private static boolean checkedSystemAAFontSettings;
    private static boolean useSystemAAFontSettings;
    private static boolean lastExtraCondition;
    private static RenderingHints desktopFontHints;
    public static final String DESKTOPFONTHINTS = "awt.font.desktophints";
    private static Method consumeNextKeyTypedMethod;

    public SunToolkit() {
        ThreadGroup threadGroup = null;
        String tgName = System.getProperty("awt.threadgroup", "");
        if (tgName.length() != 0) {
            try {
                Constructor<?> ctor = Class.forName(tgName).getConstructor(String.class);
                threadGroup = (ThreadGroup)ctor.newInstance("AWT-ThreadGroup");
            }
            catch (Exception e) {
                System.err.println("Failed loading " + tgName + ": " + e);
            }
        }
        Runnable initEQ = new Runnable(){

            public void run() {
                EventQueue eventQueue;
                String eqName = System.getProperty("AWT.EventQueueClass", "java.awt.EventQueue");
                try {
                    eventQueue = (EventQueue)Class.forName(eqName).newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.err.println("Failed loading " + eqName + ": " + e);
                    eventQueue = new EventQueue();
                }
                AppContext appContext = AppContext.getAppContext();
                appContext.put(AppContext.EVENT_QUEUE_KEY, eventQueue);
                PostEventQueue postEventQueue = new PostEventQueue(eventQueue);
                appContext.put(SunToolkit.POST_EVENT_QUEUE_KEY, postEventQueue);
            }
        };
        if (threadGroup != null) {
            Thread eqInitThread = new Thread(threadGroup, initEQ, "EventQueue-Init");
            eqInitThread.start();
            try {
                eqInitThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            initEQ.run();
        }
    }

    public boolean useBufferPerWindow() {
        return false;
    }

    @Override
    public abstract WindowPeer createWindow(Window var1) throws HeadlessException;

    @Override
    public abstract FramePeer createFrame(Frame var1) throws HeadlessException;

    @Override
    public abstract DialogPeer createDialog(Dialog var1) throws HeadlessException;

    @Override
    public abstract ButtonPeer createButton(Button var1) throws HeadlessException;

    @Override
    public abstract TextFieldPeer createTextField(TextField var1) throws HeadlessException;

    @Override
    public abstract ChoicePeer createChoice(Choice var1) throws HeadlessException;

    @Override
    public abstract LabelPeer createLabel(Label var1) throws HeadlessException;

    @Override
    public abstract ListPeer createList(List var1) throws HeadlessException;

    @Override
    public abstract CheckboxPeer createCheckbox(Checkbox var1) throws HeadlessException;

    @Override
    public abstract ScrollbarPeer createScrollbar(Scrollbar var1) throws HeadlessException;

    @Override
    public abstract ScrollPanePeer createScrollPane(ScrollPane var1) throws HeadlessException;

    @Override
    public abstract TextAreaPeer createTextArea(TextArea var1) throws HeadlessException;

    @Override
    public abstract FileDialogPeer createFileDialog(FileDialog var1) throws HeadlessException;

    @Override
    public abstract MenuBarPeer createMenuBar(MenuBar var1) throws HeadlessException;

    @Override
    public abstract MenuPeer createMenu(Menu var1) throws HeadlessException;

    @Override
    public abstract PopupMenuPeer createPopupMenu(PopupMenu var1) throws HeadlessException;

    @Override
    public abstract MenuItemPeer createMenuItem(MenuItem var1) throws HeadlessException;

    @Override
    public abstract CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem var1) throws HeadlessException;

    @Override
    public abstract DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent var1) throws InvalidDnDOperationException;

    public abstract TrayIconPeer createTrayIcon(TrayIcon var1) throws HeadlessException, AWTException;

    public abstract SystemTrayPeer createSystemTray(SystemTray var1);

    public abstract boolean isTraySupported();

    @Override
    public abstract FontPeer getFontPeer(String var1, int var2);

    @Override
    public abstract RobotPeer createRobot(Robot var1, GraphicsDevice var2) throws AWTException;

    public KeyboardFocusManagerPeer createKeyboardFocusManagerPeer(KeyboardFocusManager manager) throws HeadlessException {
        KeyboardFocusManagerPeerImpl peer = new KeyboardFocusManagerPeerImpl(manager);
        return peer;
    }

    public static final void awtLock() {
        AWT_LOCK.lock();
    }

    public static final boolean awtTryLock() {
        return AWT_LOCK.tryLock();
    }

    public static final void awtUnlock() {
        AWT_LOCK.unlock();
    }

    public static final void awtLockWait() throws InterruptedException {
        AWT_LOCK_COND.await();
    }

    public static final void awtLockWait(long timeout) throws InterruptedException {
        AWT_LOCK_COND.await(timeout, TimeUnit.MILLISECONDS);
    }

    public static final void awtLockNotify() {
        AWT_LOCK_COND.signal();
    }

    public static final void awtLockNotifyAll() {
        AWT_LOCK_COND.signalAll();
    }

    public static final boolean isAWTLockHeldByCurrentThread() {
        return AWT_LOCK.isHeldByCurrentThread();
    }

    public static AppContext createNewAppContext() {
        EventQueue eventQueue;
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        String eqName = System.getProperty("AWT.EventQueueClass", "java.awt.EventQueue");
        try {
            eventQueue = (EventQueue)Class.forName(eqName).newInstance();
        }
        catch (Exception e) {
            System.err.println("Failed loading " + eqName + ": " + e);
            eventQueue = new EventQueue();
        }
        AppContext appContext = new AppContext(threadGroup);
        appContext.put(AppContext.EVENT_QUEUE_KEY, eventQueue);
        PostEventQueue postEventQueue = new PostEventQueue(eventQueue);
        appContext.put(POST_EVENT_QUEUE_KEY, postEventQueue);
        return appContext;
    }

    public static Field getField(final Class klass, final String fieldName) {
        return AccessController.doPrivileged(new PrivilegedAction<Field>(){

            @Override
            public Field run() {
                block5: {
                    try {
                        Field field = klass.getDeclaredField(fieldName);
                        assert (field != null);
                        field.setAccessible(true);
                        return field;
                    }
                    catch (SecurityException e) {
                        assert (false);
                    }
                    catch (NoSuchFieldException e) {
                        if ($assertionsDisabled) break block5;
                        throw new AssertionError();
                    }
                }
                return null;
            }
        });
    }

    static void wakeupEventQueue(EventQueue q, boolean isShutdown) {
        block6: {
            if (wakeupMethod == null) {
                wakeupMethod = (Method)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        block5: {
                            try {
                                Method method = EventQueue.class.getDeclaredMethod("wakeup", Boolean.TYPE);
                                if (method != null) {
                                    method.setAccessible(true);
                                }
                                return method;
                            }
                            catch (NoSuchMethodException e) {
                                assert (false);
                            }
                            catch (SecurityException e) {
                                if ($assertionsDisabled) break block5;
                                throw new AssertionError();
                            }
                        }
                        return null;
                    }
                });
            }
            try {
                if (wakeupMethod != null) {
                    wakeupMethod.invoke(q, isShutdown);
                }
            }
            catch (InvocationTargetException e) {
                assert (false);
            }
            catch (IllegalAccessException e) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
    }

    protected static Object targetToPeer(Object target) {
        if (target != null && !GraphicsEnvironment.isHeadless()) {
            return AWTAutoShutdown.getInstance().getPeer(target);
        }
        return null;
    }

    protected static void targetCreatedPeer(Object target, Object peer) {
        if (target != null && peer != null && !GraphicsEnvironment.isHeadless()) {
            AWTAutoShutdown.getInstance().registerPeer(target, peer);
        }
    }

    protected static void targetDisposedPeer(Object target, Object peer) {
        if (target != null && peer != null && !GraphicsEnvironment.isHeadless()) {
            AWTAutoShutdown.getInstance().unregisterPeer(target, peer);
        }
    }

    private static boolean setAppContext(Object target, AppContext context) {
        block8: {
            if (!(target instanceof Component) && !(target instanceof MenuComponent)) {
                return false;
            }
            try {
                if (target instanceof Component) {
                    if (componentAppContextField == null) {
                        componentAppContextField = SunToolkit.getField(Component.class, "appContext");
                    }
                    componentAppContextField.set(target, context);
                } else if (target instanceof MenuComponent) {
                    if (menuComponentAppContextField == null) {
                        menuComponentAppContextField = SunToolkit.getField(MenuComponent.class, "appContext");
                    }
                    menuComponentAppContextField.set(target, context);
                }
            }
            catch (IllegalAccessException e) {
                if ($assertionsDisabled) break block8;
                throw new AssertionError();
            }
        }
        return true;
    }

    private static AppContext getAppContext(Object target) {
        AppContext retObj;
        block7: {
            retObj = null;
            try {
                if (target instanceof Component) {
                    if (componentAppContextField == null) {
                        componentAppContextField = SunToolkit.getField(Component.class, "appContext");
                    }
                    retObj = (AppContext)componentAppContextField.get(target);
                } else if (target instanceof MenuComponent) {
                    if (menuComponentAppContextField == null) {
                        menuComponentAppContextField = SunToolkit.getField(MenuComponent.class, "appContext");
                    }
                    retObj = (AppContext)menuComponentAppContextField.get(target);
                }
            }
            catch (IllegalAccessException e) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError();
            }
        }
        return retObj;
    }

    public static AppContext targetToAppContext(Object target) {
        if (target == null || GraphicsEnvironment.isHeadless()) {
            return null;
        }
        AppContext context = SunToolkit.getAppContext(target);
        if (context == null) {
            context = (AppContext)appContextMap.get(target);
        }
        return context;
    }

    public static void setLWRequestStatus(Window changed, boolean status) {
        block4: {
            if (syncLWRequestsField == null) {
                syncLWRequestsField = SunToolkit.getField(Window.class, "syncLWRequests");
            }
            try {
                if (syncLWRequestsField != null) {
                    syncLWRequestsField.setBoolean(changed, status);
                }
            }
            catch (IllegalAccessException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    public static void checkAndSetPolicy(Container cont, boolean isSwingCont) {
        FocusTraversalPolicy defaultPolicy = KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalPolicy();
        String toolkitName = Toolkit.getDefaultToolkit().getClass().getName();
        if (!"sun.awt.X11.XToolkit".equals(toolkitName)) {
            cont.setFocusTraversalPolicy(defaultPolicy);
            return;
        }
        String policyName = defaultPolicy.getClass().getName();
        if (DefaultFocusTraversalPolicy.class != defaultPolicy.getClass()) {
            if (policyName.startsWith("java.awt.")) {
                if (isSwingCont) {
                    defaultPolicy = SunToolkit.createLayoutPolicy();
                }
            } else if (policyName.startsWith("javax.swing.") && !isSwingCont) {
                defaultPolicy = new DefaultFocusTraversalPolicy();
            }
        } else if (isSwingCont) {
            defaultPolicy = SunToolkit.createLayoutPolicy();
        }
        cont.setFocusTraversalPolicy(defaultPolicy);
    }

    private static FocusTraversalPolicy createLayoutPolicy() {
        FocusTraversalPolicy policy;
        block6: {
            policy = null;
            try {
                Class<?> layoutPolicyClass = Class.forName("javax.swing.LayoutFocusTraversalPolicy");
                policy = (FocusTraversalPolicy)layoutPolicyClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                assert (false);
            }
            catch (InstantiationException e) {
                assert (false);
            }
            catch (IllegalAccessException e) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        return policy;
    }

    public static void insertTargetMapping(Object target, AppContext appContext) {
        if (!GraphicsEnvironment.isHeadless() && !SunToolkit.setAppContext(target, appContext)) {
            appContextMap.put(target, appContext);
        }
    }

    public static void postEvent(AppContext appContext, AWTEvent event) {
        PostEventQueue postEventQueue;
        if (event == null) {
            throw new NullPointerException();
        }
        AppContext eventContext = SunToolkit.targetToAppContext(event.getSource());
        if (eventContext != null && !eventContext.equals(appContext)) {
            log.fine("Event posted on wrong app context : " + event);
        }
        if ((postEventQueue = (PostEventQueue)appContext.get(POST_EVENT_QUEUE_KEY)) != null) {
            postEventQueue.postEvent(event);
        }
    }

    public static void postPriorityEvent(final AWTEvent e) {
        if (isPostedField == null) {
            isPostedField = SunToolkit.getField(AWTEvent.class, "isPosted");
        }
        PeerEvent pe = new PeerEvent(Toolkit.getDefaultToolkit(), new Runnable(){

            public void run() {
                block4: {
                    try {
                        isPostedField.setBoolean(e, true);
                    }
                    catch (IllegalArgumentException e2) {
                        assert (false);
                    }
                    catch (IllegalAccessException e3) {
                        if ($assertionsDisabled) break block4;
                        throw new AssertionError();
                    }
                }
                ((Component)e.getSource()).dispatchEvent(e);
            }
        }, 2L);
        SunToolkit.postEvent(SunToolkit.targetToAppContext(e.getSource()), pe);
    }

    public static void flushPendingEvents() {
        AppContext appContext = AppContext.getAppContext();
        PostEventQueue postEventQueue = (PostEventQueue)appContext.get(POST_EVENT_QUEUE_KEY);
        if (postEventQueue != null) {
            postEventQueue.flush();
        }
    }

    public static boolean isPostEventQueueEmpty() {
        AppContext appContext = AppContext.getAppContext();
        PostEventQueue postEventQueue = (PostEventQueue)appContext.get(POST_EVENT_QUEUE_KEY);
        if (postEventQueue != null) {
            return postEventQueue.noEvents();
        }
        return true;
    }

    public static void executeOnEventHandlerThread(Object target, Runnable runnable) {
        SunToolkit.executeOnEventHandlerThread(new PeerEvent(target, runnable, 1L));
    }

    public static void executeOnEventHandlerThread(Object target, Runnable runnable, final long when) {
        SunToolkit.executeOnEventHandlerThread(new PeerEvent(target, runnable, 1L){

            public long getWhen() {
                return when;
            }
        });
    }

    public static void executeOnEventHandlerThread(PeerEvent peerEvent) {
        SunToolkit.postEvent(SunToolkit.targetToAppContext(peerEvent.getSource()), peerEvent);
    }

    public static void invokeLaterOnAppContext(AppContext appContext, Runnable dispatcher) {
        SunToolkit.postEvent(appContext, new PeerEvent(Toolkit.getDefaultToolkit(), dispatcher, 1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeOnEDTAndWait(Object target, Runnable runnable) throws InterruptedException, InvocationTargetException {
        if (EventQueue.isDispatchThread()) {
            throw new Error("Cannot call executeOnEDTAndWait from any event dispatcher thread");
        }
        class AWTInvocationLock {
            AWTInvocationLock() {
            }
        }
        AWTInvocationLock lock = new AWTInvocationLock();
        PeerEvent event = new PeerEvent(target, runnable, lock, true, 1L);
        AWTInvocationLock aWTInvocationLock = lock;
        synchronized (aWTInvocationLock) {
            SunToolkit.executeOnEventHandlerThread(event);
            lock.wait();
        }
        Throwable eventThrowable = event.getThrowable();
        if (eventThrowable != null) {
            throw new InvocationTargetException(eventThrowable);
        }
    }

    private static EventQueue getNextQueue(Object o) {
        EventQueue result;
        block2: {
            result = null;
            try {
                Field nextQueueField = SunToolkit.getField(EventQueue.class, "nextQueue");
                result = (EventQueue)nextQueueField.get(o);
            }
            catch (IllegalAccessException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return result;
    }

    private static Thread getDispatchThread(Object o) {
        Thread result;
        block2: {
            result = null;
            try {
                Field dispatchThreadField = SunToolkit.getField(EventQueue.class, "dispatchThread");
                result = (Thread)dispatchThreadField.get(o);
            }
            catch (IllegalAccessException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return result;
    }

    public static boolean isDispatchThreadForAppContext(Object target) {
        AppContext appContext = SunToolkit.targetToAppContext(target);
        EventQueue eq = (EventQueue)appContext.get(AppContext.EVENT_QUEUE_KEY);
        EventQueue next = SunToolkit.getNextQueue(eq);
        while (next != null) {
            eq = next;
            next = SunToolkit.getNextQueue(eq);
        }
        return Thread.currentThread() == SunToolkit.getDispatchThread(eq);
    }

    @Override
    public Dimension getScreenSize() {
        return new Dimension(this.getScreenWidth(), this.getScreenHeight());
    }

    protected abstract int getScreenWidth();

    protected abstract int getScreenHeight();

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return FontDesignMetrics.getMetrics(font);
    }

    @Override
    public String[] getFontList() {
        String[] hardwiredFontList = new String[]{"Dialog", "SansSerif", "Serif", "Monospaced", "DialogInput"};
        return hardwiredFontList;
    }

    @Override
    public PanelPeer createPanel(Panel target) {
        return (PanelPeer)((Object)this.createComponent(target));
    }

    @Override
    public CanvasPeer createCanvas(Canvas target) {
        return (CanvasPeer)((Object)this.createComponent(target));
    }

    public void disableBackgroundErase(Canvas canvas) {
        if (!canvas.isDisplayable()) {
            throw new IllegalStateException("Canvas must have a valid peer");
        }
    }

    public static boolean getSunAwtNoerasebackground() {
        return AccessController.doPrivileged(new GetBooleanAction("sun.awt.noerasebackground"));
    }

    public static boolean getSunAwtErasebackgroundonresize() {
        return AccessController.doPrivileged(new GetBooleanAction("sun.awt.erasebackgroundonresize"));
    }

    static synchronized Image getImageFromHash(Toolkit tk, URL url) {
        Image img;
        block10: {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                try {
                    Permission perm = url.openConnection().getPermission();
                    if (perm == null) break block10;
                    try {
                        sm.checkPermission(perm);
                    }
                    catch (SecurityException se) {
                        if (perm instanceof FilePermission && perm.getActions().indexOf("read") != -1) {
                            sm.checkRead(perm.getName());
                            break block10;
                        }
                        if (perm instanceof SocketPermission && perm.getActions().indexOf("connect") != -1) {
                            sm.checkConnect(url.getHost(), url.getPort());
                            break block10;
                        }
                        throw se;
                    }
                }
                catch (IOException ioe) {
                    sm.checkConnect(url.getHost(), url.getPort());
                }
            }
        }
        if ((img = (Image)imgCache.get(url)) == null) {
            try {
                img = tk.createImage(new URLImageSource(url));
                imgCache.put(url, img);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return img;
    }

    static synchronized Image getImageFromHash(Toolkit tk, String filename) {
        Image img;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkRead(filename);
        }
        if ((img = (Image)imgCache.get(filename)) == null) {
            try {
                img = tk.createImage(new FileImageSource(filename));
                imgCache.put(filename, img);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return img;
    }

    @Override
    public Image getImage(String filename) {
        return SunToolkit.getImageFromHash((Toolkit)this, filename);
    }

    @Override
    public Image getImage(URL url) {
        return SunToolkit.getImageFromHash((Toolkit)this, url);
    }

    @Override
    public Image createImage(String filename) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkRead(filename);
        }
        return this.createImage(new FileImageSource(filename));
    }

    @Override
    public Image createImage(URL url) {
        block7: {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                try {
                    Permission perm = url.openConnection().getPermission();
                    if (perm == null) break block7;
                    try {
                        sm.checkPermission(perm);
                    }
                    catch (SecurityException se) {
                        if (perm instanceof FilePermission && perm.getActions().indexOf("read") != -1) {
                            sm.checkRead(perm.getName());
                            break block7;
                        }
                        if (perm instanceof SocketPermission && perm.getActions().indexOf("connect") != -1) {
                            sm.checkConnect(url.getHost(), url.getPort());
                            break block7;
                        }
                        throw se;
                    }
                }
                catch (IOException ioe) {
                    sm.checkConnect(url.getHost(), url.getPort());
                }
            }
        }
        return this.createImage(new URLImageSource(url));
    }

    @Override
    public Image createImage(byte[] data, int offset, int length) {
        return this.createImage(new ByteArrayImageSource(data, offset, length));
    }

    @Override
    public Image createImage(ImageProducer producer) {
        return new ToolkitImage(producer);
    }

    @Override
    public int checkImage(Image img, int w, int h, ImageObserver o) {
        if (!(img instanceof ToolkitImage)) {
            return 32;
        }
        ToolkitImage tkimg = (ToolkitImage)img;
        int repbits = w == 0 || h == 0 ? 32 : tkimg.getImageRep().check(o);
        return tkimg.check(o) | repbits;
    }

    @Override
    public boolean prepareImage(Image img, int w, int h, ImageObserver o) {
        if (w == 0 || h == 0) {
            return true;
        }
        if (!(img instanceof ToolkitImage)) {
            return true;
        }
        ToolkitImage tkimg = (ToolkitImage)img;
        if (tkimg.hasError()) {
            if (o != null) {
                o.imageUpdate(img, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation ir = tkimg.getImageRep();
        return ir.prepare(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getScaledIconImage(java.util.List<Image> imageList, int width, int height) {
        if (width == 0 || height == 0) {
            return null;
        }
        Image bestImage = null;
        int bestWidth = 0;
        int bestHeight = 0;
        double bestSimilarity = 3.0;
        double bestScaleFactor = 0.0;
        for (Image im : imageList) {
            int ih;
            int iw;
            if (im == null) {
                if (!log.isLoggable(Level.FINER)) continue;
                log.log(Level.FINER, "SunToolkit.getScaledIconImage: Skipping the image passed into Java because it's null.");
                continue;
            }
            if (im instanceof ToolkitImage) {
                ImageRepresentation ir = ((ToolkitImage)im).getImageRep();
                ir.reconstruct(32);
            }
            try {
                iw = im.getWidth(null);
                ih = im.getHeight(null);
            }
            catch (Exception e) {
                if (!log.isLoggable(Level.FINER)) continue;
                log.log(Level.FINER, "SunToolkit.getScaledIconImage: Perhaps the image passed into Java is broken. Skipping this icon.");
                continue;
            }
            if (iw <= 0 || ih <= 0) continue;
            double scaleFactor = Math.min((double)width / (double)iw, (double)height / (double)ih);
            int adjw = 0;
            int adjh = 0;
            double scaleMeasure = 1.0;
            if (scaleFactor >= 2.0) {
                scaleFactor = Math.floor(scaleFactor);
                adjw = iw * (int)scaleFactor;
                adjh = ih * (int)scaleFactor;
                scaleMeasure = 1.0 - 0.5 / scaleFactor;
            } else if (scaleFactor >= 1.0) {
                scaleFactor = 1.0;
                adjw = iw;
                adjh = ih;
                scaleMeasure = 0.0;
            } else if (scaleFactor >= 0.75) {
                scaleFactor = 0.75;
                adjw = iw * 3 / 4;
                adjh = ih * 3 / 4;
                scaleMeasure = 0.3;
            } else if (scaleFactor >= 0.6666) {
                scaleFactor = 0.6666;
                adjw = iw * 2 / 3;
                adjh = ih * 2 / 3;
                scaleMeasure = 0.33;
            } else {
                double scaleDivider = Math.ceil(1.0 / scaleFactor);
                scaleFactor = 1.0 / scaleDivider;
                adjw = (int)Math.round((double)iw / scaleDivider);
                adjh = (int)Math.round((double)ih / scaleDivider);
                scaleMeasure = 1.0 - 1.0 / scaleDivider;
            }
            double similarity = ((double)width - (double)adjw) / (double)width + ((double)height - (double)adjh) / (double)height + scaleMeasure;
            if (similarity < bestSimilarity) {
                bestSimilarity = similarity;
                bestScaleFactor = scaleFactor;
                bestImage = im;
                bestWidth = adjw;
                bestHeight = adjh;
            }
            if (similarity != 0.0) continue;
            break;
        }
        if (bestImage == null) {
            return null;
        }
        BufferedImage bimage = new BufferedImage(width, height, 2);
        Graphics2D g = bimage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        try {
            int x = (width - bestWidth) / 2;
            int y = (height - bestHeight) / 2;
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "WWindowPeer.getScaledIconData() result : w : " + width + " h : " + height + " iW : " + bestImage.getWidth(null) + " iH : " + bestImage.getHeight(null) + " sim : " + bestSimilarity + " sf : " + bestScaleFactor + " adjW : " + bestWidth + " adjH : " + bestHeight + " x : " + x + " y : " + y);
            }
            g.drawImage(bestImage, x, y, bestWidth, bestHeight, null);
        }
        finally {
            g.dispose();
        }
        return bimage;
    }

    public static DataBufferInt getScaledIconData(java.util.List<Image> imageList, int width, int height) {
        BufferedImage bimage = SunToolkit.getScaledIconImage(imageList, width, height);
        if (bimage == null) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "SunToolkit.getScaledIconData: Perhaps the image passed into Java is broken. Skipping this icon.");
            }
            return null;
        }
        WritableRaster raster = bimage.getRaster();
        DataBuffer buffer = raster.getDataBuffer();
        return (DataBufferInt)buffer;
    }

    @Override
    protected EventQueue getSystemEventQueueImpl() {
        return SunToolkit.getSystemEventQueueImplPP();
    }

    static EventQueue getSystemEventQueueImplPP() {
        return SunToolkit.getSystemEventQueueImplPP(AppContext.getAppContext());
    }

    public static EventQueue getSystemEventQueueImplPP(AppContext appContext) {
        EventQueue theEventQueue = (EventQueue)appContext.get(AppContext.EVENT_QUEUE_KEY);
        return theEventQueue;
    }

    public static Container getNativeContainer(Component c) {
        return Toolkit.getNativeContainer(c);
    }

    @Override
    public Window createInputMethodWindow(String title, InputContext context) {
        return new SimpleInputMethodWindow(title, context);
    }

    @Override
    public boolean enableInputMethodsForTextComponent() {
        return false;
    }

    public static Locale getStartupLocale() {
        if (startupLocale == null) {
            String variant;
            String country;
            String language = AccessController.doPrivileged(new GetPropertyAction("user.language", "en"));
            String region = AccessController.doPrivileged(new GetPropertyAction("user.region"));
            if (region != null) {
                int i = region.indexOf(95);
                if (i >= 0) {
                    country = region.substring(0, i);
                    variant = region.substring(i + 1);
                } else {
                    country = region;
                    variant = "";
                }
            } else {
                country = AccessController.doPrivileged(new GetPropertyAction("user.country", ""));
                variant = AccessController.doPrivileged(new GetPropertyAction("user.variant", ""));
            }
            startupLocale = new Locale(language, country, variant);
        }
        return startupLocale;
    }

    @Override
    public Locale getDefaultKeyboardLocale() {
        return SunToolkit.getStartupLocale();
    }

    protected static void setDataTransfererClassName(String className) {
        dataTransfererClassName = className;
    }

    public static String getDataTransfererClassName() {
        if (dataTransfererClassName == null) {
            Toolkit.getDefaultToolkit();
        }
        return dataTransfererClassName;
    }

    @Override
    public WindowClosingListener getWindowClosingListener() {
        return this.windowClosingListener;
    }

    @Override
    public void setWindowClosingListener(WindowClosingListener wcl) {
        this.windowClosingListener = wcl;
    }

    @Override
    public RuntimeException windowClosingNotify(WindowEvent event) {
        if (this.windowClosingListener != null) {
            return this.windowClosingListener.windowClosingNotify(event);
        }
        return null;
    }

    @Override
    public RuntimeException windowClosingDelivered(WindowEvent event) {
        if (this.windowClosingListener != null) {
            return this.windowClosingListener.windowClosingDelivered(event);
        }
        return null;
    }

    @Override
    protected synchronized MouseInfoPeer getMouseInfoPeer() {
        if (mPeer == null) {
            mPeer = new DefaultMouseInfoPeer();
        }
        return mPeer;
    }

    public static boolean needsXEmbed() {
        String noxembed = AccessController.doPrivileged(new GetPropertyAction("sun.awt.noxembed", "false"));
        if ("true".equals(noxembed)) {
            return false;
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        if (tk instanceof SunToolkit) {
            return ((SunToolkit)tk).needsXEmbedImpl();
        }
        return false;
    }

    protected boolean needsXEmbedImpl() {
        return false;
    }

    protected final boolean isXEmbedServerRequested() {
        return AccessController.doPrivileged(new GetBooleanAction("sun.awt.xembedserver"));
    }

    public static boolean isModalExcludedSupported() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        return tk.isModalExclusionTypeSupported(DEFAULT_MODAL_EXCLUSION_TYPE);
    }

    protected boolean isModalExcludedSupportedImpl() {
        return false;
    }

    public static void setModalExcluded(Window window) {
        window.setModalExclusionType(DEFAULT_MODAL_EXCLUSION_TYPE);
    }

    public static boolean isModalExcluded(Window window) {
        return window.getModalExclusionType().compareTo(DEFAULT_MODAL_EXCLUSION_TYPE) >= 0;
    }

    @Override
    public boolean isModalityTypeSupported(Dialog.ModalityType modalityType) {
        return modalityType == Dialog.ModalityType.MODELESS || modalityType == Dialog.ModalityType.APPLICATION_MODAL;
    }

    @Override
    public boolean isModalExclusionTypeSupported(Dialog.ModalExclusionType exclusionType) {
        return exclusionType == Dialog.ModalExclusionType.NO_EXCLUDE;
    }

    public void addModalityListener(ModalityListener listener) {
        this.modalityListeners.add(listener);
    }

    public void removeModalityListener(ModalityListener listener) {
        this.modalityListeners.remove(listener);
    }

    public void notifyModalityPushed(Dialog dialog) {
        this.notifyModalityChange(1300, dialog);
    }

    public void notifyModalityPopped(Dialog dialog) {
        this.notifyModalityChange(1301, dialog);
    }

    final void notifyModalityChange(int id, Dialog source) {
        ModalityEvent ev = new ModalityEvent(source, this.modalityListeners, id);
        ev.dispatch();
    }

    public static boolean isLightweightOrUnknown(Component comp) {
        if (comp.isLightweight() || !(SunToolkit.getDefaultToolkit() instanceof SunToolkit)) {
            return true;
        }
        return !(comp instanceof Button) && !(comp instanceof Canvas) && !(comp instanceof Checkbox) && !(comp instanceof Choice) && !(comp instanceof Label) && !(comp instanceof List) && !(comp instanceof Panel) && !(comp instanceof Scrollbar) && !(comp instanceof ScrollPane) && !(comp instanceof TextArea) && !(comp instanceof TextField) && !(comp instanceof Window);
    }

    public static Method getMethod(final Class clz, final String methodName, final Class[] params) {
        Method res = null;
        try {
            res = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws Exception {
                    Method m = clz.getDeclaredMethod(methodName, params);
                    m.setAccessible(true);
                    return m;
                }
            });
        }
        catch (PrivilegedActionException ex) {
            ex.printStackTrace();
        }
        return res;
    }

    public void realSync() throws OperationTimedOut, InfiniteLoop {
        this.realSync(10000L);
    }

    public void realSync(long timeout) throws OperationTimedOut, InfiniteLoop {
        if (EventQueue.isDispatchThread()) {
            throw new IllegalThreadException("The SunToolkit.realSync() method cannot be used on the event dispatch thread (EDT).");
        }
        int bigLoop = 0;
        do {
            int iters;
            this.sync();
            for (iters = 0; iters < 0; ++iters) {
                this.syncNativeQueue(timeout);
            }
            while (this.syncNativeQueue(timeout) && iters < 20) {
                ++iters;
            }
            if (iters >= 20) {
                throw new InfiniteLoop();
            }
            for (iters = 0; iters < 0; ++iters) {
                this.waitForIdle(timeout);
            }
            while (this.waitForIdle(timeout) && iters < 20) {
                ++iters;
            }
            if (iters < 20) continue;
            throw new InfiniteLoop();
        } while ((this.syncNativeQueue(timeout) || this.waitForIdle(timeout)) && ++bigLoop < 20);
    }

    protected abstract boolean syncNativeQueue(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEQEmpty() {
        EventQueue queue = this.getSystemEventQueueImpl();
        Class<SunToolkit> clazz = SunToolkit.class;
        synchronized (SunToolkit.class) {
            if (eqNoEvents == null) {
                eqNoEvents = SunToolkit.getMethod(EventQueue.class, "noEvents", null);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            try {
                return (Boolean)eqNoEvents.invoke(queue, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean waitForIdle(final long timeout) {
        SunToolkit.flushPendingEvents();
        boolean queueWasEmpty = this.isEQEmpty();
        this.queueEmpty = false;
        this.eventDispatched = false;
        Object object = this.waitLock;
        synchronized (object) {
            SunToolkit.postEvent(AppContext.getAppContext(), new PeerEvent(this.getSystemEventQueueImpl(), null, 4L){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void dispatch() {
                    int iters;
                    for (iters = 0; iters < 0; ++iters) {
                        SunToolkit.this.syncNativeQueue(timeout);
                    }
                    while (SunToolkit.this.syncNativeQueue(timeout) && iters < 20) {
                        ++iters;
                    }
                    SunToolkit.flushPendingEvents();
                    Object object = SunToolkit.this.waitLock;
                    synchronized (object) {
                        SunToolkit.this.queueEmpty = SunToolkit.this.isEQEmpty();
                        SunToolkit.this.eventDispatched = true;
                        SunToolkit.this.waitLock.notifyAll();
                    }
                }
            });
            try {
                while (!this.eventDispatched) {
                    this.waitLock.wait();
                }
            }
            catch (InterruptedException ie) {
                return false;
            }
        }
        try {
            Thread.sleep(0L);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException("Interrupted");
        }
        SunToolkit.flushPendingEvents();
        object = this.waitLock;
        synchronized (object) {
            return !this.queueEmpty || !this.isEQEmpty() || !queueWasEmpty;
        }
    }

    public abstract void grab(Window var1);

    public abstract void ungrab(Window var1);

    public static native void closeSplashScreen();

    private void fireDesktopFontPropertyChanges() {
        this.setDesktopProperty(DESKTOPFONTHINTS, SunToolkit.getDesktopFontHints());
    }

    public static void setAAFontSettingsCondition(boolean extraCondition) {
        if (extraCondition != lastExtraCondition) {
            lastExtraCondition = extraCondition;
            if (checkedSystemAAFontSettings) {
                checkedSystemAAFontSettings = false;
                Toolkit tk = Toolkit.getDefaultToolkit();
                if (tk instanceof SunToolkit) {
                    ((SunToolkit)tk).fireDesktopFontPropertyChanges();
                }
            }
        }
    }

    private static RenderingHints getDesktopAAHintsByName(String hintname) {
        Object aaHint = null;
        if ((hintname = hintname.toLowerCase(Locale.ENGLISH)).equals("on")) {
            aaHint = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
        } else if (hintname.equals("gasp")) {
            aaHint = RenderingHints.VALUE_TEXT_ANTIALIAS_GASP;
        } else if (hintname.equals("lcd") || hintname.equals("lcd_hrgb")) {
            aaHint = RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB;
        } else if (hintname.equals("lcd_hbgr")) {
            aaHint = RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR;
        } else if (hintname.equals("lcd_vrgb")) {
            aaHint = RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VRGB;
        } else if (hintname.equals("lcd_vbgr")) {
            aaHint = RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VBGR;
        }
        if (aaHint != null) {
            RenderingHints map = new RenderingHints(null);
            map.put(RenderingHints.KEY_TEXT_ANTIALIASING, aaHint);
            return map;
        }
        return null;
    }

    private static boolean useSystemAAFontSettings() {
        if (!checkedSystemAAFontSettings) {
            useSystemAAFontSettings = true;
            String systemAAFonts = null;
            Toolkit tk = Toolkit.getDefaultToolkit();
            if (tk instanceof SunToolkit) {
                systemAAFonts = AccessController.doPrivileged(new GetPropertyAction("awt.useSystemAAFontSettings"));
            }
            if (systemAAFonts != null && !(useSystemAAFontSettings = Boolean.valueOf(systemAAFonts).booleanValue())) {
                desktopFontHints = SunToolkit.getDesktopAAHintsByName(systemAAFonts);
            }
            if (useSystemAAFontSettings) {
                useSystemAAFontSettings = lastExtraCondition;
            }
            checkedSystemAAFontSettings = true;
        }
        return useSystemAAFontSettings;
    }

    protected RenderingHints getDesktopAAHints() {
        return null;
    }

    public static RenderingHints getDesktopFontHints() {
        if (SunToolkit.useSystemAAFontSettings()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            if (tk instanceof SunToolkit) {
                RenderingHints map = ((SunToolkit)tk).getDesktopAAHints();
                return map;
            }
            return null;
        }
        if (desktopFontHints != null) {
            return (RenderingHints)desktopFontHints.clone();
        }
        return null;
    }

    public abstract boolean isDesktopSupported();

    public static synchronized void consumeNextKeyTyped(KeyEvent keyEvent) {
        if (consumeNextKeyTypedMethod == null) {
            consumeNextKeyTypedMethod = SunToolkit.getMethod(DefaultKeyboardFocusManager.class, "consumeNextKeyTyped", new Class[]{KeyEvent.class});
        }
        try {
            consumeNextKeyTypedMethod.invoke(KeyboardFocusManager.getCurrentKeyboardFocusManager(), keyEvent);
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
        }
    }

    protected static void dumpPeers(Logger aLog) {
        AWTAutoShutdown.getInstance().dumpPeers(aLog);
    }

    public boolean isNativeGTKAvailable() {
        return false;
    }

    static {
        String nativeDebug = System.getProperty("sun.awt.nativedebug");
        if ("true".equalsIgnoreCase(nativeDebug)) {
            DebugSettings.init();
        }
        AWT_LOCK = new ReentrantLock();
        AWT_LOCK_COND = AWT_LOCK.newCondition();
        appContextMap = Collections.synchronizedMap(new WeakHashMap());
        imgCache = new SoftCache();
        startupLocale = null;
        dataTransfererClassName = null;
        mPeer = null;
        DEFAULT_MODAL_EXCLUSION_TYPE = (Dialog.ModalExclusionType)((Object)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Dialog.ModalExclusionType defaultType = Dialog.ModalExclusionType.NO_EXCLUDE;
                try {
                    Field f = Dialog.class.getDeclaredField("DEFAULT_MODAL_EXCLUSION_TYPE");
                    f.setAccessible(true);
                    defaultType = (Dialog.ModalExclusionType)((Object)f.get(null));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return defaultType;
            }
        }));
        lastExtraCondition = true;
        consumeNextKeyTypedMethod = null;
    }

    public static class IllegalThreadException
    extends RuntimeException {
        public IllegalThreadException(String msg) {
            super(msg);
        }

        public IllegalThreadException() {
        }
    }

    public static class InfiniteLoop
    extends RuntimeException {
    }

    public static class OperationTimedOut
    extends RuntimeException {
        public OperationTimedOut(String msg) {
            super(msg);
        }

        public OperationTimedOut() {
        }
    }

    static class ModalityListenerList
    implements ModalityListener {
        Vector<ModalityListener> listeners = new Vector();

        ModalityListenerList() {
        }

        void add(ModalityListener listener) {
            this.listeners.addElement(listener);
        }

        void remove(ModalityListener listener) {
            this.listeners.removeElement(listener);
        }

        public void modalityPushed(ModalityEvent ev) {
            Iterator<ModalityListener> it = this.listeners.iterator();
            while (it.hasNext()) {
                it.next().modalityPushed(ev);
            }
        }

        public void modalityPopped(ModalityEvent ev) {
            Iterator<ModalityListener> it = this.listeners.iterator();
            while (it.hasNext()) {
                it.next().modalityPopped(ev);
            }
        }
    }
}

