/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.util.Vector;

public class LayoutQueue {
    Vector tasks = new Vector();
    Thread worker;
    static LayoutQueue defaultQueue;

    public static LayoutQueue getDefaultQueue() {
        if (defaultQueue == null) {
            defaultQueue = new LayoutQueue();
        }
        return defaultQueue;
    }

    public static void setDefaultQueue(LayoutQueue q) {
        defaultQueue = q;
    }

    public synchronized void addTask(Runnable task) {
        if (this.worker == null) {
            this.worker = new LayoutThread();
            this.worker.start();
        }
        this.tasks.addElement(task);
        this.notifyAll();
    }

    protected synchronized Runnable waitForWork() {
        while (this.tasks.size() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                return null;
            }
        }
        Runnable work = (Runnable)this.tasks.firstElement();
        this.tasks.removeElementAt(0);
        return work;
    }

    class LayoutThread
    extends Thread {
        LayoutThread() {
            super("text-layout");
            this.setPriority(1);
        }

        public void run() {
            Runnable work;
            do {
                if ((work = LayoutQueue.this.waitForWork()) == null) continue;
                work.run();
            } while (work != null);
        }
    }
}

