/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.Icon;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;

public class IconView
extends View {
    private Icon c;

    public IconView(Element elem) {
        super(elem);
        AttributeSet attr = elem.getAttributes();
        this.c = StyleConstants.getIcon(attr);
    }

    public void paint(Graphics g, Shape a) {
        Rectangle alloc = a.getBounds();
        this.c.paintIcon(this.getContainer(), g, alloc.x, alloc.y);
    }

    public float getPreferredSpan(int axis) {
        switch (axis) {
            case 0: {
                return this.c.getIconWidth();
            }
            case 1: {
                return this.c.getIconHeight();
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + axis);
    }

    public float getAlignment(int axis) {
        switch (axis) {
            case 1: {
                return 1.0f;
            }
        }
        return super.getAlignment(axis);
    }

    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        int p0 = this.getStartOffset();
        int p1 = this.getEndOffset();
        if (pos >= p0 && pos <= p1) {
            Rectangle r = a.getBounds();
            if (pos == p1) {
                r.x += r.width;
            }
            r.width = 0;
            return r;
        }
        throw new BadLocationException(pos + " not in range " + p0 + "," + p1, pos);
    }

    public int viewToModel(float x, float y, Shape a, Position.Bias[] bias) {
        Rectangle alloc = (Rectangle)a;
        if (x < (float)(alloc.x + alloc.width / 2)) {
            bias[0] = Position.Bias.Forward;
            return this.getStartOffset();
        }
        bias[0] = Position.Bias.Backward;
        return this.getEndOffset();
    }
}

