/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicMenuBarUI;
import javax.swing.plaf.metal.MetalToolBarUI;
import javax.swing.plaf.metal.MetalUtils;

public class MetalMenuBarUI
extends BasicMenuBarUI {
    public static ComponentUI createUI(JComponent x) {
        if (x == null) {
            throw new NullPointerException("Must pass in a non-null component");
        }
        return new MetalMenuBarUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        MetalToolBarUI.register(c);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        MetalToolBarUI.unregister(c);
    }

    public void update(Graphics g, JComponent c) {
        boolean isOpaque = c.isOpaque();
        if (g == null) {
            throw new NullPointerException("Graphics must be non-null");
        }
        if (isOpaque && c.getBackground() instanceof UIResource && UIManager.get("MenuBar.gradient") != null) {
            JToolBar tb;
            if (MetalToolBarUI.doesMenuBarBorderToolBar((JMenuBar)c) && (tb = (JToolBar)MetalToolBarUI.findRegisteredComponentOfType(c, JToolBar.class)).isOpaque() && tb.getBackground() instanceof UIResource) {
                MetalUtils.drawGradient(c, g, "MenuBar.gradient", 0, 0, c.getWidth(), c.getHeight() + tb.getHeight(), true);
                this.paint(g, c);
                return;
            }
            MetalUtils.drawGradient(c, g, "MenuBar.gradient", 0, 0, c.getWidth(), c.getHeight(), true);
            this.paint(g, c);
        } else {
            super.update(g, c);
        }
    }
}

