/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ToolTipUI;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class BasicToolTipUI
extends ToolTipUI {
    static BasicToolTipUI sharedInstance = new BasicToolTipUI();
    private static PropertyChangeListener sharedPropertyChangedListener;
    private PropertyChangeListener propertyChangeListener;

    public static ComponentUI createUI(JComponent c) {
        return sharedInstance;
    }

    public void installUI(JComponent c) {
        this.installDefaults(c);
        this.installComponents(c);
        this.installListeners(c);
    }

    public void uninstallUI(JComponent c) {
        this.uninstallDefaults(c);
        this.uninstallComponents(c);
        this.uninstallListeners(c);
    }

    protected void installDefaults(JComponent c) {
        LookAndFeel.installColorsAndFont(c, "ToolTip.background", "ToolTip.foreground", "ToolTip.font");
        LookAndFeel.installProperty(c, "opaque", Boolean.TRUE);
        this.componentChanged(c);
    }

    protected void uninstallDefaults(JComponent c) {
        LookAndFeel.uninstallBorder(c);
    }

    private void installComponents(JComponent c) {
        BasicHTML.updateRenderer(c, ((JToolTip)c).getTipText());
    }

    private void uninstallComponents(JComponent c) {
        BasicHTML.updateRenderer(c, "");
    }

    protected void installListeners(JComponent c) {
        this.propertyChangeListener = this.createPropertyChangeListener(c);
        c.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void uninstallListeners(JComponent c) {
        c.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    private PropertyChangeListener createPropertyChangeListener(JComponent c) {
        if (sharedPropertyChangedListener == null) {
            sharedPropertyChangedListener = new PropertyChangeHandler();
        }
        return sharedPropertyChangedListener;
    }

    public void paint(Graphics g, JComponent c) {
        Font font = c.getFont();
        FontMetrics metrics = SwingUtilities2.getFontMetrics(c, g, font);
        Dimension size = c.getSize();
        g.setColor(c.getForeground());
        String tipText = ((JToolTip)c).getTipText();
        if (tipText == null) {
            tipText = "";
        }
        Insets insets = c.getInsets();
        Rectangle paintTextR = new Rectangle(insets.left + 3, insets.top, size.width - (insets.left + insets.right) - 6, size.height - (insets.top + insets.bottom));
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            v.paint(g, paintTextR);
        } else {
            g.setFont(font);
            SwingUtilities2.drawString(c, g, tipText, paintTextR.x, paintTextR.y + metrics.getAscent());
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        Font font = c.getFont();
        FontMetrics fm = c.getFontMetrics(font);
        Insets insets = c.getInsets();
        Dimension prefSize = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        String text = ((JToolTip)c).getTipText();
        if (text == null || text.equals("")) {
            text = "";
        } else {
            View v;
            View view = v = c != null ? (View)c.getClientProperty("html") : null;
            if (v != null) {
                prefSize.width += (int)v.getPreferredSpan(0) + 6;
                prefSize.height += (int)v.getPreferredSpan(1);
            } else {
                prefSize.width += SwingUtilities2.stringWidth(c, fm, text) + 6;
                prefSize.height += fm.getHeight();
            }
        }
        return prefSize;
    }

    public Dimension getMinimumSize(JComponent c) {
        Dimension d = this.getPreferredSize(c);
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            d.width = (int)((float)d.width - (v.getPreferredSpan(0) - v.getMinimumSpan(0)));
        }
        return d;
    }

    public Dimension getMaximumSize(JComponent c) {
        Dimension d = this.getPreferredSize(c);
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            d.width = (int)((float)d.width + (v.getMaximumSpan(0) - v.getPreferredSpan(0)));
        }
        return d;
    }

    private void componentChanged(JComponent c) {
        JComponent comp = ((JToolTip)c).getComponent();
        if (comp != null && !comp.isEnabled()) {
            if (UIManager.getBorder("ToolTip.borderInactive") != null) {
                LookAndFeel.installBorder(c, "ToolTip.borderInactive");
            } else {
                LookAndFeel.installBorder(c, "ToolTip.border");
            }
            if (UIManager.getColor("ToolTip.backgroundInactive") != null) {
                LookAndFeel.installColors(c, "ToolTip.backgroundInactive", "ToolTip.foregroundInactive");
            } else {
                LookAndFeel.installColors(c, "ToolTip.background", "ToolTip.foreground");
            }
        } else {
            LookAndFeel.installBorder(c, "ToolTip.border");
            LookAndFeel.installColors(c, "ToolTip.background", "ToolTip.foreground");
        }
    }

    private static class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            JToolTip tip;
            String name = e.getPropertyName();
            if (name.equals("tiptext") || "font".equals(name) || "foreground".equals(name)) {
                JToolTip tip2 = (JToolTip)e.getSource();
                String text = tip2.getTipText();
                BasicHTML.updateRenderer(tip2, text);
            } else if ("component".equals(name) && (tip = (JToolTip)e.getSource()).getUI() instanceof BasicToolTipUI) {
                ((BasicToolTipUI)tip.getUI()).componentChanged(tip);
            }
        }
    }
}

