/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import javax.sound.sampled.Control;

public abstract class FloatControl
extends Control {
    private float minimum;
    private float maximum;
    private float precision;
    private int updatePeriod;
    private final String units;
    private final String minLabel;
    private final String maxLabel;
    private final String midLabel;
    private float value;

    protected FloatControl(Type type, float minimum, float maximum, float precision, int updatePeriod, float initialValue, String units, String minLabel, String midLabel, String maxLabel) {
        super(type);
        this.minimum = minimum;
        this.maximum = maximum;
        this.precision = precision;
        this.updatePeriod = updatePeriod;
        this.value = initialValue;
        this.units = units;
        this.minLabel = minLabel == null ? "" : minLabel;
        this.midLabel = midLabel == null ? "" : midLabel;
        this.maxLabel = maxLabel == null ? "" : maxLabel;
    }

    protected FloatControl(Type type, float minimum, float maximum, float precision, int updatePeriod, float initialValue, String units) {
        this(type, minimum, maximum, precision, updatePeriod, initialValue, units, "", "", "");
    }

    public void setValue(float newValue) {
        if (newValue > this.maximum) {
            throw new IllegalArgumentException("Requested value " + newValue + " exceeds allowable maximum value " + this.maximum + ".");
        }
        if (newValue < this.minimum) {
            throw new IllegalArgumentException("Requested value " + newValue + " smaller than allowable minimum value " + this.minimum + ".");
        }
        this.value = newValue;
    }

    public float getValue() {
        return this.value;
    }

    public float getMaximum() {
        return this.maximum;
    }

    public float getMinimum() {
        return this.minimum;
    }

    public String getUnits() {
        return this.units;
    }

    public String getMinLabel() {
        return this.minLabel;
    }

    public String getMidLabel() {
        return this.midLabel;
    }

    public String getMaxLabel() {
        return this.maxLabel;
    }

    public float getPrecision() {
        return this.precision;
    }

    public int getUpdatePeriod() {
        return this.updatePeriod;
    }

    public void shift(float from, float to, int microseconds) {
        this.setValue(to);
    }

    public String toString() {
        return new String(this.getType() + " with current value: " + this.getValue() + " " + this.units + " (range: " + this.minimum + " - " + this.maximum + ")");
    }

    public static class Type
    extends Control.Type {
        public static final Type MASTER_GAIN = new Type("Master Gain");
        public static final Type AUX_SEND = new Type("AUX Send");
        public static final Type AUX_RETURN = new Type("AUX Return");
        public static final Type REVERB_SEND = new Type("Reverb Send");
        public static final Type REVERB_RETURN = new Type("Reverb Return");
        public static final Type VOLUME = new Type("Volume");
        public static final Type PAN = new Type("Pan");
        public static final Type BALANCE = new Type("Balance");
        public static final Type SAMPLE_RATE = new Type("Sample Rate");

        protected Type(String name) {
            super(name);
        }
    }
}

