/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.naming.RefAddr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reference
implements Cloneable,
Serializable {
    protected String className;
    protected Vector<RefAddr> addrs = null;
    protected String classFactory = null;
    protected String classFactoryLocation = null;
    private static final long serialVersionUID = -1673475790065791735L;

    public Reference(String className) {
        this.className = className;
        this.addrs = new Vector();
    }

    public Reference(String className, RefAddr addr) {
        this.className = className;
        this.addrs = new Vector();
        this.addrs.addElement(addr);
    }

    public Reference(String className, String factory, String factoryLocation) {
        this(className);
        this.classFactory = factory;
        this.classFactoryLocation = factoryLocation;
    }

    public Reference(String className, RefAddr addr, String factory, String factoryLocation) {
        this(className, addr);
        this.classFactory = factory;
        this.classFactoryLocation = factoryLocation;
    }

    public String getClassName() {
        return this.className;
    }

    public String getFactoryClassName() {
        return this.classFactory;
    }

    public String getFactoryClassLocation() {
        return this.classFactoryLocation;
    }

    public RefAddr get(String addrType) {
        int len = this.addrs.size();
        for (int i = 0; i < len; ++i) {
            RefAddr addr = this.addrs.elementAt(i);
            if (addr.getType().compareTo(addrType) != 0) continue;
            return addr;
        }
        return null;
    }

    public RefAddr get(int posn) {
        return this.addrs.elementAt(posn);
    }

    public Enumeration<RefAddr> getAll() {
        return this.addrs.elements();
    }

    public int size() {
        return this.addrs.size();
    }

    public void add(RefAddr addr) {
        this.addrs.addElement(addr);
    }

    public void add(int posn, RefAddr addr) {
        this.addrs.insertElementAt(addr, posn);
    }

    public Object remove(int posn) {
        RefAddr r = this.addrs.elementAt(posn);
        this.addrs.removeElementAt(posn);
        return r;
    }

    public void clear() {
        this.addrs.setSize(0);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Reference) {
            Reference target = (Reference)obj;
            if (target.className.equals(this.className) && target.size() == this.size()) {
                Enumeration<RefAddr> mycomps = this.getAll();
                Enumeration<RefAddr> comps = target.getAll();
                while (mycomps.hasMoreElements()) {
                    if (((Object)mycomps.nextElement()).equals(comps.nextElement())) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = this.className.hashCode();
        Enumeration<RefAddr> e = this.getAll();
        while (e.hasMoreElements()) {
            hash += ((Object)e.nextElement()).hashCode();
        }
        return hash;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("Reference Class Name: " + this.className + "\n");
        int len = this.addrs.size();
        for (int i = 0; i < len; ++i) {
            buf.append(this.get(i).toString());
        }
        return buf.toString();
    }

    public Object clone() {
        Reference r = new Reference(this.className, this.classFactory, this.classFactoryLocation);
        Enumeration<RefAddr> a = this.getAll();
        r.addrs = new Vector();
        while (a.hasMoreElements()) {
            r.addrs.addElement(a.nextElement());
        }
        return r;
    }
}

