/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadLocal<T> {
    private final int threadLocalHashCode = ThreadLocal.nextHashCode();
    private static AtomicInteger nextHashCode = new AtomicInteger();
    private static final int HASH_INCREMENT = 1640531527;

    private static int nextHashCode() {
        return nextHashCode.getAndAdd(1640531527);
    }

    protected T initialValue() {
        return null;
    }

    public T get() {
        ThreadLocalMap.Entry e;
        Thread t = Thread.currentThread();
        ThreadLocalMap map = this.getMap(t);
        if (map != null && (e = map.getEntry(this)) != null) {
            return (T)e.value;
        }
        return this.setInitialValue();
    }

    private T setInitialValue() {
        T value = this.initialValue();
        Thread t = Thread.currentThread();
        ThreadLocalMap map = this.getMap(t);
        if (map != null) {
            map.set(this, value);
        } else {
            this.createMap(t, value);
        }
        return value;
    }

    public void set(T value) {
        Thread t = Thread.currentThread();
        ThreadLocalMap map = this.getMap(t);
        if (map != null) {
            map.set(this, value);
        } else {
            this.createMap(t, value);
        }
    }

    public void remove() {
        ThreadLocalMap m = this.getMap(Thread.currentThread());
        if (m != null) {
            m.remove(this);
        }
    }

    ThreadLocalMap getMap(Thread t) {
        return t.threadLocals;
    }

    void createMap(Thread t, T firstValue) {
        t.threadLocals = new ThreadLocalMap(this, firstValue);
    }

    static ThreadLocalMap createInheritedMap(ThreadLocalMap parentMap) {
        return new ThreadLocalMap(parentMap);
    }

    T childValue(T parentValue) {
        throw new UnsupportedOperationException();
    }

    static class ThreadLocalMap {
        private static final int INITIAL_CAPACITY = 16;
        private Entry[] table;
        private int size = 0;
        private int threshold;

        private void setThreshold(int len) {
            this.threshold = len * 2 / 3;
        }

        private static int nextIndex(int i, int len) {
            return i + 1 < len ? i + 1 : 0;
        }

        private static int prevIndex(int i, int len) {
            return i - 1 >= 0 ? i - 1 : len - 1;
        }

        ThreadLocalMap(ThreadLocal firstKey, Object firstValue) {
            this.table = new Entry[16];
            int i = firstKey.threadLocalHashCode & 0xF;
            this.table[i] = new Entry(firstKey, firstValue);
            this.size = 1;
            this.setThreshold(16);
        }

        private ThreadLocalMap(ThreadLocalMap parentMap) {
            Entry[] parentTable = parentMap.table;
            int len = parentTable.length;
            this.setThreshold(len);
            this.table = new Entry[len];
            for (int j = 0; j < len; ++j) {
                ThreadLocal key;
                Entry e = parentTable[j];
                if (e == null || (key = (ThreadLocal)e.get()) == null) continue;
                Object value = key.childValue(e.value);
                Entry c = new Entry(key, value);
                int h = key.threadLocalHashCode & len - 1;
                while (this.table[h] != null) {
                    h = ThreadLocalMap.nextIndex(h, len);
                }
                this.table[h] = c;
                ++this.size;
            }
        }

        private Entry getEntry(ThreadLocal key) {
            int i = key.threadLocalHashCode & this.table.length - 1;
            Entry e = this.table[i];
            if (e != null && e.get() == key) {
                return e;
            }
            return this.getEntryAfterMiss(key, i, e);
        }

        private Entry getEntryAfterMiss(ThreadLocal key, int i, Entry e) {
            Entry[] tab = this.table;
            int len = tab.length;
            while (e != null) {
                ThreadLocal k = (ThreadLocal)e.get();
                if (k == key) {
                    return e;
                }
                if (k == null) {
                    this.expungeStaleEntry(i);
                } else {
                    i = ThreadLocalMap.nextIndex(i, len);
                }
                e = tab[i];
            }
            return null;
        }

        private void set(ThreadLocal key, Object value) {
            int sz;
            Entry[] tab = this.table;
            int len = tab.length;
            int i = key.threadLocalHashCode & len - 1;
            Entry e = tab[i];
            while (e != null) {
                ThreadLocal k = (ThreadLocal)e.get();
                if (k == key) {
                    e.value = value;
                    return;
                }
                if (k == null) {
                    this.replaceStaleEntry(key, value, i);
                    return;
                }
                i = ThreadLocalMap.nextIndex(i, len);
                e = tab[i];
            }
            tab[i] = new Entry(key, value);
            if (!this.cleanSomeSlots(i, sz = ++this.size) && sz >= this.threshold) {
                this.rehash();
            }
        }

        private void remove(ThreadLocal key) {
            Entry[] tab = this.table;
            int len = tab.length;
            int i = key.threadLocalHashCode & len - 1;
            Entry e = tab[i];
            while (e != null) {
                if (e.get() == key) {
                    e.clear();
                    this.expungeStaleEntry(i);
                    return;
                }
                i = ThreadLocalMap.nextIndex(i, len);
                e = tab[i];
            }
        }

        private void replaceStaleEntry(ThreadLocal key, Object value, int staleSlot) {
            Entry e;
            Entry[] tab = this.table;
            int len = tab.length;
            int slotToExpunge = staleSlot;
            int i = ThreadLocalMap.prevIndex(staleSlot, len);
            while ((e = tab[i]) != null) {
                if (e.get() == null) {
                    slotToExpunge = i;
                }
                i = ThreadLocalMap.prevIndex(i, len);
            }
            i = ThreadLocalMap.nextIndex(staleSlot, len);
            while ((e = tab[i]) != null) {
                ThreadLocal k = (ThreadLocal)e.get();
                if (k == key) {
                    e.value = value;
                    tab[i] = tab[staleSlot];
                    tab[staleSlot] = e;
                    if (slotToExpunge == staleSlot) {
                        slotToExpunge = i;
                    }
                    this.cleanSomeSlots(this.expungeStaleEntry(slotToExpunge), len);
                    return;
                }
                if (k == null && slotToExpunge == staleSlot) {
                    slotToExpunge = i;
                }
                i = ThreadLocalMap.nextIndex(i, len);
            }
            tab[staleSlot].value = null;
            tab[staleSlot] = new Entry(key, value);
            if (slotToExpunge != staleSlot) {
                this.cleanSomeSlots(this.expungeStaleEntry(slotToExpunge), len);
            }
        }

        private int expungeStaleEntry(int staleSlot) {
            Entry e;
            Entry[] tab = this.table;
            int len = tab.length;
            tab[staleSlot].value = null;
            tab[staleSlot] = null;
            --this.size;
            int i = ThreadLocalMap.nextIndex(staleSlot, len);
            while ((e = tab[i]) != null) {
                ThreadLocal k = (ThreadLocal)e.get();
                if (k == null) {
                    e.value = null;
                    tab[i] = null;
                    --this.size;
                } else {
                    int h = k.threadLocalHashCode & len - 1;
                    if (h != i) {
                        tab[i] = null;
                        while (tab[h] != null) {
                            h = ThreadLocalMap.nextIndex(h, len);
                        }
                        tab[h] = e;
                    }
                }
                i = ThreadLocalMap.nextIndex(i, len);
            }
            return i;
        }

        private boolean cleanSomeSlots(int i, int n) {
            boolean removed = false;
            Entry[] tab = this.table;
            int len = tab.length;
            do {
                Entry e;
                if ((e = tab[i = ThreadLocalMap.nextIndex(i, len)]) == null || e.get() != null) continue;
                n = len;
                removed = true;
                i = this.expungeStaleEntry(i);
            } while ((n >>>= 1) != 0);
            return removed;
        }

        private void rehash() {
            this.expungeStaleEntries();
            if (this.size >= this.threshold - this.threshold / 4) {
                this.resize();
            }
        }

        private void resize() {
            Entry[] oldTab = this.table;
            int oldLen = oldTab.length;
            int newLen = oldLen * 2;
            Entry[] newTab = new Entry[newLen];
            int count = 0;
            for (int j = 0; j < oldLen; ++j) {
                Entry e = oldTab[j];
                if (e == null) continue;
                ThreadLocal k = (ThreadLocal)e.get();
                if (k == null) {
                    e.value = null;
                    continue;
                }
                int h = k.threadLocalHashCode & newLen - 1;
                while (newTab[h] != null) {
                    h = ThreadLocalMap.nextIndex(h, newLen);
                }
                newTab[h] = e;
                ++count;
            }
            this.setThreshold(newLen);
            this.size = count;
            this.table = newTab;
        }

        private void expungeStaleEntries() {
            Entry[] tab = this.table;
            int len = tab.length;
            for (int j = 0; j < len; ++j) {
                Entry e = tab[j];
                if (e == null || e.get() != null) continue;
                this.expungeStaleEntry(j);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class Entry
        extends WeakReference<ThreadLocal> {
            Object value;

            Entry(ThreadLocal k, Object v) {
                super(k);
                this.value = v;
            }
        }
    }
}

