/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.server.provider;

import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Messages;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.encoding.xml.XMLMessage;
import com.sun.xml.internal.ws.resources.ServerMessages;
import com.sun.xml.internal.ws.server.provider.ProviderArgumentsBuilder;
import com.sun.xml.internal.ws.server.provider.ProviderEndpointModel;
import javax.activation.DataSource;
import javax.xml.transform.Source;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.http.HTTPException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class XMLProviderArgumentBuilder<T>
extends ProviderArgumentsBuilder<T> {
    XMLProviderArgumentBuilder() {
    }

    @Override
    protected Packet getResponse(Packet request, Exception e, WSDLPort port, WSBinding binding) {
        Packet response = super.getResponse(request, e, port, binding);
        if (e instanceof HTTPException && response.supports("javax.xml.ws.http.response.code")) {
            response.put("javax.xml.ws.http.response.code", ((HTTPException)e).getStatusCode());
        }
        return response;
    }

    static XMLProviderArgumentBuilder create(ProviderEndpointModel model) {
        if (model.mode == Service.Mode.PAYLOAD) {
            return new PayloadSource();
        }
        if (model.datatype == Source.class) {
            return new PayloadSource();
        }
        if (model.datatype == DataSource.class) {
            return new DataSourceParameter();
        }
        throw new WebServiceException(ServerMessages.PROVIDER_INVALID_PARAMETER_TYPE(model.implClass, model.datatype));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DataSourceParameter
    extends XMLProviderArgumentBuilder<DataSource> {
        private DataSourceParameter() {
        }

        @Override
        public DataSource getParameter(Packet packet) {
            Message msg = packet.getMessage();
            return msg instanceof XMLMessage.MessageDataSource ? ((XMLMessage.MessageDataSource)((Object)msg)).getDataSource() : XMLMessage.getDataSource(msg);
        }

        @Override
        public Message getResponseMessage(DataSource ds) {
            return XMLMessage.create(ds);
        }

        @Override
        protected Message getResponseMessage(Exception e) {
            return XMLMessage.create(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PayloadSource
    extends XMLProviderArgumentBuilder<Source> {
        private PayloadSource() {
        }

        @Override
        public Source getParameter(Packet packet) {
            return packet.getMessage().readPayloadAsSource();
        }

        @Override
        public Message getResponseMessage(Source source) {
            return Messages.createUsingPayload(source, SOAPVersion.SOAP_11);
        }

        @Override
        protected Message getResponseMessage(Exception e) {
            return XMLMessage.create(e);
        }
    }
}

