/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys;

import com.sun.org.apache.xml.internal.security.encryption.EncryptedKey;
import com.sun.org.apache.xml.internal.security.encryption.XMLCipher;
import com.sun.org.apache.xml.internal.security.encryption.XMLEncryptionException;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.KeyName;
import com.sun.org.apache.xml.internal.security.keys.content.KeyValue;
import com.sun.org.apache.xml.internal.security.keys.content.MgmtData;
import com.sun.org.apache.xml.internal.security.keys.content.PGPData;
import com.sun.org.apache.xml.internal.security.keys.content.RetrievalMethod;
import com.sun.org.apache.xml.internal.security.keys.content.SPKIData;
import com.sun.org.apache.xml.internal.security.keys.content.X509Data;
import com.sun.org.apache.xml.internal.security.keys.content.keyvalues.DSAKeyValue;
import com.sun.org.apache.xml.internal.security.keys.content.keyvalues.RSAKeyValue;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolver;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.transforms.Transforms;
import com.sun.org.apache.xml.internal.security.utils.IdResolver;
import com.sun.org.apache.xml.internal.security.utils.SignatureElementProxy;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class KeyInfo
extends SignatureElementProxy {
    static Logger log = Logger.getLogger(KeyInfo.class.getName());
    List _internalKeyResolvers = new ArrayList();
    List _storageResolvers = new ArrayList();
    static boolean _alreadyInitialized = false;

    public KeyInfo(Document doc) {
        super(doc);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public KeyInfo(Element element, String BaseURI) throws XMLSecurityException {
        super(element, BaseURI);
    }

    public void setId(String Id) {
        if (this._state == 0 && Id != null) {
            this._constructionElement.setAttributeNS(null, "Id", Id);
            IdResolver.registerElementById(this._constructionElement, Id);
        }
    }

    public String getId() {
        return this._constructionElement.getAttributeNS(null, "Id");
    }

    public void addKeyName(String keynameString) {
        this.add(new KeyName(this._doc, keynameString));
    }

    public void add(KeyName keyname) {
        if (this._state == 0) {
            this._constructionElement.appendChild(keyname.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void addKeyValue(PublicKey pk) {
        this.add(new KeyValue(this._doc, pk));
    }

    public void addKeyValue(Element unknownKeyValueElement) {
        this.add(new KeyValue(this._doc, unknownKeyValueElement));
    }

    public void add(DSAKeyValue dsakeyvalue) {
        this.add(new KeyValue(this._doc, dsakeyvalue));
    }

    public void add(RSAKeyValue rsakeyvalue) {
        this.add(new KeyValue(this._doc, rsakeyvalue));
    }

    public void add(PublicKey pk) {
        this.add(new KeyValue(this._doc, pk));
    }

    public void add(KeyValue keyvalue) {
        if (this._state == 0) {
            this._constructionElement.appendChild(keyvalue.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void addMgmtData(String mgmtdata) {
        this.add(new MgmtData(this._doc, mgmtdata));
    }

    public void add(MgmtData mgmtdata) {
        if (this._state == 0) {
            this._constructionElement.appendChild(mgmtdata.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void add(PGPData pgpdata) {
        if (this._state == 0) {
            this._constructionElement.appendChild(pgpdata.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void addRetrievalMethod(String URI2, Transforms transforms, String Type2) {
        this.add(new RetrievalMethod(this._doc, URI2, transforms, Type2));
    }

    public void add(RetrievalMethod retrievalmethod) {
        if (this._state == 0) {
            this._constructionElement.appendChild(retrievalmethod.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void add(SPKIData spkidata) {
        if (this._state == 0) {
            this._constructionElement.appendChild(spkidata.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void add(X509Data x509data) {
        if (this._state == 0) {
            this._constructionElement.appendChild(x509data.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void add(EncryptedKey encryptedKey) throws XMLEncryptionException {
        if (this._state == 0) {
            XMLCipher cipher = XMLCipher.getInstance();
            this._constructionElement.appendChild(cipher.martial(encryptedKey));
        }
    }

    public void addUnknownElement(Element element) {
        if (this._state == 0) {
            this._constructionElement.appendChild(element);
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public int lengthKeyName() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "KeyName");
    }

    public int lengthKeyValue() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "KeyValue");
    }

    public int lengthMgmtData() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "MgmtData");
    }

    public int lengthPGPData() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "PGPData");
    }

    public int lengthRetrievalMethod() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "RetrievalMethod");
    }

    public int lengthSPKIData() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "SPKIData");
    }

    public int lengthX509Data() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "X509Data");
    }

    public int lengthUnknownElement() {
        int res = 0;
        NodeList nl = this._constructionElement.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node current = nl.item(i);
            if (current.getNodeType() != 1 || !current.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#")) continue;
            ++res;
        }
        return res;
    }

    public KeyName itemKeyName(int i) throws XMLSecurityException {
        Element e = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "KeyName", i);
        if (e != null) {
            return new KeyName(e, this._baseURI);
        }
        return null;
    }

    public KeyValue itemKeyValue(int i) throws XMLSecurityException {
        Element e = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "KeyValue", i);
        if (e != null) {
            return new KeyValue(e, this._baseURI);
        }
        return null;
    }

    public MgmtData itemMgmtData(int i) throws XMLSecurityException {
        Element e = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "MgmtData", i);
        if (e != null) {
            return new MgmtData(e, this._baseURI);
        }
        return null;
    }

    public PGPData itemPGPData(int i) throws XMLSecurityException {
        Element e = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "PGPData", i);
        if (e != null) {
            return new PGPData(e, this._baseURI);
        }
        return null;
    }

    public RetrievalMethod itemRetrievalMethod(int i) throws XMLSecurityException {
        Element e = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "RetrievalMethod", i);
        if (e != null) {
            return new RetrievalMethod(e, this._baseURI);
        }
        return null;
    }

    public SPKIData itemSPKIData(int i) throws XMLSecurityException {
        Element e = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "SPKIData", i);
        if (e != null) {
            return new SPKIData(e, this._baseURI);
        }
        return null;
    }

    public X509Data itemX509Data(int i) throws XMLSecurityException {
        Element e = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "X509Data", i);
        if (e != null) {
            return new X509Data(e, this._baseURI);
        }
        return null;
    }

    public EncryptedKey itemEncryptedKey(int i) throws XMLSecurityException {
        Element e = XMLUtils.selectXencNode(this._constructionElement.getFirstChild(), "EncryptedKey", i);
        if (e != null) {
            XMLCipher cipher = XMLCipher.getInstance();
            cipher.init(4, null);
            return cipher.loadEncryptedKey(e);
        }
        return null;
    }

    public Element itemUnknownElement(int i) {
        NodeList nl = this._constructionElement.getChildNodes();
        int res = 0;
        for (int j = 0; j < nl.getLength(); ++j) {
            Node current = nl.item(j);
            if (current.getNodeType() != 1 || !current.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#") || ++res != i) continue;
            return (Element)current;
        }
        return null;
    }

    public boolean isEmpty() {
        return this._constructionElement.getFirstChild() == null;
    }

    public boolean containsKeyName() {
        return this.lengthKeyName() > 0;
    }

    public boolean containsKeyValue() {
        return this.lengthKeyValue() > 0;
    }

    public boolean containsMgmtData() {
        return this.lengthMgmtData() > 0;
    }

    public boolean containsPGPData() {
        return this.lengthPGPData() > 0;
    }

    public boolean containsRetrievalMethod() {
        return this.lengthRetrievalMethod() > 0;
    }

    public boolean containsSPKIData() {
        return this.lengthSPKIData() > 0;
    }

    public boolean containsUnknownElement() {
        return this.lengthUnknownElement() > 0;
    }

    public boolean containsX509Data() {
        return this.lengthX509Data() > 0;
    }

    public PublicKey getPublicKey() throws KeyResolverException {
        PublicKey pk = this.getPublicKeyFromInternalResolvers();
        if (pk != null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "I could find a key using the per-KeyInfo key resolvers");
            }
            return pk;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "I couldn't find a key using the per-KeyInfo key resolvers");
        }
        if ((pk = this.getPublicKeyFromStaticResolvers()) != null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "I could find a key using the system-wide key resolvers");
            }
            return pk;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "I couldn't find a key using the system-wide key resolvers");
        }
        return null;
    }

    PublicKey getPublicKeyFromStaticResolvers() throws KeyResolverException {
        for (int i = 0; i < KeyResolver.length(); ++i) {
            KeyResolver keyResolver = KeyResolver.item(i);
            for (Node currentChild = this._constructionElement.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
                if (currentChild.getNodeType() != 1) continue;
                if (this._storageResolvers.size() == 0) {
                    PublicKey pk;
                    StorageResolver storage = null;
                    if (!keyResolver.canResolve((Element)currentChild, this.getBaseURI(), storage) || (pk = keyResolver.resolvePublicKey((Element)currentChild, this.getBaseURI(), storage)) == null) continue;
                    return pk;
                }
                for (int k = 0; k < this._storageResolvers.size(); ++k) {
                    PublicKey pk;
                    StorageResolver storage = (StorageResolver)this._storageResolvers.get(k);
                    if (!keyResolver.canResolve((Element)currentChild, this.getBaseURI(), storage) || (pk = keyResolver.resolvePublicKey((Element)currentChild, this.getBaseURI(), storage)) == null) continue;
                    return pk;
                }
            }
        }
        return null;
    }

    PublicKey getPublicKeyFromInternalResolvers() throws KeyResolverException {
        for (int i = 0; i < this.lengthInternalKeyResolver(); ++i) {
            KeyResolverSpi keyResolver = this.itemInternalKeyResolver(i);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Try " + keyResolver.getClass().getName());
            }
            for (Node currentChild = this._constructionElement.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
                if (currentChild.getNodeType() != 1) continue;
                if (this._storageResolvers.size() == 0) {
                    PublicKey pk;
                    StorageResolver storage = null;
                    if (!keyResolver.engineCanResolve((Element)currentChild, this.getBaseURI(), storage) || (pk = keyResolver.engineResolvePublicKey((Element)currentChild, this.getBaseURI(), storage)) == null) continue;
                    return pk;
                }
                for (int k = 0; k < this._storageResolvers.size(); ++k) {
                    PublicKey pk;
                    StorageResolver storage = (StorageResolver)this._storageResolvers.get(k);
                    if (!keyResolver.engineCanResolve((Element)currentChild, this.getBaseURI(), storage) || (pk = keyResolver.engineResolvePublicKey((Element)currentChild, this.getBaseURI(), storage)) == null) continue;
                    return pk;
                }
            }
        }
        return null;
    }

    public X509Certificate getX509Certificate() throws KeyResolverException {
        X509Certificate cert = this.getX509CertificateFromInternalResolvers();
        if (cert != null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "I could find a X509Certificate using the per-KeyInfo key resolvers");
            }
            return cert;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "I couldn't find a X509Certificate using the per-KeyInfo key resolvers");
        }
        if ((cert = this.getX509CertificateFromStaticResolvers()) != null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "I could find a X509Certificate using the system-wide key resolvers");
            }
            return cert;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "I couldn't find a X509Certificate using the system-wide key resolvers");
        }
        return null;
    }

    X509Certificate getX509CertificateFromStaticResolvers() throws KeyResolverException {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Start getX509CertificateFromStaticResolvers() with " + KeyResolver.length() + " resolvers");
        }
        for (int i = 0; i < KeyResolver.length(); ++i) {
            KeyResolver keyResolver = KeyResolver.item(i);
            for (Node currentChild = this._constructionElement.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
                if (currentChild.getNodeType() != 1) continue;
                if (this._storageResolvers.size() == 0) {
                    X509Certificate cert;
                    StorageResolver storage = null;
                    if (!keyResolver.canResolve((Element)currentChild, this.getBaseURI(), storage) || (cert = keyResolver.resolveX509Certificate((Element)currentChild, this.getBaseURI(), storage)) == null) continue;
                    return cert;
                }
                for (int k = 0; k < this._storageResolvers.size(); ++k) {
                    X509Certificate cert;
                    StorageResolver storage = (StorageResolver)this._storageResolvers.get(k);
                    if (!keyResolver.canResolve((Element)currentChild, this.getBaseURI(), storage) || (cert = keyResolver.resolveX509Certificate((Element)currentChild, this.getBaseURI(), storage)) == null) continue;
                    return cert;
                }
            }
        }
        return null;
    }

    X509Certificate getX509CertificateFromInternalResolvers() throws KeyResolverException {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Start getX509CertificateFromInternalResolvers() with " + this.lengthInternalKeyResolver() + " resolvers");
        }
        for (int i = 0; i < this.lengthInternalKeyResolver(); ++i) {
            KeyResolverSpi keyResolver = this.itemInternalKeyResolver(i);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Try " + keyResolver.getClass().getName());
            }
            for (Node currentChild = this._constructionElement.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
                if (currentChild.getNodeType() != 1) continue;
                if (this._storageResolvers.size() == 0) {
                    X509Certificate cert;
                    StorageResolver storage = null;
                    if (!keyResolver.engineCanResolve((Element)currentChild, this.getBaseURI(), storage) || (cert = keyResolver.engineResolveX509Certificate((Element)currentChild, this.getBaseURI(), storage)) == null) continue;
                    return cert;
                }
                for (int k = 0; k < this._storageResolvers.size(); ++k) {
                    X509Certificate cert;
                    StorageResolver storage = (StorageResolver)this._storageResolvers.get(k);
                    if (!keyResolver.engineCanResolve((Element)currentChild, this.getBaseURI(), storage) || (cert = keyResolver.engineResolveX509Certificate((Element)currentChild, this.getBaseURI(), storage)) == null) continue;
                    return cert;
                }
            }
        }
        return null;
    }

    public SecretKey getSecretKey() throws KeyResolverException {
        SecretKey sk = this.getSecretKeyFromInternalResolvers();
        if (sk != null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "I could find a secret key using the per-KeyInfo key resolvers");
            }
            return sk;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "I couldn't find a secret key using the per-KeyInfo key resolvers");
        }
        if ((sk = this.getSecretKeyFromStaticResolvers()) != null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "I could find a secret key using the system-wide key resolvers");
            }
            return sk;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "I couldn't find a secret key using the system-wide key resolvers");
        }
        return null;
    }

    SecretKey getSecretKeyFromStaticResolvers() throws KeyResolverException {
        for (int i = 0; i < KeyResolver.length(); ++i) {
            KeyResolver keyResolver = KeyResolver.item(i);
            for (Node currentChild = this._constructionElement.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
                if (currentChild.getNodeType() != 1) continue;
                if (this._storageResolvers.size() == 0) {
                    SecretKey sk;
                    StorageResolver storage = null;
                    if (!keyResolver.canResolve((Element)currentChild, this.getBaseURI(), storage) || (sk = keyResolver.resolveSecretKey((Element)currentChild, this.getBaseURI(), storage)) == null) continue;
                    return sk;
                }
                for (int k = 0; k < this._storageResolvers.size(); ++k) {
                    SecretKey sk;
                    StorageResolver storage = (StorageResolver)this._storageResolvers.get(k);
                    if (!keyResolver.canResolve((Element)currentChild, this.getBaseURI(), storage) || (sk = keyResolver.resolveSecretKey((Element)currentChild, this.getBaseURI(), storage)) == null) continue;
                    return sk;
                }
            }
        }
        return null;
    }

    SecretKey getSecretKeyFromInternalResolvers() throws KeyResolverException {
        for (int i = 0; i < this.lengthInternalKeyResolver(); ++i) {
            KeyResolverSpi keyResolver = this.itemInternalKeyResolver(i);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Try " + keyResolver.getClass().getName());
            }
            for (Node currentChild = this._constructionElement.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
                if (currentChild.getNodeType() != 1) continue;
                if (this._storageResolvers.size() == 0) {
                    SecretKey sk;
                    StorageResolver storage = null;
                    if (!keyResolver.engineCanResolve((Element)currentChild, this.getBaseURI(), storage) || (sk = keyResolver.engineResolveSecretKey((Element)currentChild, this.getBaseURI(), storage)) == null) continue;
                    return sk;
                }
                for (int k = 0; k < this._storageResolvers.size(); ++k) {
                    SecretKey sk;
                    StorageResolver storage = (StorageResolver)this._storageResolvers.get(k);
                    if (!keyResolver.engineCanResolve((Element)currentChild, this.getBaseURI(), storage) || (sk = keyResolver.engineResolveSecretKey((Element)currentChild, this.getBaseURI(), storage)) == null) continue;
                    return sk;
                }
            }
        }
        return null;
    }

    public void registerInternalKeyResolver(KeyResolverSpi realKeyResolver) {
        this._internalKeyResolvers.add(realKeyResolver);
    }

    int lengthInternalKeyResolver() {
        return this._internalKeyResolvers.size();
    }

    KeyResolverSpi itemInternalKeyResolver(int i) {
        return (KeyResolverSpi)this._internalKeyResolvers.get(i);
    }

    public void addStorageResolver(StorageResolver storageResolver) {
        if (storageResolver != null) {
            this._storageResolvers.add(storageResolver);
        }
    }

    List getStorageResolvers() {
        return this._storageResolvers;
    }

    public static void init() {
        if (!_alreadyInitialized) {
            if (log == null) {
                log = Logger.getLogger(KeyInfo.class.getName());
                log.log(Level.SEVERE, "Had to assign log in the init() function");
            }
            _alreadyInitialized = true;
        }
    }

    public String getBaseLocalName() {
        return "KeyInfo";
    }
}

