/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import com.sun.jndi.dns.BindingEnumeration;
import com.sun.jndi.dns.CT;
import com.sun.jndi.dns.DnsName;
import com.sun.jndi.dns.DnsNameParser;
import com.sun.jndi.dns.NameClassPairEnumeration;
import com.sun.jndi.dns.NameNode;
import com.sun.jndi.dns.Resolver;
import com.sun.jndi.dns.ResourceRecord;
import com.sun.jndi.dns.ResourceRecords;
import com.sun.jndi.dns.ZoneNode;
import com.sun.jndi.toolkit.ctx.ComponentDirContext;
import com.sun.jndi.toolkit.ctx.Continuation;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidAttributeIdentifierException;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.spi.DirectoryManager;

public class DnsContext
extends ComponentDirContext {
    DnsName domain;
    Hashtable environment;
    private boolean envShared;
    private boolean parentIsDns;
    private String[] servers;
    private Resolver resolver;
    private boolean authoritative;
    private boolean recursion;
    private int timeout;
    private int retries;
    static final NameParser nameParser = new DnsNameParser();
    private static final int DEFAULT_INIT_TIMEOUT = 1000;
    private static final int DEFAULT_RETRIES = 4;
    private static final String INIT_TIMEOUT = "com.sun.jndi.dns.timeout.initial";
    private static final String RETRIES = "com.sun.jndi.dns.timeout.retries";
    private CT lookupCT;
    private static final String LOOKUP_ATTR = "com.sun.jndi.dns.lookup.attr";
    private static final String RECURSION = "com.sun.jndi.dns.recursion";
    private static final int ANY = 255;
    private static final ZoneNode zoneTree = new ZoneNode(null);
    public static boolean debug = false;

    public DnsContext(String domain, String[] servers, Hashtable environment) throws NamingException {
        this.domain = new DnsName(domain.endsWith(".") ? domain : domain + ".");
        this.servers = servers;
        this.environment = (Hashtable)environment.clone();
        this.envShared = false;
        this.parentIsDns = false;
        this.resolver = null;
        this.initFromEnvironment();
    }

    DnsContext(DnsContext ctx, DnsName domain) {
        this(ctx);
        this.domain = domain;
        this.parentIsDns = true;
    }

    private DnsContext(DnsContext ctx) {
        this.environment = ctx.environment;
        ctx.envShared = true;
        this.envShared = true;
        this.parentIsDns = ctx.parentIsDns;
        this.domain = ctx.domain;
        this.servers = ctx.servers;
        this.resolver = ctx.resolver;
        this.authoritative = ctx.authoritative;
        this.recursion = ctx.recursion;
        this.timeout = ctx.timeout;
        this.retries = ctx.retries;
        this.lookupCT = ctx.lookupCT;
    }

    public void close() {
        if (this.resolver != null) {
            this.resolver.close();
            this.resolver = null;
        }
    }

    protected Hashtable p_getEnvironment() {
        return this.environment;
    }

    public Hashtable getEnvironment() throws NamingException {
        return (Hashtable)this.environment.clone();
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        int val;
        if (propName.equals(LOOKUP_ATTR)) {
            this.lookupCT = this.getLookupCT((String)propVal);
        } else if (propName.equals("java.naming.authoritative")) {
            this.authoritative = "true".equalsIgnoreCase((String)propVal);
        } else if (propName.equals(RECURSION)) {
            this.recursion = "true".equalsIgnoreCase((String)propVal);
        } else if (propName.equals(INIT_TIMEOUT)) {
            int val2 = Integer.parseInt((String)propVal);
            if (this.timeout != val2) {
                this.timeout = val2;
                this.resolver = null;
            }
        } else if (propName.equals(RETRIES) && this.retries != (val = Integer.parseInt((String)propVal))) {
            this.retries = val;
            this.resolver = null;
        }
        if (!this.envShared) {
            return this.environment.put(propName, propVal);
        }
        if (this.environment.get(propName) != propVal) {
            this.environment = (Hashtable)this.environment.clone();
            this.envShared = false;
            return this.environment.put(propName, propVal);
        }
        return propVal;
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        if (propName.equals(LOOKUP_ATTR)) {
            this.lookupCT = this.getLookupCT(null);
        } else if (propName.equals("java.naming.authoritative")) {
            this.authoritative = false;
        } else if (propName.equals(RECURSION)) {
            this.recursion = true;
        } else if (propName.equals(INIT_TIMEOUT)) {
            if (this.timeout != 1000) {
                this.timeout = 1000;
                this.resolver = null;
            }
        } else if (propName.equals(RETRIES) && this.retries != 4) {
            this.retries = 4;
            this.resolver = null;
        }
        if (!this.envShared) {
            return this.environment.remove(propName);
        }
        if (this.environment.get(propName) != null) {
            this.environment = (Hashtable)this.environment.clone();
            this.envShared = false;
            return this.environment.remove(propName);
        }
        return null;
    }

    void setProviderUrl(String url) {
        this.environment.put("java.naming.provider.url", url);
    }

    private void initFromEnvironment() throws InvalidAttributeIdentifierException {
        this.lookupCT = this.getLookupCT((String)this.environment.get(LOOKUP_ATTR));
        this.authoritative = "true".equalsIgnoreCase((String)this.environment.get("java.naming.authoritative"));
        String val = (String)this.environment.get(RECURSION);
        this.recursion = val == null || "true".equalsIgnoreCase(val);
        val = (String)this.environment.get(INIT_TIMEOUT);
        this.timeout = val == null ? 1000 : Integer.parseInt(val);
        val = (String)this.environment.get(RETRIES);
        this.retries = val == null ? 4 : Integer.parseInt(val);
    }

    private CT getLookupCT(String attrId) throws InvalidAttributeIdentifierException {
        return attrId == null ? new CT(1, 16) : DnsContext.fromAttrId(attrId);
    }

    public Object c_lookup(Name name, Continuation cont) throws NamingException {
        cont.setSuccess();
        if (name.isEmpty()) {
            DnsContext ctx = new DnsContext(this);
            ctx.resolver = new Resolver(this.servers, this.timeout, this.retries);
            return ctx;
        }
        try {
            DnsName fqdn = this.fullyQualify(name);
            ResourceRecords rrs = this.getResolver().query(fqdn, this.lookupCT.rrclass, this.lookupCT.rrtype, this.recursion, this.authoritative);
            Attributes attrs = DnsContext.rrsToAttrs(rrs, null);
            DnsContext ctx = new DnsContext(this, fqdn);
            return DirectoryManager.getObjectInstance(ctx, name, this, this.environment, attrs);
        }
        catch (NamingException e) {
            cont.setError((Object)this, name);
            throw cont.fillInException(e);
        }
        catch (Exception e) {
            cont.setError((Object)this, name);
            NamingException ne = new NamingException("Problem generating object using object factory");
            ne.setRootCause(e);
            throw cont.fillInException(ne);
        }
    }

    public Object c_lookupLink(Name name, Continuation cont) throws NamingException {
        return this.c_lookup(name, cont);
    }

    public NamingEnumeration c_list(Name name, Continuation cont) throws NamingException {
        cont.setSuccess();
        try {
            DnsName fqdn = this.fullyQualify(name);
            NameNode nnode = this.getNameNode(fqdn);
            DnsContext ctx = new DnsContext(this, fqdn);
            return new NameClassPairEnumeration(ctx, nnode.getChildren());
        }
        catch (NamingException e) {
            cont.setError((Object)this, name);
            throw cont.fillInException(e);
        }
    }

    public NamingEnumeration c_listBindings(Name name, Continuation cont) throws NamingException {
        cont.setSuccess();
        try {
            DnsName fqdn = this.fullyQualify(name);
            NameNode nnode = this.getNameNode(fqdn);
            DnsContext ctx = new DnsContext(this, fqdn);
            return new BindingEnumeration(ctx, nnode.getChildren());
        }
        catch (NamingException e) {
            cont.setError((Object)this, name);
            throw cont.fillInException(e);
        }
    }

    public void c_bind(Name name, Object obj, Continuation cont) throws NamingException {
        cont.setError((Object)this, name);
        throw cont.fillInException(new OperationNotSupportedException());
    }

    public void c_rebind(Name name, Object obj, Continuation cont) throws NamingException {
        cont.setError((Object)this, name);
        throw cont.fillInException(new OperationNotSupportedException());
    }

    public void c_unbind(Name name, Continuation cont) throws NamingException {
        cont.setError((Object)this, name);
        throw cont.fillInException(new OperationNotSupportedException());
    }

    public void c_rename(Name oldname, Name newname, Continuation cont) throws NamingException {
        cont.setError((Object)this, oldname);
        throw cont.fillInException(new OperationNotSupportedException());
    }

    public Context c_createSubcontext(Name name, Continuation cont) throws NamingException {
        cont.setError((Object)this, name);
        throw cont.fillInException(new OperationNotSupportedException());
    }

    public void c_destroySubcontext(Name name, Continuation cont) throws NamingException {
        cont.setError((Object)this, name);
        throw cont.fillInException(new OperationNotSupportedException());
    }

    public NameParser c_getNameParser(Name name, Continuation cont) throws NamingException {
        cont.setSuccess();
        return nameParser;
    }

    public void c_bind(Name name, Object obj, Attributes attrs, Continuation cont) throws NamingException {
        cont.setError((Object)this, name);
        throw cont.fillInException(new OperationNotSupportedException());
    }

    public void c_rebind(Name name, Object obj, Attributes attrs, Continuation cont) throws NamingException {
        cont.setError((Object)this, name);
        throw cont.fillInException(new OperationNotSupportedException());
    }

    public DirContext c_createSubcontext(Name name, Attributes attrs, Continuation cont) throws NamingException {
        cont.setError((Object)this, name);
        throw cont.fillInException(new OperationNotSupportedException());
    }

    public Attributes c_getAttributes(Name name, String[] attrIds, Continuation cont) throws NamingException {
        cont.setSuccess();
        try {
            DnsName fqdn = this.fullyQualify(name);
            CT[] cts = DnsContext.attrIdsToClassesAndTypes(attrIds);
            CT ct = DnsContext.getClassAndTypeToQuery(cts);
            ResourceRecords rrs = this.getResolver().query(fqdn, ct.rrclass, ct.rrtype, this.recursion, this.authoritative);
            return DnsContext.rrsToAttrs(rrs, cts);
        }
        catch (NamingException e) {
            cont.setError((Object)this, name);
            throw cont.fillInException(e);
        }
    }

    public void c_modifyAttributes(Name name, int mod_op, Attributes attrs, Continuation cont) throws NamingException {
        cont.setError((Object)this, name);
        throw cont.fillInException(new OperationNotSupportedException());
    }

    public void c_modifyAttributes(Name name, ModificationItem[] mods, Continuation cont) throws NamingException {
        cont.setError((Object)this, name);
        throw cont.fillInException(new OperationNotSupportedException());
    }

    public NamingEnumeration c_search(Name name, Attributes matchingAttributes, String[] attributesToReturn, Continuation cont) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration c_search(Name name, String filter, SearchControls cons, Continuation cont) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration c_search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons, Continuation cont) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext c_getSchema(Name name, Continuation cont) throws NamingException {
        cont.setError((Object)this, name);
        throw cont.fillInException(new OperationNotSupportedException());
    }

    public DirContext c_getSchemaClassDefinition(Name name, Continuation cont) throws NamingException {
        cont.setError((Object)this, name);
        throw cont.fillInException(new OperationNotSupportedException());
    }

    public String getNameInNamespace() {
        return this.domain.toString();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        if (!(prefix instanceof DnsName) && !(prefix instanceof CompositeName)) {
            prefix = new DnsName().addAll(prefix);
        }
        if (!(name instanceof DnsName) && !(name instanceof CompositeName)) {
            name = new DnsName().addAll(name);
        }
        if (prefix instanceof DnsName && name instanceof DnsName) {
            DnsName result = (DnsName)prefix.clone();
            result.addAll(name);
            return new CompositeName().add(((Object)result).toString());
        }
        Name prefixC = prefix instanceof CompositeName ? prefix : new CompositeName().add(prefix.toString());
        Name nameC = name instanceof CompositeName ? name : new CompositeName().add(name.toString());
        int prefixLast = prefixC.size() - 1;
        if (nameC.isEmpty() || nameC.get(0).equals("") || prefixC.isEmpty() || prefixC.get(prefixLast).equals("")) {
            return super.composeName(nameC, prefixC);
        }
        Name result = prefix == prefixC ? (CompositeName)prefixC.clone() : prefixC;
        result.addAll(nameC);
        if (this.parentIsDns) {
            DnsName dnsComp = prefix instanceof DnsName ? (DnsName)prefix.clone() : new DnsName(prefixC.get(prefixLast));
            dnsComp.addAll(name instanceof DnsName ? name : new DnsName(nameC.get(0)));
            result.remove(prefixLast + 1);
            result.remove(prefixLast);
            result.add(prefixLast, dnsComp.toString());
        }
        return result;
    }

    private synchronized Resolver getResolver() throws NamingException {
        if (this.resolver == null) {
            this.resolver = new Resolver(this.servers, this.timeout, this.retries);
        }
        return this.resolver;
    }

    DnsName fullyQualify(Name name) throws NamingException {
        DnsName dnsName;
        if (name.isEmpty()) {
            return this.domain;
        }
        DnsName dnsName2 = dnsName = name instanceof CompositeName ? new DnsName(name.get(0)) : (DnsName)new DnsName().addAll(name);
        if (dnsName.hasRootLabel()) {
            if (this.domain.size() == 1) {
                return dnsName;
            }
            throw new InvalidNameException("DNS name " + dnsName + " not relative to " + this.domain);
        }
        return (DnsName)dnsName.addAll(0, this.domain);
    }

    private static Attributes rrsToAttrs(ResourceRecords rrs, CT[] cts) {
        BasicAttributes attrs = new BasicAttributes(true);
        for (int i = 0; i < rrs.answer.size(); ++i) {
            ResourceRecord rr = (ResourceRecord)rrs.answer.elementAt(i);
            int rrtype = rr.getType();
            int rrclass = rr.getRrclass();
            if (!DnsContext.classAndTypeMatch(rrclass, rrtype, cts)) continue;
            String attrId = DnsContext.toAttrId(rrclass, rrtype);
            Attribute attr = attrs.get(attrId);
            if (attr == null) {
                attr = new BasicAttribute(attrId);
                attrs.put(attr);
            }
            attr.add(rr.getRdata());
        }
        return attrs;
    }

    private static boolean classAndTypeMatch(int rrclass, int rrtype, CT[] cts) {
        if (cts == null) {
            return true;
        }
        for (int i = 0; i < cts.length; ++i) {
            boolean typeMatch;
            CT ct = cts[i];
            boolean classMatch = ct.rrclass == 255 || ct.rrclass == rrclass;
            boolean bl = typeMatch = ct.rrtype == 255 || ct.rrtype == rrtype;
            if (!classMatch || !typeMatch) continue;
            return true;
        }
        return false;
    }

    private static String toAttrId(int rrclass, int rrtype) {
        String attrId = ResourceRecord.getTypeName(rrtype);
        if (rrclass != 1) {
            attrId = ResourceRecord.getRrclassName(rrclass) + " " + attrId;
        }
        return attrId;
    }

    private static CT fromAttrId(String attrId) throws InvalidAttributeIdentifierException {
        int rrclass;
        if (attrId.equals("")) {
            throw new InvalidAttributeIdentifierException("Attribute ID cannot be empty");
        }
        int space = attrId.indexOf(32);
        if (space < 0) {
            rrclass = 1;
        } else {
            String className = attrId.substring(0, space);
            rrclass = ResourceRecord.getRrclass(className);
            if (rrclass < 0) {
                throw new InvalidAttributeIdentifierException("Unknown resource record class '" + className + '\'');
            }
        }
        String typeName = attrId.substring(space + 1);
        int rrtype = ResourceRecord.getType(typeName);
        if (rrtype < 0) {
            throw new InvalidAttributeIdentifierException("Unknown resource record type '" + typeName + '\'');
        }
        return new CT(rrclass, rrtype);
    }

    private static CT[] attrIdsToClassesAndTypes(String[] attrIds) throws InvalidAttributeIdentifierException {
        if (attrIds == null) {
            return null;
        }
        CT[] cts = new CT[attrIds.length];
        for (int i = 0; i < attrIds.length; ++i) {
            cts[i] = DnsContext.fromAttrId(attrIds[i]);
        }
        return cts;
    }

    private static CT getClassAndTypeToQuery(CT[] cts) {
        int rrtype;
        int rrclass;
        if (cts == null) {
            rrclass = 255;
            rrtype = 255;
        } else if (cts.length == 0) {
            rrclass = 1;
            rrtype = 255;
        } else {
            rrclass = cts[0].rrclass;
            rrtype = cts[0].rrtype;
            for (int i = 1; i < cts.length; ++i) {
                if (rrclass != cts[i].rrclass) {
                    rrclass = 255;
                }
                if (rrtype == cts[i].rrtype) continue;
                rrtype = 255;
            }
        }
        return new CT(rrclass, rrtype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NameNode getNameNode(DnsName fqdn) throws NamingException {
        DnsName zone;
        NameNode nnode;
        NameNode topOfZone;
        ZoneNode zoneNode;
        ZoneNode znode;
        DnsContext.dprint("getNameNode(" + fqdn + ")");
        ZoneNode zoneNode2 = zoneTree;
        synchronized (zoneNode2) {
            znode = zoneTree.getDeepestPopulated(fqdn);
        }
        DnsContext.dprint("Deepest related zone in zone tree: " + (znode != null ? znode.getLabel() : "[none]"));
        if (znode != null) {
            zoneNode = znode;
            synchronized (zoneNode) {
                topOfZone = znode.getContents();
            }
            if (topOfZone != null && (nnode = topOfZone.get(fqdn, znode.depth() + 1)) != null && !nnode.isZoneCut()) {
                DnsContext.dprint("Found node " + fqdn + " in zone tree");
                zone = (DnsName)fqdn.getPrefix(znode.depth() + 1);
                boolean current = this.isZoneCurrent(znode, zone);
                boolean restart = false;
                ZoneNode zoneNode3 = znode;
                synchronized (zoneNode3) {
                    if (topOfZone != znode.getContents()) {
                        restart = true;
                    } else if (!current) {
                        znode.depopulate();
                    } else {
                        return nnode;
                    }
                }
                DnsContext.dprint("Zone not current; discarding node");
                if (restart) {
                    return this.getNameNode(fqdn);
                }
            }
        }
        DnsContext.dprint("Adding node " + fqdn + " to zone tree");
        zone = this.getResolver().findZoneName(fqdn, 1, this.recursion);
        DnsContext.dprint("Node's zone is " + zone);
        zoneNode = zoneTree;
        synchronized (zoneNode) {
            znode = (ZoneNode)zoneTree.add(zone, 1);
        }
        zoneNode = znode;
        synchronized (zoneNode) {
            topOfZone = znode.isPopulated() ? znode.getContents() : this.populateZone(znode, zone);
        }
        nnode = topOfZone.get(fqdn, zone.size());
        if (nnode == null) {
            throw new ConfigurationException("DNS error: node not found in its own zone");
        }
        DnsContext.dprint("Found node in newly-populated zone");
        return nnode;
    }

    private NameNode populateZone(ZoneNode znode, DnsName zone) throws NamingException {
        DnsContext.dprint("Populating zone " + zone);
        ResourceRecords rrs = this.getResolver().queryZone(zone, 1, this.recursion);
        DnsContext.dprint("zone xfer complete: " + rrs.answer.size() + " records");
        return znode.populate(zone, rrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isZoneCurrent(ZoneNode znode, DnsName zone) throws NamingException {
        if (!znode.isPopulated()) {
            return false;
        }
        ResourceRecord soa = this.getResolver().findSoa(zone, 1, this.recursion);
        ZoneNode zoneNode = znode;
        synchronized (zoneNode) {
            if (soa == null) {
                znode.depopulate();
            }
            return znode.isPopulated() && znode.compareSerialNumberTo(soa) >= 0;
        }
    }

    private static final void dprint(String msg) {
        if (debug) {
            System.err.println("** " + msg);
        }
    }
}

