/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.Attribute;
import com.sun.java.util.jar.pack.BandStructure;
import com.sun.java.util.jar.pack.Code;
import com.sun.java.util.jar.pack.ConstantPool;
import com.sun.java.util.jar.pack.Constants;
import com.sun.java.util.jar.pack.Fixups;
import com.sun.java.util.jar.pack.PropMap;
import com.sun.java.util.jar.pack.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

class Package
implements Constants {
    int verbose;
    int magic;
    int package_minver;
    int package_majver;
    int default_modtime;
    int default_options;
    short default_class_majver;
    short default_class_minver;
    short min_class_majver;
    short min_class_minver;
    short max_class_majver;
    short max_class_minver;
    short observed_max_class_majver;
    short observed_max_class_minver;
    ConstantPool.IndexGroup cp;
    public static final Attribute.Layout attrCodeEmpty;
    public static final Attribute.Layout attrInnerClassesEmpty;
    public static final Attribute.Layout attrSourceFileSpecial;
    public static final Map attrDefs;
    ArrayList classes;
    ArrayList files;
    ArrayList allInnerClasses;
    HashMap allInnerClassesByThis;
    private static final int SLASH_MIN = 46;
    private static final int SLASH_MAX = 47;
    private static final int DOLLAR_MIN = 0;
    private static final int DOLLAR_MAX = 45;
    static final List noObjects;
    static final List noFields;
    static final List noMethods;
    static final List noInnerClasses;

    Package() {
        PropMap pmap = Utils.currentPropMap();
        if (pmap != null) {
            this.verbose = pmap.getInteger("com.sun.java.util.jar.pack.verbose");
        }
        this.default_modtime = 0;
        this.default_options = 0;
        this.default_class_majver = (short)-1;
        this.default_class_minver = 0;
        this.min_class_majver = (short)45;
        this.min_class_minver = (short)3;
        this.max_class_majver = (short)50;
        this.max_class_minver = 0;
        this.observed_max_class_majver = this.min_class_majver;
        this.observed_max_class_minver = this.min_class_minver;
        this.cp = new ConstantPool.IndexGroup();
        this.classes = new ArrayList();
        this.files = new ArrayList();
        this.allInnerClasses = new ArrayList();
        this.magic = -889270259;
        this.package_minver = -1;
        this.package_majver = 0;
    }

    public void reset() {
        this.cp = new ConstantPool.IndexGroup();
        this.classes.clear();
        this.files.clear();
    }

    int getPackageVersion() {
        return (this.package_majver << 16) + this.package_minver;
    }

    int getDefaultClassVersion() {
        return (this.default_class_majver << 16) + (char)this.default_class_minver;
    }

    int getHighestClassVersion() {
        int res = 0;
        for (Class cls : this.classes) {
            int ver = cls.getVersion();
            if (res >= ver) continue;
            res = ver;
        }
        return res;
    }

    void choosePackageVersion() {
        assert (this.package_majver <= 0);
        int classver = this.getHighestClassVersion();
        if (classver != 0 && classver >>> 16 < 50) {
            this.package_majver = 150;
            this.package_minver = 7;
        } else {
            this.package_majver = 160;
            this.package_minver = 1;
        }
    }

    void checkVersion() throws IOException {
        if (this.magic != -889270259) {
            String gotMag = Integer.toHexString(this.magic);
            String expMag = Integer.toHexString(-889270259);
            throw new IOException("Unexpected package magic number: got " + gotMag + "; expected " + expMag);
        }
        if (this.package_majver != 160 && this.package_majver != 150 || this.package_minver != 1 && this.package_minver != 7) {
            String gotVer = this.package_majver + "." + this.package_minver;
            String expVer = "160.1 OR 150.7";
            throw new IOException("Unexpected package minor version: got " + gotVer + "; expected " + expVer);
        }
    }

    public List getClasses() {
        return this.classes;
    }

    void addClass(Class c) {
        assert (c.getPackage() == this);
        boolean added = this.classes.add(c);
        assert (added);
        if (c.file == null) {
            c.initFile(null);
        }
        this.addFile(c.file);
    }

    public List getFiles() {
        return this.files;
    }

    public List getClassStubs() {
        ArrayList<File> classStubs = new ArrayList<File>(this.classes.size());
        for (Class cls : this.classes) {
            assert (cls.file.isClassStub());
            classStubs.add(cls.file);
        }
        return classStubs;
    }

    File newStub(String classFileNameString) {
        File stub = new File(classFileNameString);
        stub.options |= 2;
        stub.prepend = null;
        stub.append = null;
        return stub;
    }

    private static String fixupFileName(String name) {
        String fname = name.replace(java.io.File.separatorChar, '/');
        if (fname.startsWith("/")) {
            throw new IllegalArgumentException("absolute file name " + fname);
        }
        return fname;
    }

    void addFile(File file) {
        boolean added = this.files.add(file);
        assert (added);
    }

    public List getAllInnerClasses() {
        return this.allInnerClasses;
    }

    public void setAllInnerClasses(Collection ics) {
        assert (ics != this.allInnerClasses);
        this.allInnerClasses.clear();
        this.allInnerClasses.addAll(ics);
        this.allInnerClassesByThis = new HashMap(this.allInnerClasses.size());
        for (InnerClass ic : this.allInnerClasses) {
            InnerClass pic = this.allInnerClassesByThis.put(ic.thisClass, ic);
            assert (pic == null);
        }
    }

    public InnerClass getGlobalInnerClass(ConstantPool.Entry thisClass) {
        assert (thisClass instanceof ConstantPool.ClassEntry);
        return (InnerClass)this.allInnerClassesByThis.get(thisClass);
    }

    private static void visitInnerClassRefs(Collection innerClasses, int mode, Collection refs) {
        if (innerClasses == null) {
            return;
        }
        if (mode == 0) {
            refs.add(Package.getRefString("InnerClasses"));
        }
        if (innerClasses.size() > 0) {
            for (InnerClass c : innerClasses) {
                c.visitRefs(mode, refs);
            }
        }
    }

    static String[] parseInnerClassName(String n) {
        int dollar1;
        String name;
        String number;
        int nlen = n.length();
        int pkglen = Package.lastIndexOf(46, 47, n, n.length()) + 1;
        int dollar2 = Package.lastIndexOf(0, 45, n, n.length());
        if (dollar2 < pkglen) {
            return null;
        }
        if (Package.isDigitString(n, dollar2 + 1, nlen)) {
            number = n.substring(dollar2 + 1, nlen);
            name = null;
            dollar1 = dollar2;
        } else {
            dollar1 = Package.lastIndexOf(0, 45, n, dollar2 - 1);
            if (dollar1 > pkglen && Package.isDigitString(n, dollar1 + 1, dollar2)) {
                number = n.substring(dollar1 + 1, dollar2);
                name = n.substring(dollar2 + 1, nlen).intern();
            } else {
                dollar1 = dollar2;
                number = null;
                name = n.substring(dollar2 + 1, nlen).intern();
            }
        }
        String pkgOuter = number == null ? n.substring(0, dollar1).intern() : null;
        return new String[]{pkgOuter, number, name};
    }

    private static int lastIndexOf(int chMin, int chMax, String str, int pos) {
        int i = pos;
        while (--i >= 0) {
            char ch = str.charAt(i);
            if (ch < chMin || ch > chMax) continue;
            return i;
        }
        return -1;
    }

    private static boolean isDigitString(String x, int beg, int end) {
        if (beg == end) {
            return false;
        }
        for (int i = beg; i < end; ++i) {
            char ch = x.charAt(i);
            if (ch >= '0' && ch <= '9') continue;
            return false;
        }
        return true;
    }

    static String getObviousSourceFile(String className) {
        int dollar2;
        String n = className;
        int pkglen = Package.lastIndexOf(46, 47, n, n.length()) + 1;
        n = n.substring(pkglen);
        int cutoff = n.length();
        while ((dollar2 = Package.lastIndexOf(0, 45, n, cutoff - 1)) >= 0 && (cutoff = dollar2) != 0) {
        }
        String obvious = n.substring(0, cutoff) + ".java";
        return obvious;
    }

    static ConstantPool.Utf8Entry getRefString(String s) {
        return ConstantPool.getUtf8Entry(s);
    }

    static ConstantPool.LiteralEntry getRefLiteral(Comparable s) {
        return ConstantPool.getLiteralEntry(s);
    }

    void stripAttributeKind(String what) {
        if (this.verbose > 0) {
            Utils.log.info("Stripping " + what.toLowerCase() + " data and attributes...");
        }
        if (what == "Debug") {
            this.strip("SourceFile");
            this.strip("LineNumberTable");
            this.strip("LocalVariableTable");
            this.strip("LocalVariableTypeTable");
        }
        if (what == "Compile") {
            this.strip("Deprecated");
            this.strip("Synthetic");
        }
        if (what == "Exceptions") {
            this.strip("Exceptions");
        }
        if (what == "Constant") {
            this.stripConstantFields();
        }
    }

    public void trimToSize() {
        this.classes.trimToSize();
        for (Class c : this.classes) {
            c.trimToSize();
        }
        this.files.trimToSize();
    }

    public void strip(String attrName) {
        for (Class c : this.classes) {
            c.strip(attrName);
        }
    }

    public static String versionStringOf(int majver, int minver) {
        return majver + "." + minver;
    }

    public static String versionStringOf(int version) {
        return Package.versionStringOf(version >>> 16, (char)version);
    }

    public void stripConstantFields() {
        for (Class c : this.classes) {
            Iterator j = c.fields.iterator();
            while (j.hasNext()) {
                Class.Field f = (Class.Field)j.next();
                if (!Modifier.isFinal(f.flags) || !Modifier.isStatic(f.flags) || f.getAttribute("ConstantValue") == null || f.getName().startsWith("serial") || this.verbose <= 2) continue;
                Utils.log.fine(">> Strip " + this + " ConstantValue");
                j.remove();
            }
        }
    }

    protected void visitRefs(int mode, Collection refs) {
        for (Class c : this.classes) {
            c.visitRefs(mode, refs);
        }
        if (mode != 0) {
            for (File f : this.files) {
                f.visitRefs(mode, refs);
            }
            Package.visitInnerClassRefs(this.allInnerClasses, mode, refs);
        }
    }

    void reorderFiles(boolean keepClassOrder, boolean stripDirectories) {
        if (!keepClassOrder) {
            Collections.sort(this.classes);
        }
        List stubs = this.getClassStubs();
        Iterator i = this.files.iterator();
        while (i.hasNext()) {
            File file = (File)i.next();
            if (!file.isClassStub() && (!stripDirectories || !file.isDirectory())) continue;
            i.remove();
        }
        Collections.sort(this.files, new Comparator(){

            public int compare(Object o0, Object o1) {
                String x1;
                File r0 = (File)o0;
                File r1 = (File)o1;
                String f0 = r0.nameString;
                String f1 = r1.nameString;
                if (f0.equals(f1)) {
                    return 0;
                }
                if ("META-INF/MANIFEST.MF".equals(f0)) {
                    return -1;
                }
                if ("META-INF/MANIFEST.MF".equals(f1)) {
                    return 1;
                }
                String n0 = f0.substring(1 + f0.lastIndexOf(47));
                String n1 = f1.substring(1 + f1.lastIndexOf(47));
                String x0 = n0.substring(1 + n0.lastIndexOf(46));
                int r = x0.compareTo(x1 = n1.substring(1 + n1.lastIndexOf(46)));
                if (r != 0) {
                    return r;
                }
                r = f0.compareTo(f1);
                return r;
            }
        });
        this.files.addAll(stubs);
    }

    void trimStubs() {
        ListIterator i = this.files.listIterator(this.files.size());
        while (i.hasPrevious()) {
            File file = (File)i.previous();
            if (!file.isTrivialClassStub()) {
                if (this.verbose <= 1) break;
                Utils.log.fine("Keeping last non-trivial " + file);
                break;
            }
            if (this.verbose > 2) {
                Utils.log.fine("Removing trivial " + file);
            }
            i.remove();
        }
        if (this.verbose > 0) {
            Utils.log.info("Transmitting " + this.files.size() + " files, including per-file data for " + this.getClassStubs().size() + " classes out of " + this.classes.size());
        }
    }

    void buildGlobalConstantPool(Set requiredEntries) {
        ConstantPool.Index ix;
        byte tag;
        int i;
        if (this.verbose > 1) {
            Utils.log.fine("Checking for unused CP entries");
        }
        requiredEntries.add(Package.getRefString(""));
        this.visitRefs(1, requiredEntries);
        ConstantPool.completeReferencesIn(requiredEntries, false);
        if (this.verbose > 1) {
            Utils.log.fine("Sorting CP entries");
        }
        ConstantPool.Index cpAllU = ConstantPool.makeIndex("unsorted", requiredEntries);
        ConstantPool.Index[] byTagU = ConstantPool.partitionByTag(cpAllU);
        for (i = 0; i < ConstantPool.TAGS_IN_ORDER.length; ++i) {
            tag = ConstantPool.TAGS_IN_ORDER[i];
            ix = byTagU[tag];
            if (ix == null) continue;
            ConstantPool.sort(ix);
            this.cp.initIndexByTag(tag, ix);
            byTagU[tag] = null;
        }
        for (i = 0; i < byTagU.length; ++i) {
            assert (byTagU[i] == null);
        }
        for (i = 0; i < ConstantPool.TAGS_IN_ORDER.length; ++i) {
            tag = ConstantPool.TAGS_IN_ORDER[i];
            ix = this.cp.getIndexByTag(tag);
            assert (ix.assertIsSorted());
            if (this.verbose <= 2) continue;
            Utils.log.fine(ix.dumpString());
        }
    }

    void ensureAllClassFiles() {
        HashSet fileSet = new HashSet(this.files);
        for (Class cls : this.classes) {
            if (fileSet.contains(cls.file)) continue;
            this.files.add(cls.file);
        }
    }

    static {
        HashMap ad = new HashMap(2);
        attrCodeEmpty = Attribute.define(ad, 2, "Code", "").layout();
        attrInnerClassesEmpty = Attribute.define(ad, 0, "InnerClasses", "").layout();
        attrSourceFileSpecial = Attribute.define(ad, 0, "SourceFile", "RUNH").layout();
        attrDefs = Collections.unmodifiableMap(ad);
        assert (Package.lastIndexOf(0, 45, "x$$y$", 4) == 2);
        assert (Package.lastIndexOf(46, 47, "x//y/", 4) == 2);
        noObjects = Arrays.asList(new Object[0]);
        noFields = Arrays.asList(new Class.Field[0]);
        noMethods = Arrays.asList(new Class.Method[0]);
        noInnerClasses = Arrays.asList(new InnerClass[0]);
    }

    static class InnerClass
    implements Comparable {
        final ConstantPool.ClassEntry thisClass;
        final ConstantPool.ClassEntry outerClass;
        final ConstantPool.Utf8Entry name;
        final int flags;
        final boolean predictable;

        InnerClass(ConstantPool.ClassEntry thisClass, ConstantPool.ClassEntry outerClass, ConstantPool.Utf8Entry name, int flags) {
            this.thisClass = thisClass;
            this.outerClass = outerClass;
            this.name = name;
            this.flags = flags;
            this.predictable = this.computePredictable();
        }

        private boolean computePredictable() {
            String[] parse = Package.parseInnerClassName(this.thisClass.stringValue());
            if (parse == null) {
                return false;
            }
            String pkgOuter = parse[0];
            String name = parse[2];
            String haveName = this.name == null ? null : this.name.stringValue();
            String haveOuter = this.outerClass == null ? null : this.outerClass.stringValue();
            boolean predictable = name == haveName && pkgOuter == haveOuter;
            return predictable;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            InnerClass that = (InnerClass)o;
            return InnerClass.eq(this.thisClass, that.thisClass) && InnerClass.eq(this.outerClass, that.outerClass) && InnerClass.eq(this.name, that.name) && this.flags == that.flags;
        }

        private static boolean eq(Object x, Object y) {
            return x == null ? y == null : x.equals(y);
        }

        public int hashCode() {
            return this.thisClass.hashCode();
        }

        public int compareTo(Object o) {
            InnerClass that = (InnerClass)o;
            return this.thisClass.compareTo(that.thisClass);
        }

        protected void visitRefs(int mode, Collection refs) {
            refs.add(this.thisClass);
            if (mode == 0 || !this.predictable) {
                refs.add(this.outerClass);
                refs.add(this.name);
            }
        }

        public String toString() {
            return this.thisClass.stringValue();
        }
    }

    public class File
    implements Comparable {
        String nameString;
        ConstantPool.Utf8Entry name;
        int modtime = 0;
        int options = 0;
        Class stubClass;
        ArrayList prepend = new ArrayList();
        ByteArrayOutputStream append = new ByteArrayOutputStream();

        File(ConstantPool.Utf8Entry name) {
            this.name = name;
            this.nameString = name.stringValue();
        }

        File(String nameString) {
            nameString = Package.fixupFileName(nameString);
            this.name = Package.getRefString(nameString);
            this.nameString = this.name.stringValue();
        }

        public boolean isDirectory() {
            return this.nameString.endsWith("/");
        }

        public boolean isClassStub() {
            return (this.options & 2) != 0;
        }

        public Class getStubClass() {
            assert (this.isClassStub());
            assert (this.stubClass != null);
            return this.stubClass;
        }

        public boolean isTrivialClassStub() {
            return this.isClassStub() && this.name.stringValue().equals("") && (this.modtime == 0 || this.modtime == Package.this.default_modtime) && (this.options & 0xFFFFFFFD) == 0;
        }

        public boolean equals(Object o) {
            File that = (File)o;
            return that.nameString == this.nameString;
        }

        public int hashCode() {
            return this.nameString.hashCode();
        }

        public int compareTo(Object o) {
            File that = (File)o;
            return this.nameString.compareTo(that.nameString);
        }

        public String toString() {
            return this.nameString + "{" + (this.isClassStub() ? "*" : "") + (BandStructure.testBit(this.options, 1) ? "@" : "") + (this.modtime == 0 ? "" : "M" + this.modtime) + (this.getFileLength() == 0L ? "" : "[" + this.getFileLength() + "]") + "}";
        }

        public java.io.File getFileName() {
            return this.getFileName(null);
        }

        public java.io.File getFileName(java.io.File parent) {
            String name = this.nameString;
            String fname = name.replace('/', java.io.File.separatorChar);
            return new java.io.File(parent, fname);
        }

        public void addBytes(byte[] bytes) {
            this.addBytes(bytes, 0, bytes.length);
        }

        public void addBytes(byte[] bytes, int off, int len) {
            if ((this.append.size() | len) << 2 < 0) {
                this.prepend.add(this.append.toByteArray());
                this.append.reset();
            }
            this.append.write(bytes, off, len);
        }

        public long getFileLength() {
            long len = 0L;
            if (this.prepend == null && this.append == null) {
                return 0L;
            }
            for (byte[] block : this.prepend) {
                len += (long)block.length;
            }
            return len += (long)this.append.size();
        }

        public void writeTo(OutputStream out) throws IOException {
            if (this.prepend == null && this.append == null) {
                return;
            }
            for (byte[] block : this.prepend) {
                out.write(block);
            }
            this.append.writeTo(out);
        }

        public void readFrom(InputStream in) throws IOException {
            int nr;
            byte[] buf = new byte[65536];
            while ((nr = in.read(buf)) > 0) {
                this.addBytes(buf, 0, nr);
            }
        }

        public InputStream getInputStream() {
            ByteArrayInputStream in = new ByteArrayInputStream(this.append.toByteArray());
            if (this.prepend.size() == 0) {
                return in;
            }
            ArrayList<ByteArrayInputStream> isa = new ArrayList<ByteArrayInputStream>(this.prepend.size() + 1);
            for (byte[] bytes : this.prepend) {
                isa.add(new ByteArrayInputStream(bytes));
            }
            isa.add(in);
            return new SequenceInputStream(Collections.enumeration(isa));
        }

        protected void visitRefs(int mode, Collection refs) {
            assert (this.name != null);
            refs.add(this.name);
        }
    }

    public class Class
    extends Attribute.Holder
    implements Comparable {
        File file;
        int magic;
        short minver;
        short majver;
        ConstantPool.Entry[] cpMap;
        ConstantPool.ClassEntry thisClass;
        ConstantPool.ClassEntry superClass;
        ConstantPool.ClassEntry[] interfaces;
        ArrayList fields;
        ArrayList methods;
        ArrayList innerClasses;

        public Package getPackage() {
            return Package.this;
        }

        Class(int flags, ConstantPool.ClassEntry thisClass, ConstantPool.ClassEntry superClass, ConstantPool.ClassEntry[] interfaces) {
            this.magic = -889275714;
            this.minver = Package.this.default_class_minver;
            this.majver = Package.this.default_class_majver;
            this.flags = flags;
            this.thisClass = thisClass;
            this.superClass = superClass;
            this.interfaces = interfaces;
            boolean added = Package.this.classes.add(this);
            assert (added);
        }

        Class(String classFile) {
            this.initFile(Package.this.newStub(classFile));
        }

        List getFields() {
            return this.fields == null ? noFields : this.fields;
        }

        List getMethods() {
            return this.methods == null ? noMethods : this.methods;
        }

        public String getName() {
            return this.thisClass.stringValue();
        }

        int getVersion() {
            return (this.majver << 16) + (char)this.minver;
        }

        String getVersionString() {
            return Package.versionStringOf(this.majver, this.minver);
        }

        public int compareTo(Object o) {
            Class that = (Class)o;
            String n0 = this.getName();
            String n1 = that.getName();
            return n0.compareTo(n1);
        }

        String getObviousSourceFile() {
            return Package.getObviousSourceFile(this.getName());
        }

        private void transformSourceFile(boolean minimize) {
            Attribute olda = this.getAttribute(attrSourceFileSpecial);
            if (olda == null) {
                return;
            }
            String obvious = this.getObviousSourceFile();
            ArrayList ref = new ArrayList(1);
            olda.visitRefs(this, 1, ref);
            ConstantPool.Utf8Entry sfName = (ConstantPool.Utf8Entry)ref.get(0);
            Attribute a = olda;
            if (sfName == null) {
                if (minimize) {
                    a = Attribute.find(0, "SourceFile", "H");
                    a = a.addContent(new byte[2]);
                } else {
                    byte[] bytes = new byte[2];
                    sfName = Package.getRefString(obvious);
                    Object f = null;
                    f = Fixups.add(f, bytes, 0, 0, sfName);
                    a = attrSourceFileSpecial.addContent(bytes, f);
                }
            } else if (obvious.equals(sfName.stringValue())) {
                if (minimize) {
                    a = attrSourceFileSpecial.addContent(new byte[2]);
                } else assert (false);
            }
            if (a != olda) {
                if (Package.this.verbose > 2) {
                    Utils.log.fine("recoding obvious SourceFile=" + obvious);
                }
                ArrayList<Attribute> newAttrs = new ArrayList<Attribute>(this.getAttributes());
                int where = newAttrs.indexOf(olda);
                newAttrs.set(where, a);
                this.setAttributes(newAttrs);
            }
        }

        void minimizeSourceFile() {
            this.transformSourceFile(true);
        }

        void expandSourceFile() {
            this.transformSourceFile(false);
        }

        protected ConstantPool.Entry[] getCPMap() {
            return this.cpMap;
        }

        protected void setCPMap(ConstantPool.Entry[] cpMap) {
            this.cpMap = cpMap;
        }

        boolean hasInnerClasses() {
            return this.innerClasses != null;
        }

        List getInnerClasses() {
            return this.innerClasses;
        }

        public void setInnerClasses(Collection ics) {
            this.innerClasses = ics == null ? null : new ArrayList(ics);
            Attribute a = this.getAttribute(attrInnerClassesEmpty);
            if (this.innerClasses != null && a == null) {
                this.addAttribute(attrInnerClassesEmpty.canonicalInstance());
            } else if (this.innerClasses == null && a != null) {
                this.removeAttribute(a);
            }
        }

        public List computeGloballyImpliedICs() {
            HashSet cpRefs = new HashSet();
            ArrayList innerClassesSaved = this.innerClasses;
            this.innerClasses = null;
            this.visitRefs(0, cpRefs);
            this.innerClasses = innerClassesSaved;
            ConstantPool.completeReferencesIn(cpRefs, true);
            HashSet<ConstantPool.Entry> icRefs = new HashSet<ConstantPool.Entry>();
            for (ConstantPool.Entry e : cpRefs) {
                InnerClass ic;
                if (!(e instanceof ConstantPool.ClassEntry)) continue;
                while (e != null && (ic = Package.this.getGlobalInnerClass(e)) != null && icRefs.add(e)) {
                    e = ic.outerClass;
                }
            }
            ArrayList<InnerClass> impliedICs = new ArrayList<InnerClass>();
            for (InnerClass ic : Package.this.allInnerClasses) {
                if (!icRefs.contains(ic.thisClass) && ic.outerClass != this.thisClass) continue;
                if (Package.this.verbose > 1) {
                    Utils.log.fine("Relevant IC: " + ic);
                }
                impliedICs.add(ic);
            }
            return impliedICs;
        }

        private List computeICdiff() {
            List impliedICs = this.computeGloballyImpliedICs();
            List actualICs = this.getInnerClasses();
            if (actualICs == null) {
                actualICs = Collections.EMPTY_LIST;
            }
            if (actualICs.isEmpty()) {
                return impliedICs;
            }
            if (impliedICs.isEmpty()) {
                return actualICs;
            }
            HashSet center = new HashSet(actualICs);
            center.retainAll(new HashSet(impliedICs));
            impliedICs.addAll(actualICs);
            impliedICs.removeAll(center);
            return impliedICs;
        }

        void minimizeLocalICs() {
            List localICs;
            List diff = this.computeICdiff();
            ArrayList actualICs = this.innerClasses;
            if (diff.isEmpty()) {
                localICs = null;
                if (actualICs != null && actualICs.isEmpty() && Package.this.verbose > 0) {
                    Utils.log.info("Warning: Dropping empty InnerClasses attribute from " + this);
                }
            } else {
                localICs = actualICs == null ? Collections.EMPTY_LIST : diff;
            }
            this.setInnerClasses(localICs);
            if (Package.this.verbose > 1 && localICs != null) {
                Utils.log.fine("keeping local ICs in " + this + ": " + localICs);
            }
        }

        int expandLocalICs() {
            int changed;
            List actualICs;
            ArrayList localICs = this.innerClasses;
            if (localICs == null) {
                List impliedICs = this.computeGloballyImpliedICs();
                if (impliedICs.isEmpty()) {
                    actualICs = null;
                    changed = 0;
                } else {
                    actualICs = impliedICs;
                    changed = 1;
                }
            } else if (localICs.isEmpty()) {
                actualICs = null;
                changed = 0;
            } else {
                actualICs = this.computeICdiff();
                changed = actualICs.containsAll(localICs) ? 1 : -1;
            }
            this.setInnerClasses(actualICs);
            return changed;
        }

        public void trimToSize() {
            super.trimToSize();
            for (int isM = 0; isM <= 1; ++isM) {
                ArrayList members;
                ArrayList arrayList = members = isM == 0 ? this.fields : this.methods;
                if (members == null) continue;
                members.trimToSize();
                for (Member m : members) {
                    m.trimToSize();
                }
            }
            if (this.innerClasses != null) {
                this.innerClasses.trimToSize();
            }
        }

        public void strip(String attrName) {
            if (attrName == "InnerClass") {
                this.innerClasses = null;
            }
            for (int isM = 0; isM <= 1; ++isM) {
                ArrayList members;
                ArrayList arrayList = members = isM == 0 ? this.fields : this.methods;
                if (members == null) continue;
                for (Member m : members) {
                    m.strip(attrName);
                }
            }
            super.strip(attrName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void visitRefs(int mode, Collection refs) {
            if (Package.this.verbose > 2) {
                Utils.log.fine("visitRefs " + this);
            }
            refs.add(this.thisClass);
            refs.add(this.superClass);
            for (int i = 0; i < this.interfaces.length; ++i) {
                refs.add(this.interfaces[i]);
            }
            for (int isM = 0; isM <= 1; ++isM) {
                ArrayList members;
                ArrayList arrayList = members = isM == 0 ? this.fields : this.methods;
                if (members == null) continue;
                for (Member m : members) {
                    boolean ok = false;
                    try {
                        m.visitRefs(mode, refs);
                        ok = true;
                    }
                    finally {
                        if (ok) continue;
                        Utils.log.warning("Error scanning " + m);
                    }
                }
            }
            this.visitInnerClassRefs(mode, refs);
            super.visitRefs(mode, refs);
        }

        protected void visitInnerClassRefs(int mode, Collection refs) {
            Package.visitInnerClassRefs(this.innerClasses, mode, refs);
        }

        void finishReading() {
            this.trimToSize();
            this.maybeChooseFileName();
        }

        public void initFile(File file) {
            assert (this.file == null);
            if (file == null) {
                file = Package.this.newStub(this.canonicalFileName());
            }
            this.file = file;
            assert (file.isClassStub());
            file.stubClass = this;
            this.maybeChooseFileName();
        }

        public void maybeChooseFileName() {
            if (this.thisClass == null) {
                return;
            }
            String canonName = this.canonicalFileName();
            if (this.file.nameString.equals("")) {
                this.file.nameString = canonName;
            }
            if (this.file.nameString.equals(canonName)) {
                this.file.name = Package.getRefString("");
                return;
            }
            if (this.file.name == null) {
                this.file.name = Package.getRefString(this.file.nameString);
            }
        }

        public String canonicalFileName() {
            if (this.thisClass == null) {
                return null;
            }
            return this.thisClass.stringValue() + ".class";
        }

        public java.io.File getFileName(java.io.File parent) {
            String name = this.file.name.stringValue();
            if (name.equals("")) {
                name = this.canonicalFileName();
            }
            String fname = name.replace('/', java.io.File.separatorChar);
            return new java.io.File(parent, fname);
        }

        public java.io.File getFileName() {
            return this.getFileName(null);
        }

        public String toString() {
            return this.thisClass.stringValue();
        }

        public class Method
        extends Member {
            Code code;

            public Method(int flags, ConstantPool.DescriptorEntry descriptor) {
                super(flags, descriptor);
                assert (descriptor.isMethod());
                if (Class.this.methods == null) {
                    Class.this.methods = new ArrayList();
                }
                boolean added = Class.this.methods.add(this);
                assert (added);
            }

            public void trimToSize() {
                super.trimToSize();
                if (this.code != null) {
                    this.code.trimToSize();
                }
            }

            public int getArgumentSize() {
                int argSize = this.descriptor.typeRef.computeSize(true);
                int thisSize = Modifier.isStatic(this.flags) ? 0 : 1;
                return thisSize + argSize;
            }

            public int compareTo(Object o) {
                Method that = (Method)o;
                return this.getDescriptor().compareTo(that.getDescriptor());
            }

            public void strip(String attrName) {
                if (attrName == "Code") {
                    this.code = null;
                }
                if (this.code != null) {
                    this.code.strip(attrName);
                }
                super.strip(attrName);
            }

            protected void visitRefs(int mode, Collection refs) {
                super.visitRefs(mode, refs);
                if (this.code != null) {
                    if (mode == 0) {
                        refs.add(Package.getRefString("Code"));
                    }
                    this.code.visitRefs(mode, refs);
                }
            }
        }

        public class Field
        extends Member {
            int order;

            public Field(int flags, ConstantPool.DescriptorEntry descriptor) {
                super(flags, descriptor);
                assert (!descriptor.isMethod());
                if (Class.this.fields == null) {
                    Class.this.fields = new ArrayList();
                }
                boolean added = Class.this.fields.add(this);
                assert (added);
                this.order = Class.this.fields.size();
            }

            public byte getLiteralTag() {
                return this.descriptor.getLiteralTag();
            }

            public int compareTo(Object o) {
                Field that = (Field)o;
                return this.order - that.order;
            }
        }

        public abstract class Member
        extends Attribute.Holder
        implements Comparable {
            ConstantPool.DescriptorEntry descriptor;

            protected Member(int flags, ConstantPool.DescriptorEntry descriptor) {
                this.flags = flags;
                this.descriptor = descriptor;
            }

            public Class thisClass() {
                return Class.this;
            }

            public ConstantPool.DescriptorEntry getDescriptor() {
                return this.descriptor;
            }

            public String getName() {
                return this.descriptor.nameRef.stringValue();
            }

            public String getType() {
                return this.descriptor.typeRef.stringValue();
            }

            protected ConstantPool.Entry[] getCPMap() {
                return Class.this.cpMap;
            }

            protected void visitRefs(int mode, Collection refs) {
                if (Package.this.verbose > 2) {
                    Utils.log.fine("visitRefs " + this);
                }
                if (mode == 0) {
                    refs.add(this.descriptor.nameRef);
                    refs.add(this.descriptor.typeRef);
                } else {
                    refs.add(this.descriptor);
                }
                super.visitRefs(mode, refs);
            }

            public String toString() {
                return Class.this + "." + this.descriptor.prettyString();
            }
        }
    }
}

