/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;

public class DesktopProperty
implements UIDefaults.ActiveValue {
    private static boolean updatePending;
    private static ReferenceQueue queue;
    private WeakPCL pcl;
    private String key;
    private Object value;
    private Object fallback;
    private Toolkit toolkit;

    static void flushUnreferencedProperties() {
        WeakPCL pcl;
        while ((pcl = (WeakPCL)queue.poll()) != null) {
            pcl.dispose();
        }
    }

    private static synchronized void setUpdatePending(boolean update) {
        updatePending = update;
    }

    private static synchronized boolean isUpdatePending() {
        return updatePending;
    }

    private static void updateAllUIs() {
        Class<?> uiClass = UIManager.getLookAndFeel().getClass();
        if (uiClass.getPackage().equals(DesktopProperty.class.getPackage())) {
            XPStyle.invalidateStyle();
        }
        Frame[] appFrames = Frame.getFrames();
        for (int j = 0; j < appFrames.length; ++j) {
            DesktopProperty.updateWindowUI(appFrames[j]);
        }
    }

    private static void updateWindowUI(Window window) {
        SwingUtilities.updateComponentTreeUI(window);
        Window[] ownedWins = window.getOwnedWindows();
        for (int i = 0; i < ownedWins.length; ++i) {
            DesktopProperty.updateWindowUI(ownedWins[i]);
        }
    }

    public DesktopProperty(String key, Object fallback, Toolkit toolkit) {
        this.key = key;
        this.fallback = fallback;
        this.toolkit = toolkit;
        DesktopProperty.flushUnreferencedProperties();
    }

    public Object createValue(UIDefaults table) {
        if (this.value == null) {
            this.value = this.configureValue(this.getValueFromDesktop());
            if (this.value == null) {
                this.value = this.configureValue(this.getDefaultValue());
            }
        }
        return this.value;
    }

    protected Object getValueFromDesktop() {
        if (this.toolkit == null) {
            this.toolkit = Toolkit.getDefaultToolkit();
        }
        Object value = this.toolkit.getDesktopProperty(this.getKey());
        this.pcl = new WeakPCL(this, this.toolkit, this.getKey(), UIManager.getLookAndFeel());
        this.toolkit.addPropertyChangeListener(this.getKey(), this.pcl);
        return value;
    }

    protected Object getDefaultValue() {
        return this.fallback;
    }

    public void invalidate(LookAndFeel laf) {
        this.invalidate();
    }

    public void invalidate() {
        if (this.pcl != null) {
            this.toolkit.removePropertyChangeListener(this.getKey(), this.pcl);
            this.toolkit = null;
            this.pcl = null;
            this.value = null;
        }
    }

    protected void updateUI() {
        if (!DesktopProperty.isUpdatePending()) {
            DesktopProperty.setUpdatePending(true);
            Runnable uiUpdater = new Runnable(){

                public void run() {
                    DesktopProperty.updateAllUIs();
                    DesktopProperty.setUpdatePending(false);
                }
            };
            SwingUtilities.invokeLater(uiUpdater);
        }
    }

    protected Object configureValue(Object value) {
        if (value != null) {
            if (value instanceof Color) {
                return new ColorUIResource((Color)value);
            }
            if (value instanceof Font) {
                return new FontUIResource((Font)value);
            }
            if (value instanceof UIDefaults.LazyValue) {
                value = ((UIDefaults.LazyValue)value).createValue(null);
            } else if (value instanceof UIDefaults.ActiveValue) {
                value = ((UIDefaults.ActiveValue)value).createValue(null);
            }
        }
        return value;
    }

    protected String getKey() {
        return this.key;
    }

    static {
        queue = new ReferenceQueue();
    }

    private static class WeakPCL
    extends WeakReference
    implements PropertyChangeListener {
        private Toolkit kit;
        private String key;
        private LookAndFeel laf;

        WeakPCL(Object target, Toolkit kit, String key, LookAndFeel laf) {
            super(target, queue);
            this.kit = kit;
            this.key = key;
            this.laf = laf;
        }

        public void propertyChange(PropertyChangeEvent pce) {
            DesktopProperty property = (DesktopProperty)this.get();
            if (property == null || this.laf != UIManager.getLookAndFeel()) {
                this.dispose();
            } else {
                property.invalidate(this.laf);
                property.updateUI();
            }
        }

        void dispose() {
            this.kit.removePropertyChangeListener(this.key, this);
        }
    }
}

