/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.jpeg;

import com.sun.imageio.plugins.jpeg.AdobeMarkerSegment;
import com.sun.imageio.plugins.jpeg.DHTMarkerSegment;
import com.sun.imageio.plugins.jpeg.DQTMarkerSegment;
import com.sun.imageio.plugins.jpeg.DRIMarkerSegment;
import com.sun.imageio.plugins.jpeg.JFIFMarkerSegment;
import com.sun.imageio.plugins.jpeg.JPEG;
import com.sun.imageio.plugins.jpeg.JPEGMetadata;
import com.sun.imageio.plugins.jpeg.MarkerSegment;
import com.sun.imageio.plugins.jpeg.SOFMarkerSegment;
import com.sun.imageio.plugins.jpeg.SOSMarkerSegment;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.plugins.jpeg.JPEGHuffmanTable;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.plugins.jpeg.JPEGQTable;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.Node;
import sun.java2d.Disposer;
import sun.java2d.DisposerRecord;
import sun.security.action.LoadLibraryAction;

public class JPEGImageWriter
extends ImageWriter {
    private boolean debug = false;
    private long structPointer = 0L;
    private ImageOutputStream ios = null;
    private Raster srcRas = null;
    private WritableRaster raster = null;
    private boolean indexed = false;
    private IndexColorModel indexCM = null;
    private boolean convertTosRGB = false;
    private WritableRaster converted = null;
    private boolean isAlphaPremultiplied = false;
    private ColorModel srcCM = null;
    private List thumbnails = null;
    private ICC_Profile iccProfile = null;
    private int sourceXOffset = 0;
    private int sourceYOffset = 0;
    private int sourceWidth = 0;
    private int[] srcBands = null;
    private int sourceHeight = 0;
    private int currentImage = 0;
    private ColorConvertOp convertOp = null;
    private JPEGQTable[] streamQTables = null;
    private JPEGHuffmanTable[] streamDCHuffmanTables = null;
    private JPEGHuffmanTable[] streamACHuffmanTables = null;
    private boolean ignoreJFIF = false;
    private boolean forceJFIF = false;
    private boolean ignoreAdobe = false;
    private int newAdobeTransform = -1;
    private boolean writeDefaultJFIF = false;
    private boolean writeAdobe = false;
    private JPEGMetadata metadata = null;
    private boolean sequencePrepared = false;
    private int numScans = 0;
    private Object disposerReferent = new Object();
    private DisposerRecord disposerRecord;
    protected static final int WARNING_DEST_IGNORED = 0;
    protected static final int WARNING_STREAM_METADATA_IGNORED = 1;
    protected static final int WARNING_DEST_METADATA_COMP_MISMATCH = 2;
    protected static final int WARNING_DEST_METADATA_JFIF_MISMATCH = 3;
    protected static final int WARNING_DEST_METADATA_ADOBE_MISMATCH = 4;
    protected static final int WARNING_IMAGE_METADATA_JFIF_MISMATCH = 5;
    protected static final int WARNING_IMAGE_METADATA_ADOBE_MISMATCH = 6;
    protected static final int WARNING_METADATA_NOT_JPEG_FOR_RASTER = 7;
    protected static final int WARNING_NO_BANDS_ON_INDEXED = 8;
    protected static final int WARNING_ILLEGAL_THUMBNAIL = 9;
    protected static final int WARNING_IGNORING_THUMBS = 10;
    protected static final int WARNING_FORCING_JFIF = 11;
    protected static final int WARNING_THUMB_CLIPPED = 12;
    protected static final int WARNING_METADATA_ADJUSTED_FOR_THUMB = 13;
    protected static final int WARNING_NO_RGB_THUMB_AS_INDEXED = 14;
    protected static final int WARNING_NO_GRAY_THUMB_AS_INDEXED = 15;
    private static final int MAX_WARNING = 15;
    static final Dimension[] preferredThumbSizes;
    private Thread theThread = null;
    private int theLockCount = 0;

    public JPEGImageWriter(ImageWriterSpi originator) {
        super(originator);
        this.structPointer = this.initJPEGImageWriter();
        this.disposerRecord = new JPEGWriterDisposerRecord(this.structPointer);
        Disposer.addRecord(this.disposerReferent, this.disposerRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutput(Object output) {
        this.setThreadLock();
        try {
            super.setOutput(output);
            this.resetInternalState();
            this.ios = (ImageOutputStream)output;
            this.setDest(this.structPointer, this.ios);
        }
        finally {
            this.clearThreadLock();
        }
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new JPEGImageWriteParam(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        this.setThreadLock();
        try {
            JPEGMetadata jPEGMetadata = new JPEGMetadata(param, this);
            return jPEGMetadata;
        }
        finally {
            this.clearThreadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        this.setThreadLock();
        try {
            JPEGMetadata jPEGMetadata = new JPEGMetadata(imageType, param, this);
            return jPEGMetadata;
        }
        finally {
            this.clearThreadLock();
        }
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        if (inData instanceof JPEGMetadata) {
            JPEGMetadata jpegData = (JPEGMetadata)inData;
            if (jpegData.isStream) {
                return inData;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        this.setThreadLock();
        try {
            IIOMetadata iIOMetadata = this.convertImageMetadataOnThread(inData, imageType, param);
            return iIOMetadata;
        }
        finally {
            this.clearThreadLock();
        }
    }

    private IIOMetadata convertImageMetadataOnThread(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        String formatName;
        Node tree;
        if (inData instanceof JPEGMetadata) {
            JPEGMetadata jpegData = (JPEGMetadata)inData;
            if (!jpegData.isStream) {
                return inData;
            }
            return null;
        }
        if (inData.isStandardMetadataFormatSupported() && (tree = inData.getAsTree(formatName = "javax_imageio_1.0")) != null) {
            JPEGMetadata jpegData = new JPEGMetadata(imageType, param, this);
            try {
                jpegData.setFromTree(formatName, tree);
            }
            catch (IIOInvalidTreeException e) {
                return null;
            }
            return jpegData;
        }
        return null;
    }

    public int getNumThumbnailsSupported(ImageTypeSpecifier imageType, ImageWriteParam param, IIOMetadata streamMetadata, IIOMetadata imageMetadata) {
        if (this.jfifOK(imageType, param, streamMetadata, imageMetadata)) {
            return Integer.MAX_VALUE;
        }
        return 0;
    }

    public Dimension[] getPreferredThumbnailSizes(ImageTypeSpecifier imageType, ImageWriteParam param, IIOMetadata streamMetadata, IIOMetadata imageMetadata) {
        if (this.jfifOK(imageType, param, streamMetadata, imageMetadata)) {
            return (Dimension[])preferredThumbSizes.clone();
        }
        return null;
    }

    private boolean jfifOK(ImageTypeSpecifier imageType, ImageWriteParam param, IIOMetadata streamMetadata, IIOMetadata imageMetadata) {
        if (imageType != null && !JPEG.isJFIFcompliant(imageType, true)) {
            return false;
        }
        if (imageMetadata != null) {
            JPEGMetadata metadata = null;
            metadata = imageMetadata instanceof JPEGMetadata ? (JPEGMetadata)imageMetadata : (JPEGMetadata)this.convertImageMetadata(imageMetadata, imageType, param);
            if (metadata.findMarkerSegment(JFIFMarkerSegment.class, true) == null) {
                return false;
            }
        }
        return true;
    }

    public boolean canWriteRasters() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        this.setThreadLock();
        try {
            this.writeOnThread(streamMetadata, image, param);
        }
        finally {
            this.clearThreadLock();
        }
    }

    private void writeOnThread(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        int i;
        IIOMetadata mdata;
        int i2;
        int i3;
        int[] sBands;
        if (this.ios == null) {
            throw new IllegalStateException("Output has not been set!");
        }
        if (image == null) {
            throw new IllegalArgumentException("image is null!");
        }
        if (streamMetadata != null) {
            this.warningOccurred(1);
        }
        boolean rasterOnly = image.hasRaster();
        RenderedImage rimage = null;
        if (rasterOnly) {
            this.srcRas = image.getRaster();
        } else {
            rimage = image.getRenderedImage();
            if (rimage instanceof BufferedImage) {
                this.srcRas = ((BufferedImage)rimage).getRaster();
            } else if (rimage.getNumXTiles() == 1 && rimage.getNumYTiles() == 1) {
                this.srcRas = rimage.getTile(rimage.getMinTileX(), rimage.getMinTileY());
                if (this.srcRas.getWidth() != rimage.getWidth() || this.srcRas.getHeight() != rimage.getHeight()) {
                    this.srcRas = this.srcRas.createChild(this.srcRas.getMinX(), this.srcRas.getMinY(), rimage.getWidth(), rimage.getHeight(), this.srcRas.getMinX(), this.srcRas.getMinY(), null);
                }
            } else {
                this.srcRas = rimage.getData();
            }
        }
        int numSrcBands = this.srcRas.getNumBands();
        this.indexed = false;
        this.indexCM = null;
        ColorModel cm = null;
        ColorSpace cs = null;
        this.isAlphaPremultiplied = false;
        this.srcCM = null;
        if (!rasterOnly && (cm = rimage.getColorModel()) != null) {
            cs = cm.getColorSpace();
            if (cm instanceof IndexColorModel) {
                this.indexed = true;
                this.indexCM = (IndexColorModel)cm;
                numSrcBands = cm.getNumComponents();
            }
            if (cm.isAlphaPremultiplied()) {
                this.isAlphaPremultiplied = true;
                this.srcCM = cm;
            }
        }
        this.srcBands = JPEG.bandOffsets[numSrcBands - 1];
        int numBandsUsed = numSrcBands;
        if (param != null && (sBands = param.getSourceBands()) != null) {
            if (this.indexed) {
                this.warningOccurred(8);
            } else {
                this.srcBands = sBands;
                numBandsUsed = this.srcBands.length;
                if (numBandsUsed > numSrcBands) {
                    throw new IIOException("ImageWriteParam specifies too many source bands");
                }
            }
        }
        boolean usingBandSubset = numBandsUsed != numSrcBands;
        boolean fullImage = !rasterOnly && !usingBandSubset;
        int[] bandSizes = null;
        if (!this.indexed) {
            bandSizes = this.srcRas.getSampleModel().getSampleSize();
            if (usingBandSubset) {
                int[] temp = new int[numBandsUsed];
                for (i3 = 0; i3 < numBandsUsed; ++i3) {
                    temp[i3] = bandSizes[this.srcBands[i3]];
                }
                bandSizes = temp;
            }
        } else {
            int[] tempSize = this.srcRas.getSampleModel().getSampleSize();
            bandSizes = new int[numSrcBands];
            for (i3 = 0; i3 < numSrcBands; ++i3) {
                bandSizes[i3] = tempSize[0];
            }
        }
        for (i2 = 0; i2 < bandSizes.length; ++i2) {
            if (bandSizes[i2] > 8) {
                throw new IIOException("Sample size must be <= 8");
            }
            if (!this.indexed) continue;
            bandSizes[i2] = 8;
        }
        if (this.debug) {
            System.out.println("numSrcBands is " + numSrcBands);
            System.out.println("numBandsUsed is " + numBandsUsed);
            System.out.println("usingBandSubset is " + usingBandSubset);
            System.out.println("fullImage is " + fullImage);
            System.out.print("Band sizes:");
            for (i2 = 0; i2 < bandSizes.length; ++i2) {
                System.out.print(" " + bandSizes[i2]);
            }
            System.out.println();
        }
        ImageTypeSpecifier destType = null;
        if (param != null) {
            destType = param.getDestinationType();
            if (fullImage && destType != null) {
                this.warningOccurred(0);
                destType = null;
            }
        }
        this.sourceXOffset = this.srcRas.getMinX();
        this.sourceYOffset = this.srcRas.getMinY();
        int imageWidth = this.srcRas.getWidth();
        int imageHeight = this.srcRas.getHeight();
        this.sourceWidth = imageWidth;
        this.sourceHeight = imageHeight;
        int periodX = 1;
        int periodY = 1;
        int gridX = 0;
        int gridY = 0;
        JPEGQTable[] qTables = null;
        JPEGHuffmanTable[] DCHuffmanTables = null;
        JPEGHuffmanTable[] ACHuffmanTables = null;
        boolean optimizeHuffman = false;
        JPEGImageWriteParam jparam = null;
        int progressiveMode = 0;
        if (param != null) {
            Rectangle sourceRegion = param.getSourceRegion();
            if (sourceRegion != null) {
                Rectangle imageBounds = new Rectangle(this.sourceXOffset, this.sourceYOffset, this.sourceWidth, this.sourceHeight);
                sourceRegion = sourceRegion.intersection(imageBounds);
                this.sourceXOffset = sourceRegion.x;
                this.sourceYOffset = sourceRegion.y;
                this.sourceWidth = sourceRegion.width;
                this.sourceHeight = sourceRegion.height;
            }
            if (this.sourceWidth + this.sourceXOffset > imageWidth) {
                this.sourceWidth = imageWidth - this.sourceXOffset;
            }
            if (this.sourceHeight + this.sourceYOffset > imageHeight) {
                this.sourceHeight = imageHeight - this.sourceYOffset;
            }
            periodX = param.getSourceXSubsampling();
            periodY = param.getSourceYSubsampling();
            gridX = param.getSubsamplingXOffset();
            gridY = param.getSubsamplingYOffset();
            switch (param.getCompressionMode()) {
                case 0: {
                    throw new IIOException("JPEG compression cannot be disabled");
                }
                case 2: {
                    float quality = param.getCompressionQuality();
                    quality = JPEG.convertToLinearQuality(quality);
                    qTables = new JPEGQTable[]{JPEGQTable.K1Luminance.getScaledInstance(quality, true), JPEGQTable.K2Chrominance.getScaledInstance(quality, true)};
                    break;
                }
                case 1: {
                    qTables = new JPEGQTable[]{JPEGQTable.K1Div2Luminance, JPEGQTable.K2Div2Chrominance};
                }
            }
            progressiveMode = param.getProgressiveMode();
            if (param instanceof JPEGImageWriteParam) {
                jparam = (JPEGImageWriteParam)param;
                optimizeHuffman = jparam.getOptimizeHuffmanTables();
            }
        }
        if ((mdata = image.getMetadata()) != null) {
            if (mdata instanceof JPEGMetadata) {
                this.metadata = (JPEGMetadata)mdata;
                if (this.debug) {
                    System.out.println("We have metadata, and it's JPEG metadata");
                }
            } else if (!rasterOnly) {
                ImageTypeSpecifier type = destType;
                if (type == null) {
                    type = new ImageTypeSpecifier(rimage);
                }
                this.metadata = (JPEGMetadata)this.convertImageMetadata(mdata, type, param);
            } else {
                this.warningOccurred(7);
            }
        }
        this.ignoreJFIF = false;
        this.ignoreAdobe = false;
        this.newAdobeTransform = -1;
        this.writeDefaultJFIF = false;
        this.writeAdobe = false;
        int inCsType = 0;
        int outCsType = 0;
        JFIFMarkerSegment jfif = null;
        AdobeMarkerSegment adobe = null;
        SOFMarkerSegment sof = null;
        if (this.metadata != null) {
            jfif = (JFIFMarkerSegment)this.metadata.findMarkerSegment(JFIFMarkerSegment.class, true);
            adobe = (AdobeMarkerSegment)this.metadata.findMarkerSegment(AdobeMarkerSegment.class, true);
            sof = (SOFMarkerSegment)this.metadata.findMarkerSegment(SOFMarkerSegment.class, true);
        }
        this.iccProfile = null;
        this.convertTosRGB = false;
        this.converted = null;
        if (destType != null) {
            if (numBandsUsed != destType.getNumBands()) {
                throw new IIOException("Number of source bands != number of destination bands");
            }
            cs = destType.getColorModel().getColorSpace();
            if (this.metadata != null) {
                this.checkSOFBands(sof, numBandsUsed);
                this.checkJFIF(jfif, destType, false);
                if (jfif != null && !this.ignoreJFIF && JPEG.isNonStandardICC(cs)) {
                    this.iccProfile = ((ICC_ColorSpace)cs).getProfile();
                }
                this.checkAdobe(adobe, destType, false);
            } else {
                if (JPEG.isJFIFcompliant(destType, false)) {
                    this.writeDefaultJFIF = true;
                    if (JPEG.isNonStandardICC(cs)) {
                        this.iccProfile = ((ICC_ColorSpace)cs).getProfile();
                    }
                } else {
                    int transform = JPEG.transformForType(destType, false);
                    if (transform != -1) {
                        this.writeAdobe = true;
                        this.newAdobeTransform = transform;
                    }
                }
                this.metadata = new JPEGMetadata(destType, null, this);
            }
            inCsType = this.getSrcCSType(destType);
            outCsType = this.getDefaultDestCSType(destType);
        } else if (this.metadata == null) {
            if (fullImage) {
                this.metadata = new JPEGMetadata(new ImageTypeSpecifier(rimage), param, this);
                if (this.metadata.findMarkerSegment(JFIFMarkerSegment.class, true) != null && JPEG.isNonStandardICC(cs = rimage.getColorModel().getColorSpace())) {
                    this.iccProfile = ((ICC_ColorSpace)cs).getProfile();
                }
                inCsType = this.getSrcCSType(rimage);
                outCsType = this.getDefaultDestCSType(rimage);
            }
        } else {
            this.checkSOFBands(sof, numBandsUsed);
            if (fullImage) {
                ImageTypeSpecifier inputType = new ImageTypeSpecifier(rimage);
                inCsType = this.getSrcCSType(rimage);
                if (cm != null) {
                    boolean alpha = cm.hasAlpha();
                    block5 : switch (cs.getType()) {
                        case 6: {
                            if (!alpha) {
                                outCsType = 1;
                            } else if (jfif != null) {
                                this.ignoreJFIF = true;
                                this.warningOccurred(5);
                            }
                            if (adobe == null || adobe.transform == 0) break;
                            this.newAdobeTransform = 0;
                            this.warningOccurred(6);
                            break;
                        }
                        case 5: {
                            boolean subsampled;
                            int outCS;
                            if (!alpha) {
                                if (jfif != null) {
                                    outCsType = 3;
                                    if (!JPEG.isNonStandardICC(cs) && (!(cs instanceof ICC_ColorSpace) || jfif.iccSegment == null)) break;
                                    this.iccProfile = ((ICC_ColorSpace)cs).getProfile();
                                    break;
                                }
                                if (adobe != null) {
                                    switch (adobe.transform) {
                                        case 0: {
                                            outCsType = 2;
                                            break block5;
                                        }
                                        case 1: {
                                            outCsType = 3;
                                            break block5;
                                        }
                                    }
                                    this.warningOccurred(6);
                                    this.newAdobeTransform = 0;
                                    outCsType = 2;
                                    break;
                                }
                                outCS = sof.getIDencodedCSType();
                                if (outCS != 0) {
                                    outCsType = outCS;
                                    break;
                                }
                                subsampled = this.isSubsampled(sof.componentSpecs);
                                if (subsampled) {
                                    outCsType = 3;
                                    break;
                                }
                                outCsType = 2;
                                break;
                            }
                            if (jfif != null) {
                                this.ignoreJFIF = true;
                                this.warningOccurred(5);
                            }
                            if (adobe != null) {
                                if (adobe.transform != 0) {
                                    this.newAdobeTransform = 0;
                                    this.warningOccurred(6);
                                }
                                outCsType = 6;
                                break;
                            }
                            outCS = sof.getIDencodedCSType();
                            if (outCS != 0) {
                                outCsType = outCS;
                                break;
                            }
                            subsampled = this.isSubsampled(sof.componentSpecs);
                            outCsType = subsampled ? 7 : 6;
                            break;
                        }
                        case 13: {
                            if (cs != JPEG.YCC) break;
                            if (!alpha) {
                                if (jfif != null) {
                                    this.convertTosRGB = true;
                                    this.convertOp = new ColorConvertOp(cs, JPEG.sRGB, null);
                                    outCsType = 3;
                                    break;
                                }
                                if (adobe != null) {
                                    if (adobe.transform != 1) {
                                        this.newAdobeTransform = 1;
                                        this.warningOccurred(6);
                                    }
                                    outCsType = 5;
                                    break;
                                }
                                outCsType = 5;
                                break;
                            }
                            if (jfif != null) {
                                this.ignoreJFIF = true;
                                this.warningOccurred(5);
                            } else if (adobe != null && adobe.transform != 0) {
                                this.newAdobeTransform = 0;
                                this.warningOccurred(6);
                            }
                            outCsType = 10;
                        }
                    }
                }
            }
        }
        boolean metadataProgressive = false;
        int[] scans = null;
        if (this.metadata != null) {
            if (sof == null) {
                sof = (SOFMarkerSegment)this.metadata.findMarkerSegment(SOFMarkerSegment.class, true);
            }
            if (sof != null && sof.tag == 194) {
                metadataProgressive = true;
                if (progressiveMode == 3) {
                    scans = this.collectScans(this.metadata, sof);
                } else {
                    this.numScans = 0;
                }
            }
            if (jfif == null) {
                jfif = (JFIFMarkerSegment)this.metadata.findMarkerSegment(JFIFMarkerSegment.class, true);
            }
        }
        this.thumbnails = image.getThumbnails();
        int numThumbs = image.getNumThumbnails();
        this.forceJFIF = false;
        if (!this.writeDefaultJFIF) {
            if (this.metadata == null) {
                this.thumbnails = null;
                if (numThumbs != 0) {
                    this.warningOccurred(10);
                }
            } else if (!fullImage) {
                if (jfif == null) {
                    this.thumbnails = null;
                    if (numThumbs != 0) {
                        this.warningOccurred(10);
                    }
                }
            } else if (jfif == null) {
                if (outCsType == 1 || outCsType == 3) {
                    if (numThumbs != 0) {
                        this.forceJFIF = true;
                        this.warningOccurred(11);
                    }
                } else {
                    this.thumbnails = null;
                    if (numThumbs != 0) {
                        this.warningOccurred(10);
                    }
                }
            }
        }
        boolean haveMetadata = this.metadata != null || this.writeDefaultJFIF || this.writeAdobe;
        boolean writeDQT = true;
        boolean writeDHT = true;
        DQTMarkerSegment dqt = null;
        DHTMarkerSegment dht = null;
        int restartInterval = 0;
        if (this.metadata != null) {
            dqt = (DQTMarkerSegment)this.metadata.findMarkerSegment(DQTMarkerSegment.class, true);
            dht = (DHTMarkerSegment)this.metadata.findMarkerSegment(DHTMarkerSegment.class, true);
            DRIMarkerSegment dri = (DRIMarkerSegment)this.metadata.findMarkerSegment(DRIMarkerSegment.class, true);
            if (dri != null) {
                restartInterval = dri.restartInterval;
            }
            if (dqt == null) {
                writeDQT = false;
            }
            if (dht == null) {
                writeDHT = false;
            }
        }
        if (qTables == null) {
            qTables = dqt != null ? this.collectQTablesFromMetadata(this.metadata) : (this.streamQTables != null ? this.streamQTables : (jparam != null && jparam.areTablesSet() ? jparam.getQTables() : JPEG.getDefaultQTables()));
        }
        if (!optimizeHuffman) {
            if (dht != null && !metadataProgressive) {
                DCHuffmanTables = this.collectHTablesFromMetadata(this.metadata, true);
                ACHuffmanTables = this.collectHTablesFromMetadata(this.metadata, false);
            } else if (this.streamDCHuffmanTables != null) {
                DCHuffmanTables = this.streamDCHuffmanTables;
                ACHuffmanTables = this.streamACHuffmanTables;
            } else if (jparam != null && jparam.areTablesSet()) {
                DCHuffmanTables = jparam.getDCHuffmanTables();
                ACHuffmanTables = jparam.getACHuffmanTables();
            } else {
                DCHuffmanTables = JPEG.getDefaultHuffmanTables(true);
                ACHuffmanTables = JPEG.getDefaultHuffmanTables(false);
            }
        }
        int[] componentIds = new int[numBandsUsed];
        int[] HsamplingFactors = new int[numBandsUsed];
        int[] VsamplingFactors = new int[numBandsUsed];
        int[] QtableSelectors = new int[numBandsUsed];
        for (i = 0; i < numBandsUsed; ++i) {
            componentIds[i] = i + 1;
            HsamplingFactors[i] = 1;
            VsamplingFactors[i] = 1;
            QtableSelectors[i] = 0;
        }
        if (sof != null) {
            for (i = 0; i < numBandsUsed; ++i) {
                if (!this.forceJFIF) {
                    componentIds[i] = sof.componentSpecs[i].componentId;
                }
                HsamplingFactors[i] = sof.componentSpecs[i].HsamplingFactor;
                VsamplingFactors[i] = sof.componentSpecs[i].VsamplingFactor;
                QtableSelectors[i] = sof.componentSpecs[i].QtableSelector;
            }
        }
        this.sourceXOffset += gridX;
        this.sourceWidth -= gridX;
        this.sourceYOffset += gridY;
        this.sourceHeight -= gridY;
        int destWidth = (this.sourceWidth + periodX - 1) / periodX;
        int destHeight = (this.sourceHeight + periodY - 1) / periodY;
        int lineSize = this.sourceWidth * numBandsUsed;
        DataBufferByte buffer = new DataBufferByte(lineSize);
        int[] bandOffs = JPEG.bandOffsets[numBandsUsed - 1];
        this.raster = Raster.createInterleavedRaster(buffer, this.sourceWidth, 1, lineSize, numBandsUsed, bandOffs, null);
        this.processImageStarted(this.currentImage);
        boolean aborted = false;
        if (this.debug) {
            System.out.println("inCsType: " + inCsType);
            System.out.println("outCsType: " + outCsType);
        }
        if (aborted = this.writeImage(this.structPointer, buffer.getData(), inCsType, outCsType, numBandsUsed, bandSizes, this.sourceWidth, destWidth, destHeight, periodX, periodY, qTables, writeDQT, DCHuffmanTables, ACHuffmanTables, writeDHT, optimizeHuffman, progressiveMode != 0, this.numScans, scans, componentIds, HsamplingFactors, VsamplingFactors, QtableSelectors, haveMetadata, restartInterval)) {
            this.processWriteAborted();
        } else {
            this.processImageComplete();
        }
        this.ios.flush();
        ++this.currentImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareWriteSequence(IIOMetadata streamMetadata) throws IOException {
        this.setThreadLock();
        try {
            this.prepareWriteSequenceOnThread(streamMetadata);
        }
        finally {
            this.clearThreadLock();
        }
    }

    private void prepareWriteSequenceOnThread(IIOMetadata streamMetadata) throws IOException {
        if (this.ios == null) {
            throw new IllegalStateException("Output has not been set!");
        }
        if (streamMetadata != null) {
            if (streamMetadata instanceof JPEGMetadata) {
                JPEGMetadata jmeta = (JPEGMetadata)streamMetadata;
                if (!jmeta.isStream) {
                    throw new IllegalArgumentException("Invalid stream metadata object.");
                }
                if (this.currentImage != 0) {
                    throw new IIOException("JPEG Stream metadata must precede all images");
                }
                if (this.sequencePrepared) {
                    throw new IIOException("Stream metadata already written!");
                }
                this.streamQTables = this.collectQTablesFromMetadata(jmeta);
                if (this.debug) {
                    System.out.println("after collecting from stream metadata, streamQTables.length is " + this.streamQTables.length);
                }
                if (this.streamQTables == null) {
                    this.streamQTables = JPEG.getDefaultQTables();
                }
                this.streamDCHuffmanTables = this.collectHTablesFromMetadata(jmeta, true);
                if (this.streamDCHuffmanTables == null) {
                    this.streamDCHuffmanTables = JPEG.getDefaultHuffmanTables(true);
                }
                this.streamACHuffmanTables = this.collectHTablesFromMetadata(jmeta, false);
                if (this.streamACHuffmanTables == null) {
                    this.streamACHuffmanTables = JPEG.getDefaultHuffmanTables(false);
                }
                this.writeTables(this.structPointer, this.streamQTables, this.streamDCHuffmanTables, this.streamACHuffmanTables);
            } else {
                throw new IIOException("Stream metadata must be JPEG metadata");
            }
        }
        this.sequencePrepared = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToSequence(IIOImage image, ImageWriteParam param) throws IOException {
        this.setThreadLock();
        try {
            if (!this.sequencePrepared) {
                throw new IllegalStateException("sequencePrepared not called!");
            }
            this.write(null, image, param);
        }
        finally {
            this.clearThreadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endWriteSequence() throws IOException {
        this.setThreadLock();
        try {
            if (!this.sequencePrepared) {
                throw new IllegalStateException("sequencePrepared not called!");
            }
            this.sequencePrepared = false;
        }
        finally {
            this.clearThreadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void abort() {
        this.setThreadLock();
        try {
            super.abort();
            this.abortWrite(this.structPointer);
        }
        finally {
            this.clearThreadLock();
        }
    }

    private void resetInternalState() {
        this.resetWriter(this.structPointer);
        this.srcRas = null;
        this.raster = null;
        this.convertTosRGB = false;
        this.currentImage = 0;
        this.numScans = 0;
        this.metadata = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.setThreadLock();
        try {
            super.reset();
        }
        finally {
            this.clearThreadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.setThreadLock();
        try {
            if (this.structPointer != 0L) {
                this.disposerRecord.dispose();
                this.structPointer = 0L;
            }
        }
        finally {
            this.clearThreadLock();
        }
    }

    void warningOccurred(int code) {
        if (code < 0 || code > 15) {
            throw new InternalError("Invalid warning index");
        }
        this.processWarningOccurred(this.currentImage, "com.sun.imageio.plugins.jpeg.JPEGImageWriterResources", Integer.toString(code));
    }

    void warningWithMessage(String msg) {
        this.processWarningOccurred(this.currentImage, msg);
    }

    void thumbnailStarted(int thumbnailIndex) {
        this.processThumbnailStarted(this.currentImage, thumbnailIndex);
    }

    void thumbnailProgress(float percentageDone) {
        this.processThumbnailProgress(percentageDone);
    }

    void thumbnailComplete() {
        this.processThumbnailComplete();
    }

    private void checkSOFBands(SOFMarkerSegment sof, int numBandsUsed) throws IIOException {
        if (sof != null && sof.componentSpecs.length != numBandsUsed) {
            throw new IIOException("Metadata components != number of destination bands");
        }
    }

    private void checkJFIF(JFIFMarkerSegment jfif, ImageTypeSpecifier type, boolean input) {
        if (jfif != null && !JPEG.isJFIFcompliant(type, input)) {
            this.ignoreJFIF = true;
            this.warningOccurred(input ? 5 : 3);
        }
    }

    private void checkAdobe(AdobeMarkerSegment adobe, ImageTypeSpecifier type, boolean input) {
        int rightTransform;
        if (adobe != null && adobe.transform != (rightTransform = JPEG.transformForType(type, input))) {
            this.warningOccurred(input ? 6 : 4);
            if (rightTransform == -1) {
                this.ignoreAdobe = true;
            } else {
                this.newAdobeTransform = rightTransform;
            }
        }
    }

    private int[] collectScans(JPEGMetadata metadata, SOFMarkerSegment sof) {
        ArrayList<MarkerSegment> segments = new ArrayList<MarkerSegment>();
        int SCAN_SIZE = 9;
        int MAX_COMPS_PER_SCAN = 4;
        for (MarkerSegment seg : metadata.markerSequence) {
            if (!(seg instanceof SOSMarkerSegment)) continue;
            segments.add(seg);
        }
        int[] retval = null;
        this.numScans = 0;
        if (!segments.isEmpty()) {
            this.numScans = segments.size();
            retval = new int[this.numScans * SCAN_SIZE];
            int index = 0;
            for (int i = 0; i < this.numScans; ++i) {
                SOSMarkerSegment sos = (SOSMarkerSegment)segments.get(i);
                retval[index++] = sos.componentSpecs.length;
                block2: for (int j = 0; j < MAX_COMPS_PER_SCAN; ++j) {
                    if (j < sos.componentSpecs.length) {
                        int compSel = sos.componentSpecs[j].componentSelector;
                        for (int k = 0; k < sof.componentSpecs.length; ++k) {
                            if (compSel != sof.componentSpecs[k].componentId) continue;
                            retval[index++] = k;
                            continue block2;
                        }
                        continue;
                    }
                    retval[index++] = 0;
                }
                retval[index++] = sos.startSpectralSelection;
                retval[index++] = sos.endSpectralSelection;
                retval[index++] = sos.approxHigh;
                retval[index++] = sos.approxLow;
            }
        }
        return retval;
    }

    private JPEGQTable[] collectQTablesFromMetadata(JPEGMetadata metadata) {
        ArrayList tables = new ArrayList();
        for (MarkerSegment seg : metadata.markerSequence) {
            if (!(seg instanceof DQTMarkerSegment)) continue;
            DQTMarkerSegment dqt = (DQTMarkerSegment)seg;
            tables.addAll(dqt.tables);
        }
        JPEGQTable[] retval = null;
        if (tables.size() != 0) {
            retval = new JPEGQTable[tables.size()];
            for (int i = 0; i < retval.length; ++i) {
                retval[i] = new JPEGQTable(((DQTMarkerSegment.Qtable)tables.get((int)i)).data);
            }
        }
        return retval;
    }

    private JPEGHuffmanTable[] collectHTablesFromMetadata(JPEGMetadata metadata, boolean wantDC) throws IIOException {
        int i;
        ArrayList<DHTMarkerSegment.Htable> tables = new ArrayList<DHTMarkerSegment.Htable>();
        for (MarkerSegment seg : metadata.markerSequence) {
            if (!(seg instanceof DHTMarkerSegment)) continue;
            DHTMarkerSegment dht = (DHTMarkerSegment)seg;
            for (i = 0; i < dht.tables.size(); ++i) {
                DHTMarkerSegment.Htable htable = (DHTMarkerSegment.Htable)dht.tables.get(i);
                if (htable.tableClass != (wantDC ? 0 : 1)) continue;
                tables.add(htable);
            }
        }
        JPEGHuffmanTable[] retval = null;
        if (tables.size() != 0) {
            DHTMarkerSegment.Htable[] htables = new DHTMarkerSegment.Htable[tables.size()];
            tables.toArray(htables);
            retval = new JPEGHuffmanTable[tables.size()];
            for (i = 0; i < retval.length; ++i) {
                retval[i] = null;
                for (int j = 0; j < tables.size(); ++j) {
                    if (htables[j].tableID != i) continue;
                    if (retval[i] != null) {
                        throw new IIOException("Metadata has duplicate Htables!");
                    }
                    retval[i] = new JPEGHuffmanTable(htables[j].numCodes, htables[j].values);
                }
            }
        }
        return retval;
    }

    private int getSrcCSType(ImageTypeSpecifier type) {
        return this.getSrcCSType(type.getColorModel());
    }

    private int getSrcCSType(RenderedImage rimage) {
        return this.getSrcCSType(rimage.getColorModel());
    }

    private int getSrcCSType(ColorModel cm) {
        int retval = 0;
        if (cm != null) {
            boolean alpha = cm.hasAlpha();
            ColorSpace cs = cm.getColorSpace();
            switch (cs.getType()) {
                case 6: {
                    retval = 1;
                    break;
                }
                case 5: {
                    if (alpha) {
                        retval = 6;
                        break;
                    }
                    retval = 2;
                    break;
                }
                case 3: {
                    if (alpha) {
                        retval = 7;
                        break;
                    }
                    retval = 3;
                    break;
                }
                case 13: {
                    if (cs == JPEG.YCC) {
                        retval = alpha ? 10 : 5;
                    }
                }
                case 9: {
                    retval = 4;
                }
            }
        }
        return retval;
    }

    private int getDestCSType(ImageTypeSpecifier destType) {
        ColorModel cm = destType.getColorModel();
        boolean alpha = cm.hasAlpha();
        ColorSpace cs = cm.getColorSpace();
        int retval = 0;
        switch (cs.getType()) {
            case 6: {
                retval = 1;
                break;
            }
            case 5: {
                if (alpha) {
                    retval = 6;
                    break;
                }
                retval = 2;
                break;
            }
            case 3: {
                if (alpha) {
                    retval = 7;
                    break;
                }
                retval = 3;
                break;
            }
            case 13: {
                if (cs == JPEG.YCC) {
                    retval = alpha ? 10 : 5;
                }
            }
            case 9: {
                retval = 4;
            }
        }
        return retval;
    }

    private int getDefaultDestCSType(ImageTypeSpecifier type) {
        return this.getDefaultDestCSType(type.getColorModel());
    }

    private int getDefaultDestCSType(RenderedImage rimage) {
        return this.getDefaultDestCSType(rimage.getColorModel());
    }

    private int getDefaultDestCSType(ColorModel cm) {
        int retval = 0;
        if (cm != null) {
            boolean alpha = cm.hasAlpha();
            ColorSpace cs = cm.getColorSpace();
            switch (cs.getType()) {
                case 6: {
                    retval = 1;
                    break;
                }
                case 5: {
                    if (alpha) {
                        retval = 7;
                        break;
                    }
                    retval = 3;
                    break;
                }
                case 3: {
                    if (alpha) {
                        retval = 7;
                        break;
                    }
                    retval = 3;
                    break;
                }
                case 13: {
                    if (cs == JPEG.YCC) {
                        retval = alpha ? 10 : 5;
                    }
                }
                case 9: {
                    retval = 11;
                }
            }
        }
        return retval;
    }

    private boolean isSubsampled(SOFMarkerSegment.ComponentSpec[] specs) {
        int hsamp0 = specs[0].HsamplingFactor;
        int vsamp0 = specs[0].VsamplingFactor;
        for (int i = 1; i < specs.length; ++i) {
            if (specs[i].HsamplingFactor == hsamp0 && specs[i].HsamplingFactor == hsamp0) continue;
            return true;
        }
        return false;
    }

    private static native void initWriterIDs(Class var0, Class var1, Class var2);

    private native long initJPEGImageWriter();

    private native void setDest(long var1, ImageOutputStream var3);

    private native boolean writeImage(long var1, byte[] var3, int var4, int var5, int var6, int[] var7, int var8, int var9, int var10, int var11, int var12, JPEGQTable[] var13, boolean var14, JPEGHuffmanTable[] var15, JPEGHuffmanTable[] var16, boolean var17, boolean var18, boolean var19, int var20, int[] var21, int[] var22, int[] var23, int[] var24, int[] var25, boolean var26, int var27);

    private void writeMetadata() throws IOException {
        if (this.metadata == null) {
            if (this.writeDefaultJFIF) {
                JFIFMarkerSegment.writeDefaultJFIF(this.ios, this.thumbnails, this.iccProfile, this);
            }
            if (this.writeAdobe) {
                AdobeMarkerSegment.writeAdobeSegment(this.ios, this.newAdobeTransform);
            }
        } else {
            this.metadata.writeToStream(this.ios, this.ignoreJFIF, this.forceJFIF, this.thumbnails, this.iccProfile, this.ignoreAdobe, this.newAdobeTransform, this);
        }
    }

    private native void writeTables(long var1, JPEGQTable[] var3, JPEGHuffmanTable[] var4, JPEGHuffmanTable[] var5);

    private void grabPixels(int y) {
        Raster sourceLine = null;
        if (this.indexed) {
            sourceLine = this.srcRas.createChild(this.sourceXOffset, this.sourceYOffset + y, this.sourceWidth, 1, 0, 0, new int[]{0});
            boolean forceARGB = this.indexCM.getTransparency() != 1;
            BufferedImage temp = this.indexCM.convertToIntDiscrete(sourceLine, forceARGB);
            sourceLine = temp.getRaster();
        } else {
            sourceLine = this.srcRas.createChild(this.sourceXOffset, this.sourceYOffset + y, this.sourceWidth, 1, 0, 0, this.srcBands);
        }
        if (this.convertTosRGB) {
            if (this.debug) {
                System.out.println("Converting to sRGB");
            }
            this.converted = this.convertOp.filter(sourceLine, this.converted);
            sourceLine = this.converted;
        }
        if (this.isAlphaPremultiplied) {
            WritableRaster wr = sourceLine.createCompatibleWritableRaster();
            int[] data = null;
            data = sourceLine.getPixels(sourceLine.getMinX(), sourceLine.getMinY(), sourceLine.getWidth(), sourceLine.getHeight(), data);
            wr.setPixels(sourceLine.getMinX(), sourceLine.getMinY(), sourceLine.getWidth(), sourceLine.getHeight(), data);
            this.srcCM.coerceData(wr, false);
            sourceLine = wr.createChild(wr.getMinX(), wr.getMinY(), wr.getWidth(), wr.getHeight(), 0, 0, this.srcBands);
        }
        this.raster.setRect(sourceLine);
        if (y > 7 && y % 8 == 0) {
            this.processImageProgress((float)y / (float)this.sourceHeight * 100.0f);
        }
    }

    private native void abortWrite(long var1);

    private native void resetWriter(long var1);

    private static native void disposeWriter(long var0);

    private synchronized void setThreadLock() {
        Thread currThread = Thread.currentThread();
        if (this.theThread != null) {
            if (this.theThread != currThread) {
                throw new IllegalStateException("Attempt to use instance of " + this + " locked on thread " + this.theThread + " from thread " + currThread);
            }
            ++this.theLockCount;
        } else {
            this.theThread = currThread;
            this.theLockCount = 1;
        }
    }

    private synchronized void clearThreadLock() {
        Thread currThread = Thread.currentThread();
        if (this.theThread == null || this.theThread != currThread) {
            throw new IllegalStateException("Attempt to clear thread lock form wrong thread. Locked thread: " + this.theThread + "; current thread: " + currThread);
        }
        --this.theLockCount;
        if (this.theLockCount == 0) {
            this.theThread = null;
        }
    }

    static {
        AccessController.doPrivileged(new LoadLibraryAction("jpeg"));
        JPEGImageWriter.initWriterIDs(ImageOutputStream.class, JPEGQTable.class, JPEGHuffmanTable.class);
        preferredThumbSizes = new Dimension[]{new Dimension(1, 1), new Dimension(255, 255)};
    }

    private static class JPEGWriterDisposerRecord
    implements DisposerRecord {
        private long pData;

        public JPEGWriterDisposerRecord(long pData) {
            this.pData = pData;
        }

        public synchronized void dispose() {
            if (this.pData != 0L) {
                JPEGImageWriter.disposeWriter(this.pData);
                this.pData = 0L;
            }
        }
    }
}

