/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.jpeg;

import com.sun.imageio.plugins.jpeg.JPEG;
import com.sun.imageio.plugins.jpeg.JPEGBuffer;
import com.sun.imageio.plugins.jpeg.JPEGImageReader;
import com.sun.imageio.plugins.jpeg.JPEGImageWriter;
import com.sun.imageio.plugins.jpeg.JPEGMetadata;
import com.sun.imageio.plugins.jpeg.MarkerSegment;
import com.sun.imageio.plugins.jpeg.SOFMarkerSegment;
import java.awt.Graphics;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class JFIFMarkerSegment
extends MarkerSegment {
    int majorVersion;
    int minorVersion;
    int resUnits;
    int Xdensity;
    int Ydensity;
    int thumbWidth;
    int thumbHeight;
    JFIFThumbRGB thumb = null;
    ArrayList extSegments = new ArrayList();
    ICCMarkerSegment iccSegment = null;
    private static final int THUMB_JPEG = 16;
    private static final int THUMB_PALETTE = 17;
    private static final int THUMB_UNASSIGNED = 18;
    private static final int THUMB_RGB = 19;
    private static final int DATA_SIZE = 14;
    private static final int ID_SIZE = 5;
    private final int MAX_THUMB_WIDTH = 255;
    private final int MAX_THUMB_HEIGHT = 255;
    private final boolean debug = false;
    private boolean inICC = false;
    private ICCMarkerSegment tempICCSegment = null;

    JFIFMarkerSegment() {
        super(224);
        this.majorVersion = 1;
        this.minorVersion = 2;
        this.resUnits = 0;
        this.Xdensity = 1;
        this.Ydensity = 1;
        this.thumbWidth = 0;
        this.thumbHeight = 0;
    }

    JFIFMarkerSegment(JPEGBuffer buffer) throws IOException {
        super(buffer);
        buffer.bufPtr += 5;
        this.majorVersion = buffer.buf[buffer.bufPtr++];
        this.minorVersion = buffer.buf[buffer.bufPtr++];
        this.resUnits = buffer.buf[buffer.bufPtr++];
        this.Xdensity = (buffer.buf[buffer.bufPtr++] & 0xFF) << 8;
        this.Xdensity |= buffer.buf[buffer.bufPtr++] & 0xFF;
        this.Ydensity = (buffer.buf[buffer.bufPtr++] & 0xFF) << 8;
        this.Ydensity |= buffer.buf[buffer.bufPtr++] & 0xFF;
        this.thumbWidth = buffer.buf[buffer.bufPtr++] & 0xFF;
        this.thumbHeight = buffer.buf[buffer.bufPtr++] & 0xFF;
        buffer.bufAvail -= 14;
        if (this.thumbWidth > 0) {
            this.thumb = new JFIFThumbRGB(buffer, this.thumbWidth, this.thumbHeight);
        }
    }

    JFIFMarkerSegment(Node node) throws IIOInvalidTreeException {
        this();
        this.updateFromNativeNode(node, true);
    }

    protected Object clone() {
        JFIFMarkerSegment newGuy = (JFIFMarkerSegment)super.clone();
        if (!this.extSegments.isEmpty()) {
            newGuy.extSegments = new ArrayList();
            for (JFIFExtensionMarkerSegment jfxx : this.extSegments) {
                newGuy.extSegments.add(jfxx.clone());
            }
        }
        if (this.iccSegment != null) {
            newGuy.iccSegment = (ICCMarkerSegment)this.iccSegment.clone();
        }
        return newGuy;
    }

    void addJFXX(JPEGBuffer buffer, JPEGImageReader reader) throws IOException {
        this.extSegments.add(new JFIFExtensionMarkerSegment(buffer, reader));
    }

    void addICC(JPEGBuffer buffer) throws IOException {
        if (!this.inICC) {
            if (this.iccSegment != null) {
                throw new IIOException("> 1 ICC APP2 Marker Segment not supported");
            }
            this.tempICCSegment = new ICCMarkerSegment(buffer);
            if (!this.inICC) {
                this.iccSegment = this.tempICCSegment;
                this.tempICCSegment = null;
            }
        } else if (this.tempICCSegment.addData(buffer)) {
            this.iccSegment = this.tempICCSegment;
            this.tempICCSegment = null;
        }
    }

    void addICC(ICC_ColorSpace cs) throws IOException {
        if (this.iccSegment != null) {
            throw new IIOException("> 1 ICC APP2 Marker Segment not supported");
        }
        this.iccSegment = new ICCMarkerSegment(cs);
    }

    IIOMetadataNode getNativeNode() {
        IIOMetadataNode node = new IIOMetadataNode("app0JFIF");
        node.setAttribute("majorVersion", Integer.toString(this.majorVersion));
        node.setAttribute("minorVersion", Integer.toString(this.minorVersion));
        node.setAttribute("resUnits", Integer.toString(this.resUnits));
        node.setAttribute("Xdensity", Integer.toString(this.Xdensity));
        node.setAttribute("Ydensity", Integer.toString(this.Ydensity));
        node.setAttribute("thumbWidth", Integer.toString(this.thumbWidth));
        node.setAttribute("thumbHeight", Integer.toString(this.thumbHeight));
        if (!this.extSegments.isEmpty()) {
            IIOMetadataNode JFXXnode = new IIOMetadataNode("JFXX");
            node.appendChild(JFXXnode);
            for (JFIFExtensionMarkerSegment seg : this.extSegments) {
                JFXXnode.appendChild(seg.getNativeNode());
            }
        }
        if (this.iccSegment != null) {
            node.appendChild(this.iccSegment.getNativeNode());
        }
        return node;
    }

    void updateFromNativeNode(Node node, boolean fromScratch) throws IIOInvalidTreeException {
        NamedNodeMap attrs = node.getAttributes();
        if (attrs.getLength() > 0) {
            int value = JFIFMarkerSegment.getAttributeValue(node, attrs, "majorVersion", 0, 255, false);
            this.majorVersion = value != -1 ? value : this.majorVersion;
            value = JFIFMarkerSegment.getAttributeValue(node, attrs, "minorVersion", 0, 255, false);
            this.minorVersion = value != -1 ? value : this.minorVersion;
            value = JFIFMarkerSegment.getAttributeValue(node, attrs, "resUnits", 0, 2, false);
            this.resUnits = value != -1 ? value : this.resUnits;
            value = JFIFMarkerSegment.getAttributeValue(node, attrs, "Xdensity", 1, 65535, false);
            this.Xdensity = value != -1 ? value : this.Xdensity;
            value = JFIFMarkerSegment.getAttributeValue(node, attrs, "Ydensity", 1, 65535, false);
            this.Ydensity = value != -1 ? value : this.Ydensity;
            value = JFIFMarkerSegment.getAttributeValue(node, attrs, "thumbWidth", 0, 255, false);
            this.thumbWidth = value != -1 ? value : this.thumbWidth;
            value = JFIFMarkerSegment.getAttributeValue(node, attrs, "thumbHeight", 0, 255, false);
            int n = this.thumbHeight = value != -1 ? value : this.thumbHeight;
        }
        if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            int count = children.getLength();
            if (count > 2) {
                throw new IIOInvalidTreeException("app0JFIF node cannot have > 2 children", node);
            }
            for (int i = 0; i < count; ++i) {
                Node child = children.item(i);
                String name = child.getNodeName();
                if (name.equals("JFXX")) {
                    if (!this.extSegments.isEmpty() && fromScratch) {
                        throw new IIOInvalidTreeException("app0JFIF node cannot have > 1 JFXX node", node);
                    }
                    NodeList exts = child.getChildNodes();
                    int extCount = exts.getLength();
                    for (int j = 0; j < extCount; ++j) {
                        Node ext = exts.item(j);
                        this.extSegments.add(new JFIFExtensionMarkerSegment(ext));
                    }
                }
                if (!name.equals("app2ICC")) continue;
                if (this.iccSegment != null && fromScratch) {
                    throw new IIOInvalidTreeException("> 1 ICC APP2 Marker Segment not supported", node);
                }
                this.iccSegment = new ICCMarkerSegment(child);
            }
        }
    }

    int getThumbnailWidth(int index) {
        if (this.thumb != null) {
            if (index == 0) {
                return this.thumb.getWidth();
            }
            --index;
        }
        JFIFExtensionMarkerSegment jfxx = (JFIFExtensionMarkerSegment)this.extSegments.get(index);
        return jfxx.thumb.getWidth();
    }

    int getThumbnailHeight(int index) {
        if (this.thumb != null) {
            if (index == 0) {
                return this.thumb.getHeight();
            }
            --index;
        }
        JFIFExtensionMarkerSegment jfxx = (JFIFExtensionMarkerSegment)this.extSegments.get(index);
        return jfxx.thumb.getHeight();
    }

    BufferedImage getThumbnail(ImageInputStream iis, int index, JPEGImageReader reader) throws IOException {
        reader.thumbnailStarted(index);
        BufferedImage ret = null;
        if (this.thumb != null && index == 0) {
            ret = this.thumb.getThumbnail(iis, reader);
        } else {
            if (this.thumb != null) {
                --index;
            }
            JFIFExtensionMarkerSegment jfxx = (JFIFExtensionMarkerSegment)this.extSegments.get(index);
            ret = jfxx.thumb.getThumbnail(iis, reader);
        }
        reader.thumbnailComplete();
        return ret;
    }

    void write(ImageOutputStream ios, JPEGImageWriter writer) throws IOException {
        this.write(ios, null, writer);
    }

    void write(ImageOutputStream ios, BufferedImage thumb, JPEGImageWriter writer) throws IOException {
        int thumbWidth = 0;
        int thumbHeight = 0;
        int thumbLength = 0;
        int[] thumbData = null;
        if (thumb != null) {
            thumbWidth = thumb.getWidth();
            thumbHeight = thumb.getHeight();
            if (thumbWidth > 255 || thumbHeight > 255) {
                writer.warningOccurred(12);
            }
            thumbWidth = Math.min(thumbWidth, 255);
            thumbHeight = Math.min(thumbHeight, 255);
            thumbData = thumb.getRaster().getPixels(0, 0, thumbWidth, thumbHeight, (int[])null);
            thumbLength = thumbData.length;
        }
        this.length = 16 + thumbLength;
        this.writeTag(ios);
        byte[] id = new byte[]{74, 70, 73, 70, 0};
        ios.write(id);
        ios.write(this.majorVersion);
        ios.write(this.minorVersion);
        ios.write(this.resUnits);
        JFIFMarkerSegment.write2bytes(ios, this.Xdensity);
        JFIFMarkerSegment.write2bytes(ios, this.Ydensity);
        ios.write(thumbWidth);
        ios.write(thumbHeight);
        if (thumbData != null) {
            writer.thumbnailStarted(0);
            this.writeThumbnailData(ios, thumbData, writer);
            writer.thumbnailComplete();
        }
    }

    void writeThumbnailData(ImageOutputStream ios, int[] thumbData, JPEGImageWriter writer) throws IOException {
        int progInterval = thumbData.length / 20;
        if (progInterval == 0) {
            progInterval = 1;
        }
        for (int i = 0; i < thumbData.length; ++i) {
            ios.write(thumbData[i]);
            if (i <= progInterval || i % progInterval != 0) continue;
            writer.thumbnailProgress((float)i * 100.0f / (float)thumbData.length);
        }
    }

    void writeWithThumbs(ImageOutputStream ios, List thumbnails, JPEGImageWriter writer) throws IOException {
        if (thumbnails != null) {
            JFIFExtensionMarkerSegment jfxx = null;
            if (thumbnails.size() == 1) {
                if (!this.extSegments.isEmpty()) {
                    jfxx = (JFIFExtensionMarkerSegment)this.extSegments.get(0);
                }
                this.writeThumb(ios, (BufferedImage)thumbnails.get(0), jfxx, 0, true, writer);
            } else {
                this.write(ios, writer);
                for (int i = 0; i < thumbnails.size(); ++i) {
                    jfxx = null;
                    if (i < this.extSegments.size()) {
                        jfxx = (JFIFExtensionMarkerSegment)this.extSegments.get(i);
                    }
                    this.writeThumb(ios, (BufferedImage)thumbnails.get(i), jfxx, i, false, writer);
                }
            }
        } else {
            this.write(ios, writer);
        }
    }

    private void writeThumb(ImageOutputStream ios, BufferedImage thumb, JFIFExtensionMarkerSegment jfxx, int index, boolean onlyOne, JPEGImageWriter writer) throws IOException {
        ColorModel cm = thumb.getColorModel();
        ColorSpace cs = cm.getColorSpace();
        if (cm instanceof IndexColorModel) {
            if (onlyOne) {
                this.write(ios, writer);
            }
            if (jfxx == null || jfxx.code == 17) {
                this.writeJFXXSegment(index, thumb, ios, writer);
            } else {
                BufferedImage thumbRGB = ((IndexColorModel)cm).convertToIntDiscrete(thumb.getRaster(), false);
                jfxx.setThumbnail(thumbRGB);
                writer.thumbnailStarted(index);
                jfxx.write(ios, writer);
                writer.thumbnailComplete();
            }
        } else if (cs.getType() == 5) {
            if (jfxx == null) {
                if (onlyOne) {
                    this.write(ios, thumb, writer);
                } else {
                    this.writeJFXXSegment(index, thumb, ios, writer);
                }
            } else {
                if (onlyOne) {
                    this.write(ios, writer);
                }
                if (jfxx.code == 17) {
                    this.writeJFXXSegment(index, thumb, ios, writer);
                    writer.warningOccurred(14);
                } else {
                    jfxx.setThumbnail(thumb);
                    writer.thumbnailStarted(index);
                    jfxx.write(ios, writer);
                    writer.thumbnailComplete();
                }
            }
        } else if (cs.getType() == 6) {
            if (jfxx == null) {
                if (onlyOne) {
                    BufferedImage thumbRGB = JFIFMarkerSegment.expandGrayThumb(thumb);
                    this.write(ios, thumbRGB, writer);
                } else {
                    this.writeJFXXSegment(index, thumb, ios, writer);
                }
            } else {
                if (onlyOne) {
                    this.write(ios, writer);
                }
                if (jfxx.code == 19) {
                    BufferedImage thumbRGB = JFIFMarkerSegment.expandGrayThumb(thumb);
                    this.writeJFXXSegment(index, thumbRGB, ios, writer);
                } else if (jfxx.code == 16) {
                    jfxx.setThumbnail(thumb);
                    writer.thumbnailStarted(index);
                    jfxx.write(ios, writer);
                    writer.thumbnailComplete();
                } else if (jfxx.code == 17) {
                    this.writeJFXXSegment(index, thumb, ios, writer);
                    writer.warningOccurred(15);
                }
            }
        } else {
            writer.warningOccurred(9);
        }
    }

    private void writeJFXXSegment(int index, BufferedImage thumbnail, ImageOutputStream ios, JPEGImageWriter writer) throws IOException {
        JFIFExtensionMarkerSegment jfxx = null;
        try {
            jfxx = new JFIFExtensionMarkerSegment(thumbnail);
        }
        catch (IllegalThumbException e) {
            writer.warningOccurred(9);
            return;
        }
        writer.thumbnailStarted(index);
        jfxx.write(ios, writer);
        writer.thumbnailComplete();
    }

    private static BufferedImage expandGrayThumb(BufferedImage thumb) {
        BufferedImage ret = new BufferedImage(thumb.getWidth(), thumb.getHeight(), 1);
        Graphics g = ret.getGraphics();
        g.drawImage(thumb, 0, 0, null);
        return ret;
    }

    static void writeDefaultJFIF(ImageOutputStream ios, List thumbnails, ICC_Profile iccProfile, JPEGImageWriter writer) throws IOException {
        JFIFMarkerSegment jfif = new JFIFMarkerSegment();
        jfif.writeWithThumbs(ios, thumbnails, writer);
        if (iccProfile != null) {
            JFIFMarkerSegment.writeICC(iccProfile, ios);
        }
    }

    void print() {
        this.printTag("JFIF");
        System.out.print("Version ");
        System.out.print(this.majorVersion);
        System.out.println(".0" + Integer.toString(this.minorVersion));
        System.out.print("Resolution units: ");
        System.out.println(this.resUnits);
        System.out.print("X density: ");
        System.out.println(this.Xdensity);
        System.out.print("Y density: ");
        System.out.println(this.Ydensity);
        System.out.print("Thumbnail Width: ");
        System.out.println(this.thumbWidth);
        System.out.print("Thumbnail Height: ");
        System.out.println(this.thumbHeight);
        if (!this.extSegments.isEmpty()) {
            for (JFIFExtensionMarkerSegment extSegment : this.extSegments) {
                extSegment.print();
            }
        }
        if (this.iccSegment != null) {
            this.iccSegment.print();
        }
    }

    static void writeICC(ICC_Profile profile, ImageOutputStream ios) throws IOException {
        int LENGTH_LENGTH = 2;
        String ID2 = "ICC_PROFILE";
        int ID_LENGTH = "ICC_PROFILE".length() + 1;
        int COUNTS_LENGTH = 2;
        int MAX_ICC_CHUNK_SIZE = 65535 - LENGTH_LENGTH - ID_LENGTH - COUNTS_LENGTH;
        byte[] data = profile.getData();
        int numChunks = data.length / MAX_ICC_CHUNK_SIZE;
        if (data.length % MAX_ICC_CHUNK_SIZE != 0) {
            ++numChunks;
        }
        int chunkNum = 1;
        int offset = 0;
        for (int i = 0; i < numChunks; ++i) {
            int dataLength = Math.min(data.length - offset, MAX_ICC_CHUNK_SIZE);
            int segLength = dataLength + COUNTS_LENGTH + ID_LENGTH + LENGTH_LENGTH;
            ios.write(255);
            ios.write(226);
            MarkerSegment.write2bytes(ios, segLength);
            byte[] id = "ICC_PROFILE".getBytes("US-ASCII");
            ios.write(id);
            ios.write(0);
            ios.write(chunkNum++);
            ios.write(numChunks);
            ios.write(data, offset, dataLength);
            offset += dataLength;
        }
    }

    class ICCMarkerSegment
    extends MarkerSegment {
        ArrayList chunks;
        byte[] profile;
        private static final int ID_SIZE = 12;
        int chunksRead;
        int numChunks;

        ICCMarkerSegment(ICC_ColorSpace cs) {
            super(226);
            this.chunks = null;
            this.profile = null;
            this.chunks = null;
            this.chunksRead = 0;
            this.numChunks = 0;
            this.profile = cs.getProfile().getData();
        }

        ICCMarkerSegment(JPEGBuffer buffer) throws IOException {
            super(buffer);
            this.chunks = null;
            this.profile = null;
            buffer.bufPtr += 12;
            buffer.bufAvail -= 12;
            this.length -= 12;
            int chunkNum = buffer.buf[buffer.bufPtr] & 0xFF;
            this.numChunks = buffer.buf[buffer.bufPtr + 1] & 0xFF;
            if (chunkNum > this.numChunks) {
                throw new IIOException("Image format Error; chunk num > num chunks");
            }
            if (this.numChunks == 1) {
                this.length -= 2;
                this.profile = new byte[this.length];
                buffer.bufPtr += 2;
                buffer.bufAvail -= 2;
                buffer.readData(this.profile);
                JFIFMarkerSegment.this.inICC = false;
            } else {
                byte[] profileData = new byte[this.length];
                this.length -= 2;
                buffer.readData(profileData);
                this.chunks = new ArrayList();
                this.chunks.add(profileData);
                this.chunksRead = 1;
                JFIFMarkerSegment.this.inICC = true;
            }
        }

        ICCMarkerSegment(Node node) throws IIOInvalidTreeException {
            IIOMetadataNode ourNode;
            ICC_Profile prof;
            super(226);
            this.chunks = null;
            this.profile = null;
            if (node instanceof IIOMetadataNode && (prof = (ICC_Profile)(ourNode = (IIOMetadataNode)node).getUserObject()) != null) {
                this.profile = prof.getData();
            }
        }

        protected Object clone() {
            ICCMarkerSegment newGuy = (ICCMarkerSegment)super.clone();
            if (this.profile != null) {
                newGuy.profile = (byte[])this.profile.clone();
            }
            return newGuy;
        }

        boolean addData(JPEGBuffer buffer) throws IOException {
            ++buffer.bufPtr;
            --buffer.bufAvail;
            int dataLen = (buffer.buf[buffer.bufPtr++] & 0xFF) << 8;
            dataLen |= buffer.buf[buffer.bufPtr++] & 0xFF;
            buffer.bufAvail -= 2;
            dataLen -= 2;
            buffer.bufPtr += 12;
            buffer.bufAvail -= 12;
            dataLen -= 12;
            int chunkNum = buffer.buf[buffer.bufPtr] & 0xFF;
            if (chunkNum > this.numChunks) {
                throw new IIOException("Image format Error; chunk num > num chunks");
            }
            int newNumChunks = buffer.buf[buffer.bufPtr + 1] & 0xFF;
            if (this.numChunks != newNumChunks) {
                throw new IIOException("Image format Error; icc num chunks mismatch");
            }
            boolean retval = false;
            byte[] profileData = new byte[dataLen -= 2];
            buffer.readData(profileData);
            this.chunks.add(profileData);
            this.length += dataLen;
            ++this.chunksRead;
            if (this.chunksRead < this.numChunks) {
                JFIFMarkerSegment.this.inICC = true;
            } else {
                this.profile = new byte[this.length];
                int index = 0;
                for (int i = 1; i <= this.numChunks; ++i) {
                    boolean foundIt = false;
                    for (int chunk = 0; chunk < this.chunks.size(); ++chunk) {
                        byte[] chunkData = (byte[])this.chunks.get(chunk);
                        if (chunkData[0] != i) continue;
                        System.arraycopy(chunkData, 2, this.profile, index, chunkData.length - 2);
                        index += chunkData.length - 2;
                        foundIt = true;
                    }
                    if (foundIt) continue;
                    throw new IIOException("Image Format Error: Missing ICC chunk num " + i);
                }
                this.chunks = null;
                this.chunksRead = 0;
                this.numChunks = 0;
                JFIFMarkerSegment.this.inICC = false;
                retval = true;
            }
            return retval;
        }

        IIOMetadataNode getNativeNode() {
            IIOMetadataNode node = new IIOMetadataNode("app2ICC");
            if (this.profile != null) {
                node.setUserObject(ICC_Profile.getInstance(this.profile));
            }
            return node;
        }

        void write(ImageOutputStream ios) throws IOException {
        }

        void print() {
            this.printTag("ICC Profile APP2");
        }
    }

    class JFIFThumbJPEG
    extends JFIFThumb {
        JPEGMetadata thumbMetadata;
        byte[] data;
        private static final int PREAMBLE_SIZE = 6;

        JFIFThumbJPEG(JPEGBuffer buffer, int length, JPEGImageReader reader) throws IOException {
            super(buffer);
            this.thumbMetadata = null;
            this.data = null;
            long finalPos = this.streamPos + (long)(length - 6);
            buffer.iis.seek(this.streamPos);
            this.thumbMetadata = new JPEGMetadata(false, true, buffer.iis, reader);
            buffer.iis.seek(finalPos);
            buffer.bufAvail = 0;
            buffer.bufPtr = 0;
        }

        JFIFThumbJPEG(Node node) throws IIOInvalidTreeException {
            this.thumbMetadata = null;
            this.data = null;
            if (node.getChildNodes().getLength() > 1) {
                throw new IIOInvalidTreeException("JFIFThumbJPEG node must have 0 or 1 child", node);
            }
            Node child = node.getFirstChild();
            if (child != null) {
                String name = child.getNodeName();
                if (!name.equals("markerSequence")) {
                    throw new IIOInvalidTreeException("JFIFThumbJPEG child must be a markerSequence node", node);
                }
                this.thumbMetadata = new JPEGMetadata(false, true);
                this.thumbMetadata.setFromMarkerSequenceNode(child);
            }
        }

        JFIFThumbJPEG(BufferedImage thumb) throws IllegalThumbException {
            this.thumbMetadata = null;
            this.data = null;
            int INITIAL_BUFSIZE = 4096;
            int MAZ_BUFSIZE = 65527;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(INITIAL_BUFSIZE);
                MemoryCacheImageOutputStream mos = new MemoryCacheImageOutputStream(baos);
                JPEGImageWriter thumbWriter = new JPEGImageWriter(null);
                thumbWriter.setOutput(mos);
                JPEGMetadata metadata = (JPEGMetadata)thumbWriter.getDefaultImageMetadata(new ImageTypeSpecifier(thumb), null);
                MarkerSegment jfif = metadata.findMarkerSegment(JFIFMarkerSegment.class, true);
                if (jfif == null) {
                    throw new IllegalThumbException();
                }
                metadata.markerSequence.remove(jfif);
                thumbWriter.write(new IIOImage(thumb, null, (IIOMetadata)metadata));
                thumbWriter.dispose();
                if (baos.size() > MAZ_BUFSIZE) {
                    throw new IllegalThumbException();
                }
                this.data = baos.toByteArray();
            }
            catch (IOException e) {
                throw new IllegalThumbException();
            }
        }

        int getWidth() {
            int retval = 0;
            SOFMarkerSegment sof = (SOFMarkerSegment)this.thumbMetadata.findMarkerSegment(SOFMarkerSegment.class, true);
            if (sof != null) {
                retval = sof.samplesPerLine;
            }
            return retval;
        }

        int getHeight() {
            int retval = 0;
            SOFMarkerSegment sof = (SOFMarkerSegment)this.thumbMetadata.findMarkerSegment(SOFMarkerSegment.class, true);
            if (sof != null) {
                retval = sof.numLines;
            }
            return retval;
        }

        BufferedImage getThumbnail(ImageInputStream iis, JPEGImageReader reader) throws IOException {
            iis.mark();
            iis.seek(this.streamPos);
            JPEGImageReader thumbReader = new JPEGImageReader(null);
            thumbReader.setInput(iis);
            thumbReader.addIIOReadProgressListener(new ThumbnailReadListener(reader));
            BufferedImage ret = thumbReader.read(0, null);
            thumbReader.dispose();
            iis.reset();
            return ret;
        }

        protected Object clone() {
            JFIFThumbJPEG newGuy = (JFIFThumbJPEG)super.clone();
            if (this.thumbMetadata != null) {
                newGuy.thumbMetadata = (JPEGMetadata)this.thumbMetadata.clone();
            }
            return newGuy;
        }

        IIOMetadataNode getNativeNode() {
            IIOMetadataNode node = new IIOMetadataNode("JFIFthumbJPEG");
            if (this.thumbMetadata != null) {
                node.appendChild(this.thumbMetadata.getNativeTree());
            }
            return node;
        }

        int getLength() {
            if (this.data == null) {
                return 0;
            }
            return this.data.length;
        }

        void write(ImageOutputStream ios, JPEGImageWriter writer) throws IOException {
            int progInterval = this.data.length / 20;
            if (progInterval == 0) {
                progInterval = 1;
            }
            int offset = 0;
            while (offset < this.data.length) {
                int len = Math.min(progInterval, this.data.length - offset);
                ios.write(this.data, offset, len);
                float percentDone = (float)(offset += progInterval) * 100.0f / (float)this.data.length;
                if (percentDone > 100.0f) {
                    percentDone = 100.0f;
                }
                writer.thumbnailProgress(percentDone);
            }
        }

        void print() {
            System.out.println("JFIF thumbnail stored as JPEG");
        }

        private class ThumbnailReadListener
        implements IIOReadProgressListener {
            JPEGImageReader reader = null;

            ThumbnailReadListener(JPEGImageReader reader) {
                this.reader = reader;
            }

            public void sequenceStarted(ImageReader source, int minIndex) {
            }

            public void sequenceComplete(ImageReader source) {
            }

            public void imageStarted(ImageReader source, int imageIndex) {
            }

            public void imageProgress(ImageReader source, float percentageDone) {
                this.reader.thumbnailProgress(percentageDone);
            }

            public void imageComplete(ImageReader source) {
            }

            public void thumbnailStarted(ImageReader source, int imageIndex, int thumbnailIndex) {
            }

            public void thumbnailProgress(ImageReader source, float percentageDone) {
            }

            public void thumbnailComplete(ImageReader source) {
            }

            public void readAborted(ImageReader source) {
            }
        }
    }

    class JFIFThumbPalette
    extends JFIFThumbUncompressed {
        private static final int PALETTE_SIZE = 768;

        JFIFThumbPalette(JPEGBuffer buffer, int width, int height) throws IOException {
            super(buffer, width, height, 768 + width * height, "JFIFThumbPalette");
        }

        JFIFThumbPalette(Node node) throws IIOInvalidTreeException {
            super(node, "JFIFThumbPalette");
        }

        JFIFThumbPalette(BufferedImage thumb) throws IllegalThumbException {
            super(thumb);
            IndexColorModel icm = (IndexColorModel)this.thumbnail.getColorModel();
            if (icm.getMapSize() > 256) {
                throw new IllegalThumbException();
            }
        }

        int getLength() {
            return this.thumbWidth * this.thumbHeight + 768;
        }

        BufferedImage getThumbnail(ImageInputStream iis, JPEGImageReader reader) throws IOException {
            iis.mark();
            iis.seek(this.streamPos);
            byte[] palette = new byte[768];
            float palettePart = 768.0f / (float)this.getLength();
            this.readByteBuffer(iis, palette, reader, palettePart, 0.0f);
            DataBufferByte buffer = new DataBufferByte(this.thumbWidth * this.thumbHeight);
            this.readByteBuffer(iis, buffer.getData(), reader, 1.0f - palettePart, palettePart);
            iis.read();
            iis.reset();
            IndexColorModel cm = new IndexColorModel(8, 256, palette, 0, false);
            SampleModel sm = cm.createCompatibleSampleModel(this.thumbWidth, this.thumbHeight);
            WritableRaster raster = Raster.createWritableRaster(sm, buffer, null);
            return new BufferedImage(cm, raster, false, null);
        }

        void write(ImageOutputStream ios, JPEGImageWriter writer) throws IOException {
            super.write(ios, writer);
            byte[] palette = new byte[768];
            IndexColorModel icm = (IndexColorModel)this.thumbnail.getColorModel();
            byte[] reds = new byte[256];
            byte[] greens = new byte[256];
            byte[] blues = new byte[256];
            icm.getReds(reds);
            icm.getGreens(greens);
            icm.getBlues(blues);
            for (int i = 0; i < 256; ++i) {
                palette[i * 3] = reds[i];
                palette[i * 3 + 1] = greens[i];
                palette[i * 3 + 2] = blues[i];
            }
            ios.write(palette);
            this.writePixels(ios, writer);
        }
    }

    class JFIFThumbRGB
    extends JFIFThumbUncompressed {
        JFIFThumbRGB(JPEGBuffer buffer, int width, int height) throws IOException {
            super(buffer, width, height, width * height * 3, "JFIFthumbRGB");
        }

        JFIFThumbRGB(Node node) throws IIOInvalidTreeException {
            super(node, "JFIFthumbRGB");
        }

        JFIFThumbRGB(BufferedImage thumb) throws IllegalThumbException {
            super(thumb);
        }

        int getLength() {
            return this.thumbWidth * this.thumbHeight * 3;
        }

        BufferedImage getThumbnail(ImageInputStream iis, JPEGImageReader reader) throws IOException {
            iis.mark();
            iis.seek(this.streamPos);
            DataBufferByte buffer = new DataBufferByte(this.getLength());
            this.readByteBuffer(iis, buffer.getData(), reader, 1.0f, 0.0f);
            iis.reset();
            WritableRaster raster = Raster.createInterleavedRaster(buffer, this.thumbWidth, this.thumbHeight, this.thumbWidth * 3, 3, new int[]{0, 1, 2}, null);
            ComponentColorModel cm = new ComponentColorModel(JPEG.sRGB, false, false, 1, 0);
            return new BufferedImage(cm, raster, false, null);
        }

        void write(ImageOutputStream ios, JPEGImageWriter writer) throws IOException {
            super.write(ios, writer);
            this.writePixels(ios, writer);
        }
    }

    abstract class JFIFThumbUncompressed
    extends JFIFThumb {
        BufferedImage thumbnail;
        int thumbWidth;
        int thumbHeight;
        String name;

        JFIFThumbUncompressed(JPEGBuffer buffer, int width, int height, int skip, String name) throws IOException {
            super(buffer);
            this.thumbnail = null;
            this.thumbWidth = width;
            this.thumbHeight = height;
            buffer.skipData(skip);
            this.name = name;
        }

        JFIFThumbUncompressed(Node node, String name) throws IIOInvalidTreeException {
            this.thumbnail = null;
            this.thumbWidth = 0;
            this.thumbHeight = 0;
            this.name = name;
            NamedNodeMap attrs = node.getAttributes();
            int count = attrs.getLength();
            if (count > 2) {
                throw new IIOInvalidTreeException(name + " node cannot have > 2 attributes", node);
            }
            if (count != 0) {
                int value = MarkerSegment.getAttributeValue(node, attrs, "thumbWidth", 0, 255, false);
                this.thumbWidth = value != -1 ? value : this.thumbWidth;
                value = MarkerSegment.getAttributeValue(node, attrs, "thumbHeight", 0, 255, false);
                this.thumbHeight = value != -1 ? value : this.thumbHeight;
            }
        }

        JFIFThumbUncompressed(BufferedImage thumb) {
            this.thumbnail = null;
            this.thumbnail = thumb;
            this.thumbWidth = thumb.getWidth();
            this.thumbHeight = thumb.getHeight();
            this.name = null;
        }

        void readByteBuffer(ImageInputStream iis, byte[] data, JPEGImageReader reader, float workPortion, float workOffset) throws IOException {
            int progInterval = Math.max((int)((float)(data.length / 20) / workPortion), 1);
            int offset = 0;
            while (offset < data.length) {
                int len = Math.min(progInterval, data.length - offset);
                iis.read(data, offset, len);
                float percentDone = (float)(offset += progInterval) * 100.0f / (float)data.length * workPortion + workOffset;
                if (percentDone > 100.0f) {
                    percentDone = 100.0f;
                }
                reader.thumbnailProgress(percentDone);
            }
        }

        int getWidth() {
            return this.thumbWidth;
        }

        int getHeight() {
            return this.thumbHeight;
        }

        IIOMetadataNode getNativeNode() {
            IIOMetadataNode node = new IIOMetadataNode(this.name);
            node.setAttribute("thumbWidth", Integer.toString(this.thumbWidth));
            node.setAttribute("thumbHeight", Integer.toString(this.thumbHeight));
            return node;
        }

        void write(ImageOutputStream ios, JPEGImageWriter writer) throws IOException {
            if (this.thumbWidth > 255 || this.thumbHeight > 255) {
                writer.warningOccurred(12);
            }
            this.thumbWidth = Math.min(this.thumbWidth, 255);
            this.thumbHeight = Math.min(this.thumbHeight, 255);
            ios.write(this.thumbWidth);
            ios.write(this.thumbHeight);
        }

        void writePixels(ImageOutputStream ios, JPEGImageWriter writer) throws IOException {
            if (this.thumbWidth > 255 || this.thumbHeight > 255) {
                writer.warningOccurred(12);
            }
            this.thumbWidth = Math.min(this.thumbWidth, 255);
            this.thumbHeight = Math.min(this.thumbHeight, 255);
            int[] data = this.thumbnail.getRaster().getPixels(0, 0, this.thumbWidth, this.thumbHeight, (int[])null);
            JFIFMarkerSegment.this.writeThumbnailData(ios, data, writer);
        }

        void print() {
            System.out.print(this.name + " width: ");
            System.out.println(this.thumbWidth);
            System.out.print(this.name + " height: ");
            System.out.println(this.thumbHeight);
        }
    }

    abstract class JFIFThumb
    implements Cloneable {
        long streamPos = -1L;

        abstract int getLength();

        abstract int getWidth();

        abstract int getHeight();

        abstract BufferedImage getThumbnail(ImageInputStream var1, JPEGImageReader var2) throws IOException;

        protected JFIFThumb() {
        }

        protected JFIFThumb(JPEGBuffer buffer) throws IOException {
            this.streamPos = buffer.getStreamPosition();
        }

        abstract void print();

        abstract IIOMetadataNode getNativeNode();

        abstract void write(ImageOutputStream var1, JPEGImageWriter var2) throws IOException;

        protected Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }
    }

    class JFIFExtensionMarkerSegment
    extends MarkerSegment {
        int code;
        JFIFThumb thumb;
        private static final int DATA_SIZE = 6;
        private static final int ID_SIZE = 5;

        JFIFExtensionMarkerSegment(JPEGBuffer buffer, JPEGImageReader reader) throws IOException {
            super(buffer);
            buffer.bufPtr += 5;
            this.code = buffer.buf[buffer.bufPtr++] & 0xFF;
            buffer.bufAvail -= 6;
            if (this.code == 16) {
                this.thumb = new JFIFThumbJPEG(buffer, this.length, reader);
            } else {
                buffer.loadBuf(2);
                int thumbX = buffer.buf[buffer.bufPtr++] & 0xFF;
                int thumbY = buffer.buf[buffer.bufPtr++] & 0xFF;
                buffer.bufAvail -= 2;
                this.thumb = this.code == 17 ? new JFIFThumbPalette(buffer, thumbX, thumbY) : new JFIFThumbRGB(buffer, thumbX, thumbY);
            }
        }

        JFIFExtensionMarkerSegment(Node node) throws IIOInvalidTreeException {
            super(224);
            NamedNodeMap attrs = node.getAttributes();
            if (attrs.getLength() > 0) {
                this.code = JFIFExtensionMarkerSegment.getAttributeValue(node, attrs, "extensionCode", 16, 19, false);
                if (this.code == 18) {
                    throw new IIOInvalidTreeException("invalid extensionCode attribute value", node);
                }
            } else {
                this.code = 18;
            }
            if (node.getChildNodes().getLength() != 1) {
                throw new IIOInvalidTreeException("app0JFXX node must have exactly 1 child", node);
            }
            Node child = node.getFirstChild();
            String name = child.getNodeName();
            if (name.equals("JFIFthumbJPEG")) {
                if (this.code == 18) {
                    this.code = 16;
                }
                this.thumb = new JFIFThumbJPEG(child);
            } else if (name.equals("JFIFthumbPalette")) {
                if (this.code == 18) {
                    this.code = 17;
                }
                this.thumb = new JFIFThumbPalette(child);
            } else if (name.equals("JFIFthumbRGB")) {
                if (this.code == 18) {
                    this.code = 19;
                }
                this.thumb = new JFIFThumbRGB(child);
            } else {
                throw new IIOInvalidTreeException("unrecognized app0JFXX child node", node);
            }
        }

        JFIFExtensionMarkerSegment(BufferedImage thumbnail) throws IllegalThumbException {
            super(224);
            ColorModel cm = thumbnail.getColorModel();
            int csType = cm.getColorSpace().getType();
            if (cm.hasAlpha()) {
                throw new IllegalThumbException();
            }
            if (cm instanceof IndexColorModel) {
                this.code = 17;
                this.thumb = new JFIFThumbPalette(thumbnail);
            } else if (csType == 5) {
                this.code = 19;
                this.thumb = new JFIFThumbRGB(thumbnail);
            } else if (csType == 6) {
                this.code = 16;
                this.thumb = new JFIFThumbJPEG(thumbnail);
            } else {
                throw new IllegalThumbException();
            }
        }

        void setThumbnail(BufferedImage thumbnail) {
            try {
                switch (this.code) {
                    case 17: {
                        this.thumb = new JFIFThumbPalette(thumbnail);
                        break;
                    }
                    case 19: {
                        this.thumb = new JFIFThumbRGB(thumbnail);
                        break;
                    }
                    case 16: {
                        this.thumb = new JFIFThumbJPEG(thumbnail);
                    }
                }
            }
            catch (IllegalThumbException e) {
                throw new InternalError("Illegal thumb in setThumbnail!");
            }
        }

        protected Object clone() {
            JFIFExtensionMarkerSegment newGuy = (JFIFExtensionMarkerSegment)super.clone();
            if (this.thumb != null) {
                newGuy.thumb = (JFIFThumb)this.thumb.clone();
            }
            return newGuy;
        }

        IIOMetadataNode getNativeNode() {
            IIOMetadataNode node = new IIOMetadataNode("app0JFXX");
            node.setAttribute("extensionCode", Integer.toString(this.code));
            node.appendChild(this.thumb.getNativeNode());
            return node;
        }

        void write(ImageOutputStream ios, JPEGImageWriter writer) throws IOException {
            this.length = 8 + this.thumb.getLength();
            this.writeTag(ios);
            byte[] id = new byte[]{74, 70, 88, 88, 0};
            ios.write(id);
            ios.write(this.code);
            this.thumb.write(ios, writer);
        }

        void print() {
            this.printTag("JFXX");
            this.thumb.print();
        }
    }

    private class IllegalThumbException
    extends Exception {
        private IllegalThumbException() {
        }
    }
}

