/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import sun.security.internal.spec.TlsKeyMaterialParameterSpec;
import sun.security.internal.spec.TlsKeyMaterialSpec;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.P11SecretKeyFactory;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.CK_SSL3_KEY_MAT_OUT;
import sun.security.pkcs11.wrapper.CK_SSL3_KEY_MAT_PARAMS;
import sun.security.pkcs11.wrapper.CK_SSL3_RANDOM_DATA;
import sun.security.pkcs11.wrapper.PKCS11Exception;

public final class P11TlsKeyMaterialGenerator
extends KeyGeneratorSpi {
    private static final String MSG = "TlsKeyMaterialGenerator must be initialized using a TlsKeyMaterialParameterSpec";
    private final Token token;
    private final String algorithm;
    private long mechanism;
    private TlsKeyMaterialParameterSpec spec;
    private P11Key p11Key;
    private int version;

    P11TlsKeyMaterialGenerator(Token token, String algorithm, long mechanism) throws PKCS11Exception {
        this.token = token;
        this.algorithm = algorithm;
        this.mechanism = mechanism;
    }

    protected void engineInit(SecureRandom random) {
        throw new InvalidParameterException(MSG);
    }

    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(params instanceof TlsKeyMaterialParameterSpec)) {
            throw new InvalidAlgorithmParameterException(MSG);
        }
        this.spec = (TlsKeyMaterialParameterSpec)params;
        try {
            this.p11Key = P11SecretKeyFactory.convertKey(this.token, this.spec.getMasterSecret(), "TlsMasterSecret");
        }
        catch (InvalidKeyException e) {
            throw new InvalidAlgorithmParameterException("init() failed", e);
        }
        this.version = this.spec.getMajorVersion() << 8 | this.spec.getMinorVersion();
        if (this.version < 768 && this.version > 770) {
            throw new InvalidAlgorithmParameterException("Only SSL 3.0, TLS 1.0, and TLS 1.1 are supported");
        }
    }

    protected void engineInit(int keysize, SecureRandom random) {
        throw new InvalidParameterException(MSG);
    }

    protected SecretKey engineGenerateKey() {
        boolean isExportable;
        if (this.spec == null) {
            throw new IllegalStateException("TlsKeyMaterialGenerator must be initialized");
        }
        this.mechanism = this.version == 768 ? 882L : 886L;
        int macBits = this.spec.getMacKeyLength() << 3;
        int ivBits = this.spec.getIvLength() << 3;
        int expandedKeyBits = this.spec.getExpandedCipherKeyLength() << 3;
        int keyBits = this.spec.getCipherKeyLength() << 3;
        if (expandedKeyBits != 0) {
            isExportable = true;
        } else {
            isExportable = false;
            expandedKeyBits = keyBits;
        }
        CK_SSL3_RANDOM_DATA random = new CK_SSL3_RANDOM_DATA(this.spec.getClientRandom(), this.spec.getServerRandom());
        CK_SSL3_KEY_MAT_PARAMS params = new CK_SSL3_KEY_MAT_PARAMS(macBits, keyBits, ivBits, isExportable, random);
        String cipherAlgorithm = this.spec.getCipherAlgorithm();
        long keyType = P11SecretKeyFactory.getKeyType(cipherAlgorithm);
        if (keyType < 0L) {
            if (keyBits != 0) {
                throw new ProviderException("Unknown algorithm: " + this.spec.getCipherAlgorithm());
            }
            keyType = 16L;
        }
        Session session = null;
        try {
            SecretKey serverCipherKey;
            SecretKey clientCipherKey;
            session = this.token.getObjSession();
            CK_ATTRIBUTE[] attributes = keyBits != 0 ? new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 4L), new CK_ATTRIBUTE(256L, keyType), new CK_ATTRIBUTE(353L, expandedKeyBits >> 3)} : new CK_ATTRIBUTE[]{};
            attributes = this.token.getAttributes("generate", 4L, keyType, attributes);
            long keyID = this.token.p11.C_DeriveKey(session.id(), new CK_MECHANISM(this.mechanism, params), this.p11Key.keyID, attributes);
            CK_SSL3_KEY_MAT_OUT out = params.pReturnedKeyMaterial;
            SecretKey clientMacKey = P11Key.secretKey(session, out.hClientMacSecret, "MAC", macBits, attributes);
            SecretKey serverMacKey = P11Key.secretKey(session, out.hServerMacSecret, "MAC", macBits, attributes);
            if (keyBits != 0) {
                clientCipherKey = P11Key.secretKey(session, out.hClientKey, cipherAlgorithm, expandedKeyBits, attributes);
                serverCipherKey = P11Key.secretKey(session, out.hServerKey, cipherAlgorithm, expandedKeyBits, attributes);
            } else {
                clientCipherKey = null;
                serverCipherKey = null;
            }
            IvParameterSpec clientIv = out.pIVClient == null ? null : new IvParameterSpec(out.pIVClient);
            IvParameterSpec serverIv = out.pIVServer == null ? null : new IvParameterSpec(out.pIVServer);
            TlsKeyMaterialSpec tlsKeyMaterialSpec = new TlsKeyMaterialSpec(clientMacKey, serverMacKey, clientCipherKey, clientIv, serverCipherKey, serverIv);
            return tlsKeyMaterialSpec;
        }
        catch (Exception e) {
            throw new ProviderException("Could not generate key", e);
        }
        finally {
            this.token.releaseSession(session);
        }
    }
}

