/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import sun.nio.ch.DirectBuffer;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.P11SecretKeyFactory;
import sun.security.pkcs11.P11Util;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class P11Cipher
extends CipherSpi {
    private static final int MODE_ECB = 3;
    private static final int MODE_CBC = 4;
    private static final int PAD_NONE = 5;
    private static final int PAD_PKCS5 = 6;
    private final Token token;
    private final String algorithm;
    private final String keyAlgorithm;
    private final long mechanism;
    private Session session;
    private P11Key p11Key;
    private boolean initialized;
    private boolean encrypt;
    private int blockMode;
    private final int blockSize;
    private int paddingType;
    private byte[] iv;
    private int bytesProcessed;

    P11Cipher(Token token, String algorithm, long mechanism) throws PKCS11Exception {
        this.token = token;
        this.algorithm = algorithm;
        this.mechanism = mechanism;
        this.keyAlgorithm = algorithm.split("/")[0];
        if (this.keyAlgorithm.equals("AES")) {
            this.blockSize = 16;
            this.blockMode = 4;
            this.paddingType = 5;
        } else if (this.keyAlgorithm.equals("RC4") || this.keyAlgorithm.equals("ARCFOUR")) {
            this.blockSize = 0;
            this.blockMode = 3;
            this.paddingType = 5;
        } else {
            this.blockSize = 8;
            this.blockMode = 4;
            this.paddingType = 5;
        }
        this.session = token.getOpSession();
    }

    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if ((mode = mode.toUpperCase()).equals("ECB")) {
            this.blockMode = 3;
        } else if (mode.equals("CBC")) {
            if (this.blockSize == 0) {
                throw new NoSuchAlgorithmException("CBC mode not supported with stream ciphers");
            }
            this.blockMode = 4;
        } else {
            throw new NoSuchAlgorithmException("Unsupported mode " + mode);
        }
    }

    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        if (!padding.equalsIgnoreCase("NoPadding")) {
            if (padding.equalsIgnoreCase("PKCS5Padding")) {
                if (this.blockSize == 0) {
                    throw new NoSuchPaddingException("PKCS#5 padding not supported with stream ciphers");
                }
                this.paddingType = 6;
                throw new NoSuchPaddingException("pkcs5");
            }
            throw new NoSuchPaddingException("Unsupported padding " + padding);
        }
        this.paddingType = 5;
    }

    protected int engineGetBlockSize() {
        return this.blockSize;
    }

    protected int engineGetOutputSize(int inputLen) {
        return this.doFinalLength(inputLen);
    }

    protected byte[] engineGetIV() {
        return this.iv == null ? null : (byte[])this.iv.clone();
    }

    protected AlgorithmParameters engineGetParameters() {
        if (this.iv == null) {
            return null;
        }
        IvParameterSpec ivSpec = new IvParameterSpec(this.iv);
        try {
            AlgorithmParameters params = AlgorithmParameters.getInstance(this.keyAlgorithm, P11Util.getSunJceProvider());
            params.init(ivSpec);
            return params;
        }
        catch (GeneralSecurityException e) {
            throw new ProviderException("Could not encode parameters", e);
        }
    }

    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.implInit(opmode, key, null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException("init() failed", e);
        }
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        byte[] iv;
        if (params != null) {
            if (!(params instanceof IvParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Only IvParameterSpec supported");
            }
            IvParameterSpec ivSpec = (IvParameterSpec)params;
            iv = ivSpec.getIV();
        } else {
            iv = null;
        }
        this.implInit(opmode, key, iv, random);
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        byte[] iv;
        if (params != null) {
            try {
                IvParameterSpec ivSpec = params.getParameterSpec(IvParameterSpec.class);
                iv = ivSpec.getIV();
            }
            catch (InvalidParameterSpecException e) {
                throw new InvalidAlgorithmParameterException("Could not decode IV", e);
            }
        } else {
            iv = null;
        }
        this.implInit(opmode, key, iv, random);
    }

    private void implInit(int opmode, Key key, byte[] iv, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.cancelOperation();
        switch (opmode) {
            case 1: {
                this.encrypt = true;
                break;
            }
            case 2: {
                this.encrypt = false;
                break;
            }
            default: {
                throw new InvalidAlgorithmParameterException("Unsupported mode: " + opmode);
            }
        }
        if (this.blockMode == 3) {
            if (iv != null) {
                if (this.blockSize == 0) {
                    throw new InvalidAlgorithmParameterException("IV not used with stream ciphers");
                }
                throw new InvalidAlgorithmParameterException("IV not used in ECB mode");
            }
        } else if (iv == null) {
            if (!this.encrypt) {
                throw new InvalidAlgorithmParameterException("IV must be specified for decryption in CBC mode");
            }
            if (random == null) {
                random = new SecureRandom();
            }
            iv = new byte[this.blockSize];
            random.nextBytes(iv);
        } else if (iv.length != this.blockSize) {
            throw new InvalidAlgorithmParameterException("IV length must match block size");
        }
        this.iv = iv;
        this.p11Key = P11SecretKeyFactory.convertKey(this.token, key, this.keyAlgorithm);
        try {
            this.initialize();
        }
        catch (PKCS11Exception e) {
            throw new InvalidKeyException("Could not initialize cipher", e);
        }
    }

    private void cancelOperation() {
        if (!this.initialized) {
            return;
        }
        this.initialized = false;
        if (this.session == null || !this.token.explicitCancel) {
            return;
        }
        int bufLen = this.doFinalLength(0);
        byte[] buffer = new byte[bufLen];
        try {
            if (this.encrypt) {
                this.token.p11.C_EncryptFinal(this.session.id(), 0L, buffer, 0, bufLen);
            } else {
                this.token.p11.C_DecryptFinal(this.session.id(), 0L, buffer, 0, bufLen);
            }
        }
        catch (PKCS11Exception e) {
            throw new ProviderException("Cancel failed", e);
        }
    }

    private void ensureInitialized() throws PKCS11Exception {
        if (!this.initialized) {
            this.initialize();
        }
    }

    private void initialize() throws PKCS11Exception {
        if (this.session == null) {
            this.session = this.token.getOpSession();
        }
        if (this.encrypt) {
            this.token.p11.C_EncryptInit(this.session.id(), new CK_MECHANISM(this.mechanism, this.iv), this.p11Key.keyID);
        } else {
            this.token.p11.C_DecryptInit(this.session.id(), new CK_MECHANISM(this.mechanism, this.iv), this.p11Key.keyID);
        }
        this.bytesProcessed = 0;
        this.initialized = true;
    }

    private int bytesBuffered(int totalLen) {
        if (this.paddingType == 5) {
            return totalLen & this.blockSize - 1;
        }
        int buffered = totalLen & this.blockSize - 1;
        if (buffered == 0 && !this.encrypt) {
            buffered = this.blockSize;
        }
        return buffered;
    }

    private int updateLength(int inLen) {
        if (inLen <= 0) {
            return 0;
        }
        if (this.blockSize == 0) {
            return inLen;
        }
        int buffered = this.bytesBuffered(this.bytesProcessed);
        int newBuffered = this.bytesBuffered(this.bytesProcessed + inLen);
        return inLen + buffered - newBuffered;
    }

    private int doFinalLength(int inLen) {
        if (this.paddingType == 5) {
            return this.updateLength(inLen);
        }
        if (inLen < 0) {
            return 0;
        }
        int buffered = this.bytesBuffered(this.bytesProcessed);
        int newProcessed = this.bytesProcessed + inLen;
        int paddedProcessed = newProcessed + this.blockSize & ~(this.blockSize - 1);
        return paddedProcessed - this.bytesProcessed + buffered;
    }

    protected byte[] engineUpdate(byte[] in, int inOfs, int inLen) {
        try {
            byte[] out = new byte[this.updateLength(inLen)];
            int n = this.engineUpdate(in, inOfs, inLen, out, 0);
            return P11Util.convert(out, 0, n);
        }
        catch (ShortBufferException e) {
            throw new ProviderException(e);
        }
    }

    protected int engineUpdate(byte[] in, int inOfs, int inLen, byte[] out, int outOfs) throws ShortBufferException {
        int outLen = out.length - outOfs;
        return this.implUpdate(in, inOfs, inLen, out, outOfs, outLen);
    }

    protected int engineUpdate(ByteBuffer inBuffer, ByteBuffer outBuffer) throws ShortBufferException {
        return this.implUpdate(inBuffer, outBuffer);
    }

    protected byte[] engineDoFinal(byte[] in, int inOfs, int inLen) throws IllegalBlockSizeException, BadPaddingException {
        try {
            byte[] out = new byte[this.doFinalLength(inLen)];
            int n = this.engineDoFinal(in, inOfs, inLen, out, 0);
            return P11Util.convert(out, 0, n);
        }
        catch (ShortBufferException e) {
            throw new ProviderException(e);
        }
    }

    protected int engineDoFinal(byte[] in, int inOfs, int inLen, byte[] out, int outOfs) throws ShortBufferException, IllegalBlockSizeException {
        int n = 0;
        if (inLen != 0 && in != null) {
            n = this.engineUpdate(in, inOfs, inLen, out, outOfs);
            outOfs += n;
        }
        return n += this.implDoFinal(out, outOfs, out.length - outOfs);
    }

    protected int engineDoFinal(ByteBuffer inBuffer, ByteBuffer outBuffer) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int n = this.engineUpdate(inBuffer, outBuffer);
        return n += this.implDoFinal(outBuffer);
    }

    private int implUpdate(byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws ShortBufferException {
        if (outLen < this.updateLength(inLen)) {
            throw new ShortBufferException();
        }
        try {
            this.ensureInitialized();
            int k = this.encrypt ? this.token.p11.C_EncryptUpdate(this.session.id(), 0L, in, inOfs, inLen, 0L, out, outOfs, outLen) : this.token.p11.C_DecryptUpdate(this.session.id(), 0L, in, inOfs, inLen, 0L, out, outOfs, outLen);
            this.bytesProcessed += inLen;
            return k;
        }
        catch (PKCS11Exception e) {
            throw new ProviderException("update() failed", e);
        }
    }

    private int implUpdate(ByteBuffer inBuffer, ByteBuffer outBuffer) throws ShortBufferException {
        int inLen = inBuffer.remaining();
        if (inLen <= 0) {
            return 0;
        }
        int outLen = outBuffer.remaining();
        if (outLen < this.updateLength(inLen)) {
            throw new ShortBufferException();
        }
        boolean inPosChanged = false;
        try {
            this.ensureInitialized();
            long inAddr = 0L;
            int inOfs = inBuffer.position();
            byte[] inArray = null;
            if (inBuffer instanceof DirectBuffer) {
                inAddr = ((DirectBuffer)((Object)inBuffer)).address();
            } else if (inBuffer.hasArray()) {
                inArray = inBuffer.array();
                inOfs += inBuffer.arrayOffset();
            } else {
                inArray = new byte[inLen];
                inBuffer.get(inArray);
                inOfs = 0;
                inPosChanged = true;
            }
            long outAddr = 0L;
            int outOfs = outBuffer.position();
            byte[] outArray = null;
            if (outBuffer instanceof DirectBuffer) {
                outAddr = ((DirectBuffer)((Object)outBuffer)).address();
            } else if (outBuffer.hasArray()) {
                outArray = outBuffer.array();
                outOfs += outBuffer.arrayOffset();
            } else {
                outArray = new byte[outLen];
                outOfs = 0;
            }
            int k = this.encrypt ? this.token.p11.C_EncryptUpdate(this.session.id(), inAddr, inArray, inOfs, inLen, outAddr, outArray, outOfs, outLen) : this.token.p11.C_DecryptUpdate(this.session.id(), inAddr, inArray, inOfs, inLen, outAddr, outArray, outOfs, outLen);
            this.bytesProcessed += inLen;
            if (!inPosChanged) {
                inBuffer.position(inBuffer.position() + inLen);
            }
            if (!(outBuffer instanceof DirectBuffer) && !outBuffer.hasArray()) {
                outBuffer.put(outArray, outOfs, k);
            } else {
                outBuffer.position(outBuffer.position() + k);
            }
            return k;
        }
        catch (PKCS11Exception e) {
            if (inPosChanged) {
                inBuffer.position(inBuffer.position() - inLen);
            }
            throw new ProviderException("update() failed", e);
        }
    }

    private int implDoFinal(byte[] out, int outOfs, int outLen) throws ShortBufferException, IllegalBlockSizeException {
        if (outLen < this.doFinalLength(0)) {
            throw new ShortBufferException();
        }
        try {
            this.ensureInitialized();
            if (this.encrypt) {
                int n = this.token.p11.C_EncryptFinal(this.session.id(), 0L, out, outOfs, outLen);
                return n;
            }
            int n = this.token.p11.C_DecryptFinal(this.session.id(), 0L, out, outOfs, outLen);
            return n;
        }
        catch (PKCS11Exception e) {
            this.handleException(e);
            throw new ProviderException("doFinal() failed", e);
        }
        finally {
            this.initialized = false;
            this.bytesProcessed = 0;
            this.session = this.token.releaseSession(this.session);
        }
    }

    private int implDoFinal(ByteBuffer outBuffer) throws ShortBufferException, IllegalBlockSizeException {
        int outLen = outBuffer.remaining();
        if (outLen < this.doFinalLength(0)) {
            throw new ShortBufferException();
        }
        try {
            this.ensureInitialized();
            long outAddr = 0L;
            int outOfs = outBuffer.position();
            byte[] outArray = null;
            if (outBuffer instanceof DirectBuffer) {
                outAddr = ((DirectBuffer)((Object)outBuffer)).address();
            } else if (outBuffer.hasArray()) {
                outArray = outBuffer.array();
                outOfs += outBuffer.arrayOffset();
            } else {
                outArray = new byte[outLen];
                outOfs = 0;
            }
            int k = this.encrypt ? this.token.p11.C_EncryptFinal(this.session.id(), outAddr, outArray, outOfs, outLen) : this.token.p11.C_DecryptFinal(this.session.id(), outAddr, outArray, outOfs, outLen);
            if (!(outBuffer instanceof DirectBuffer) && !outBuffer.hasArray()) {
                outBuffer.put(outArray, outOfs, k);
            } else {
                outBuffer.position(outBuffer.position() + k);
            }
            int n = k;
            return n;
        }
        catch (PKCS11Exception e) {
            this.handleException(e);
            throw new ProviderException("doFinal() failed", e);
        }
        finally {
            this.initialized = false;
            this.bytesProcessed = 0;
            this.session = this.token.releaseSession(this.session);
        }
    }

    private void handleException(PKCS11Exception e) throws IllegalBlockSizeException {
        long errorCode = e.getErrorCode();
        if (errorCode == 33L) {
            throw (IllegalBlockSizeException)new IllegalBlockSizeException(e.toString()).initCause(e);
        }
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        throw new UnsupportedOperationException("engineWrap()");
    }

    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        throw new UnsupportedOperationException("engineUnwrap()");
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        int n = P11SecretKeyFactory.convertKey(this.token, key, this.keyAlgorithm).keyLength();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.session != null && this.token.isValid()) {
                this.cancelOperation();
                this.session = this.token.releaseSession(this.session);
            }
        }
        finally {
            super.finalize();
        }
    }
}

