/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.PBECipherCore;
import com.sun.crypto.provider.SunJCE;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public final class PBEWithMD5AndDESCipher
extends CipherSpi {
    private PBECipherCore core;

    public PBEWithMD5AndDESCipher() throws NoSuchAlgorithmException, NoSuchPaddingException {
        if (!SunJCE.verifySelfIntegrity(this.getClass())) {
            throw new SecurityException("The SunJCE provider may have been tampered.");
        }
        this.core = new PBECipherCore("DES");
    }

    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (mode != null && !mode.equalsIgnoreCase("CBC")) {
            throw new NoSuchAlgorithmException("Invalid cipher mode: " + mode);
        }
    }

    protected void engineSetPadding(String paddingScheme) throws NoSuchPaddingException {
        if (paddingScheme != null && !paddingScheme.equalsIgnoreCase("PKCS5Padding")) {
            throw new NoSuchPaddingException("Invalid padding scheme: " + paddingScheme);
        }
    }

    protected int engineGetBlockSize() {
        return this.core.getBlockSize();
    }

    protected int engineGetOutputSize(int inputLen) {
        return this.core.getOutputSize(inputLen);
    }

    protected byte[] engineGetIV() {
        return this.core.getIV();
    }

    protected AlgorithmParameters engineGetParameters() {
        return this.core.getParameters();
    }

    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException ie) {
            InvalidKeyException ike = new InvalidKeyException("requires PBE parameters");
            ike.initCause(ie);
            throw ike;
        }
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.core.init(opmode, key, params, random);
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.core.init(opmode, key, params, random);
    }

    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        return this.core.update(input, inputOffset, inputLen);
    }

    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        return this.core.update(input, inputOffset, inputLen, output, outputOffset);
    }

    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        return this.core.doFinal(input, inputOffset, inputLen);
    }

    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.core.doFinal(input, inputOffset, inputLen, output, outputOffset);
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        return 56;
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        return this.core.wrap(key);
    }

    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        return this.core.unwrap(wrappedKey, wrappedKeyAlgorithm, wrappedKeyType);
    }
}

