#include "webpage.h"
#include "webview.h"

#include <QCursor>
#include <QDragEnterEvent>
#include <QMouseEvent>


bool qt_sendSpontaneousEvent(QObject *receiver, QEvent *event);

WebView::WebView(QWidget *parent) :
    QWebView(parent) {

    setPage(new WebPage(this));
    setContextMenuPolicy(Qt::PreventContextMenu);
}

#ifdef Q_WS_MAEMO_5
void WebView::mouseMoveEvent(QMouseEvent *event) {

    Q_ASSERT(event);
    // prevent switching to drag'n drop mode (breaks kinetic scrolling)
    event->accept();
}
#endif

#ifdef Q_WS_S60
void WebView::dragEnterEvent(QDragEnterEvent *event) {

    Q_ASSERT(event);
    event->ignore();

    // FIXME: this is a hack to make sure clicks still behave properly when we
    //        enter drag mode. preferably, we would never enter drag mode in the
    //        first place
    //
    // note: This code caused segementation faults in all sort of strange places
    // on Maemo5, so for now enable this fix on S60 only
    QMouseEvent mePress(QMouseEvent::MouseButtonPress, event->pos(), QCursor::pos(),
                        Qt::LeftButton, Qt::LeftButton, Qt::NoModifier);
    qt_sendSpontaneousEvent(this, &mePress);

    QMouseEvent meRelease(QMouseEvent::MouseButtonRelease, event->pos(), QCursor::pos(),
                          Qt::LeftButton, Qt::NoButton, Qt::NoModifier);
    qt_sendSpontaneousEvent(this, &meRelease);
}
#endif
