/****************************************************************************
**
** This file is part of the Hyves PhoneGap container.
** Copyright (C) 2010-2011 Hyves (Startphone Ltd.)
** http://www.hyves.nl
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#include "splashscreen.h"

#include <QLabel>
#include <QImage>
#include <QPixmap>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QProgressBar>


SplashScreen::SplashScreen(QWidget *parent) :
    QWidget(parent),
    m_progressBar(new QProgressBar()) {

    QVBoxLayout *mainLayout = new QVBoxLayout(this);
    QHBoxLayout *progressLayout = new QHBoxLayout();
    QLabel *label = new QLabel();

    label->setAlignment(Qt::AlignCenter);
#ifdef Q_WS_MAEMO_5
    label->setPixmap(QPixmap::fromImage(QImage("/usr/share/hyves/splash.png", "PNG")));
#else
    label->setPixmap(QPixmap::fromImage(QImage("./template/splash.png", "PNG")));
#endif

    m_progressBar->setStyleSheet(
            "QProgressBar { background: #C0C0C0; height: 20px; border-radius: 10px; }"
            "QProgressBar::chunk { background: #3588D5; border: 1px solid grey; border-radius: 10px; }");
    m_progressBar->setFixedSize(250, 20);
    m_progressBar->setTextVisible(false);
    m_progressBar->setAlignment(Qt::AlignHCenter);
    progressLayout->addWidget(m_progressBar);

    mainLayout->addWidget(label);
    mainLayout->addLayout(progressLayout);
    mainLayout->addSpacerItem(new QSpacerItem(0, 50));
}


void SplashScreen::setProgress(int progress) {

    m_progressBar->setValue(progress);
}

int SplashScreen::progress() const {

    return m_progressBar->value();
}

