/****************************************************************************
**
** This file is part of the Hyves PhoneGap container.
** Copyright (C) 2010-2011 Hyves (Startphone Ltd.)
** http://www.hyves.nl
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#ifndef NETWORKACCESSMANAGER_H
#define NETWORKACCESSMANAGER_H

#include <QNetworkAccessManager>
#ifndef Q_WS_MAEMO_5
#include <QNetworkConfigurationManager>
#include <QNetworkConfiguration>
#include <QNetworkSession>

QTM_USE_NAMESPACE
#endif

class NetworkAccessManager : public QNetworkAccessManager {

    Q_OBJECT

    public:
        explicit NetworkAccessManager(QObject *parent = 0);

    protected:
        QNetworkReply *createRequest(Operation op, const QNetworkRequest &request, QIODevice *outgoingData = 0);

    private slots:
        void sslErrors(QNetworkReply *reply, const QList<QSslError> &errors);
        void finished(QNetworkReply *reply);
#ifndef Q_WS_MAEMO_5
        void preferredNetworkConfigurationChanged(const QNetworkConfiguration &config, bool isSeamless);

    private:
        QNetworkConfigurationManager *m_manager;
        QNetworkSession *m_session;
#endif
};

#endif // NETWORKACCESSMANAGER_H
