#include "extensions/debugconsole.h"
#include "networkaccessmanager.h"
#include "webpage.h"

#include <QDebug>
#include <QDesktopServices>
#include <QMessageBox>
#include <QNetworkRequest>
#include <QWebFrame>


WebPage::WebPage(QObject *parent) :
    QWebPage(parent) {

    setNetworkAccessManager(new NetworkAccessManager(this));
}

void WebPage::javaScriptConsoleMessage(const QString &message, int lineNumber, const QString &sourceId) {

    qDebug() << sourceId << ":" << lineNumber << ": " << message;
}

bool WebPage::acceptNavigationRequest(QWebFrame *frame, const QNetworkRequest &request,
                                      QWebPage::NavigationType type) {

    if (request.url().scheme() != "file" &&
        !request.url().host().endsWith(".hyves.nl") &&
        !request.url().host().endsWith(".hyves.org") &&
        !request.url().host().endsWith(".hyveshq")) {
        qDebug() << "Opening" << request.url() << "in external browser";
        QDesktopServices::openUrl(request.url());
        return false;
    }

    return QWebPage::acceptNavigationRequest(frame, request, type);
}
