#-------------------------------------------------
#
# Project created by QtCreator 2010-11-29T22:43:53
#
#-------------------------------------------------

QT += core gui webkit network

TARGET = Hyves
VERSION = 1.0.8
TEMPLATE = app

SOURCES += \
    cookiejar.cpp \
    extensions.cpp \
    main.cpp \
    mainwindow.cpp \
    gapapplication.cpp \
    networkaccessmanager.cpp \
    webpage.cpp \
    webview.cpp \
    thumbnail/thumbnailnetworkreply.cpp \
    thumbnail/thumbnailloader.cpp \
    diskcache/networkdiskcache.cpp \
#    extensions/accelerometer.cpp \
    extensions/debugconsole.cpp \
    extensions/deviceinfo.cpp \
    extensions/camera.cpp \
#    extensions/camera2.cpp \
    extensions/geolocation.cpp \
    extensions/hyvesupload.cpp \
    extensions/notification.cpp \
    extensions/oauthutil.cpp \
    extensions/profiling.cpp \
    extensions/utility.cpp \
    qjson/json_driver.cc \
    qjson/json_parser.cc \
    qjson/json_scanner.cpp

HEADERS += \
    cookiejar.h \
    extensions.h \
    mainwindow.h \
    gapapplication.h \
    networkaccessmanager.h \
    webpage.h \
    webview.h \
    thumbnail/thumbnailnetworkreply.h \
    thumbnail/thumbnailloader.h \
    diskcache/networkdiskcache.h \
    diskcache/networkdiskcache_p.h \
#    extensions/accelerometer.h \
    extensions/camera.h \
#    extensions/camera2.h \
    extensions/debugconsole.h \
    extensions/deviceinfo.h \
    extensions/geolocation.h \
    extensions/hyvesupload.h \
    extensions/notification.h \
    extensions/oauthutil.h \
    extensions/profiling.h \
    extensions/utility.h \
    qjson/json_driver.hh \
    qjson/json_parser.hh \
    qjson/json_scanner.h


CONFIG += mobility
#MOBILITY += bearer location sensors systeminfo
MOBILITY += bearer location systeminfo

symbian {
    TARGET.UID3 = 0x2003A5DB
    ICON = icon.svg
    TARGET.EPOCSTACKSIZE = 0x14000
    TARGET.CAPABILITY = Location NetworkServices ReadUserData UserEnvironment ReadDeviceData WriteDeviceData WriteUserData PowerMgmt
    TARGET.EPOCHEAPSIZE = 0x20000 0x2000000

    language = \
        "&DU"
    vendorinfo = \
        "%{\"Hyves\"}" \
        ":\"Hyves\""
    hyves_deployment.pkg_prerules += language vendorinfo
    DEPLOYMENT += hyves_deployment

    DEPLOYMENT.installer_header = 0x2002CCCF

    htmlfiles.sources = ./../template/
    phonegap_js.sources = ./../js/*
    phonegap_js.path = ./template/
    DEPLOYMENT += htmlfiles phonegap_js

    include(vibra/vibra.pri)

    HEADERS += \
        extensions/camerafileobserver.h \
        extensions/memorywatcher.h \
        scroller/qkineticscroller.h \
        scroller/qkineticscroller_p.h \
        scroller/qwebviewkineticscroller.h \
        scroller/qwebviewselectionsuppressor.h \
        thumbnail/symbianpicloader.h
    SOURCES += \
        extensions/camerafileobserver.cpp \
        extensions/memorywatcher.cpp \
        scroller/qkineticscroller.cpp \
        scroller/qwebviewkineticscroller.cpp \
        scroller/qwebviewselectionsuppressor.cpp \
        thumbnail/symbianpicloader.cpp
    LIBS += -lcone -leikcore -lavkon -lhwrmvibraclient -lfbscli -lefsrv -lexiflib.dll -limageconversion
    QMAKE_CXXFLAGS += -Wno-attributes -Wno-parentheses
}

# Maemo 5
unix:!symbian {
    HEADERS += splashscreen.h \
        animatedstackedwidget.h
    SOURCES += splashscreen.cpp \
        animatedstackedwidget.cpp

    INSTALLS += target desktop icon48 iconScale media translations
    target.path = /usr/bin
    desktop.path = /usr/share/applications/hildon
    desktop.files += ./../maemofiles/Hyves.desktop
    icon48.path = /usr/share/icons/hicolor/48x48/apps
    icon48.files += ./../maemofiles/hyves.png
    iconScale.path = /usr/share/icons/hicolor/scalable/apps
    iconScale.files += ./../maemofiles/hyves.png
    media.path = /usr/share/hyves
    media.files += ./../maemofiles/splash.png
    translations.path = /usr/share/hyves/translations
    translations.files += hyves.nl_NL.qm \
        hyves.en_US.qm
}

OTHER_FILES += \
    readme.txt \
    template/index.html
