/****************************************************************************
**
** This file is part of the Hyves PhoneGap container.
** Copyright (C) 2010-2011 Hyves (Startphone Ltd.)
** http://www.hyves.nl
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#include "profiling.h"
#include "utility.h"

#include <QCoreApplication>
#include <QDebug>
#include <QDesktopServices>
#include <QDir>
#include <QFile>
#include <QUrl>
#include <QLocale>
#include <QWebView>
#include <QSettings>

Utility::Utility(QWebView *webView, QObject *parent) :
    QObject(parent),
    m_webView(webView) {
}

void Utility::exit() {

    qApp->quit();
}

void Utility::openUrl(const QString &url) {

    QDesktopServices::openUrl(QUrl::fromEncoded(url.toUtf8()));
}

void Utility::forceRepaint() {

    Profiling::instance()->start("forceRepaint");
    m_webView->repaint();
    Profiling::instance()->stop("forceRepaint");
}

static bool removeDirectory(const QString &path) {

    QDir dir(path);
    bool error = false;
    if (dir.exists()) {
        QFileInfoList entries = dir.entryInfoList(QDir::NoDotAndDotDot |
                                                  QDir::Dirs | QDir::Files);
        int count = entries.size();
        for (int i = 0; i < count && !error; i++) {
            QFileInfo entryInfo = entries[i];
            QString path = entryInfo.absoluteFilePath();
            if (entryInfo.isDir()) {
                error = !removeDirectory(path);
            } else {
                QFile file(path);
                if (!file.remove()) {
                    qWarning() << "Could not remove file" << path;
                    error = true;
                }
            }
        }
        if (!dir.rmdir(dir.absolutePath())) {
            qWarning() << "Could not remove directory" << path;
            error = true;
        }
    }
    return !error;
}

void Utility::purgeCache() {

    QString path = QDesktopServices::storageLocation(QDesktopServices::CacheLocation) + "/cache";
    bool result = removeDirectory(path);
    if (result) {
        qDebug() << "Cache purged.";
    }
}

QString Utility::locale() const {

    return QSettings().value("locale", QLocale::system().name()).toString();
}

void Utility::setLocale(const QString &name) {

    QSettings settings;
    if (name.isEmpty()) {
        settings.remove("locale");
    } else {
        settings.setValue("locale", name);
    }
}
