/****************************************************************************
**
** This file is part of the Hyves PhoneGap container.
** Copyright (C) 2010-2011 Hyves (Startphone Ltd.)
** http://www.hyves.nl
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#include "thumbnailloader.h"

#include <QThreadPool>
#include <QMetaObject>
#include <QImageReader>
#include <QBuffer>
#include <QImage>
#include <QSize>

//#include <QDebug>
//#include <QTime>

const QSize THUMB_MAX_SIZE = QSize(75, 75);


ThumbnailLoader::ThumbnailLoader(QObject *parent) :
    QObject(parent), m_running(false) {
}

ThumbnailLoader::~ThumbnailLoader() {

    if (m_running) {
        QThreadPool::globalInstance()->waitForDone(); // make sure runnable is delete first
    }
}

void ThumbnailLoader::loadImage(const QString &path) {

    if (m_running) {
        return;
    }

    m_running = true;
    m_path = path;
    ThumbnailLoaderRunnable *worker = new ThumbnailLoaderRunnable(this);
    worker->setAutoDelete(true);
    QThreadPool::globalInstance()->start(worker);
}

void ThumbnailLoader::done() {

    m_running = false;
    emit thumbLoaded(m_imgData);
}


ThumbnailLoaderRunnable::ThumbnailLoaderRunnable(ThumbnailLoader *loader) :
    m_loader(loader) {
}

void ThumbnailLoaderRunnable::run() {

    //QTime elapsedTimer;
    //elapsedTimer.start();

    QImageReader reader(m_loader->m_path);
    QSize imgSize(reader.size());
    imgSize.scale(THUMB_MAX_SIZE, Qt::KeepAspectRatioByExpanding);
    reader.setScaledSize(imgSize);

    QImage img;
    if (reader.read(&img)) {
        QBuffer buffer(&(m_loader->m_imgData));
        buffer.open(QIODevice::WriteOnly);
        img.save(&buffer, "JPEG");
        buffer.close();
    }

    //qDebug() << "generated thumb in " << elapsedTimer.elapsed() << "ms (file: " << m_loader->m_path << ")";
    QMetaObject::invokeMethod(m_loader, "done", Qt::QueuedConnection);
}

