#include "orientationpickselectoraction.h"

#include <QMaemo5ListPickSelector>
#include <QMaemo5ValueButton>
#include <QStandardItemModel>
#include <QStandardItem>
#include <QSettings>


OrientationPickSelectorAction::OrientationPickSelectorAction(QObject *parent) :
    QWidgetAction(parent) {
}

QWidget *OrientationPickSelectorAction::createWidget(QWidget *parent) {

    //: Description for menu action invoking the display orientation picker
    QMaemo5ValueButton *button = new QMaemo5ValueButton(tr("Display orientation"), parent);
    QMaemo5ListPickSelector *picker = new QMaemo5ListPickSelector();
    QStandardItemModel *model = new QStandardItemModel(0,1);

    //: Label for display orientation (portrait mode)
    model->appendRow(new QStandardItem(tr("Portrait")));
    //: Label for display orientation (landscape mode)
    model->appendRow(new QStandardItem(tr("Landscape")));
    //: Label for display orientation (auto rotation)
    model->appendRow(new QStandardItem(tr("Auto")));
    picker->setModel(model);

    switch(QSettings().value("displayOrientation", Qt::WA_Maemo5AutoOrientation).toInt()) {
    case Qt::WA_Maemo5PortraitOrientation:
        picker->setCurrentIndex(0);
        break;
    case Qt::WA_Maemo5LandscapeOrientation:
        picker->setCurrentIndex(1);
        break;
    case Qt::WA_Maemo5AutoOrientation:
        picker->setCurrentIndex(2);
        break;
    }

    connect(picker, SIGNAL(selected(QString)), this, SLOT(selectionChanged(QString)));
    button->setPickSelector(picker);
    return button;
}

void OrientationPickSelectorAction::selectionChanged(const QString &text) {

    Q_UNUSED(text);
    QMaemo5ListPickSelector *picker = qobject_cast<QMaemo5ListPickSelector*>(sender());
    if (picker) {
        Qt::WidgetAttribute orientation;
        switch (picker->currentIndex()) {
        case 0:
            orientation = Qt::WA_Maemo5PortraitOrientation;
            break;
        case 1:
            orientation = Qt::WA_Maemo5LandscapeOrientation;
            break;
        case 2: // fall
        default:
            orientation = Qt::WA_Maemo5AutoOrientation;
            break;
        }
        QSettings().setValue("displayOrientation", orientation);
        emit orientationSelected(orientation);
    }
}
