#include "extensions.h"
#include "mainwindow.h"
#include "webview.h"

#include <QDesktopServices>
#include <QDir>
#include <QWebSettings>
#include <QWebView>
#include <QWebFrame>

#ifdef Q_WS_S60
#include "qwebviewkineticscroller.h"
#endif

#ifdef Q_WS_MAEMO_5
#include "orientationpickselectoraction.h"
#include "animatedstackedwidget.h"
#include "splashscreen.h"

#include <QMessageBox>
#include <QApplication>
#include <QSettings>
#include <QMenuBar>
#include <QAction>
#endif


MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    m_webView(new WebView(this)) {

#ifdef Q_WS_S60
    QWebViewKineticScroller *scroller = new QWebViewKineticScroller();
    scroller->setWidget(m_webView);
#endif

#ifdef Q_WS_MAEMO_5
    QPalette pal = palette();
    pal.setColor(backgroundRole(), Qt::white);
    setPalette(pal); // set white background (inherited by splash screen)

    QMenuBar *menu = menuBar();
    OrientationPickSelectorAction *orientationPicker = new OrientationPickSelectorAction();
    setDisplayOrientation(static_cast<Qt::WidgetAttribute>(QSettings().value("displayOrientation", Qt::WA_Maemo5AutoOrientation).toInt()));
    connect(orientationPicker, SIGNAL(orientationSelected(Qt::WidgetAttribute)), this, SLOT(setDisplayOrientation(Qt::WidgetAttribute)));
    menu->addAction(orientationPicker);
    //: name for 'about' button in menu bar
    menu->addAction(tr("About"), this, SLOT(showAbout()));


    SplashScreen *splash = new SplashScreen(m_webView);
    AnimatedStackedWidget *stackedWidget = new AnimatedStackedWidget();

    stackedWidget->addWidget(splash);
    stackedWidget->addWidget(m_webView);
    setCentralWidget(stackedWidget);

    connect(m_webView, SIGNAL(loadFinished(bool)), this, SLOT(loadFinished(bool)));
    connect(m_webView, SIGNAL(loadProgress(int)), splash, SLOT(setProgress(int)));
#else
    setCentralWidget(m_webView);
#endif

    m_webView->settings()->setAttribute(QWebSettings::LocalContentCanAccessRemoteUrls, true);
    m_webView->settings()->enablePersistentStorage();
    m_webView->settings()->setLocalStoragePath(QDesktopServices::storageLocation(QDesktopServices::CacheLocation) + "/storage");

    new Extensions(m_webView);

#ifdef Q_WS_MAEMO_5
    QString hybridUrl(qgetenv("HYBRID_URL").constData());
    //: locale selecting which language-version of the Hybrid app is being loaded on startup (currently 'en_US' and 'nl_NL' are supported only)
    m_webView->load(QUrl(hybridUrl.isEmpty() ? "http://www.hyves.nl/hybrid/?&locale=" + tr("en_US") : hybridUrl));
#else
    QDir templateDir = QDir::current();
#ifdef Q_WS_SIMULATOR
    templateDir.cdUp();
#endif
    templateDir.cd("template");
    m_webView->load(QUrl::fromUserInput(templateDir.filePath("index.html")));
#endif
}

MainWindow::~MainWindow() {
}

#ifdef Q_WS_MAEMO_5
void MainWindow::loadFinished(bool success) {

    if (success && m_webView->page()->mainFrame()->evaluateJavaScript("typeof($('#loader'))") == "object") {
        // hide splash screen
        AnimatedStackedWidget *stackedWidget = qobject_cast<AnimatedStackedWidget*>(centralWidget());
        if (stackedWidget) {
            stackedWidget->setCurrentWidget(m_webView);
        }
        return;
    }

    //: something went wrong during initialization, ask user whether he wants to try to reconnect or quit the application
    if (QMessageBox::question(this, tr("Failed to connect..."), tr("Try again?"), QMessageBox::Yes, QMessageBox::No) == QMessageBox::Yes) {
        m_webView->reload();
    } else {
        qApp->quit();
    }
}

void MainWindow::setDisplayOrientation(Qt::WidgetAttribute orientation) {

    switch (orientation) {
    case Qt::WA_Maemo5PortraitOrientation:
    case Qt::WA_Maemo5LandscapeOrientation:
    case Qt::WA_Maemo5AutoOrientation:
        setAttribute(orientation, true);
        break;
    default:
        qDebug("MainWindow::setDisplayOrientation(): invalid value");
        break;
    }
}

void MainWindow::showAbout() {

    //: Title for about dialog
    QMessageBox::information(this, tr("About %1").arg(qApp->applicationName()),
                             //: Text for about dialog, parameters:'%1' application name, '%2' version (e.g. '1.0.9'), '%3' Qt version
                             tr("%1\nVersion %2\nUsing Qt %3")
                             .arg(qApp->applicationName(), qApp->applicationVersion(), qVersion()),
                             QMessageBox::Ok);
}
#endif
